program KBDPS2;

{ $W+ Warnings}            {Warnings off}

Device = mega8, VCC = 5;
{ $BOOTRST $00C00}         {Reset Jump to $00C00}


Import SysTick, BeepPort;

From System Import Processes, Tasks, Pipes, LongWord;


Define
  ProcClock      = 8000000;        {Hertz}
  SysTick        = 5;               {msec}
  StackSize      = $0100, iData;
  FrameSize      = $0100, iData;
  Scheduler      = 10, 10, iData;
  TaskStack      = $0020, iData;
  TaskFrame      = $0010;
  BeepPort       = PortB, 0;

Implementation

{$IDATA}

{--------------------------------------------------------------}
{ Type Declarations }
type
  tKbShiftEnum   = (shShift, shCtrl, shAlt, shCaps, shNum, shScroll);
  tKbShiftState  = BitSet of tKbShiftEnum;

  tKeybState     = (KeyStat_Byte1, KeyStat_E0, KeyStat_F0);
  // KeyStat_Byte1 = normaler Tastaturcode (1 Byte)
  // KeyStat_E0 = erweiterter Tataturcode beginnt mit E0 (z.B. fuer INSERT, HOME, PRINT ...)
  // KeyStat_F0 = freigesetzt BREAK beginnt mit F0 (Taste wird losgelassen - auch nach Repetierung)
  
  tLedStatEnum   = (LedScroll, LedNum, LedCaps);
  tLedState      = BitSet of tLedStatEnum;


  BA_Mode_Typ = (BA_mode_keineBA, BA_mode_INI, BA_mode_SET_WR, BA_mode_WR,
                 BA_mode_SET_RD, BA_mode_RD);

  RECEIVE_MODE_Typ = (NO_RECEIVE_MODE, RECEIVE_CONST, RECEIVE_CONIN,
                      RECEIVE_DEVCODE, RECEIVE_ERROR_CODE);



{--------------------------------------------------------------}
{ Const Declarations }
const
  CodeTab_NORMAL : array[$0..$7F] of Char =
  (
  { *** Tabelle SCAN-Code - ohne SHIFT *** }
  { 00-0F / 00-15 }
{  0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F  }
{      F9        F5   F3   F1   F2  F12       F10   F8   F6   F4  TAB   ^        }
  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0, #09, '^',  #0,
  { 10-1F / 16-31 }
{    LAlt  LSh      Strg   Q    1                   Y    S    A    W    2        }
  #0,  #0,  #0,  #0,  #0, 'q', '1',  #0,  #0,  #0, 'y', 's', 'a', 'w', '2',  #0,
  { 20-2F / 32-47 }
{      C    X    D    E    4    3            Spac   V    F    T    R    5        }
  #0, 'c', 'x', 'd', 'e', '4', '3',  #0,  #0, ' ', 'v', 'f', 't', 'r', '5',  #0,
  { 30-3F / 48-63 }
{      N    B    H    G    Z    6                   M    J    U    7    8        }
  #0, 'n', 'b', 'h', 'g', 'z', '6',  #0,  #0,  #0, 'm', 'j', 'u', '7', '8',  #0,
  { 40-4F / 64-79 }
{      ,    K    I    O    0    9              .    -    L        P            }
  #0, ',', 'k', 'i', 'o', '0', '9',  #0,  #0, '.', '-', 'l', 'o', 'p', '\',  #0,
  { 50-5F / 80-95 }
{                                    CaLo  RSh Retu   +         #             }
  #0,  #0, 'a',  #0, 'u', #39,  #0,  #0,  #0,  #0, #13, '+',  #0, '#',  #0,  #0,
  { 60-6F / 96-111 }
{                               BS                                               }
  #0,  #0,  #0,  #0,  #0,  #0,#127,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,
  { 70-7F / 112-127 }
{                              Esc  Num  F11                          Roll       }
  #0,  #0,  #0,  #0,  #0,  #0, #27,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0);



  CodeTab_SHIFT : array[$0..$7F] of Char =
  (
  { *** Tabelle SCAN-Code - mit SHIFT *** }
  { 00-0F / 00-15 }
{  0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F  }
{      F9        F5   F3   F1   F2  F12       F10   F8   F6   F4  TAB   ^       }
  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0, #09, '^',  #0,
  { 10-1F / 16-31 }
{    LAlt  LSh      Strg   Q    1                   Y    S    A    W    2        }
  #0,  #0,  #0,  #0,  #0, 'Q', '!',  #0,  #0,  #0, 'Y', 'S', 'A', 'W', '"',  #0,
  { 20-2F / 32-47 }
{      C    X    D    E    4    3            Spac   V    F    T    R    5        }
  #0, 'C', 'X', 'D', 'E', '$', '#',  #0,  #0, ' ', 'V', 'F', 'T', 'R', '%',  #0,
  { 30-3F / 48-63 }
{      N    B    H    G    Z    6                   M    J    U    7    8        }
  #0, 'N', 'B', 'H', 'G', 'Z', '&',  #0,  #0,  #0, 'M', 'J', 'U', '/', '(',  #0,
  { 40-4F / 64-79 }
{      ,    K    I    O    0    9              .    -    L        P            }
  #0, ';', 'K', 'I', 'O', '=', ')',  #0,  #0, ':', '_', 'L', 'O', 'P', '?',  #0,
  { 50-5F / 80-95 }
{                                    CaLo  RSh Retu   +         #             }
  #0,  #0, 'A',  #0, 'U', #96,  #0,  #0,  #0,  #0, #13, '*',  #0, #39,  #0,  #0,
  { 60-6F / 96-111 }
{                               BS                                               }
  #0,  #0,  #0,  #0,  #0,  #0,#127,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,
  { 70-7F / 112-127 }
{                              Esc  Num  F11                          Roll       }
  #0,  #0,  #0,  #0,  #0,  #0, #27,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0);



  CodeTab_CTRL : array[$0..$7F] of Char =
  (
  { *** Tabelle SCAN-Code - mit CTRL *** }
  { 00-0F / 00-15 }
{  0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F  }
{      F9        F5   F3   F1   F2  F12       F10   F8   F6   F4  TAB   ^       }
  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0, #09, #30,  #0,
  { 10-1F / 16-31 }
{    LAlt  LSh      Strg   Q    1                   Y    S    A    W    2        }
  #0,  #0,  #0,  #0,  #0, #17,  #0,  #0,  #0,  #0, #25, #19, #01, #23,  #0,  #0,
  { 20-2F / 32-47 }
{      C    X    D    E    4    3            Spac   V    F    T    R    5        }
  #0, #03, #24, #04, #05,  #0,  #0,  #0,  #0, ' ', #22, #06, #20, #18,  #0,  #0,
  { 30-3F / 48-63 }
{      N    B    H    G    Z    6                   M    J    U    7    8        }
  #0, #14, #02, #08, #07, #26,  #0,  #0,  #0,  #0, #13, #10, #21,  #0, #27,  #0,
  { 40-4F / 64-79 }
{      ,    K    I    O    0    9              .    -    L        P            }
  #0,  #0, #11, #09, #15,  #0, #29,  #0,  #0,  #0,  #0, #12, #15, #16, #28,  #0,
  { 50-5F / 80-95 }
{                                    CaLo  RSh Retu   +         #             }
  #0,  #0, #01,  #0, #21,  #0,  #0,  #0,  #0,  #0, #13,  #0,  #0,  #0,  #0,  #0,
  { 60-6F / 96-111 }
{                               BS                                               }
  #0,  #0,  #0,  #0,  #0,  #0,#127,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,
  { 70-7F / 112-127 }
{                              Esc  Num  F11                          Roll       }
  #0,  #0,  #0,  #0,  #0,  #0, #27,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0);



  CodeTab_ALT : array[$0..$7F] of Char =
  (
  { *** Tabelle SCAN-Code - mit ALT *** }
  { 00-0F / 00-15 }
{  0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F  }
{      F9        F5   F3   F1   F2  F12       F10   F8   F6   F4  TAB   ^       }
  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0, #09,  #0,  #0,
  { 10-1F / 16-31 }
{    LAlt  LSh      Strg   Q    1                   Y    S    A    W    2        }
  #0,  #0,  #0,  #0,  #0, '@',  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,
  { 20-2F / 32-47 }
{      C    X    D    E    4    3            Spac   V    F    T    R    5        }
  #0,  #0,  #0,  #0, #36,  #0, '#',  #0,  #0, ' ',  #0,  #0,  #0,  #0,  #0,  #0,
  { 30-3F / 48-63 }
{      N    B    H    G    Z    6                   M    J    U    7    8        }
  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0, '{', '[',  #0,
  { 40-4F / 64-79 }
{      ,    K    I    O    0    9              .    -    L        P            }
  #0,  #0,  #0,  #0,  #0, '}', ']',  #0,  #0,  #0,  #0,  #0,  #0,  #0, '\',  #0,
  { 50-5F / 80-95 }
{                                    CaLo  RSh Retu   +         #             }
  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0, #13, '~',  #0,  #0,  #0,  #0,
  { 60-6F / 96-111 }
{                               BS                                               }
  #0,  #0,  #0,  #0,  #0,  #0,#127,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,
  { 70-7F / 112-127 }
{                              Esc  Num  F11                          Roll       }
  #0,  #0,  #0,  #0,  #0,  #0, #27,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0,  #0);



  // keyboard codes
  // 1 Byte
  kbdNum         : byte      = $77;
  kbdCaps        : byte      = $58;
  kbdScroll      : byte      = $7E;
  kbdAlt         : byte      = $11;
  kbdCtrl        : byte      = $14;
  kbdLShift      : byte      = $12;
  kbdRShift      : byte      = $59;
  
  kbdEnter       : Byte      = $5A;
  kbdSpace       : Byte      = $29;
  kbdBS          : Byte      = $66;
  kbdTab         : Byte      = $0D;
  kbdESC         : Byte      = $76;
  


  kbdF1          : byte      = $05;
  kbdF2          : byte      = $06;
  kbdF3          : byte      = $04;
  kbdF4          : byte      = $0C;
  kbdF5          : byte      = $03;
  kbdF6          : byte      = $0B;
  kbdF7          : byte      = $83;
  kbdF8          : byte      = $0A;
  kbdF9          : byte      = $01;
  kbdF10         : byte      = $09;
  kbdF11         : byte      = $78;
  kbdF12         : byte      = $07;



  // 2 Byte - E0 XX
  kbdRGUI        : byte      = $27;
  kbdLGUI        : byte      = $1F;
  kbdApps        : byte      = $2F;



  // 4 Byte - E0 12 E0 XX
  kbdEnd         : byte      = $69;  // Ende
  kbdHome        : byte      = $6C;  // Pos1
  
  kbdUp          : Byte      = $75;
  kbdDn          : Byte      = $72;
  kbdLeft        : Byte      = $6B;
  kbdRight       : Byte      = $74;

  kbdPgUp        : Byte      = $7D;
  kbdPgDn        : Byte      = $7A;

  kbdInsert      : byte      = $70;
  kbdDelete      : byte      = $71;

  kbdPrint       : byte      = $12;



  // E1 14 77 E1 F0 14 F0 77
  kbdPause       : byte      = $E1;




  scanBreak      : byte      = $F0;
  scanExt        : byte      = $E0;



  // special chars send to host
  hstScroll      : byte      = $00;

  hstPrint       : byte      = $10; // Ctrl-P
  hstIns         : byte      = $16; // Ctrl-V
  hstHome        : byte      = $00;
  hstPgUp        : byte      = $12; // Ctrl-R
  hstPgDn        : byte      = $03; // Ctrl-C
  hstDel         : byte      = $08; // Ctrl-H
  hstEnd         : byte      = $00;
  hstLeft        : byte      = $13;  // Ctrl-S
  hstRight       : byte      = $04;  // Ctrl-D
  hstUp          : byte      = $05;  // Ctrl-E
  hstDn          : byte      = $18;  // Ctrl-X
  hstRGUI        : byte      = $00;
  hstLGUI        : byte      = $00;
  hstApps        : byte      = $00;

  hstF1          : byte      = $80;
  hstF2          : byte      = $81;
  hstF3          : byte      = $82;
  hstF4          : byte      = $83;
  hstF5          : byte      = $84;
  hstF6          : byte      = $85;
  hstF7          : byte      = $86;
  hstF8          : byte      = $87;
  hstF9          : byte      = $88;
  hstF10         : byte      = $89;
  hstF11         : byte      = $8A;
  hstF12         : byte      = $8B;


  keyBufferMax   : byte = 30;



  RE_CONST   : BYTE = 1;  // Code fuer RECEIVE CONST
  RE_CONIN   : BYTE = 2;  // Code fuer RECEIVE CONIN

  RE_ERROR_CODE
             : BYTE = 10;  // Code fuer RECEIVE ERROR CODE

  RE_WHO_ARE_YOU
             : BYTE = 20; // Code fuer Abfrage der Funktionalitaet
			//  des angeschlossenen Geraetes

// ------------------------------------------------------

  DEVCODE_PC_CPM_EMU   : BYTE = 2;  // Code fuer PC-CP/M-Emulator
  DEVCODE_KEYBOARD     : BYTE = 3;  // Code fuer Tastatur
  DEVCODE_DISPLAY      : BYTE = 4;  // Code fuer LCD-Display
  DEVCODE_RAMFLOPPY    : BYTE = 5;  // Code fuer RAM-Floppy


// Nachricht auf die Anfrage "Wer bist Du?" RE_WHO_ARE_YOU ist
// die Nachricht "Wer bin ich?" MESSAGE_WHO_AM_I
//
//  !!!!! Achtung diese Zeile muss bei jedem Geraet angepasst werden !!!!!
//
  MESSAGE_WHO_AM_I     : BYTE = DEVCODE_KEYBOARD;


{--------------------------------------------------------------}


{ Var Declarations }
{$IDATA}
structconst
  ClickEna       : boolean   = true;

var
  // PC keyboard handler
  BitCntr        : Byte;
  tmpByte        : Byte;
  KbShiftState   : tKbShiftState;
  KeybState      : tKeybState;
  LedState       : tLedState;
  KeyBdPipe      : pipe[32] of byte;
  LocalMode      : boolean;
  LocalByte      : byte;
  ch             : char;
  doClick        : boolean;
  InitFailed     : boolean;
  
  LED_GRUEN[@PortB, 1] : bit;
  LED_ROT[@PortB, 2] : bit;

  CAPS_pressed   : boolean;
  NUM_pressed    : boolean;
  Scroll_pressed : boolean;
  
  KeyBuffer      : array [1..keyBufferMax] of byte;
  keyBufferPtr   : Byte;
  

{
ITP2 Steuerleitungen

PD4 = DDWR (ITP2) = E
PD5 = DDAC (ITP2) = A
PD6 = CDEN (ITP2) = E/A
PD7 = CRAC (ITP2) = A/E

Anzeige

PB1 = LED1 gruen = A
PB2 = LED2 rot   = A
}

  DDWR_E[@PIND, 4]   : bit; // E

  DDAC_A[@PortD, 5]  : bit; // A

  CDEN_E[@PIND, 6]   : bit; // E
  CDEN_A[@PortD, 6]  : bit; // A
  CDEN_P[@DDRD, 6]   : bit; // P { 1=Ausgang, 0=Eingang }

  CRAC_A[@PortD, 7]  : bit; // A
  CRAC_E[@PIND, 7]   : bit; // E
  CRAC_P[@DDRD, 7]   : bit; // P { 1=Ausgang, 0=Eingang }



  BA_Mode : BA_Mode_Typ;
  RECEIVE_MODE : RECEIVE_MODE_Typ;
  SEND_MULTI_SIGN_LENGTH,
  BSEC_LFD_NR, VAR_SECTOR,
  VAR_TRACK_H, VAR_TRACK_L,
  VAR_WR_LFD_NR, VAR_WR_DATA_CNT,
  ERROR_CODE, ERROR_PARAM : BYTE;




{--------------------------------------------------------------}
{ functions }

Procedure InitKeyb;
begin
  BitCntr:= 11;
  KeybState:= KeyStat_Byte1;
  PipeFlush(KeyBdPipe);
end InitKeyb;



procedure InitPorts;
begin

  DDRB:= DDRB or %00000111;

{ D0..D3 = Daten }
  DDRC:= %00000000;
  
{
ITP2 Steuerleitungen

PD4 = DDWR (ITP2) = E
PD5 = DDAC (ITP2) = A
PD6 = CDEN (ITP2) = E/A
PD7 = CRAC (ITP2) = A/E
}
  DDRD:= DDRD or %00100000;

  // init port interrupt INT0
  MCUCR:= MCUCR or 2;                // falling edge INT0
  incl(GIFR, 6);                     // reset  INT0
  incl(GICR, 6);                     // enable INT0
end; // InitPorts



Interrupt INT0;
begin
  if InitFailed then
    return;
  endif;
  if (BitCntr in [3..10]) then    // Bit 3 to 10 is data. Parity bit,
    tmpByte:= tmpByte shr 1;                  // start and stop bits are ignored.
    setBit(tmpByte, 7, PinD.3);
  endif;
  dec (BitCntr);
  if BitCntr = 0 then                         // All bits received
    BitCntr:= 11;
    if LocalMode then
      LocalByte:= tmpByte;
      LocalMode:= false;
      Return;
    else
      PipeSend(KeyBdPipe, tmpByte);
    endif;
  endif;      // BitCntr = 0
end; // Interrupt INT0




procedure write_key(write_key_value : byte);
begin
  DisableInts;
  if keyBufferPtr<keyBufferMax then
    inc(keyBufferPtr);
    KeyBuffer[keyBufferPtr]:=write_key_value;
  endif;
  EnableInts;
end;



procedure write_c_key(cKey : char);
begin
  write_key(byte(cKey));
end;




procedure write_text(text : String[15]);
var
  zaehler : byte;
begin
  for zaehler:=1 to length(text) do
    write_c_key(text[zaehler]);
  endfor;
end;




procedure SendKey(sKey : byte);
begin
  case sKey of
    $00 : BeepOut(262, 10);
      |
    $80 : write_text('DIR'+char($0D)); // F1
      |
    $81 : write_text('POWER'+char($0D)); // F2
      |
    $82 : write_text('COPY'+char($0D)); // F3
      |
    $83 : write_text('ERA'+char($0D)); // F4
      |
    $84 : write_text('TYPEX'+char($0D)); // F5
      |
    $85 : write_text('EXIT'+char($0D)); // F6
      |
    $86 : write_text('TURBO'+char($0D)); // F7
      |
    $87 : write_text('TURBO'+char($0D)); // F8
      |
    $88 : write_key($0B); write_key($04); // F9   Ctrl-K + Ctrl-D
      |
    $89 : BeepSiren(0, 1); // F10
      |
    $8A : BeepSiren(0, 1); // F11
      |
    $8B : BeepSiren(0, 1); // F12
      |
  else
    write_key(sKey);
  endcase;
end; { procedure SendKey }


procedure SendKeyChar(sKey : char);
begin
  SendKey(byte(sKey));
end;






procedure Set_Kbd_clk;
begin
  BitCntr:= 11;
  incl(GIFR, 6);                     // reset  INT0
  PortD.2:= 1;
  DDRD.2:= 0;
  EnableInts;
end; { procedure Set_Kbd_clk }



procedure Reset_Kbd_clk;
begin
  DisableInts;
  BitCntr:= 11;
  PortD.2:= 0;
  DDRD.2:= 1;
end; { procedure Reset_Kbd_clk }



//------------------------[Transmit Byte to Keyboard]----------------------------


procedure SendToKbd(b1 : Byte);
var
  p              : boolean;
  w              : word;
  cnt            : byte;
begin
  DisableInts;
  p := not Parity(b1);
  DDRD.2 := 0;
  // check clock line
  w:= 60000;
  repeat
    dec(w);
  until PinD.2 and (w > 0);
  if (w <= 0) then
    InitFailed:= true;
    return;
  endif;
  // Bring the Clock line low for at least 100 microseconds.
  DDRD.2 := 1;
  PortD.2 := 0;
  mDelay(100);
  // Bring the Data line low.
  PortD.3 := 0;
  DDRD.3 := 1;
  // Release the Clock line.
  PortD.2 := 1;
  DDRD.2 := 0;
  // Wait for the device to bring the Clock line low.
  w:= 60000;
  repeat
    dec(w);
  until not PinD.2 and (w > 0);
  if (w <= 0) then
    InitFailed:= true;
    return;
  endif;
  // Sending the 8 bit data
  _ACCA:= B1;
  ASM;
    LDI    _ACCB, 8;
    M_tx_data:
    ROR    _ACCA

    // Set/reset the Data line to send the first data bit
    BRCS     M_tx_data0
    // set databit -> 0
    CBI    PortD, 3
    RJMP     M_tx_data1

    M_tx_data0:
    // set databit -> 1
    SBI    PortD, 3

    M_tx_data1:
    // Wait for the device to bring Clock high.
    SBIS   PIND, 2
    RJMP   M_tx_data1;                                // wait till CLK rise

    M_tx_data2:
    // Wait for the device to bring Clock low.
    SBIC   PIND, 2
    RJMP   M_tx_data2;                                // now wait till CLK falls down

    // next bit please ...
    DEC    _ACCB
    BRNE   M_tx_data
  ENDASM;
  // PARITY BIT
  // ????? even/odd ????????
  _ACCA.0 := P;
  ASM;
    ROR    _ACCA
    BRCS     M_tx_data3
    // set databit -> 0
    CBI    PortD, 3
    RJMP     M_tx_data5

    M_tx_data3:
    // set databit -> 1
    SBI    PortD, 3


    M_tx_data5:
    // Wait for the device to bring Clock high.
    SBIS   PIND, 2
    RJMP   M_tx_data5;                                // wait till CLK rise

    M_tx_data6:
    // Wait for the device to bring Clock low.
    SBIC   PIND, 2
    RJMP   M_tx_data6;                                // now wait till CLK falls down

    // Getting stopbit
    SBI PortD, 3
    M_tx_data7:
    // waiting until clock will rise
    SBIS   PIND, 2
    RJMP   M_tx_data7;                                // wait till CLK rise
    // Now release the Data line.
    //  DDRD.3 := 0;
    CBI DDRD, 3;
  ENDASM;
  // Wait for the device to bring Data and Clock low.
  repeat
  until not PinD.3 and not PinD.2;
  // Wait for the device to release Data and Clock
  repeat
  until PinD.2 and PinD.3;
  Reset_Kbd_clk;
  LocalMode:= true;
  Set_Kbd_clk;                                      // enable the keyboard
  // ignore first byte
  repeat
  until not LocalMode;
end;




//------------[Subroutine for sending LED status to the Keyboard]----------------

procedure Set_Kbd_state;
begin
  SendToKbd($ED);
  SendToKbd(byte(LedState));
End; { procedure Set_Kbd_state }




process SendToHost(16, 32 : iData);
var
  curScan : byte;
begin
  // warten bis eine Taste gedrueckt wurde
  WaitPipe(KeyBdPipe);
  
  // dann verarbeiten der Taste(n)
  While PipeStat(KeyBdPipe) > 0 do
  
    // Taste lesen
    curScan:= PipeRecv(KeyBdPipe);
    

      // Decode scan codes into char
      case KeybState of
        KeyStat_Byte1 : doClick:= true;
                      case curScan of
                        scanExt    : KeybState:= KeyStat_E0;         // $E0
                                     doClick:= false;
                                   |
                        scanBreak  : KeybState:= KeyStat_F0;        // $F0
                                     doClick:= false;
                                   |
                                   
                        kbdAlt     : // left ALT pressed
                                     if not ([shAlt] in KbShiftState) then
                                       incl(KbShiftState, [shAlt]);
                                     endif;
                                     doClick:= false;
                                   |
                        kbdLShift,
                        kbdRShift  : // SHIFT pressed
                                     if not ([shShift] in KbShiftState) then
                                       incl(KbShiftState, [shShift]);
                                     endif;
                                     doClick:= false;
                                   |
                        kbdCtrl    : // left CTRL pressed
                                     if not ([shCtrl] in KbShiftState) then
                                       incl(KbShiftState, [shCtrl]);
                                     endif;
                                     doClick:= false;
                                   |

                        kbdCaps    : // CAPS pressed
                                     if not CAPS_pressed then
                                       if ([shCaps] in KbShiftState) then
                                         excl(KbShiftState, [shCaps]);
                                         excl(LedState, [LedCaps]);
                                       else
                                         incl(KbShiftState, [shCaps]);
                                         incl(LedState, [LedCaps]);
                                       endif;
                                       Set_Kbd_state;
                                       CAPS_pressed:=true; // nur einmal annehmen
                                     endif;
                                     doClick:= false;
                                   |
                                   
                        kbdNum     : // NUM pressed
                                     if not NUM_pressed then
                                       if ([shNum] in KbShiftState) then
                                         excl(KbShiftState, [shNum]);
                                         excl(LedState, [LedNum]);
                                       else
                                         incl(KbShiftState, [shNum]);
                                         incl(LedState, [LedNum]);
                                       endif;
                                       Set_Kbd_state;
                                       NUM_pressed:=true; // nur einmal annehmen
                                     endif;
                                     doClick:= false;
                                   |
                                   
                                   
                        kbdScroll  : // Scroll pressed
                                     if not Scroll_pressed then
                                       if ([shScroll] in KbShiftState) then
                                         excl(KbShiftState, [shScroll]);
                                         excl(LedState, [LedScroll]);
                                       else
                                         incl(KbShiftState, [shScroll]);
                                         incl(LedState, [LedScroll]);
                                       endif;
                                       Set_Kbd_state;
                                       Scroll_pressed:=true; // nur einmal annehmen
                                     endif;
                                     doClick:= false;
                                   |
                                   
                                   
                                   
                        // special keys which can not handled by the lookup table
                        kbdEnter   : // Enter
                                     SendKey($0D);
                                   |
                        kbdSpace   :
                                     SendKeyChar(' ');
                                   |
                        kbdBS      :
                                     SendKey($7F);
                                   |
                        kbdTab     :
                                     SendKey($09);
                                   |
                        kbdESC     :
                                     SendKey($1B);
                                   |

                        kbdF1      : // F1
                                     SendKey(hstF1);
                                   |
                        kbdF2      : // F2
                                     SendKey(hstF2);
                                   |
                        kbdF3      : // F3
                                     SendKey(hstF3);
                                   |
                        kbdF4      : // F4
                                     SendKey(hstF4);
                                   |
                        kbdF5      : // F5
                                     SendKey(hstF5);
                                   |
                        kbdF6      : // F6
                                     SendKey(hstF6);
                                   |
                        kbdF7      : // F7
                                     SendKey(hstF7);
                                   |
                        kbdF8      : // F8
                                     SendKey(hstF8);
                                   |
                        kbdF9      : // F9
                                     SendKey(hstF9);
                                   |
                        kbdF10     : // F10
                                     SendKey(hstF10);
                                   |
                        kbdF11     : // F11
                                     SendKey(hstF11);
                                   |
                        kbdF12     : // F12
                                     SendKey(hstF12);
                                   |
                        kbdPause   : // Pause/Break, special case with multiple chars
                                     // Taste Pause lieber nicht druecken
                                     // E1 14 77 E1 F0 14 F0 77
                                   |
                      else
                        // wir muessen den SHIFT, CTRL, ALT und CAPS Status einfuegen
                        // fuer die Deutsche Tastatur

                        ch:=char($00);
                        
                        if [shShift] in KbShiftState then
                          if [shCaps] in KbShiftState then
                            ch:= CodeTab_NORMAL[curScan];
                          else
                            ch:= CodeTab_SHIFT[curScan];
                          endif;
                        else
                          if [shCaps] in KbShiftState then
                            ch:= CodeTab_SHIFT[curScan];
                          else
                            ch:= CodeTab_NORMAL[curScan];
                          endif;
                        endif;

                        if [shCtrl] in KbShiftState then
                          ch:= CodeTab_CTRL[curScan];
                        endif;

                        if [shAlt] in KbShiftState then
                          ch:= CodeTab_ALT[curScan];
                        endif;

                        SendKeyChar(ch);

                      endcase; { case curScan of }

                      if doClick and ClickEna then
                        BeepClick;
                      endif;
                      
                      
                    |
        KeyStat_E0 : KeybState:= KeyStat_Byte1;
                      doClick:= true;
                      
                      // der letzte Scan war $E0 = extended
                      case curScan of
                        scanBreak : KeybState:= KeyStat_F0;  // $F0
                                    doClick:= false;
                                  |
                        kbdAlt    : // ALT Gr pressed
                                    if not ([shAlt] in KbShiftState) then
                                      incl(KbShiftState, [shAlt]);
                                    endif;
                                    doClick:= false;
                                  |
                        kbdCtrl   : // right CTRL pressed
                                    if not ([shCtrl] in KbShiftState) then
                                      incl(KbShiftState, [shCtrl]);
                                    endif;
                                    doClick:= false;
                                  |
                        kbdEnter  : // NumPad Enter
                                    SendKey($0D);
                                  |
                        kbdUp     :
                                    SendKey(hstUp);
                                  |
                        kbdDn     :
                                    SendKey(hstDn);
                                  |
                        kbdLeft   :
                                    SendKey(hstLeft);
                                  |
                        kbdRight  :
                                    SendKey(hstRight);
                                  |
                        kbdPgUp   :
                                    SendKey(hstPgUp);
                                  |
                        kbdPgDn   :
                                    SendKey(hstPgDn);
                                  |
                        kbdHome   :
                                    SendKey(hstHome);
                                  |
                        kbdInsert :
                                    SendKey(hstIns);
                                  |
                        kbdDelete :
                                    SendKey(hstDel);
                                  |
                        kbdEnd    :
                                    SendKey(hstEnd);
                                  |
                        kbdRGUI   :
                                    SendKey(hstRGUI);
                                  |
                        kbdLGUI   :
                                    SendKey(hstLGUI);
                                  |
                        kbdApps   :
                                    SendKey(hstApps);
                                  |
                        kbdPrint  : // Print Screen, special case with multiple chars
                                    // hstPrint
                                  |
                      endcase;
                      
                      if doClick and ClickEna then
                        BeepClick;
                      endif;
                      
                      
                    |
        KeyStat_F0 : case curScan of     // last scan was $F0 = break
                        kbdAlt    : // ALT released
                                    if [shAlt] in KbShiftState then
                                      excl(KbShiftState, [shAlt]);
                                    endif;
                                  |
                        kbdLShift,
                        kbdRShift : // SHIFT released
                                    if [shShift] in KbShiftState then
                                      excl(KbShiftState, [shShift]);
                                    endif;
                                  |
                        kbdCtrl   : // CTRL released
                                    if [shCtrl] in KbShiftState then
                                      excl(KbShiftState, [shCtrl]);
                                    endif;
                                  |

                        kbdCaps   : // CAPS released
                                    CAPS_pressed:=false;
                                  |
                        kbdNum    : // NUM released
                                    NUM_pressed:=false;
                                  |
                        kbdScroll : // Scroll released
                                    Scroll_pressed:=false;
                                  |

                      endcase;
                      KeybState:= KeyStat_Byte1;
                    |


                    
      endcase;  // KeybState
  endwhile;
end;  { process SendToHost }



procedure Reset_Kbd_data;
begin
  PortD.3:= 0;
  DDRD.3:= 1;
end; { procedure Reset_Kbd_data }


procedure Set_Kbd_data;
begin
  PortD.3:= 1;
  DDRD.3:= 0;
end; { procedure Set_Kbd_data }




procedure KbdReset;
begin

  InitFailed:= false;
  Reset_Kbd_clk;                                                // disable the Keyboard
  
  mDelay(500);

  LocalByte:= 0;
  repeat
    SendToKbd($FF);                                             // reset the Keyboard and wait
  until (LocalByte in[$FA, $AA]) or InitFailed;                    // ack or selftest ok

  if InitFailed then
    Set_Kbd_clk;
    LedState:= [];
    KbShiftState:= [];
    KeybState:= KeyStat_Byte1;
  else
    // KBD LED: 0 -> Caps lock, 1 -> Scroll Lock, 2 -> Num Lock
    LedState:= [LedNum];
    Set_Kbd_state;                                                // initially Num Lock On
    InitKeyb;
  endif;
  
end; { procedure KbdReset }



function read_key : byte;
var
  read_key_value, key_counter : byte;
begin
  DisableInts;
  read_key_value:=KeyBuffer[1];
  dec(keyBufferPtr);
  if keyBufferPtr>0 then
    for key_counter:=1 to keyBufferPtr do
      KeyBuffer[key_counter]:=KeyBuffer[key_counter+1];
    endfor;
  endif;
  EnableInts;
  return(read_key_value);
end;





procedure start_keyboard;
begin
  InitKeyb;
  Start_Processes;

  KbdReset;

  if InitFailed then
    BeepSiren(0, 3);
  else
    BeepOutHL;
  endif;

  INCL(LED_GRUEN);

end; { procedure start_keyboard }



{--------------------------------------------------------------}









{ *** Anfang - Daten Programme *** }



procedure change_mode(DATA_Byte : Byte);
begin
  case DATA_Byte of

    RE_CONST       : RECEIVE_MODE := RECEIVE_CONST;
    |
    RE_CONIN       : RECEIVE_MODE := RECEIVE_CONIN;
    |
    RE_WHO_ARE_YOU : RECEIVE_MODE := RECEIVE_DEVCODE;
    |
    RE_ERROR_CODE  : RECEIVE_MODE := RECEIVE_ERROR_CODE;
    |

  else
    INCL(LED_ROT);
    ERROR_CODE := $01;
    ERROR_PARAM := DATA_Byte;
  endcase;
end; { procedure change_mode }






// sendet ein Nibble an die Z80
procedure SEND_ONE_NIBBLE(ONE_NIBBLE : Byte);
var
  Bit_Test : Byte;
begin
  // erstmal alles auf 0
  EXCL(CDEN_A);

  PortC := ONE_NIBBLE;

  NOP;
  NOP;
  NOP;
  NOP;

  while not Bit(CRAC_E) do
    INCL(CDEN_A);
  endwhile;

  while Bit(CRAC_E) do
    EXCL(CDEN_A);
  endwhile;

end; { procedure SEND_ONE_NIBBLE }




// sendet ein Byte an die Z80
procedure RUN_RECEIVE_MESSAGE(RECEIVE_MESSAGE : Byte);
var
  ONE_NIBBLE : Byte;
begin
 ONE_NIBBLE := RECEIVE_MESSAGE and $0F;
 SEND_ONE_NIBBLE(ONE_NIBBLE);

 ONE_NIBBLE := RECEIVE_MESSAGE shr 4;
 SEND_ONE_NIBBLE(ONE_NIBBLE);

end; { procedure RUN_RECEIVE_MESSAGE }







procedure RUN_RECEIVE_CONST;
var
  RECEIVE_MESSAGE : Byte;
begin
  if keyBufferPtr=0 then
    RECEIVE_MESSAGE:=$00;
  else
    RECEIVE_MESSAGE:=$FF;
  endif;
  RUN_RECEIVE_MESSAGE(RECEIVE_MESSAGE);

  RECEIVE_MODE := NO_RECEIVE_MODE;

end; { procedure RUN_RECEIVE_CONST }






procedure RUN_RECEIVE_CONIN;
var
  RECEIVE_MESSAGE, C_Zaehler : Byte;
begin
  if keyBufferPtr=0 then
    RECEIVE_MESSAGE:=$00;
  else
    Suspend(SendToHost);
    RECEIVE_MESSAGE:=read_key;
    Resume(SendToHost);
  endif; { if Pos_ConsoleIn=0 then }
  RUN_RECEIVE_MESSAGE(RECEIVE_MESSAGE);
  RECEIVE_MODE := NO_RECEIVE_MODE;
end; { procedure RUN_RECEIVE_CONST }









procedure RUN_RECEIVE_DEVCODE;
begin
  RUN_RECEIVE_MESSAGE(MESSAGE_WHO_AM_I);
  RECEIVE_MODE := NO_RECEIVE_MODE;
  start_keyboard;
end; { procedure RUN_RECEIVE_DEVCODE }





procedure RUN_RECEIVE_ERROR_CODE;
begin
  RUN_RECEIVE_MESSAGE(ERROR_CODE);  // Fehlercode 0=kein Fehler
  RUN_RECEIVE_MESSAGE(ERROR_PARAM);  // Parameter fuer Fehlercode
  RECEIVE_MODE := NO_RECEIVE_MODE;
  EXCL(LED_ROT);
end; { procedure RUN_RECEIVE_ERROR_CODE }






{ *** Ende - Daten Programme *** }












{ *** Anfang - Betriebsarten Programme *** }




procedure RUN_BA_mode_keineBA;
begin
  BA_Mode:=BA_mode_INI;
end; { procedure RUN_BA_mode_keineBA }





procedure RUN_BA_mode_SET_RD;
begin

  { Umschalten auf Server = Lesen, Client = Schreiben
   D0-D3 = Ausgaenge,
   CDEN = Ausgang,
   CRAC = Eingang  }
  DDRC:=%00001111; // D0-D3 A

  EXCL(CDEN_A); // 0 - Vorbelegung
  INCL(CDEN_P); // A
  EXCL(CDEN_A); // 0 - Vorbelegung
  EXCL(CRAC_P); // E

  EXCL(DDAC_A); // DDAC=0 -> RD = Bestaetigung der Umstellung

  BA_Mode:=BA_mode_RD;

end; { procedure RUN_BA_mode_SET_RD }





procedure RUN_BA_mode_INI;
begin

  if not Bit(DDWR_E) then // Am Anfang von WR -> RD (1 -> 0)
    RUN_BA_mode_SET_RD;
  endif;
end; { procedure RUN_BA_mode_INI }






procedure RUN_BA_mode_SET_WR;
begin

  BA_Mode:=BA_mode_WR;
  { Umschalten auf Server = Schreiben, Client = Lesen
    D0-D3 = Eingaenge,
    CDEN = Eingang,
    CRAC = Ausgang  }
  DDRC:=%00000000; // D0-D7 E

  EXCL(CDEN_P); // E
  EXCL(CRAC_A); // 0 - Vorbelegung
  INCL(CRAC_P); // A
  EXCL(CRAC_A); // 0 - Vorbelegung

  INCL(DDAC_A);  // DDAC=1 -> WR = Bestaetigung der Umstellung
end; { procedure RUN_BA_mode_SET_WR }






procedure RUN_BA_mode_RD;
begin

  if RECEIVE_MODE <> NO_RECEIVE_MODE then
    case RECEIVE_MODE of
    
      RECEIVE_CONST : RUN_RECEIVE_CONST;
      |
      RECEIVE_CONIN : RUN_RECEIVE_CONIN;
      |
      RECEIVE_DEVCODE : RUN_RECEIVE_DEVCODE;
      |
      RECEIVE_ERROR_CODE : RUN_RECEIVE_ERROR_CODE;
      |
      
    endcase; { if RECEIVE_MODE <> NO_RECEIVE_MODE then }
  endif; { if RECEIVE_MODE <> NO_RECEIVE_MODE then }


  if Bit(DDWR_E) then  // ist DDWR_E=1, dann will der
                       // Server auf WR umstellen
    RUN_BA_mode_SET_WR;
  endif;
end; { procedure RUN_BA_mode_RD }











procedure RUN_BA_mode_WR;
var
  DATA_Buf_LOW, DATA_Buf_HIGH,
  DATA_Buf : Byte;
begin

  if Bit(CDEN_E) then  // ist CDEN_E=1, dann hat der Server
                       // Daten gesendet

    NOP;
    NOP;
    NOP;
    NOP;

    DATA_Buf_LOW := PINC and %00001111; // Daten aus Port C lesen
                                          // es sind aber nur D0-D3 Daten
                                         // die anderen werden ausgeblendet

    while Bit(CDEN_E) do
      INCL(CRAC_A);
    endwhile;

    while not Bit(CDEN_E) do
      EXCL(CRAC_A);
    endwhile;

    // 2. Lauf

    NOP;
    NOP;
    NOP;
    NOP;

    DATA_Buf_HIGH := PINC and %00001111; // Daten aus Port C lesen
                                           // es sind aber nur D0-D3 Daten
                                          // die anderen werden ausgeblendet

    DATA_Buf_HIGH := DATA_Buf_HIGH shl 4;
    DATA_Buf := DATA_Buf_HIGH or DATA_Buf_LOW;

    change_mode(DATA_Buf);

    while Bit(CDEN_E) do
      INCL(CRAC_A);
    endwhile;

    EXCL(CRAC_A);

  endif; { if Bit(CDEN_E) then }


  if not Bit(DDWR_E) then  // ist DDWR_E=0, dann will der
                           // Server auf RD umstellen
    RUN_BA_mode_SET_RD;
  endif;

end; { procedure RUN_BA_mode_WR }


{ *** Ende - Betriebsarten Programme *** }









{--------------------------------------------------------------}
{ Main Program }
{$IDATA}



begin
  EXCL(LED_GRUEN); // gruen aus
  EXCL(LED_ROT); // rot aus


  // Vorbelegung vor dem Freischalten der Ausgaenge

  INCL(DDAC_A);  // DDAC=1
  EXCL(CRAC_A);  // CRAC=0

  InitPorts;

  INCL(DDAC_A);  // DDAC=1
  EXCL(CRAC_A);  // CRAC=0


  BA_Mode:=BA_mode_keineBA;
  RECEIVE_MODE := NO_RECEIVE_MODE;

  ERROR_CODE := $00;
  ERROR_PARAM := $00;

  CAPS_pressed:=false;
  NUM_pressed:=false;
  Scroll_pressed:=false;
  
  keyBufferPtr:=0;

  BeepClick;
  
  loop

  
    case BA_Mode of
      BA_mode_keineBA : RUN_BA_mode_keineBA;
      |
      BA_mode_INI : RUN_BA_mode_INI;
      |
      BA_mode_RD : RUN_BA_mode_RD;
      |
      BA_mode_WR : RUN_BA_mode_WR;
      |
    endcase;


  endloop;


end KBDPS2.

