unit BitOp;

{$mode objfpc}

interface

uses
  Classes, SysUtils; 


function GetBit(const Value: Byte; const Bit: Byte): Boolean;
function ClearBit(const Value: Byte; const Bit: Byte): DWord;
function SetBit(const Value: Byte; const Bit: Byte): Byte;
function EnableBit(const Value: Byte; const Bit: Byte; const TurnOn: Boolean): Byte;


implementation


function GetBit(const Value: Byte; const Bit: Byte): Boolean;
begin
  Result := (Value and (1 shl Bit)) <> 0;
end;

function ClearBit(const Value: Byte; const Bit: Byte): DWord;
begin
	Result := Value and not (1 shl Bit);
end;

function SetBit(const Value: Byte; const Bit: Byte): Byte;
begin
	Result := Value or (1 shl Bit);
end;

function EnableBit(const Value: Byte; const Bit: Byte; const TurnOn: Boolean): Byte;
begin
	Result := (Value or (1 shl Bit)) xor (Integer(not TurnOn) shl Bit);
end;


end.

