unit MainUnit;

{$mode objfpc}{$H+}{$M+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  synaser, StdCtrls, ExtCtrls, Buttons, IniFiles, DateUtils,
  Unit_CONS, wincpm, win_ws, BitOp, Trace;


const
  CRLF = CHR($0D)+CHR($0A);
  Laenge_ConsoleIn = 20;
  TEMPLATES = 'TEMPLATES';
  DiskImages = 'DiskImages';


type


  { TForm_CPD2 }

  TForm_CPD2 = class(TForm)
    BitBtn_Trace: TBitBtn;
    BitBtn_Save_Screen: TBitBtn;
    BitBtn_Print_Save: TBitBtn;
    BitBtn_Terminal_Save: TBitBtn;
    Button_IMAGE_save: TButton;
    Button_IMAGE_neu: TButton;
    Button_BOOT_aendern: TButton;
    Button_Close: TButton;
    Button_BOOT_neu: TButton;
    CheckBox_LOG_TERM: TCheckBox;
    CheckBox_Graf_Term: TCheckBox;
    CheckBox_LOG_WRITE: TCheckBox;
    CheckBox_LOG_READ: TCheckBox;
    CheckBox_LOG_CONOUT: TCheckBox;
    CheckBox_LOG_CONIN: TCheckBox;
    ComboBox_TIE: TComboBox;
    ComboBox_Image_Auswahl: TComboBox;
    ComboBoxBauds: TComboBox;
    ComboBoxPort: TComboBox;
    Edit_DISK: TEdit;
    Edit_BOOT: TEdit;
    Image1: TImage;
    Image_DISK_MONITOR: TImage;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label_VAR_SECNT: TLabel;
    Label_TRK: TLabel;
    Label_SEC: TLabel;
    Label_DISK: TLabel;
    LED_GE: TImage;
    LED_GN: TImage;
    LED_RT: TImage;
    Image_rt: TImage;
    Image_gn: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Terminal: TListBox;
    OpenDialog_IMAGE: TOpenDialog;
    OpenDialog_BOOT: TOpenDialog;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel_BOOT: TPanel;
    ConnectButton: TButton;
    Timer1: TTimer;
    procedure BitBtn_TraceClick(Sender: TObject);
    procedure BitBtn_Print_SaveClick(Sender: TObject);
    procedure BitBtn_Save_ScreenClick(Sender: TObject);
    procedure BitBtn_Terminal_SaveClick(Sender: TObject);
    procedure Button_BOOT_aendernClick(Sender: TObject);
    procedure Button_BOOT_neuClick(Sender: TObject);
    procedure Button_CloseClick(Sender: TObject);
    procedure Button_IMAGE_neuClick(Sender: TObject);
    procedure Button_IMAGE_saveClick(Sender: TObject);
    procedure CheckBox_LOG_CONINChange(Sender: TObject);
    procedure CheckBox_LOG_CONOUTChange(Sender: TObject);
    procedure CheckBox_LOG_READChange(Sender: TObject);
    procedure CheckBox_LOG_WRITEChange(Sender: TObject);
    procedure ComboBox_Image_AuswahlChange(Sender: TObject);
    procedure ComboBox_TIEChange(Sender: TObject);
    procedure ConnectButtonClick(Sender: TObject);
    procedure Edit_BOOTChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure TerminalKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState
      );
    procedure Timer1Timer(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
  private
    { private declarations }
    PortConnected : Boolean;
    FIni:TMemIniFile;
    BOOT_File_Name, BOOT_File_Ordner,
    PRINT_File_Name : string;
    ReadCOM : WideString;
    VAR_SECNT, VAR_SECTOR, VAR_TRACK, VAR_DISKNO,
    F1_x, F1_y : Integer;
    BOOT_File, PRINT_File : TMemoryStream;
    ConsoleIn  : Array [1..Laenge_ConsoleIn] of Byte;
    Pos_ConsoleIn : Byte;
    Trace_Liste : TStringList;
    procedure Port_verbinden;
    procedure Einlesen_BOOT_Datei;
    procedure Einlesen_IMAGE_Datei;
    procedure Send_BOOT_Sektor(BSEC_LFD_NR, BSEC_SECTOR : Byte);
    procedure DISK_MONITOR_OFF;
    procedure DISK_MONITOR_READ;
    procedure DISK_MONITOR_WRITE;
    procedure Read_IMAGE_Sektor(ISEC_LFD_NR : Byte);
    procedure Read_IMAGE_Sektor_unkomprimiert(ISEC_LFD_NR : Byte);
    procedure Write_IMAGE_Sektor(Zeile : string);
    procedure Write_IMAGE_Sektor_unkomprimiert(Zeile : String);
    procedure WRITE_TO_LIST(DatenByte : Byte);
    procedure Write_Trace(T_Zeile : String);
    procedure sende_Datum_und_Zeit;
  public
    { public declarations }
    Programm_File_Pfad, PRINT_File_Ordner : string;
    F2_x, F2_y : Integer;
    F2_bsDialog, LOG_CONIN, LOG_CONOUT,
    LOG_READ, LOG_WRITE, RW_Sperre2 : Boolean;

    FormTrace_Left, FormTrace_Top, FormTrace_Width, FormTrace_Height : Integer;

    procedure Send_Char_To_Serial(Zeichen : Byte);

  end; { TForm_CPD2 }

var
  Form_CPD2: TForm_CPD2;
  PortCom: TBlockSerial;

  const ligneMax = 30;

implementation

{ TForm_CPD2 }





procedure TForm_CPD2.FormCreate(Sender: TObject);
var
  l, Com_Port : string;
  p, Zeiger, Baud_Rate: integer;

begin
  Form_CPD2.Caption:='CP/M CONSOLE - Version 1.1 (c) by Ronald Daleske';

  // Terminal Emulation
  ComboBox_TIE.Items.Add('VT100');
  ComboBox_TIE.Items.Add('VT52');
  ComboBox_TIE.Items.Add('PC1715');
  ComboBox_TIE.Items.Add('ANSI');
  ComboBox_TIE.Items.Add('ADM31');

  Programm_File_Pfad := ExtractFilePath(Application.ExeName);
  FIni := TMemIniFile.Create(Programm_File_Pfad +'CONSOLE.ini');
  Com_Port := FIni.ReadString('ComPort', 'ComPort', 'COM1');
  Baud_Rate := FIni.ReadInteger('ComPort', 'BaudRate', 0);

  BOOT_File_Name := FIni.ReadString('BOOT', 'File_Name', 'CPD2.COM');
  BOOT_File_Ordner := FIni.ReadString('BOOT', 'File_Ordner', 'BOOT');

  Edit_BOOT.Text := BOOT_File_Name;

  PRINT_File_Name := FIni.ReadString('PRINT', 'File_Name', 'PRINT.txt');
  PRINT_File_Ordner := FIni.ReadString('PRINT', 'File_Ordner', 'PRINT');

  F1_x := FIni.ReadInteger('FORM', 'F1_x', 0);
  F1_y := FIni.ReadInteger('FORM', 'F1_y', 0);
  F2_x := FIni.ReadInteger('FORM', 'F2_x', 0);
  F2_y := FIni.ReadInteger('FORM', 'F2_y', 0);

  F2_bsDialog := FIni.ReadBool('FORM', 'F2_bsDialog', true);

  LOG_CONIN := FIni.ReadBool('FORM', 'LOG_CONIN', true);
  CheckBox_LOG_CONIN.Checked := LOG_CONIN;
  LOG_CONOUT := FIni.ReadBool('FORM', 'LOG_CONOUT', true);
  CheckBox_LOG_CONOUT.Checked := LOG_CONOUT;
  LOG_READ := FIni.ReadBool('FORM', 'LOG_READ', true);
  CheckBox_LOG_READ.Checked := LOG_READ;
  LOG_WRITE := FIni.ReadBool('FORM', 'LOG_WRITE', true);
  CheckBox_LOG_WRITE.Checked := LOG_WRITE;

  CheckBox_Graf_Term.Checked := FIni.ReadBool('Terminal', 'Graf_Term', false);

  CheckBox_LOG_TERM.Checked := FIni.ReadBool('Terminal', 'LOG_Term', false);

  ComboBox_TIE.ItemIndex := FIni.ReadInteger('Terminal', 'Index_Emulation', 0);

  FormTrace_Top := FIni.ReadInteger('TRACE', 'Top', 500);
  FormTrace_Left := FIni.ReadInteger('TRACE', 'Left', 100);
  FormTrace_Width := FIni.ReadInteger('TRACE', 'Width', 400);
  FormTrace_Height := FIni.ReadInteger('TRACE', 'Height', 400);

  if not dir_exist(Programm_File_Pfad+BOOT_File_Ordner) then
    create_dir(Programm_File_Pfad+BOOT_File_Ordner);

  ReadCOM:='';
  Terminal.Clear;

  l := GetSerialPortNames;

  if l >'' then
    repeat begin
      p :=  pos(',',l);
      if p > 0 then begin
        ComboBoxPort.Items.Add(copy(L,1,p-1));
        delete(L,1,p);
      end
      else
        ComboBoxPort.Items.Add(L);
    end;
    until p = 0;

  Zeiger:=-1;
  for p:=0 to ComboBoxPort.Items.Count-1 do begin
    if ComboBoxPort.Items[p]=Com_Port then
      Zeiger:=p;

  end; { for p:=0 to ComboBoxPort.Items.Count-1 do }

  if Zeiger>-1 then
    ComboBoxPort.ItemIndex:=Zeiger
  else
    ComboBoxPort.ItemIndex:=0;


  ComboBoxBauds.Items.Add('   110');
  ComboBoxBauds.Items.Add('   300');
  ComboBoxBauds.Items.Add('   600');
  ComboBoxBauds.Items.Add('  1200');
  ComboBoxBauds.Items.Add('  2400');
  ComboBoxBauds.Items.Add('  4800');
  ComboBoxBauds.Items.Add('  9600');
  ComboBoxBauds.Items.Add(' 14400');
  ComboBoxBauds.Items.Add(' 19200');
  ComboBoxBauds.Items.Add(' 38400');
  ComboBoxBauds.Items.Add(' 56000');
  ComboBoxBauds.Items.Add(' 57600');
  ComboBoxBauds.Items.Add('115200');
  ComboBoxBauds.Items.Add('128000');
  ComboBoxBauds.Items.Add('230400');
  ComboBoxBauds.Items.Add('256000');
  ComboBoxBauds.Items.Add('384000');
  ComboBoxBauds.Items.Add('512000');
//  ComboBoxBauds.Items.Add('1000000');
  ComboBoxBauds.ItemIndex:=Baud_Rate;



  ConnectButton.Caption:='Verbinden';
  PortConnected:=false;

  Image_rt.Visible:=true;
  Image_gn.Visible:=false;

  // BOOT
  VAR_SECNT:=0;
  BOOT_File := TMemoryStream.Create;
  Einlesen_BOOT_Datei;

  // IMAGE
  wcpm := Twcpm.Create(Terminal, Image1);
  Edit_DISK.Text := wcpm.Dateiname;
  wcpm.Write_Log_File:=false;

  ComboBox_Image_Auswahl.Items.Add('cpmdsk - Z80Emu for EZ80');
  ComboBox_Image_Auswahl.Items.Add('img - ZEMU - Z80 Emulator by Joe Moore');
  ComboBox_Image_Auswahl.Items.Add('dsk - SIMH AltairZ80 Simulator');

  ComboBox_Image_Auswahl.ItemIndex := wcpm.Index_Emulation;

  case ComboBox_Image_Auswahl.ItemIndex of
    0 : wcpm.load_dpb_cpmdsk;
    1 : wcpm.load_dpb_img;
    2 : wcpm.load_dpb_dsk;
  end;

  Einlesen_IMAGE_Datei;

  // PRINT
  PRINT_File := TMemoryStream.Create;

  LED_GE.Left:=Image_DISK_MONITOR.Left+48;
  LED_GN.Left:=Image_DISK_MONITOR.Left+128;
  LED_RT.Left:=Image_DISK_MONITOR.Left+208;

  LED_GE.Top:=Image_DISK_MONITOR.Top+58;
  LED_GN.Top:=Image_DISK_MONITOR.Top+58;
  LED_RT.Top:=Image_DISK_MONITOR.Top+58;

  LABEL_DISK.Left:=Image_DISK_MONITOR.Left+46;
  LABEL_SEC.Left:=Image_DISK_MONITOR.Left+113;
  LABEL_TRK.Left:=Image_DISK_MONITOR.Left+198;

  LABEL_DISK.Top:=Image_DISK_MONITOR.Top+32;
  LABEL_SEC.Top:=Image_DISK_MONITOR.Top+32;
  LABEL_TRK.Top:=Image_DISK_MONITOR.Top+32;

  LABEL_DISK.Font.Size:=9;
  LABEL_SEC.Font.Size:=9;
  LABEL_TRK.Font.Size:=9;

  DISK_MONITOR_OFF;
  RW_Sperre2:=false;
  Pos_ConsoleIn := 0;

  Trace_Liste := TStringList.Create;

end; { procedure TForm_CPD2.FormCreate }





procedure TForm_CPD2.Einlesen_BOOT_Datei;
var
  Pfad_Name : WideString;
begin

  Pfad_Name:=Programm_File_Pfad+BOOT_File_Ordner+'\'+BOOT_File_Name;
  if FileExists(Pfad_Name) then begin
    BOOT_File.LoadFromFile(Pfad_Name);
    VAR_SECNT:=BOOT_File.Size div 128;
    Terminal.Items.Add('BOOT-Datei: '+BOOT_File_Name+' geladen');
    Terminal.Items.Add('Anzahl der Sektoren= '+IntToStr(VAR_SECNT));
    Label_VAR_SECNT.Caption:='Anzahl der Sektoren= '+IntToStr(VAR_SECNT);
  end
  else begin
    Terminal.Items.Add('*** Fehler: Datei <'+Pfad_Name+'> nicht vorhanden');
    VAR_SECNT:=0;
  end;
end; { procedure TForm_CPD2.Einlesen_BOOT_Datei }







procedure TForm_CPD2.Einlesen_IMAGE_Datei;
var
  Pfad_Name, File_Name : WideString;

begin
  wcpm.Dateiname := Edit_DISK.Text;

  Pfad_Name := WideExtractFilePath(Application.ExeName);
  File_Name := Pfad_Name+IMAGE_DIR+'\'+wcpm.Dateiname;

  if FileExists(File_Name) then begin
    DeleteFile(File_Name);
  end;

  Image1.Picture.Bitmap.Width:=Image1.Width;
  Image1.Picture.Bitmap.Height:=Image1.Height;

  wcpm.Import_Files_To_Image;

  Terminal.Items.Add('IMAGE-Datei: '+wcpm.Dateiname+' geladen');

end; { procedure TForm_CPD2.Einlesen_IMAGE_Datei }






procedure TForm_CPD2.Port_verbinden;
var
  bauds: Integer;
  PortName, BaudRate : String;
begin

  if not PortConnected then begin
    PortCom := TBlockSerial.Create;
    PortCom.RaiseExcept := true;
    PortName:=ComboBoxPort.Items[ComboBoxPort.itemindex];
    PortCom.Connect(PortName);
    BaudRate:=ComboBoxBauds.Items[ComboBoxBauds.itemindex];
    bauds := StrToInt(BaudRate);
    PortCom.Config(bauds,8,'N',SB1,false,false); { baud, bits: integer; parity: char; stop: integer; softflow, hardflow: boolean }
    Timer1.Enabled:=true;
    ConnectButton.Caption:='Trennen';
    PortConnected:=true;
    Image_rt.Visible:=false;
    Image_gn.Visible:=true;
    Terminal.Items.Add('--- Port '+PortName+' ist mit einer Baudrate von '+BaudRate+' verbunden');
  end
  else begin
    ConnectButton.Caption:='Verbinden';
    PortConnected:=false;
    Timer1.Enabled:=false;
    PortCom.Free;
    Image_gn.Visible:=false;
    Image_rt.Visible:=true;
    Terminal.Items.Add('--- Port wurde getrennt');
  end;

end; { procedure TForm_CPD2.Port_verbinden }




procedure TForm_CPD2.ConnectButtonClick(Sender: TObject);
begin
  Port_verbinden;
end; { procedure TForm_CPD2.ConnectButtonClick }






procedure TForm_CPD2.Edit_BOOTChange(Sender: TObject);
begin
   BOOT_File_Name := Edit_BOOT.Text;
end;







procedure TForm_CPD2.Button_BOOT_neuClick(Sender: TObject);
begin
  Einlesen_BOOT_Datei;
end; { procedure TForm_CPD2.Button_BOOTClick }




procedure TForm_CPD2.Button_IMAGE_neuClick(Sender: TObject);
begin
  Einlesen_IMAGE_Datei;
end; { procedure TForm_CPD2.Button_IMAGE_neuClick }




procedure TForm_CPD2.Button_IMAGE_saveClick(Sender: TObject);
begin
  wcpm.Save_IMG_File;
  wcpm.Export_Files_From_Image;
end; { procedure TForm_CPD2.Button_IMAGE_saveClick }




procedure TForm_CPD2.Button_BOOT_aendernClick(Sender: TObject);
var
  f_name : String;
begin
  if OpenDialog_BOOT.Execute then begin
    Terminal.Items.Add('BOOT_File_Name='+BOOT_File_Name);
    Terminal.Items.Add('OpenDialog1.FileName='+OpenDialog_BOOT.FileName);
    f_name:=ExtractFileName(OpenDialog_BOOT.FileName);
    Terminal.Items.Add('f_name='+f_name);
    BOOT_File_Name := f_name;

    Edit_BOOT.Text := BOOT_File_Name;
  end;
end;




procedure TForm_CPD2.BitBtn_Print_SaveClick(Sender: TObject);
begin
  PRINT_File.SaveToFile(Programm_File_Pfad+PRINT_File_Ordner+'\'+PRINT_File_Name);
end; { procedure TForm_CPD2.BitBtn_Print_SaveClick }



procedure TForm_CPD2.BitBtn_TraceClick(Sender: TObject);
begin
  if FormTrace.Visible then begin
    FormTrace.Visible:=false;
    BitBtn_Trace.Caption:='Trace anzeigen';
  end
  else begin
    FormTrace.Visible:=true;
    BitBtn_Trace.Caption:='Trace ausblenden';
  end;
end; { procedure TForm_CPD2.BitBtn1Click }




procedure TForm_CPD2.BitBtn_Save_ScreenClick(Sender: TObject);
begin
  Form_CONS.Save_Screen;
end; { procedure TForm_CPD2.BitBtn_Save_ScreenClick }




procedure TForm_CPD2.BitBtn_Terminal_SaveClick(Sender: TObject);
begin
  terminal.Items.SaveToFile(Programm_File_Pfad+PRINT_File_Ordner+'\terminal.txt');
end; { procedure TForm_CPD2.BitBtn_Terminal_SaveClick }





procedure TForm_CPD2.Send_Char_To_Serial(Zeichen : Byte);
begin
  if not PortConnected then
    Port_verbinden;

  if RW_Sperre2 then begin
    ConsoleIn[Pos_ConsoleIn]:=Zeichen;
    Inc(Pos_ConsoleIn);
    if Pos_ConsoleIn>Laenge_ConsoleIn then
      Dec(Pos_ConsoleIn);

  end
  else begin
    PortCom.SendString('T'+IntToHex(Zeichen,2)+CRLF);

    if LOG_CONIN then
      Terminal.Items.Add('<< CONIN='+IntToHex(Zeichen,2));


  end; { if RW_Sperre then }

end; { procedure TForm_CPD2.Send_Char_To_Serial }







procedure TForm_CPD2.Send_BOOT_Sektor(BSEC_LFD_NR, BSEC_SECTOR : Byte);
var
  Zeile7, Zeile8 : String;
  DB8, DB7 : Byte;
  x1, x2, x3 : Integer;
begin
  if not PortConnected then
    Port_verbinden;

  BOOT_File.Position:=((BSEC_SECTOR*128)+(BSEC_LFD_NR*32));
  Zeile7:='R';
  Zeile8:=Zeile7;
  x3:=6; DB7:=%10000000;

  for x1:=0 to 31 do begin
    BOOT_File.Read(DB8,1);
    Zeile8:=Zeile8+IntToHex(DB8,2);

    for x2:=7 downto 0 do begin

      if GetBit(DB8,x2) then
        DB7 := SetBit(DB7,x3)
      else
        DB7 := ClearBit(DB7,x3);

      dec(x3);

      if x3<0 then begin
        Zeile7:=Zeile7+Char(DB7);
        x3:=6; DB7:=%10000000;
      end;

    end; { for x2:=0 to 7 do }

  end; { for x1:=0 to 31 do }

  Zeile7:=Zeile7+Char(DB7);

  PortCom.SendString(Zeile7+CRLF);

  if LOG_READ then
    Terminal.Items.Add('<< READ('+IntToStr(BSEC_LFD_NR)+')='+Zeile8);


end; { procedure TForm_CPD2.Send_BOOT_Sektor }





procedure TForm_CPD2.DISK_MONITOR_OFF;
var
  Zeichen : Byte;
begin
  LED_GE.Visible:=true;
  LED_GN.Visible:=false;
  LED_RT.Visible:=false;

  LABEL_DISK.Visible:=false;
  LABEL_SEC.Visible:=false;
  LABEL_TRK.Visible:=false;

  RW_Sperre2:=false;

  while Pos_ConsoleIn>0 do begin
    Zeichen:=ConsoleIn[Pos_ConsoleIn];
    Dec(Pos_ConsoleIn);

    PortCom.SendString('T'+IntToHex(Zeichen,2)+CRLF);

    if LOG_CONIN then
      Terminal.Items.Add('<< CONIN='+IntToHex(Zeichen,2));

  end; { if Pos_ConsoleIn>0 then }

end; { procedure TForm_CPD2.DISK_MONITOR_OFF }





procedure TForm_CPD2.DISK_MONITOR_READ;
begin
  LED_GE.Visible:=false;
  LED_GN.Visible:=true;
  LED_RT.Visible:=false;

  LABEL_DISK.Caption:=IntToStr(VAR_DISKNO);
  LABEL_SEC.Caption:=IntToStr(VAR_SECTOR);
  LABEL_TRK.Caption:=IntToStr(VAR_TRACK);

  LABEL_DISK.Visible:=true;
  LABEL_SEC.Visible:=true;
  LABEL_TRK.Visible:=true;
end; { procedure TForm_CPD2.DISK_MONITOR_READ }







procedure TForm_CPD2.DISK_MONITOR_WRITE;
begin
  LED_GE.Visible:=false;
  LED_GN.Visible:=false;
  LED_RT.Visible:=true;

  LABEL_DISK.Caption:=IntToStr(VAR_DISKNO);
  LABEL_SEC.Caption:=IntToStr(VAR_SECTOR);
  LABEL_TRK.Caption:=IntToStr(VAR_TRACK);

  LABEL_DISK.Visible:=true;
  LABEL_SEC.Visible:=true;
  LABEL_TRK.Visible:=true;

end; { procedure TForm_CPD2.DISK_MONITOR_WRITE }







procedure TForm_CPD2.Read_IMAGE_Sektor(ISEC_LFD_NR : Byte);
var
  Zeile7, Zeile8 : String;
  DB8, DB7 : Byte;
  x1, x2, x3 : Integer;
  I_POS : LongInt;

begin

  if not PortConnected then
    Port_verbinden;

  // VAR_SECTOR, VAR_TRACK, VAR_DISKNO, spt=72
  // 0..71, 72..143,
  // 18432 / 128 = 144 / 72 = 2

  if ISEC_LFD_NR=0 then
    DISK_MONITOR_READ;


  I_POS:=(ISEC_LFD_NR*32)+(((VAR_TRACK*wcpm.DPB.SPT)+(VAR_SECTOR))*128);

  if LOG_READ and (ISEC_LFD_NR=0) then
    Terminal.Items.Add('Sec='+IntToStr(VAR_SECTOR)+
                       ' Trk='+IntToStr(VAR_TRACK)+'  Dsk='+IntToStr(VAR_DISKNO));


  wcpm.IMG_File.Position:=I_POS;
  Zeile7:='R';
  Zeile8:=Zeile7;
  x3:=6; DB7:=%10000000;

  for x1:=0 to 31 do begin

    wcpm.IMG_File.Read(DB8,1);
    Zeile8:=Zeile8+IntToHex(DB8,2);

    for x2:=7 downto 0 do begin

      if GetBit(DB8,x2) then
        DB7 := SetBit(DB7,x3)
      else
        DB7 := ClearBit(DB7,x3);

      dec(x3);

      if x3<0 then begin
        Zeile7:=Zeile7+Char(DB7);
        x3:=6; DB7:=%10000000;
      end;

    end; { for x2:=0 to 7 do }

  end; { for x1:=0 to 31 do }


  Zeile7:=Zeile7+Char(DB7);


  PortCom.SendString(Zeile7+CRLF);

  if LOG_READ then
    Terminal.Items.Add('<< READ('+IntToStr(ISEC_LFD_NR)+')='+Zeile8);

  if ISEC_LFD_NR=3 then
    DISK_MONITOR_OFF;

end; { procedure TForm_CPD2.Read_IMAGE_Sektor }














procedure TForm_CPD2.Read_IMAGE_Sektor_unkomprimiert(ISEC_LFD_NR : Byte);
var
  B_Zaehler : Integer;
  Zeile : String;
  B_Byte : Byte;
  I_POS : LongInt;

begin

  if not PortConnected then
    Port_verbinden;

  // VAR_SECTOR, VAR_TRACK, VAR_DISKNO, spt=72
  // 0..71, 72..143,
  // 18432 / 128 = 144 / 72 = 2

  if ISEC_LFD_NR=0 then
    DISK_MONITOR_READ;


  I_POS:=(ISEC_LFD_NR*16)+(((VAR_TRACK*wcpm.DPB.SPT)+(VAR_SECTOR))*128);

  if LOG_READ and (ISEC_LFD_NR=0) then
    Terminal.Items.Add('Sec='+IntToStr(VAR_SECTOR)+
                       ' Trk='+IntToStr(VAR_TRACK)+'  Dsk='+IntToStr(VAR_DISKNO));


  wcpm.IMG_File.Position:=I_POS;
  Zeile:='U';
  for B_Zaehler:=0 to 15 do begin
    wcpm.IMG_File.Read(B_Byte,1);
    Zeile:=Zeile+IntToHex(B_Byte,2);
  end;
  PortCom.SendString(Zeile+CRLF);


  if LOG_READ then
    Terminal.Items.Add('<< READ('+IntToStr(ISEC_LFD_NR)+')='+Zeile);

  if ISEC_LFD_NR=7 then
    DISK_MONITOR_OFF;

end; { procedure TForm_CPD2.Read_IMAGE_Sektor_unkomprimiert }














procedure TForm_CPD2.Write_IMAGE_Sektor(Zeile : String);
var
  B_Zaehler, VAR_WR_LFD_NR : Integer;
  B_Byte : Byte;
  I_POS : LongInt;
  S_Zahl : String;
begin
  if not PortConnected then
    Port_verbinden;

  // 01 D01 .. D32
  S_Zahl := Copy(Zeile,1,2);
  VAR_WR_LFD_NR := StrToInt('$'+S_Zahl);

  if VAR_WR_LFD_NR=0 then begin
    if LOG_WRITE then
      Terminal.Items.Add('Sec='+IntToStr(VAR_SECTOR)+
                         ' Trk='+IntToStr(VAR_TRACK)+'  Dsk='+IntToStr(VAR_DISKNO));
    DISK_MONITOR_WRITE;
  end;

  if LOG_WRITE then
    Terminal.Items.Add('<< WRITE='+Zeile);

  // VAR_SECTOR, VAR_TRACK, VAR_DISKNO, spt=72
  // 0..71, 72..143,
  // 18432 / 128 = 144 / 72 = 2

  I_POS:=(VAR_WR_LFD_NR*32)+(((VAR_TRACK*wcpm.DPB.SPT)+(VAR_SECTOR))*128);

  wcpm.IMG_File.Position:=I_POS;

  for B_Zaehler:=0 to 31 do begin
    S_Zahl := Copy(Zeile,3+(B_Zaehler*2),2);
    B_Byte := StrToInt('$'+S_Zahl);
    wcpm.IMG_File.Write(B_Byte,1);
  end;

  if (VAR_WR_LFD_NR=3) then begin
    DISK_MONITOR_OFF;
  end; { if (VAR_WR_LFD_NR=4) then }


end; { procedure TForm_CPD2.Write_IMAGE_Sektor }










procedure TForm_CPD2.Write_IMAGE_Sektor_unkomprimiert(Zeile : String);
var
  B_Zaehler, VAR_WR_LFD_NR : Integer;
  B_Byte : Byte;
  I_POS : LongInt;
  S_Zahl : String;
begin
  if not PortConnected then
    Port_verbinden;


  S_Zahl := Copy(Zeile,1,2);
  VAR_WR_LFD_NR := StrToInt('$'+S_Zahl);

  if VAR_WR_LFD_NR=0 then begin
    if LOG_WRITE then
      Terminal.Items.Add('Sec='+IntToStr(VAR_SECTOR)+
                         ' Trk='+IntToStr(VAR_TRACK)+'  Dsk='+IntToStr(VAR_DISKNO));
    DISK_MONITOR_WRITE;
  end;


  if LOG_WRITE then
    Terminal.Items.Add('<< WRITE='+Zeile);

  // VAR_SECTOR, VAR_TRACK, VAR_DISKNO, spt=72
  // 0..71, 72..143,
  // 18432 / 128 = 144 / 72 = 2

  I_POS:=(VAR_WR_LFD_NR*16)+(((VAR_TRACK*72)+(VAR_SECTOR))*128);

  wcpm.IMG_File.Position:=I_POS;
  for B_Zaehler:=0 to 15 do begin
    S_Zahl := Copy(Zeile,3+(B_Zaehler*2),2);
    B_Byte := StrToInt('$'+S_Zahl);
    wcpm.IMG_File.Write(B_Byte,1);
  end;

  if (VAR_WR_LFD_NR=7) then begin
    DISK_MONITOR_OFF;
  end; { if (VAR_WR_LFD_NR=7) then }

end; { procedure TForm_CPD2.Write_IMAGE_Sektor_unkomprimiert }







procedure TForm_CPD2.WRITE_TO_LIST(DatenByte : Byte);
begin
  PRINT_File.Write(DatenByte,1);
end; { procedure TForm_CPD2.WRITE_TO_LIST }








procedure TForm_CPD2.Write_Trace(T_Zeile : String);
begin
  Trace_Liste.Add(T_Zeile);
  if Trace_Liste.Count=300 then begin
    Trace_Liste.SaveToFile('TRACE.TXT');
    Trace_Liste.Clear;
  end;
end; { procedure TForm_CPD2.Write_Trace }









procedure TForm_CPD2.sende_Datum_und_Zeit;
var
  Start_Datum : TDateTime;
  Zeile, S_Stunde, S_Minute, S_Sekunde : String;
  Diff : Word;
  Zahl : Byte;
begin
  Start_Datum:=StrToDate('01.01.1978');
  Diff:=DaysBetween(Date, Start_Datum)+1;
  Zeile:=TimeToStr(Time);
  S_Stunde:=Copy(Zeile,1,2);
  S_Minute:=Copy(Zeile,4,2);
  S_Sekunde:=Copy(Zeile,7,2);

  Zeile:='D'+IntToHex(Diff,4)+S_Stunde+S_Minute+S_Sekunde; // D329B133357 = D + Datum(4) + Zeit(6)

  PortCom.SendString(Zeile+CRLF);

  Terminal.Items.Add('<< Datum und Zeit gesendet ('+Zeile+')');


end; { procedure TForm_CPD2.sende_Datum_und_Zeit }








procedure TForm_CPD2.Timer1Timer(Sender: TObject);
var
  Kommando : Char;
  EmpfangsZeile : String;
  POS_KA, DatenByte, DatenByte2 : Integer;




    procedure Convert_7_to_8;
    var
      x1, x2, x3 : Integer;
      DB7, DB8 : Byte;
      EmpfangsZeile2 : String;
    begin
      EmpfangsZeile2 := Copy(EmpfangsZeile,1,2);
      x3:=7; DB8:=$00;
      for x1:=3 to 39 do begin
        DB7 := Byte(EmpfangsZeile[x1]);
        for x2:=6 downto 0 do begin

          if GetBit(DB7,x2) then
            DB8 := SetBit(DB8,x3)
          else
            DB8 := ClearBit(DB8,x3);

          dec(x3);

          if X3<0 then begin
            EmpfangsZeile2 := EmpfangsZeile2 + IntToHex(DB8,2);
            x3:=7; DB8:=$00;
          end;

        end; { for x2:=6 downto 0 do }
      end; { for x1:=3 to 39 do }

      EmpfangsZeile := EmpfangsZeile2;

    end; { procedure Convert_7_to_8 }




begin

  Timer1.Enabled := false;


  if (PortCom.CanReadEx(0) = true) then { Daten wurden empfangen }
    ReadCOM:=ReadCOM+PortCom.RecvPacket(10);



    POS_KA:=Pos('@',ReadCOM);
    if POS_KA>0 then begin
      ReadCOM := '';
      Terminal.Items.Clear;
      Terminal.Items.Add('>> RESET von der Hardware empfangen');
    end; { if POS_KA>0 then }


      while Pos(CRLF,ReadCOM)>0 do begin { Befehlszeile wurde vollstaendig empfangen }

        if Length(ReadCOM)>Length(CRLF) then begin
          Kommando:=ReadCOM[1];
          Delete(ReadCOM,1,1);
          case Kommando of


          'a' : begin // Anfangsinitialisierung - ReadCOM leeren
                  if Pos(CRLF,ReadCOM)=1 then begin
                    Delete(ReadCOM,1,Length(CRLF));
                    Form_CONS.Reset_Form;
                    PortCom.SendString('N'+IntToHex(VAR_SECNT,2)+CRLF);
                    Terminal.Items.Add('<< Anzahl der Sektoren= '+IntToStr(VAR_SECNT)+' gesendet');
                  end
                  else
                    Terminal.Items.Add('*** Fehler: zu viele Parameter in den Daten ('+ReadCOM+') ***');

                end; { 'a' }


            'b' : begin // Read BOOT Sektor
                    if Pos(CRLF,ReadCOM)=5 then begin
                      EmpfangsZeile:=Copy(ReadCOM,1,2);
                      DatenByte:=StrToInt('$'+EmpfangsZeile); // BSEC_LFD_NR
                      EmpfangsZeile:=Copy(ReadCOM,3,2);
                      DatenByte2:=StrToInt('$'+EmpfangsZeile); // BSEC_SECTOR
                      Delete(ReadCOM,1,4+Length(CRLF));
                      Send_BOOT_Sektor(DatenByte,DatenByte2);

                    end
                    else
                      Terminal.Items.Add('*** Fehler: zu viele Parameter in den Daten ('+ReadCOM+') ***');

                  end; { 'b' }



            'c' : begin // Trace
                    if Pos(CRLF,ReadCOM)=7 then begin
                      EmpfangsZeile:=Copy(ReadCOM,1,6);
                      Delete(ReadCOM,1,6+Length(CRLF));
                      Write_Trace(EmpfangsZeile);

                    end
                    else
                      Terminal.Items.Add('*** Fehler: zu viele Parameter in den Daten ('+ReadCOM+') ***');

                  end; { 'b' }










            'd' : begin // Datum und Zeit
                    if Pos(CRLF,ReadCOM)=1 then begin
                      Delete(ReadCOM,1,Length(CRLF));
                      sende_Datum_und_Zeit;
                    end
                    else
                      Terminal.Items.Add('*** Fehler: zu viele Parameter in den Daten ('+ReadCOM+') ***');

                  end; { 'd' }











            'l' : begin // LIST
                    if Pos(CRLF,ReadCOM)=3 then begin
                      EmpfangsZeile:=Copy(ReadCOM,1,2);
                      Delete(ReadCOM,1,2+Length(CRLF));
                      DatenByte:=StrToInt('$'+EmpfangsZeile);
                      WRITE_TO_LIST(DatenByte);
                    end
                    else
                      Terminal.Items.Add('*** Fehler: zu viele Parameter in den Daten ('+ReadCOM+') ***');

                  end; { 'l' }



            'o' : begin // CONOUT

                    if Pos(CRLF,ReadCOM)=3 then begin
                      EmpfangsZeile:=Copy(ReadCOM,1,2);
                      Delete(ReadCOM,1,2+Length(CRLF));
                      DatenByte:=StrToInt('$'+EmpfangsZeile);

                      if LOG_CONOUT then
                        Terminal.Items.Add('conout='+IntToHex(DatenByte,2));

                      Form_CONS.RECEIVE_FROM_CONOUT(DatenByte);


                    end
                    else
                      Terminal.Items.Add('*** Fehler: zu viele Parameter in den Daten ('+ReadCOM+') ***');

                  end; { 'o' }





            'r' : begin // Read IMAGE Sektor - komprimiert
                    if Pos(CRLF,ReadCOM)=3 then begin
                      EmpfangsZeile:=Copy(ReadCOM,1,2);
                      DatenByte:=StrToInt('$'+EmpfangsZeile); // ISEC_LFD_NR
                      Delete(ReadCOM,1,2+Length(CRLF));
                      Read_IMAGE_Sektor(DatenByte);
                    end
                    else
                      Terminal.Items.Add('*** Fehler: zu viele Parameter in den Daten ('+ReadCOM+') ***');

                  end; { 'r' }



            's' : begin // Sector, Track, Drive (STD) = s SE TH TL DR
                    if Pos(CRLF,ReadCOM)=9 then begin
                      // VAR_SECTOR, VAR_TRACK, VAR_DISKNO
                      RW_Sperre2:=true;
                      EmpfangsZeile:=Copy(ReadCOM,1,2);
                      VAR_SECTOR:=StrToInt('$'+EmpfangsZeile); // VAR_SECTOR
                      EmpfangsZeile:=Copy(ReadCOM,3,4);
                      VAR_TRACK:=StrToInt('$'+EmpfangsZeile); // VAR_TRACK
                      EmpfangsZeile:=Copy(ReadCOM,7,2);
                      VAR_DISKNO:=StrToInt('$'+EmpfangsZeile); // VAR_DISKNO
                      Delete(ReadCOM,1,8+Length(CRLF));
                    end
                    else
                      Terminal.Items.Add('*** Fehler: zu viele Parameter in den Daten ('+ReadCOM+') ***');

                  end; { 's' }


                  { 'T' fuer CONIN genutzt }


            'u' : begin // Read IMAGE Sektor - unkomprimiert
                    if Pos(CRLF,ReadCOM)=3 then begin
                      EmpfangsZeile:=Copy(ReadCOM,1,2);
                      DatenByte:=StrToInt('$'+EmpfangsZeile); // ISEC_LFD_NR
                      Delete(ReadCOM,1,2+Length(CRLF));
                      Read_IMAGE_Sektor_unkomprimiert(DatenByte);
                    end
                    else
                      Terminal.Items.Add('*** Fehler: zu viele Parameter in den Daten ('+ReadCOM+') ***');

                  end; { 'u' }




            // v NR D32 = v + 34 = 35
            'v' : begin // Write IMAGE Sektor - unkomprimiert
                    if Pos(CRLF,ReadCOM)=35 then begin
                      EmpfangsZeile:=Copy(ReadCOM,1,34);
                      Delete(ReadCOM,1,34+Length(CRLF));
                      Write_IMAGE_Sektor_unkomprimiert(EmpfangsZeile);
                    end
                    else
                      Terminal.Items.Add('*** Fehler: zu viele Parameter in den Daten ('+ReadCOM+') ***');

                  end; { 'v' }





                  // w NR DB7_01 .. DB7_37 = 37 + 2 = 39 + w
            'w' : begin // Write IMAGE Sektor - komprimiert
                    if Pos(CRLF,ReadCOM)=40 then begin
                      EmpfangsZeile:=Copy(ReadCOM,1,39);
                      Delete(ReadCOM,1,39+Length(CRLF));

                      Convert_7_to_8;

                      Write_IMAGE_Sektor(EmpfangsZeile);
                    end
                    else
                      Terminal.Items.Add('*** Fehler: zu viele Parameter in den Daten ('+ReadCOM+') ***');

                  end; { 'w' }



            'x' : begin // Fehlernummer
                    if Pos(CRLF,ReadCOM)=3 then begin
                      EmpfangsZeile:=Copy(ReadCOM,1,2);
                      Delete(ReadCOM,1,2+Length(CRLF));
                      Terminal.Items.Add('>> Fehler Nr: '+EmpfangsZeile+' vom Controller gesendet');
                    end
                    else
                      Terminal.Items.Add('*** Fehler: zu viele Parameter in den Daten ('+ReadCOM+') ***');

                  end; { 'x' }


            'y' : begin  // Kommentare
                      EmpfangsZeile:=Copy(ReadCOM,1,Pos(CRLF,ReadCOM)-1);
                      Delete(ReadCOM,1,Pos(CRLF,ReadCOM)-1+Length(CRLF));
                      Terminal.Items.Add('*** '+EmpfangsZeile);
                  end; { 'y' }


          else
            Terminal.Items.Add('*** Fehler: das Kommando:'+Kommando+' ('+IntToHex(Ord(Kommando),2)+') ist nicht definiert ***');
          end;

        end { if Length(ReadCOM)>Length(CRLF) then }
        else
          Terminal.Items.Add('*** Fehler: kein Kommando in der Befehlszeile ***');


      end; { while Pos(CRLF,ReadCOM)>0 do }


   Timer1.Enabled := true;

end; { procedure TForm_CPD2.Timer1Timer }











procedure TForm_CPD2.Timer2Timer(Sender: TObject);
begin
  Form_CPD2.Caption:='ReadCOM='+IntToStr(Length(ReadCOM));  // ReadCOM
end;





procedure TForm_CPD2.Button_CloseClick(Sender: TObject);
begin
  Close;
end; { procedure TForm_CPD2.ButtonCloseClick }




procedure TForm_CPD2.CheckBox_LOG_CONINChange(Sender: TObject);
begin
  LOG_CONIN:=CheckBox_LOG_CONIN.Checked;
end; { procedure TForm_CPD2.CheckBox_LOG_CONINChange }



procedure TForm_CPD2.CheckBox_LOG_CONOUTChange(Sender: TObject);
begin
  LOG_CONOUT:=CheckBox_LOG_CONOUT.Checked;
end; { procedure TForm_CPD2.CheckBox_LOG_CONOUTChange }



procedure TForm_CPD2.CheckBox_LOG_READChange(Sender: TObject);
begin
  LOG_READ:=CheckBox_LOG_READ.Checked;
end; { procedure TForm_CPD2.CheckBox_LOG_READChange }



procedure TForm_CPD2.CheckBox_LOG_WRITEChange(Sender: TObject);
begin
  LOG_WRITE:=CheckBox_LOG_WRITE.Checked;
end; { procedure TForm_CPD2.CheckBox_LOG_WRITEChange }




procedure TForm_CPD2.ComboBox_Image_AuswahlChange(Sender: TObject);
var
  DatName : String;
begin
  DatName  := ExtractFileName(Edit_DISK.Text);
  if pos(wcpm.DateiExtention,DatName)>0 then
    delete(DatName,pos(wcpm.DateiExtention,DatName),Length(wcpm.DateiExtention));

  wcpm.Index_Emulation := ComboBox_Image_Auswahl.ItemIndex;

  case ComboBox_Image_Auswahl.ItemIndex of
    0 : wcpm.load_dpb_cpmdsk;
    1 : wcpm.load_dpb_img;
    2 : wcpm.load_dpb_dsk;
  end;

  DatName := DatName + wcpm.DateiExtention;
  Edit_DISK.Text := DatName;
  wcpm.Dateiname:= DatName;


  Einlesen_IMAGE_Datei;

end; { procedure TForm_CPD2.ComboBox_Image_AuswahlChange }





procedure TForm_CPD2.ComboBox_TIEChange(Sender: TObject);
begin
  Form_CONS.SET_EmuMode;
end;





procedure TForm_CPD2.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin

  if Shift = [] then
    case Key of
      27 : Form_CPD2.Close; // ESC
  end; { if Shift = [] then }

end; { procedure TForm_CPD2.FormKeyDown }



procedure TForm_CPD2.FormShow(Sender: TObject);
begin
  Form_CPD2.Left := F1_x;
  Form_CPD2.Top := F1_y;
end;



procedure TForm_CPD2.TerminalKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin

  if Shift = [] then
    case Key of
      27 : Form_CPD2.Close; // ESC
  end; { if Shift = [] then }

end; { procedure TForm_CPD2.TerminalKeyDown }






procedure TForm_CPD2.FormDestroy(Sender: TObject);
begin
  if Assigned(FIni) then begin
    FIni.WriteString('ComPort', 'ComPort', ComboBoxPort.Items[ComboBoxPort.itemindex] );
    FIni.WriteInteger('ComPort','BaudRate', ComboBoxBauds.itemindex );

    FIni.WriteString('BOOT', 'File_Name', BOOT_File_Name );
    FIni.WriteString('BOOT', 'File_Ordner', BOOT_File_Ordner );

    FIni.WriteString('PRINT', 'File_Name', PRINT_File_Name );
    FIni.WriteString('PRINT', 'File_Ordner', PRINT_File_Ordner );

    FIni.WriteInteger('FORM','F1_x', Form_CPD2.Left );
    FIni.WriteInteger('FORM','F1_y', Form_CPD2.Top );
    FIni.WriteInteger('FORM','F2_x', Form_CONS.Left );
    FIni.WriteInteger('FORM','F2_y', Form_CONS.Top );


    FIni.WriteBool('FORM','F2_bsDialog', F2_bsDialog );

    FIni.WriteBool('FORM','LOG_CONIN', LOG_CONIN );
    FIni.WriteBool('FORM','LOG_CONOUT', LOG_CONOUT );
    FIni.WriteBool('FORM','LOG_READ', LOG_READ );
    FIni.WriteBool('FORM','LOG_WRITE', LOG_WRITE );

    FIni.WriteBool('Terminal','Graf_Term', CheckBox_Graf_Term.Checked );

    FIni.WriteBool('Terminal','LOG_Term', CheckBox_LOG_TERM.Checked );

    FIni.WriteInteger('Terminal', 'Index_Emulation', ComboBox_TIE.ItemIndex );

    FIni.WriteInteger('TRACE','Top', FormTrace_Top );
    FIni.WriteInteger('TRACE','Left', FormTrace_Left );
    FIni.WriteInteger('TRACE','Width', FormTrace_Width );
    FIni.WriteInteger('TRACE','Height', FormTrace_Height );


    FIni.UpdateFile;
    FIni.Free;
  end; { if Assigned(FIni) then }

  if PortConnected then
    PortCom.Free;


  BOOT_File.Free;


  wcpm.Save_IMG_File;
  wcpm.Export_Files_From_Image;

  wcpm.Index_Emulation := ComboBox_Image_Auswahl.ItemIndex;
  wcpm.Dateiname := Edit_DISK.Text;
  wcpm.Destroy;


  if PRINT_File.Size>0 then
    PRINT_File.SaveToFile(Programm_File_Pfad+PRINT_File_Ordner+'\'+PRINT_File_Name);

  PRINT_File.Free;

end; { procedure TForm_CPD2.FormDestroy }









initialization
  {$I MainUnit.lrs}

end.

