unit Unit_CONS;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  ExtCtrls, StdCtrls, MMSystem;


const
  max_Zeilen = 24;
  max_Spalten = 80;
  x_Offset = 3;
  y_Offset = 29;
//  Fuellzeichen = '.';
  Fuellzeichen = ' ';
  ZeiHoehe = 18;
  ZeiBreite = 10;
  LeftMargin = 40;
  TopMargin = 24;

type

  TZeichenZeile = Array [1..max_Spalten] of Char;
  TZeichenMatrix = Array [1..max_Zeilen] of TZeichenZeile;

  TTermMode = (Normal_TM, IBM_ESC_TM, IBM_CSI_TM, IBM_CSI_TM_Par, IBM_CSI_TM_Par_Zeile,
               PC1715_ESC_TM, PC1715_TM_Zeile, DCA_TM, DCA_TM_Zeile,
               ADM31_ESC_TM, ADM31_ESC_TM_R, ADM31_ESC_TM_C, ADM31_ESC_ESC,
               ADM31_ESC_ESC_ESC, ADM31_ESC_TM_G);

  TEmuMode = (Emu_VT100, Emu_VT52, Emu_PC1715, EMU_ANSI, EMU_ADM31);

  TMCursor = record
               on_off : boolean;
               Spalte, Zeile : Integer;
               Zeichen : Char;
             end;

  { TForm_CONS }

  TForm_CONS = class(TForm)
    Image_Graf_Mon2: TImage;
    Image_Graf_Mon1: TImage;
    Image_MON: TImage;
    StaticText1: TStaticText;
    StaticText2: TStaticText;
    Timer_CURSOR: TTimer;
    Timer_DEL: TTimer;
    Timer_BWS: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: word; Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure Image_MONMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Timer_CURSORTimer(Sender: TObject);
    procedure Timer_DELTimer(Sender: TObject);
    procedure Timer_BWSTimer(Sender: TObject);

  private
    { private declarations }
    MCursor : TMCursor;
    beim_ersten_mal, DEL_Sperre, ST_change,
    BOLD_ON : Boolean;
    ZeichenMatrix, BOLDMatrix : TZeichenMatrix;
    TermMode : TTermMode;
    EmuMode : TEmuMode;
    CSI_Parameter1, CSI_Parameter2, ESC_Zeile : Integer;
    CONOUT_Line : String;
    CONTROL_ACTIVE : Boolean;
    procedure RUN_DEL;
    procedure Matrix_in_StaticText;
    procedure Matrix_in_GrafMon;
  public
    { public declarations }
    procedure SET_EmuMode;
    procedure SET_Graf_Term;
    procedure RECEIVE_FROM_CONOUT(Zeichen : Byte);
    procedure Reset_Form;
    procedure Save_Screen;
  end;

var
  Form_CONS: TForm_CONS;

implementation

uses
  MainUnit;


{ TForm_CONS }




procedure TForm_CONS.FormCreate(Sender: TObject);
begin
  beim_ersten_mal:=true;

  BOLD_ON := false;

  StaticText1.Left:=80;
  StaticText1.Top:=60;
  StaticText1.Height:=472;
  StaticText1.Width:=864;
  StaticText1.Font.Name:='Courier New';
  StaticText1.Font.Size:=12;

  StaticText2.Left:=80;
  StaticText2.Top:=60;
  StaticText2.Height:=472;
  StaticText2.Width:=864;
  StaticText2.Font.Name:='Courier New';
  StaticText1.Font.Size:=12;

  Image_Graf_Mon1.Left:=40;
  Image_Graf_Mon1.Top:=40;
  Image_Graf_Mon1.Height:=509;
  Image_Graf_Mon1.Width:=910;
  Image_Graf_Mon1.Canvas.Brush.Color:=clWhite;
  Image_Graf_Mon1.Canvas.Pen.Color:=clWhite;
  Image_Graf_Mon1.Canvas.Pen.Width:=1;
  Image_Graf_Mon1.Canvas.Font.Name:='Courier New';
  Image_Graf_Mon1.Canvas.Font.Size:=12;
  Image_Graf_Mon1.Canvas.Rectangle(0,0,Image_Graf_Mon1.Width,Image_Graf_Mon1.Height);


  Image_Graf_Mon2.Left:=40;
  Image_Graf_Mon2.Top:=40;
  Image_Graf_Mon2.Height:=509;
  Image_Graf_Mon2.Width:=910;
  Image_Graf_Mon2.Canvas.Brush.Color:=clWhite;
  Image_Graf_Mon2.Canvas.Pen.Color:=clWhite;
  Image_Graf_Mon2.Canvas.Pen.Width:=1;
  Image_Graf_Mon2.Canvas.Font.Name:='Courier New';
  Image_Graf_Mon2.Canvas.Font.Size:=12;
  Image_Graf_Mon2.Canvas.Rectangle(0,0,Image_Graf_Mon1.Width,Image_Graf_Mon1.Height);

  SET_Graf_Term;

  SET_EmuMode;

  ST_change := true;
  Reset_Form;

  CONOUT_Line:='';
  CONTROL_ACTIVE:=false;

end; { procedure TForm_CONS.FormCreate }




procedure TForm_CONS.SET_Graf_Term;
begin
  if Form_CPD2.CheckBox_Graf_Term.Checked then begin
    Image_Graf_Mon1.Visible:=true;
    Image_Graf_Mon2.Visible:=false;
    StaticText2.Visible:=false;
    StaticText1.Visible:=false;
  end
  else begin
    Image_Graf_Mon1.Visible:=false;
    Image_Graf_Mon2.Visible:=false;
    StaticText2.Visible:=false;
    StaticText1.Visible:=true;
  end;
end; { procedure TForm_CONS.SET_Graf_Term }




procedure TForm_CONS.SET_EmuMode;
begin
    case Form_CPD2.ComboBox_TIE.ItemIndex of
    0 : EmuMode := Emu_VT100;
    1 : EmuMode := Emu_VT52;
    2 : EmuMode := Emu_PC1715;
    3 : EmuMode := EMU_ANSI;
    4 : EmuMode := EMU_ADM31;
  end;
end;


procedure TForm_CONS.Matrix_in_StaticText;
var
  z1, s1 : Integer;
  MatrixZeichen : Char;
  Zeile : WideString;
begin
  Zeile := '';
  for z1:=1 to max_Zeilen do begin
    for s1:=1 to max_Spalten do begin
      MatrixZeichen := ZeichenMatrix[z1,s1];
      Zeile := Zeile + MatrixZeichen;
    end;
    if z1<max_Zeilen then
      Zeile := Zeile + Chr($0D)+Chr($0A);

  end;
  if StaticText1.Visible then begin
    StaticText2.Caption := Zeile;
    StaticText1.Visible:=false;
    StaticText2.Visible:=true;
  end
  else begin
    StaticText1.Caption := Zeile;
    StaticText2.Visible:=false;
    StaticText1.Visible:=true;
  end;
end; { procedure TForm_CONS.Matrix_in_StaticText }







procedure TForm_CONS.Matrix_in_GrafMon;
var
  z1, s1, x1, y1 : Integer;
  MatrixZeichen : Char;
begin
  x1:=LeftMargin;
  y1:=TopMargin;
  for z1:=1 to max_Zeilen do begin
    for s1:=1 to max_Spalten do begin
      MatrixZeichen := ZeichenMatrix[z1,s1];
      x1:=LeftMargin+(ZeiBreite*(s1-1));
      y1:=TopMargin+(ZeiHoehe*(z1-1));
      if Image_Graf_Mon1.Visible then begin
        if BOLDMatrix[z1,s1]='1' then
          Image_Graf_Mon2.Canvas.Font.Style:=[fsBold]
        else
          Image_Graf_Mon2.Canvas.Font.Style:=[];

        Image_Graf_Mon2.Canvas.TextOut(x1,y1,MatrixZeichen);
      end
      else begin
        if BOLDMatrix[z1,s1]='1' then
          Image_Graf_Mon1.Canvas.Font.Style:=[fsBold]
        else
          Image_Graf_Mon1.Canvas.Font.Style:=[];

        Image_Graf_Mon1.Canvas.TextOut(x1,y1,MatrixZeichen);
      end;

    end;

  end;
  if Image_Graf_Mon1.Visible then begin
    Image_Graf_Mon1.Visible:=false;
    Image_Graf_Mon2.Visible:=true;
  end
  else begin
    Image_Graf_Mon2.Visible:=false;
    Image_Graf_Mon1.Visible:=true;
  end;
end; { procedure TForm_CONS.Matrix_in_GrafMon }





procedure TForm_CONS.Save_Screen;
var
  z1, s1 : Integer;
  Zeile : String;
  SS_Line : TStringList;
begin
  SS_Line := TStringList.Create;
  for z1:=1 to max_Zeilen do begin
    Zeile:='';
    for s1:=1 to max_Spalten do begin
      Zeile:=Zeile+ZeichenMatrix[z1,s1];
    end; { for s1:=1 to max_Spalten do }
    SS_Line.Add(Zeile);
  end; { for z1:=1 to max_Zeilen do }
  SS_Line.SaveToFile(Form_CPD2.PRINT_File_Ordner+'\SCREEN.TXT');
  SS_Line.Free;

end; { procedure TForm_CONS.Save_Screen }




procedure TForm_CONS.Reset_Form;
var
  z1, s1 : Integer;
begin
  DEL_Sperre:=false;

  for s1:=1 to max_Spalten do begin
    for z1:=1 to max_Zeilen do begin
      ZeichenMatrix[z1,s1]:=Fuellzeichen;
    end;
  end;

  MCursor.Spalte:=1;
  MCursor.Zeile:=1;
  MCursor.on_off:=false;
  CSI_Parameter1:=0;
  CSI_Parameter2:=0;
  ESC_Zeile:=0;
  TermMode := Normal_TM;

  Timer_CURSOR.Enabled:=true;

  ST_change := true;

end; { procedure TForm_CONS.Reset_Form }




procedure TForm_CONS.RUN_DEL;
begin
  Timer_CURSOR.Enabled:=false;

  if MCursor.on_off then begin
    ZeichenMatrix[MCursor.Zeile,MCursor.Spalte]:=MCursor.Zeichen;
    MCursor.on_off:=false;
  end; { if MCursor.on_off then }

  if MCursor.Spalte>1 then begin
    dec(MCursor.Spalte);
    ZeichenMatrix[MCursor.Zeile,MCursor.Spalte]:=Fuellzeichen;
  end;

  Timer_CURSOR.Enabled:=true;
end; { procedure TForm_CONS.RUN_DEL }




procedure TForm_CONS.RECEIVE_FROM_CONOUT(Zeichen : Byte);



  procedure Zeilen_Scrollen;
  var
    z1, s1 : Integer;
  begin
    for z1:=1 to max_Zeilen-1 do begin
      ZeichenMatrix[z1]:=ZeichenMatrix[z1+1];
    end;
    for s1:=1 to max_Spalten do begin
      ZeichenMatrix[max_Zeilen,s1]:=Fuellzeichen;
    end;
    MCursor.Spalte:=1;
    MCursor.Zeile:=max_Zeilen;
  end; { procedure Zeilen_Scrollen }



  procedure RUN_BELL;
  begin
    sndPlaySound(PChar(Form_CPD2.Programm_File_Pfad+'bell.wav'), SND_NODEFAULT Or SND_ASYNC);
  end; { procedure RUN_BELL }



  procedure Zeichen_in_Matrix(MZeichen : Byte);
  begin
    ZeichenMatrix[MCursor.Zeile,MCursor.Spalte]:=Chr(MZeichen);
    if BOLD_ON then
      BOLDMatrix[MCursor.Zeile,MCursor.Spalte]:='1'
    else
      BOLDMatrix[MCursor.Zeile,MCursor.Spalte]:='0';

    Inc(MCursor.Spalte);
    if MCursor.Spalte>max_Spalten then begin
      MCursor.Spalte:=1;
      Inc(MCursor.Zeile);
      if MCursor.Zeile>max_Zeilen then begin
        Zeilen_Scrollen;
      end;
    end;
  end; { procedure Zeichen_in_Matrix }



  procedure SonderZeichen_in_Matrix;
  var
    SZeile : String;
    SZaehler : Integer;
  begin
    SZeile:='['+IntToHex(Zeichen,2)+']';
    Form_CPD2.Terminal.Items.Add('CODE : '+SZeile+' nicht aufgeloest');

  end; { procedure SonderZeichen_in_Matrix }


  procedure ESC_SonderZeichen_in_Matrix(SonderZeichen : String);
  var
    SZeile : String;
    SZaehler, SondZeichen : Integer;
    CZeichen : Char;
  begin
    SZeile:='[ESC]';
    for SZaehler:=1 to Length(SonderZeichen) do begin
      CZeichen := SonderZeichen[SZaehler];
      SondZeichen := ord(CZeichen);
      SZeile:=SZeile+'['+IntToHex(SondZeichen,2)+']';
    end;

    SZeile:=SZeile+'['+IntToHex(Zeichen,2)+']';
    Form_CPD2.Terminal.Items.Add('CODE : '+SZeile+' nicht aufgeloest');

  end; { procedure ESC_SonderZeichen_in_Matrix }


  procedure CURSOR_UP;
  begin
    if MCursor.Zeile>1 then
      Dec(MCursor.Zeile);

    MCursor.on_off:=true;
    TermMode:=Normal_TM;
  end; { procedure CURSOR_UP }


  procedure CURSOR_DOWN;
  begin
    if MCursor.Zeile<max_Zeilen then
      Inc(MCursor.Zeile);

    MCursor.on_off:=true;
    TermMode:=Normal_TM;
  end; { procedure CURSOR_DOWN }


  procedure CURSOR_RIGHT;
  begin
    if MCursor.Spalte<max_Spalten then
      Inc(MCursor.Spalte);

    MCursor.on_off:=true;
    TermMode:=Normal_TM;
  end; { procedure CURSOR_RIGHT }


  procedure CURSOR_LEFT;
  begin
    if MCursor.Spalte>1 then
      Dec(MCursor.Spalte);

    MCursor.on_off:=true;
    TermMode:=Normal_TM;
  end; { procedure CURSOR_LEFT }


  procedure CURSOR_HOME;
  begin
    MCursor.Spalte:=1;
    MCursor.Zeile:=1;
    MCursor.on_off:=true;
    TermMode:=Normal_TM;
  end; { procedure CURSOR_HOME }



  procedure DELETE_EOL;
  var
    s1 : Integer;
  begin
    for s1:=MCursor.Spalte to max_Spalten do
      ZeichenMatrix[MCursor.Zeile,s1]:=Fuellzeichen;

    MCursor.on_off:=true;
    TermMode:=Normal_TM;
  end; { procedure DELETE_EOL }




  procedure DELETE_CHARACTER;
  var
    s1 : Integer;
  begin
    for s1:=MCursor.Spalte to max_Spalten-1 do
      ZeichenMatrix[MCursor.Zeile,s1]:=ZeichenMatrix[MCursor.Zeile,s1+1];

    MCursor.on_off:=true;
    TermMode:=Normal_TM;
  end; { procedure DELETE_CHARACTER }



  procedure DELETE_BOL;
  var
    s1 : Integer;
  begin
    for s1:=1 to MCursor.Spalte-1 do
      ZeichenMatrix[MCursor.Zeile,s1]:=Fuellzeichen;

    MCursor.on_off:=true;
    TermMode:=Normal_TM;
  end; { procedure DELETE_BOL }



  procedure DELETE_LINE;
  var
    s1 : Integer;
  begin
    for s1:=1 to max_Spalten do
      ZeichenMatrix[MCursor.Zeile,s1]:=Fuellzeichen;

//    MCursor.Spalte:=1;
    MCursor.on_off:=true;
    TermMode:=Normal_TM;
  end; { procedure DELETE_LINE }




  procedure DELETE_LINE_SCR_ROLL;
  var
    z1, s1 : Integer;
  begin
    for z1:=MCursor.Zeile to max_Zeilen-1 do begin
      ZeichenMatrix[z1]:=ZeichenMatrix[z1+1];
    end;
    for s1:=1 to max_Spalten do begin
      ZeichenMatrix[max_Zeilen,s1]:=Fuellzeichen;
    end;
 //   MCursor.Spalte:=1;
    MCursor.on_off:=true;
    TermMode:=Normal_TM;
  end; { procedure DELETE_LINE_SCR_ROLL }



  procedure DELETE_EOS;
  var
    s1, z1 : Integer;
  begin
    DELETE_EOL;

    if MCursor.Zeile<max_Zeilen then begin
      for z1:=MCursor.Zeile+1 to max_Zeilen do begin
         for s1:=1 to max_Spalten do begin
           ZeichenMatrix[z1,s1]:=Fuellzeichen;
         end;
      end;
    end;

    MCursor.on_off:=true;
    TermMode:=Normal_TM;
  end; { procedure DELETE_EOS }




  procedure DELETE_BOS;
  var
    s1, z1 : Integer;
  begin
    DELETE_BOL;

    if MCursor.Zeile>1 then begin
      for z1:=1 to MCursor.Zeile-1 do begin
         for s1:=1 to max_Spalten do begin
           ZeichenMatrix[z1,s1]:=Fuellzeichen;
         end;
      end;
    end;

    MCursor.on_off:=true;
    TermMode:=Normal_TM;
  end; { procedure DELETE_BOS }



  procedure LINE_FEED;
  begin
    Inc(MCursor.Zeile);
    if MCursor.Zeile>max_Zeilen then begin
      Zeilen_Scrollen;
    end;
    TermMode:=Normal_TM;
  end; { procedure LINE_FEED }




  procedure INSERT_CHARACTER;
  var
    s1 : Integer;
  begin
    for s1:=max_Spalten downto MCursor.Spalte+1 do begin
      ZeichenMatrix[MCursor.Zeile,s1]:=ZeichenMatrix[MCursor.Zeile,s1-1];
    end;
    ZeichenMatrix[MCursor.Zeile,MCursor.Spalte]:=Fuellzeichen;
    TermMode:=Normal_TM;
  end; { procedure INSERT_CHARACTER }






  procedure INSERT_LINE_SCR_ROLL;
  var
    z1, s1 : Integer;
  begin
    for z1:=max_Zeilen downto MCursor.Zeile+1 do begin
      ZeichenMatrix[z1]:=ZeichenMatrix[z1-1];
    end;
    for s1:=1 to max_Spalten do begin
      ZeichenMatrix[MCursor.Zeile,s1]:=Fuellzeichen;
    end;
    MCursor.on_off:=true;
    TermMode:=Normal_TM;
  end; { procedure INSERT_LINE_SCR_ROLL }






  procedure Normal_Terminal_Mode;
  begin

    case Zeichen of
      $01 : CURSOR_HOME;   // auf Pos 1,1
      $04 : CURSOR_RIGHT;  // rechts
      $05 : CURSOR_UP;     // oben
      $07 : RUN_BELL;      // BELL - Glocke
      $09 : MCursor.Spalte:=8 * ((MCursor.Spalte div 8) +1);  // TAB
      $0A : LINE_FEED; // LF
      $0C : Reset_Form; // CLS - Clear Screen
      $0D : MCursor.Spalte:=1;  // CR
      $13 : CURSOR_LEFT;  // links
      $16 : DELETE_EOL;   // ab Cursorposition bis Zeilenende loeschen
      $18 : CURSOR_DOWN; // unten
      $1B : begin
              case EmuMode of
                Emu_PC1715 : TermMode:= PC1715_ESC_TM;
                Emu_VT100  : TermMode:=IBM_ESC_TM;
                Emu_VT52   : TermMode:=IBM_ESC_TM;
                EMU_ANSI   : TermMode:=IBM_ESC_TM;
                EMU_ADM31  : TermMode:=ADM31_ESC_TM;
              else
                TermMode:= PC1715_ESC_TM;
              end;
            end; { $1B [ESC] }

      $20..$7E : Zeichen_in_Matrix(Zeichen);

      $7F : RUN_DEL;
    else
      SonderZeichen_in_Matrix;
    end;

    if MCursor.on_off then begin
      MCursor.Zeichen:=ZeichenMatrix[MCursor.Zeile,MCursor.Spalte];
      ZeichenMatrix[MCursor.Zeile,MCursor.Spalte]:='_';
    end; { if MCursor.on_off then }

  end; { procedure Normal_Terminal_Mode }






  procedure SET_CURSOR_POSITION(Zeile, Spalte : Integer); // bezogen auf 0,0 !!!
  begin
    MCursor.Zeile:=Zeile+1;
    MCursor.Spalte:=Spalte+1;

    if (MCursor.Zeile>max_Zeilen) then
      MCursor.Zeile:=max_Zeilen;

    if (MCursor.Zeile<1) then
      MCursor.Zeile:=1;

    if (MCursor.Spalte>max_Spalten) then
      MCursor.Spalte:=max_Spalten;

    if (MCursor.Spalte<1) then
      MCursor.Spalte:=1;

    TermMode:=Normal_TM;

    // !!!!!!!!!!!!!!!!!!!!!!!!
    MCursor.on_off:=true;



  end; { procedure SET_CURSOR_POSITION }






  procedure ADM31_ESC_Terminal_Mode;
  begin
    if Zeichen<>$1B then begin

      case Zeichen of

        $3D : begin
                TermMode:=ADM31_ESC_TM_R; // ESC = R C
              end; { $3D }
        $1B : begin
                TermMode:=ADM31_ESC_ESC; // ESC ESC
              end; { $3D }
        $54 : begin
                DELETE_EOL; // ESC T = clear to end of line
                TermMode:=Normal_TM;
              end; { $54 }
        $74 : begin
                DELETE_EOL; // ESC t = clear to end of line
                TermMode:=Normal_TM;
              end; { $74 }
        $59 : begin
                DELETE_EOS; // ESC Y = clear to end of screen
                TermMode:=Normal_TM;
              end; { $59 }
        $79 : begin
                DELETE_EOS; // ESC y = clear to end of screen
                TermMode:=Normal_TM;
              end; { $79 }
        $3A : begin
                Reset_Form; // ESC : = home & clear screen
                TermMode:=Normal_TM;
              end; { $3A }
        $2A : begin
                Reset_Form; // ESC * = home & clear screen
                TermMode:=Normal_TM;
              end; { $2A }
        $47 : begin
                TermMode:=ADM31_ESC_TM_G; // ESC G ...
              end; { $47 }
        $28 : begin
                // ESC ( = Half intensity off
                // derzeit nicht implementiert
              end; { $28 }
        $29 : begin
                // ESC ) = Half intensity on
                // derzeit nicht implementiert
              end; { $29 }
        $45 : begin
                LINE_FEED; // ESC E = Insert line
                TermMode:=Normal_TM;
              end; { $45 }
        $51 : begin
                INSERT_CHARACTER; // ESC Q = Insert Character
                TermMode:=Normal_TM;
              end; { $51 }
        $52 : begin
                DELETE_LINE; // ESC R = Delete Line
                TermMode:=Normal_TM;
              end; { $52 }
        $57 : begin
                DELETE_CHARACTER; // ESC W = Delete Character
                TermMode:=Normal_TM;
              end; { $57 }

      else
        TermMode:=Normal_TM;
        Normal_Terminal_Mode;
      end; { case Zeichen of }
    end
    else begin
      Form_CPD2.Terminal.Items.Add('ESC+ESC empfangen');
    end;
  end; { procedure ADM31_ESC_Terminal_Mode }





  procedure ADM31_ESC_Par_Zeile_Terminal_Mode;
  begin
    if Zeichen>=$20 then begin
      ESC_Zeile:=Zeichen-$20;
      TermMode:=ADM31_ESC_TM_C;
    end
    else begin
      ESC_SonderZeichen_in_Matrix('=');
      TermMode:=Normal_TM;
    end;
  end; { procedure ADM31_ESC_Par_Zeile_Terminal_Mode }



  procedure ADM31_ESC_Par_Spalte_Terminal_Mode;
  begin
    if Zeichen>=$20 then begin
      SET_CURSOR_POSITION(ESC_Zeile, Zeichen-$20);
    end
    else begin
      ESC_SonderZeichen_in_Matrix('=R');
    end;
    TermMode:=Normal_TM;
  end; { procedure ADM31_ESC_Par_Spalte_Terminal_Mode }




  procedure ADM31_ESC_ESC_Terminal_Mode;
  begin
    case Zeichen of
      $1B : begin
              TermMode:=ADM31_ESC_ESC_ESC;
            end; { $1B }
      $3D : begin
              TermMode:=ADM31_ESC_TM_R; // ESC = R C
            end; { $3D }
      $29 : begin
              // Zeichen - nicht implementiert
            end; { $29 }
      $54 : begin
              // Zeichen - nicht implementiert
            end; { $54 }
    else
      ESC_SonderZeichen_in_Matrix(char($1B));
      TermMode:=Normal_TM;
    end;

  end; { procedure ADM31_ESC_ESC_Terminal_Mode }




  procedure ADM31_ESC_ESC_ESC_Terminal_Mode;
  begin
    if Zeichen=$1B then begin
      // color = Zeichen - nicht implementiert
      TermMode:=Normal_TM;
    end
    else begin
      ESC_SonderZeichen_in_Matrix(char($1B)+char($1B));
      TermMode:=Normal_TM;
    end;
  end; { procedure ADM31_ESC_ESC_ESC_Terminal_Mode }







  procedure ADM31_ESC_G_Terminal_Mode;
  begin
     case Zeichen of
       $00 : begin
               // ESC G 0 = Rev. video and blinking off, restore normal 80 col char set
               // nicht implementiert
             end; { $00 }
       $01 : begin
               // ESC G 1 = select 80 col alternate character set
               // nicht implementiert
             end; { $01 }
       $02 : begin
               // ESC G 2 = Blinking on
               // nicht implementiert
             end; { $02 }
       $04 : begin
               // ESC G 4 = Reverse video on
               // nicht implementiert
             end; { $04 }
      else
        ESC_SonderZeichen_in_Matrix('');
      end; { case Zeichen of }
     TermMode:=Normal_TM;
  end; { procedure ADM31_ESC_Terminal_Mode }







  procedure IBM_ESC_Terminal_Mode;
  begin
    case Zeichen of
      $3C : begin
              EmuMode:=Emu_VT100;  // VT52 = ESC < - ENTER_ANSI_MODE
            end; { $3C }
      $41 : begin
              EmuMode:=Emu_VT52;
              CURSOR_UP;  // VT52 = ESC A - CURSOR_UP
            end; { $41 }
      $42 : begin
              EmuMode:=Emu_VT52;
              CURSOR_DOWN; // VT52 = ESC B - CURSOR_DOWN
            end; { $42 }
      $43 : begin
              EmuMode:=Emu_VT52;
              CURSOR_RIGHT; // VT52 = ESC C - CURSOR_RIGHT
            end; { $43 }
      $44 : begin
              EmuMode:=Emu_VT52;
              CURSOR_LEFT; // VT52 = ESC D - CURSOR_LEFT
            end; { $44 }
      $48 : begin
              EmuMode:=Emu_VT52;
              CURSOR_HOME; // VT52 = ESC H - CURSOR_HOME
            end; { $48 }
      $4A : begin
              EmuMode:=Emu_VT52;
              DELETE_EOS; // VT52 = ESC J - DELETE_EOS
            end; { $4A }
      $4B : begin
              EmuMode:=Emu_VT52;
              DELETE_EOL; // VT52 = ESC K - DELETE_EOL
            end; { $4B }
      $59 : begin
              EmuMode:=Emu_VT52;
              TermMode:=DCA_TM; // VT52 = ESC Y Zeile Spalte - DIRECT_CURSOR_ADRESS
            end; { $59 }
      $5B : begin
              TermMode:=IBM_CSI_TM; // Control Sequence Introducer (CSI) = ESC [
              EmuMode:=Emu_VT100;
            end; { $5B }
    else
      ESC_SonderZeichen_in_Matrix('');
      TermMode:=Normal_TM;
    end; { case Zeichen of }
   end; { procedure ESC_Terminal_Mode }



  procedure IBM_CSI_Terminal_Mode;
  begin
    case Zeichen of
      $30..$39 : begin
                  CSI_Parameter1:=Zeichen-$30;
                  TermMode:=IBM_CSI_TM_Par;
                end;
      $4B : begin // ERASE LINE = ESC [ K
              // DELETE_LINE;
              DELETE_EOL;
              CSI_Parameter1:=0;
              TermMode:=Normal_TM;
            end; { $4B }
      $6D : begin // Character Attributes = ESC [ m
              BOLD_ON:=false;
              CSI_Parameter1:=0;
              TermMode:=Normal_TM;
            end; { $6D }
      $66 : begin // Character Attributes = ESC [ f
              Reset_Form;
              CSI_Parameter1:=0;
              TermMode:=Normal_TM;
            end; { $66 }

    else
      ESC_SonderZeichen_in_Matrix('[');
      TermMode:=Normal_TM;
    end;
  end; { procedure IBM_CSI_Terminal_Mode }



  procedure IBM_CSI_Par_Terminal_Mode;
  var
    x_counter : Integer;
  begin
    case Zeichen of
      $30..$39 : begin
                  CSI_Parameter1:=(CSI_Parameter1*10)+Zeichen-$30;
                  TermMode:=IBM_CSI_TM_Par;
                end;

      $3B : begin // ";" -- MOVE CURSOR = ESC [ Pn1 ; PN2 H oder ESC [ Pn1 ; PN2 f
              TermMode:=IBM_CSI_TM_Par_Zeile;
            end; { $3B }

      $41 : begin // CUU -- Cursor Up = ESC [ Pn A
              if MCursor.Zeile>CSI_Parameter1 then
                MCursor.Zeile:=MCursor.Zeile-CSI_Parameter1
              else
                MCursor.Zeile:=1;

              TermMode:=Normal_TM;
              CSI_Parameter1:=0;
            end; { $41 }
      $42 : begin // CUD -- Cursor Down = ESC [ Pn B
              if (MCursor.Zeile+CSI_Parameter1)<max_Zeilen then
                MCursor.Zeile:=MCursor.Zeile+CSI_Parameter1
              else
                MCursor.Zeile:=max_Zeilen;

              CSI_Parameter1:=0;
              TermMode:=Normal_TM;
            end; { $42 }
      $43 : begin // CUF -- Cursor Forward  = ESC [ Pn C
              if (MCursor.Spalte+CSI_Parameter1)<max_Spalten then
                MCursor.Spalte:=MCursor.Spalte+CSI_Parameter1
              else
                MCursor.Spalte:=max_Spalten;

              CSI_Parameter1:=0;
              TermMode:=Normal_TM;
            end; { $43 }
      $44 : begin // CUB -- Cursor Backward = ESC [ Pn D
              if MCursor.Spalte>CSI_Parameter1 then
                MCursor.Spalte:=MCursor.Spalte-CSI_Parameter1
              else
                MCursor.Spalte:=1;

              CSI_Parameter1:=0;
              TermMode:=Normal_TM;
            end; { $44 }
      $4B : begin // ERASE LINE = ESC [ Pn K
              case CSI_Parameter1 of
                0 : DELETE_EOL;
                1 : DELETE_BOL;
                2 : DELETE_LINE;
              else
                ESC_SonderZeichen_in_Matrix('['+IntToStr(CSI_Parameter1)+'K');
              end;

              CSI_Parameter1:=0;
              TermMode:=Normal_TM;
            end; { $4B }

      $4A : begin // ERASE LINE = ESC [ Pn J
              case CSI_Parameter1 of
                // Löschen vom Bildanfang und von links bis zum Kursor
                1 : DELETE_BOS;
                2 : Reset_Form;
              else
                ESC_SonderZeichen_in_Matrix('['+IntToStr(CSI_Parameter1)+'J');
              end;

              CSI_Parameter1:=0;
              TermMode:=Normal_TM;
            end; { $4A }


      $4C : begin // ERASE LINE = ESC [ Pn L
              for x_counter:=0 to CSI_Parameter1-1 do
                INSERT_LINE_SCR_ROLL;

              CSI_Parameter1:=0;
              TermMode:=Normal_TM;
            end; { $4C }


      $4D : begin // ERASE LINE = ESC [ Pn M
              for x_counter:=0 to CSI_Parameter1-1 do
                DELETE_LINE_SCR_ROLL;

              CSI_Parameter1:=0;
              TermMode:=Normal_TM;
            end; { $4D }


      $6D : begin // Character Attributes = ESC [ Pn m
              case CSI_Parameter1 of
                0 : BOLD_ON:=false;
                1 : BOLD_ON:=true;
                4 : BOLD_ON:=false;
                5 : BOLD_ON:=false;
                7 : BOLD_ON:=false;
              else
                ESC_SonderZeichen_in_Matrix('['+IntToStr(CSI_Parameter1)+'m');
              end;
              CSI_Parameter1:=0;
              TermMode:=Normal_TM;
            end; { $6D }
    else
      ESC_SonderZeichen_in_Matrix('[0');
      TermMode:=Normal_TM;
    end;

  end; { procedure IBM_CSI_Par_Terminal_Mode }






  procedure IBM_CSI_Par_Zeile_Terminal_Mode;
  begin
    case Zeichen of
      $30..$39 : begin
                   CSI_Parameter2:=(CSI_Parameter2*10)+Zeichen-$30;
                   TermMode:=IBM_CSI_TM_Par_Zeile;
                 end;
      $48 : begin // -- MOVE CURSOR = ESC [ Pn1 ; PN2 H
              SET_CURSOR_POSITION(CSI_Parameter1, CSI_Parameter2);
              CSI_Parameter1:=0;
              CSI_Parameter2:=0;
              TermMode:=Normal_TM;
            end; { $48 }
      $66 : begin // -- MOVE CURSOR = ESC [ Pn1 ; PN2 f
              SET_CURSOR_POSITION(CSI_Parameter1, CSI_Parameter2);
              CSI_Parameter1:=0;
              CSI_Parameter2:=0;
              TermMode:=Normal_TM;
            end; { $66 }
    else
      ESC_SonderZeichen_in_Matrix('['+IntToStr(CSI_Parameter1)+';');
      TermMode:=Normal_TM;
    end;
  end; { procedure IBM_CSI_Par_Zeile_Terminal_Mode }



  procedure PC1715_ESC_Terminal_Mode;
  begin
    if Zeichen>=$80 then begin
      ESC_Zeile:=Zeichen-$80;
      TermMode:=PC1715_TM_Zeile;
    end
    else begin
      ESC_SonderZeichen_in_Matrix('');
      TermMode:=Normal_TM;
    end;
  end; { procedure PC1715_ESC_Terminal_Mode }



  procedure PC1715_ESC_Zeile_Terminal_Mode;
  begin
    if Zeichen>=$80 then begin
      SET_CURSOR_POSITION(ESC_Zeile, Zeichen-$80);
    end
    else begin
      ESC_SonderZeichen_in_Matrix(CHR(ESC_Zeile+$80));
    end;

    TermMode:=Normal_TM;

  end; { procedure PC1715_ESC_Zeile_Terminal_Mode }



  procedure DCA_Terminal_Mode;
  begin
    if Zeichen>=$20 then begin
      ESC_Zeile:=Zeichen-$20;
      TermMode:=DCA_TM_Zeile;
    end
    else begin
      ESC_SonderZeichen_in_Matrix('Y');
      TermMode:=Normal_TM;
    end;
  end; { procedure DCA_Terminal_Mode }




  procedure DCA_Terminal_Mode_Zeile;
  begin
    if Zeichen>=$20 then begin
      SET_CURSOR_POSITION(ESC_Zeile, Zeichen-$20);
    end
    else begin
      ESC_SonderZeichen_in_Matrix('Y'+chr(ESC_Zeile));
    end;
    TermMode:=Normal_TM;
  end; { procedure DCA_Terminal_Mode_Zeile }



begin

  Timer_CURSOR.Enabled:=false;


  if Form_CPD2.CheckBox_LOG_TERM.Checked then begin

    if TermMode=Normal_TM then begin
      case Zeichen of
        $20..$7F : begin
                     if CONTROL_ACTIVE then begin
                       Form_CPD2.Terminal.Items.Add(CONOUT_Line);
                       CONOUT_Line:='';
                       CONTROL_ACTIVE:=false;
                     end;
                     CONOUT_Line:=CONOUT_Line+Char(Zeichen);
                   end;
        $1B : begin
                CONOUT_Line:=CONOUT_Line+'[ESC]';
                CONTROL_ACTIVE:=true;
              end; { $1B }
        $0D : begin
                Form_CPD2.Terminal.Items.Add(CONOUT_Line);
              end; { $0D }
        $0A : begin
                CONOUT_Line:='';
              end; { $0A }
      else
        CONOUT_Line:=CONOUT_Line+'['+IntToHex(Zeichen,2)+']';
      end;
    end
    else begin
      CONOUT_Line:=CONOUT_Line+'['+IntToHex(Zeichen,2)+']';
    end; { if TermMode=Normal_TM then }

  end; { if Form_CPD2.CheckBox_LOG_TERM.Checked then }




  if not DEL_Sperre then begin

    if MCursor.on_off then begin
      ZeichenMatrix[MCursor.Zeile,MCursor.Spalte]:=MCursor.Zeichen;
      MCursor.on_off:=false;
    end; { if MCursor.on_off then }

    case TermMode of
      Normal_TM            : Normal_Terminal_Mode;
      IBM_ESC_TM           : IBM_ESC_Terminal_Mode;
      IBM_CSI_TM           : IBM_CSI_Terminal_Mode;
      IBM_CSI_TM_Par       : IBM_CSI_Par_Terminal_Mode;
      IBM_CSI_TM_Par_Zeile : IBM_CSI_Par_Zeile_Terminal_Mode;
      PC1715_ESC_TM        : PC1715_ESC_Terminal_Mode;
      PC1715_TM_Zeile      : PC1715_ESC_Zeile_Terminal_Mode;
      DCA_TM               : DCA_Terminal_Mode;
      DCA_TM_Zeile         : DCA_Terminal_Mode_Zeile;
      ADM31_ESC_TM         : ADM31_ESC_Terminal_Mode;
      ADM31_ESC_TM_R       : ADM31_ESC_Par_Zeile_Terminal_Mode;
      ADM31_ESC_TM_C       : ADM31_ESC_Par_Spalte_Terminal_Mode;
      ADM31_ESC_ESC        : ADM31_ESC_ESC_Terminal_Mode;
      ADM31_ESC_ESC_ESC    : ADM31_ESC_ESC_ESC_Terminal_Mode;
      ADM31_ESC_TM_G       : ADM31_ESC_G_Terminal_Mode;
    end;

  end; { if not DEL_Sperre then }

  ST_change := true;
  Timer_CURSOR.Enabled:=true;

end; { procedure TForm_CONS.RECEIVE_FROM_CONOUT }





procedure TForm_CONS.FormKeyDown(Sender: TObject; var Key: word; Shift: TShiftState);
var
  Zeichen : Byte;
begin

  Zeichen := $00;

  if Shift = [] then begin
    case Key of
      08 : begin // DEL
             Zeichen := $7F;
             Timer_DEL.Enabled:=true;
             DEL_Sperre:=true;
             RUN_DEL;
           end; { 08 }

      09 : Zeichen := Key; // TAB
      13 : Zeichen := Key; // ENTER

      27 : Zeichen := $1B;  // ESC
      32 : Zeichen := $20; // SPACE

      33 : Zeichen := $12; // Ctrl R
      34 : Zeichen := $03; // Ctrl C

      37 : Zeichen := $13; // links
      38 : Zeichen := $05; // oben
      39 : Zeichen := $04; // rechts
      40 : Zeichen := $18; // unten

      45 : Zeichen := $16; // Einfg = Ctrl V
      46 : Zeichen := $07; // Entf = Ctrl G

      48..57 : Zeichen := Key; // 1..0
      65..90 : Zeichen := Key+32; // a..z
      186 : Zeichen := $75; // ue
      187 : Zeichen := $2B; // +
      188 : Zeichen := $2C; // ,
      189 : Zeichen := $2D; // -
      190 : Zeichen := $2E; // .
      191 : Zeichen := $23; // #
      192 : Zeichen := $6F; // oe
      219 : Zeichen := $73; // s
      220 : Zeichen := $5E; // ^
      221 : Zeichen := $60; // `
      222 : Zeichen := $61; // a
      226 : Zeichen := $3C; // <
    else
      Zeichen := $00;
//      Zeile:=Zeile+'['+IntToStr(Key)+']';
//      StaticText1.Caption:=Zeile;
    end; { case Key of }
  end; { if Shift = [] then }


  if Shift = [SSSHIFT] then begin
    if Key<>16 then begin  // Shift-Taste
      case Key of
        00 : Zeichen := Key;
        48 : Zeichen := $3D; // =
        49 : Zeichen := $21; // !
        50 : Zeichen := $22; // "
        51 : Zeichen := $23; // §
        52 : Zeichen := $24; // $
        53 : Zeichen := $25; // %
        54 : Zeichen := $26; // &
        55 : Zeichen := $2F; // /
        56 : Zeichen := $28; // (
        57 : Zeichen := $29; // )
        65..90 : Zeichen := Key; // A..Z
       187 : Zeichen := $2A; // *
       188 : Zeichen := $3B; // ;
       189 : Zeichen := $5F; // _
       190 : Zeichen := $3A; // :
       191 : Zeichen := $27; // '

       219 : Zeichen := $3F; // ?
       220 : Zeichen := $7E; // ° -> ~
       221 : Zeichen := $60; // `
       226 : Zeichen := $3E; // >
      else
        Zeichen := $00;
//      Zeile:=Zeile+'['+IntToStr(Key)+']';                      //      StaticText1.Caption:=Zeile;
      end; { if Key<>16 then }
    end; { if Key<>16 then }
  end; { if Shift=[SSSHIFT] then }


  if Shift = [SSCTRL] then begin
    if Key<>17 then begin
      if (Key>64) and (Key<91) then
         Zeichen := Key-64;

    end; { if Key<>17 then }
  end; { if Shift=[SSCTRL] then }


  if Shift = [ssAlt] then begin
    if Key<>18 then begin
      case Key of
        48 : Zeichen := $7D; // }
        55 : Zeichen := $7B; // {
        56 : Zeichen := $5B; // [
        57 : Zeichen := $5D; // ]
        81 : Zeichen := $40; // @
        187 : Zeichen := $7E; // ~
        219 : Zeichen := $5C; // \
        226 : Zeichen := $7D; // |

      else
        Zeichen := $00;
//        Zeile:=Zeile+'['+IntToStr(Key)+']';
//        StaticText1.Caption:=Zeile;
      end; { case Key of }
    end; { if Key<>17 then }
  end; { if Shift=[SSCTRL] then }


  if Zeichen>$00 then
    Form_CPD2.Send_Char_To_Serial(Byte(Zeichen));

 //  RECEIVE_FROM_CONOUT(Zeichen);    // Testbetrieb


        {
   if Zeichen=$0D then
     RECEIVE_FROM_CONOUT($0A);

           }

end; { procedure TForm_CONS.FormKeyDown }




procedure TForm_CONS.FormShow(Sender: TObject);
begin
  if beim_ersten_mal then begin

    Form_CONS.Left := Form_CPD2.F2_x;
    Form_CONS.Top := Form_CPD2.F2_y;
    if Form_CPD2.F2_bsDialog then
      Form_CONS.BorderStyle:=bsDialog
    else
      Form_CONS.BorderStyle:=bsNone;

    beim_ersten_mal:=false;
  end; { if beim_ersten_mal then }
end; { procedure TForm_CONS.FormShow }



procedure TForm_CONS.Image_MONMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin

  if (x>923) and (x<940) and (y>561) and (y<576) then begin
    // Form_CPD2.Close;
    Reset_Form;
  end
  else begin

    if Form_CONS.BorderStyle=bsDialog then begin
      Form_CONS.BorderStyle:=bsNone;
      Form_CPD2.F2_bsDialog:=false;
      Form_CONS.Left:=Form_CONS.Left+x_Offset;
      Form_CONS.Top:=Form_CONS.Top+y_Offset;
    end
    else begin
      Form_CONS.BorderStyle:=bsDialog;
      Form_CPD2.F2_bsDialog:=true;
      Form_CONS.Left:=Form_CONS.Left-x_Offset;
      Form_CONS.Top:=Form_CONS.Top-y_Offset;
    end; { if Form_CONS.BorderStyle=bsDialog then }

  end; { if (x>923) and (x<940) and (y>561) and (y<576) then }

  Form_CPD2.F2_x := Form_CONS.Left;
  Form_CPD2.F2_y := Form_CONS.Top;

end; { procedure TForm_CONS.Image_MONMouseDown }





procedure TForm_CONS.Timer_CURSORTimer(Sender: TObject);
begin
  Timer_CURSOR.Enabled:=false;

  // Ist der Kursor eingeschaltet (MCursor.on_off:=true;  und "_" wird angezeigt),
  // dann befindet sich auch in MCursor.Zeichen das Zeichen
  if MCursor.on_off then begin
    ZeichenMatrix[MCursor.Zeile,MCursor.Spalte]:=MCursor.Zeichen;
    MCursor.on_off:=false;
  end
  else begin
    MCursor.Zeichen:=ZeichenMatrix[MCursor.Zeile,MCursor.Spalte];
    ZeichenMatrix[MCursor.Zeile,MCursor.Spalte]:='_';
    MCursor.on_off:=true;
  end;

  ST_change:=true;
  Timer_CURSOR.Enabled:=true;

end; { procedure TForm_CONS.Timer1Timer }



procedure TForm_CONS.Timer_DELTimer(Sender: TObject);
begin
  DEL_Sperre:=false;
  Timer_DEL.Enabled:=false;
end; { procedure TForm_CONS.Timer2Timer }


procedure TForm_CONS.Timer_BWSTimer(Sender: TObject);
begin
  Timer_BWS.Enabled:=false;

  if ST_change then begin
    if Form_CPD2.CheckBox_Graf_Term.Checked then
      Matrix_in_GrafMon
    else
      Matrix_in_StaticText;

    ST_change:=false;
  end;

  Timer_BWS.Enabled:=true;
end; { procedure TForm_CONS.Timer_BWSTimer }



procedure TForm_CONS.FormDestroy(Sender: TObject);
begin
   //
end; { procedure TForm_CONS.FormDestroy }







initialization
  {$I Unit_CONS.lrs}

end.

