unit Trace;

{$mode objfpc}

interface

uses
  Classes, SysUtils, FileUtil, SynEdit, SynHighlighterAny, LResources, Forms,
  Controls, Graphics, Dialogs, ExtCtrls, StdCtrls, ComCtrls, Buttons,
  SynEditMarks;



const
  Trace_Laenge = 299;



type

  // Daten-Satz
  TRC_DATEN_REC = record
    Adresse, Befehl, Zeilennummer, Bemerkung : String;
    gefunden : Boolean;
    ZeilenNr, Position_Befehl : Cardinal;
  end;



  { TFormTrace }

  TFormTrace = class(TForm)
    BitBtn_Trace_Neu: TBitBtn;
    Edit_TraceNr: TEdit;
    ImageList1: TImageList;
    ListBox_Meldungen: TListBox;
    Panel1: TPanel;
    SynAnySyn_Z80_ASM: TSynAnySyn;
    SynEdit_Z80_ASM: TSynEdit;
    UpDown_Gesamt: TUpDown;
    UpDown_Einzel: TUpDown;
    procedure BitBtn_Trace_NeuClick(Sender: TObject);
    procedure Button_Starte_TraceClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TraceZeile_anzeigen;
    procedure TRACE_Datei_neu_einlesen;
    procedure UpDown_EinzelClick(Sender: TObject; Button: TUDBtnType);
    procedure UpDown_GesamtClick(Sender: TObject; Button: TUDBtnType);
  private
    { private declarations }
    Zeiger : Integer;
    Trace_Text : TStringList;
    Trace_Array : Array [0..Trace_Laenge] of TRC_DATEN_REC;
    List_Array : Array [0..10000] of TRC_DATEN_REC;
    List_Array_Zeiger : Cardinal;
  public
    { public declarations }
  end;

var
  FormTrace: TFormTrace;

implementation

{ TFormTrace }



uses
  MainUnit;




procedure TFormTrace.FormCreate(Sender: TObject);
begin

  ListBox_Meldungen.Clear;
        {
  SynEdit_Z80_ASM.Lines.Clear;
  Trace_Text := TStringList.Create;

  SynEdit_Z80_ASM.Lines.LoadFromFile('Trace\CPD5.PRN');

  Trace_Text.LoadFromFile('Trace\CCP.PRN');

  SynEdit_Z80_ASM.Lines.Text:=SynEdit_Z80_ASM.Lines.Text+Trace_Text.Text;

  Trace_Text.LoadFromFile('Trace\BDOS.PRN');

  SynEdit_Z80_ASM.Lines.Text:=SynEdit_Z80_ASM.Lines.Text+Trace_Text.Text;

  TRACE_Datei_neu_einlesen;

  Zeiger:=0;
  Edit_TraceNr.Text:=IntToStr(Zeiger);
  TraceZeile_anzeigen;
           }

  FormTrace.Left:=Form_CPD2.FormTrace_Left;
  FormTrace.Top:=Form_CPD2.FormTrace_Top;
  FormTrace.Width:=Form_CPD2.FormTrace_Width;
  FormTrace.Height:=Form_CPD2.FormTrace_Height;

end; { procedure TFormTrace.FormCreate }





procedure TFormTrace.TraceZeile_anzeigen;


  procedure SynEditSelLine(const Line: Integer; const Synedit: TSynEdit);
  var i, l: Integer;
  begin
    if (Line < Synedit.Lines.Count + 1) and (Line > -1) and (Synedit <> nil) then
    begin
      l := 0;

      for i := -1 to Line -2 do
      inc(l, Length(Synedit.Lines[i]) + 2);

      Synedit.SelStart := l-1;
      Synedit.SelEnd := l + Length(Synedit.Lines[Line-1]);

    end;
  end;


begin

  if (Zeiger<=Trace_Laenge) and (Zeiger>=0) then begin

    if Trace_Array[Zeiger].gefunden then begin
      FormTrace.SynEdit_Z80_ASM.CaretY:=Trace_Array[Zeiger].ZeilenNr+12;
      SynEditSelLine(Trace_Array[Zeiger].ZeilenNr+1,FormTrace.SynEdit_Z80_ASM);
    end
    else
      ListBox_Meldungen.Items.Add('die Adresse <'+Trace_Array[Zeiger].Adresse+
                                  '> konnte nicht gefunden werden');

  end; { if Zeiger<=Trace_Text.Count-1 then }

end; { procedure TFormTrace.TraceZeile_anzeigen }






procedure TFormTrace.TRACE_Datei_neu_einlesen;
var
  Zaehler, Zaehler2 : Integer;
  Zeile, STR_Adresse, STR_Daten,
  STR_ZeilenNummer, Bef_Zeile : String;
  Zeichen : Char;
  Adresse_Vorgaenger, Adresse_Zaehler : LongInt;



  procedure Add_Gutter(ZeiNr : Integer);
  var
    m: TSynEditMark;
  begin
    m := TSynEditMark.Create(SynEdit_Z80_ASM);
    m.Line := ZeiNr;
    m.Visible := true;
    m.ImageList := ImageList1;
    m.ImageIndex := 0;
    SynEdit_Z80_ASM.Marks.Add(m);
  end;





begin

  ListBox_Meldungen.Clear;
                {
    Trace_Text.LoadFromFile('Trace\TRACE.TXT');

    if Trace_Text.Count=Trace_Laenge+1 then begin
      for Zaehler:=0 to Trace_Laenge do begin
        Zeile:=Trace_Text[Zaehler];
        Trace_Array[Zaehler].Adresse:=Copy(Zeile,1,4);
        Trace_Array[Zaehler].Befehl:=Copy(Zeile,5,2);
        Trace_Array[Zaehler].gefunden:=false;
      end;
    end
    else
      ListBox_Meldungen.Items.Add('die Datei:<TRACE.TXT> muss '+IntToStr(Trace_Laenge+1)+
                                  ' Datensaetze haben, hat aber '+
                                  IntToStr(Trace_Text.Count)+' Datensaetze');


  //  F591    C9

    List_Array_Zeiger:=0;

    for Zaehler:=0 to SynEdit_Z80_ASM.Lines.Count-1 do begin
      Zeile:=SynEdit_Z80_ASM.Lines[Zaehler];
      if Length(Zeile)>10 then begin
        if pos('  ',Zeile)=1 then begin
          Zeichen:=Zeile[3];
          if Zeichen IN ['0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'] then begin
            Zeichen:=Zeile[4];
            if Zeichen IN ['0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'] then begin
              Zeichen:=Zeile[5];
              if Zeichen IN ['0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'] then begin
                Zeichen:=Zeile[6];
                if Zeichen IN ['0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'] then begin
                  STR_Adresse:=Copy(Zeile,3,4);
                  if pos('    ',Zeile)=7 then begin
                    Zeichen:=Zeile[11];
                    if Zeichen IN ['0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'] then begin
                      Zeichen:=Zeile[12];
                      if Zeichen IN ['0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'] then begin
                        STR_Daten:=Copy(Zeile,11,2);
                        STR_ZeilenNummer:=IntToStr(Zaehler);

                        if Zaehler<10 then
                          STR_ZeilenNummer:='0'+STR_ZeilenNummer;

                        if Zaehler<100 then
                          STR_ZeilenNummer:='0'+STR_ZeilenNummer;

                        if Zaehler<1000 then
                          STR_ZeilenNummer:='0'+STR_ZeilenNummer;

                        if Zaehler<10000 then
                          STR_ZeilenNummer:='0'+STR_ZeilenNummer;

                        List_Array[List_Array_Zeiger].Adresse:=STR_Adresse;
                        List_Array[List_Array_Zeiger].Befehl:=STR_Daten;
                        List_Array[List_Array_Zeiger].Zeilennummer:=STR_ZeilenNummer;
                        List_Array[List_Array_Zeiger].ZeilenNr:=Zaehler;
                        Inc(List_Array_Zeiger);

                      end; { if c1 IN ['0123456789ABCDEF'] then }
                    end; { if c1 IN ['0123456789ABCDEF'] then }
                  end; { if pos('    ',Zeile)=7 then }
                end; { if c1 IN ['0123456789ABCDEF'] then }
              end; { if c1 IN ['0123456789ABCDEF'] then }
            end; { if c1 IN ['0123456789ABCDEF'] then }
          end; { if c1 IN ['0123456789ABCDEF'] then }
        end; { if pos('  ',Zeile)=1 then }
      end; { if Length(Zeile)>10 then }
    end; { for Zaehler:=0 to SynEdit_Z80_ASM.Lines.Count-1 do }


    for Zaehler:=0 to Trace_Laenge do begin

      for Zaehler2:=0 to List_Array_Zeiger-1 do begin

        if not Trace_Array[Zaehler].gefunden then begin

          if Trace_Array[Zaehler].Adresse=List_Array[Zaehler2].Adresse then begin

            Trace_Array[Zaehler].gefunden:=true;
            Trace_Array[Zaehler].ZeilenNr:=List_Array[Zaehler2].ZeilenNr;
            Trace_Array[Zaehler].Zeilennummer:=IntToStr(List_Array[Zaehler2].ZeilenNr);
            Trace_Array[Zaehler].Bemerkung:='Adresse gefunden';
            Zeile:=SynEdit_Z80_ASM.Lines[List_Array[Zaehler2].ZeilenNr];

            //  E1CE    20 20 20 20
            Bef_Zeile:=Copy(Zeile,11,11);

            Trace_Array[Zaehler].Position_Befehl:=Pos(Trace_Array[Zaehler].Befehl,Bef_Zeile);

            if Trace_Array[Zaehler].Position_Befehl=1 then
              Trace_Array[Zaehler].Bemerkung:='Adresse und Befehl gefunden';

          end; { if Trace_Array[Zaehler].Adresse=List_Array[Zaehler2].Adresse then }

        end; { if not Trace_Array[Zaehler].gefunden then }

      end; { for Zaehler:=0 to List_Array_Zeiger-1 do }


      if not Trace_Array[Zaehler].gefunden then begin

        STR_Adresse:='$'+Trace_Array[Zaehler].Adresse;
        Adresse_Vorgaenger:=StrToInt(STR_Adresse)-1;
        STR_Adresse:=IntToHex(Adresse_Vorgaenger,4);

        for Zaehler2:=0 to List_Array_Zeiger-1 do begin

          if not Trace_Array[Zaehler].gefunden then begin

            if STR_Adresse=List_Array[Zaehler2].Adresse then begin

              Trace_Array[Zaehler].gefunden:=true;
              Trace_Array[Zaehler].ZeilenNr:=List_Array[Zaehler2].ZeilenNr;
              Trace_Array[Zaehler].Zeilennummer:=IntToStr(List_Array[Zaehler2].ZeilenNr);
              Trace_Array[Zaehler].Bemerkung:='Adresse in Vorzeile gefunden';
              Zeile:=SynEdit_Z80_ASM.Lines[List_Array[Zaehler2].ZeilenNr];

              Bef_Zeile:=Copy(Zeile,11,11);

              Trace_Array[Zaehler].Position_Befehl:=Pos(Trace_Array[Zaehler].Befehl,Bef_Zeile);

              if Trace_Array[Zaehler].Position_Befehl>0 then
                Trace_Array[Zaehler].Bemerkung:='Adresse und Befehl in Vorzeile gefunden';

            end; { if Trace_Array[Zaehler].Adresse=List_Array[Zaehler2].Adresse then }

          end; { if not Trace_Array[Zaehler].gefunden then }

        end; { for Zaehler:=0 to List_Array_Zeiger-1 do }

      end; { if not Trace_Array[Zaehler].gefunden then }



      if not Trace_Array[Zaehler].gefunden then begin

        STR_Adresse:='$'+Trace_Array[Zaehler].Adresse;
        Adresse_Vorgaenger:=StrToInt(STR_Adresse)-2;
        STR_Adresse:=IntToHex(Adresse_Vorgaenger,4);

        for Zaehler2:=0 to List_Array_Zeiger-1 do begin

          if not Trace_Array[Zaehler].gefunden then begin

            if STR_Adresse=List_Array[Zaehler2].Adresse then begin

              Trace_Array[Zaehler].gefunden:=true;
              Trace_Array[Zaehler].ZeilenNr:=List_Array[Zaehler2].ZeilenNr;
              Trace_Array[Zaehler].Zeilennummer:=IntToStr(List_Array[Zaehler2].ZeilenNr);
              Trace_Array[Zaehler].Bemerkung:='Adresse in Vor-Vorzeile gefunden';
              Zeile:=SynEdit_Z80_ASM.Lines[List_Array[Zaehler2].ZeilenNr];

              Bef_Zeile:=Copy(Zeile,11,11);

              Trace_Array[Zaehler].Position_Befehl:=Pos(Trace_Array[Zaehler].Befehl,Bef_Zeile);

              if Trace_Array[Zaehler].Position_Befehl>0 then
                Trace_Array[Zaehler].Bemerkung:='Adresse und Befehl in Vor-Vorzeile gefunden';

            end; { if Trace_Array[Zaehler].Adresse=List_Array[Zaehler2].Adresse then }

          end; { if not Trace_Array[Zaehler].gefunden then }

        end; { for Zaehler:=0 to List_Array_Zeiger-1 do }

      end; { if not Trace_Array[Zaehler].gefunden then }



      if not Trace_Array[Zaehler].gefunden then begin
        ListBox_Meldungen.Items.Add('die Adresse <'+Trace_Array[Zaehler].Adresse+
                                    '> in der Datei:<TRACE.TXT> konnte nicht gefunden werden');
      end; { if not Trace_Array[Zaehler].gefunden then }

    end; { for Zaehler:=0 to Trace_Laenge do }



    for Zaehler:=0 to Trace_Laenge do begin
      Add_Gutter(Trace_Array[Zaehler].ZeilenNr+1);
    end; { for Zaehler2:=0 to List_Array_Zeiger-1 do }


    Trace_Text.Clear;

    for Zaehler:=0 to Trace_Laenge do begin
      Zeile:='A='+Trace_Array[Zaehler].Adresse;
      Zeile:=Zeile+'  Bef='+Trace_Array[Zaehler].Befehl;
      Zeile:=Zeile+'  ZNR='+Trace_Array[Zaehler].Zeilennummer;
      Zeile:=Zeile+'  Pos='+IntToStr(Trace_Array[Zaehler].Position_Befehl);
      Zeile:=Zeile+'  Bem='+Trace_Array[Zaehler].Bemerkung;
      if Trace_Array[Zaehler].gefunden then
        Zeile:=Zeile+'  gefunden'
      else
        Zeile:=Zeile+'  *** nicht gefunden';

      Trace_Text.Add(Zeile);
    end; { for Zaehler2:=0 to List_Array_Zeiger-1 do }

    Trace_Text.SaveToFile('Trace\TRACE_gefunden.TXT');
                        }
end; { procedure TFormTrace.TRACE_Datei_neu_einlesen }






procedure TFormTrace.UpDown_EinzelClick(Sender: TObject; Button: TUDBtnType);
begin
  if Button=BTNEXT then begin
    if Zeiger<299 then begin
      Inc(Zeiger);
      TraceZeile_anzeigen;
    end { if Zeiger<299 then }
    else
      ListBox_Meldungen.Items.Add('Datensatz 299 bereits erreicht');
  end
  else begin
    if Zeiger>0 then begin
      Dec(Zeiger);
      TraceZeile_anzeigen;
    end { if Zeiger>0 then }
    else
      ListBox_Meldungen.Items.Add('Datensatz 0 bereits erreicht');

  end; { if Button=BTNEXT then }
  Edit_TraceNr.Text:=IntToStr(Zeiger);

end; { procedure TFormTrace.UpDown_EinzelClick }




procedure TFormTrace.UpDown_GesamtClick(Sender: TObject; Button: TUDBtnType);
begin
  if Button=BTNEXT then begin
    Zeiger:=299;
    TraceZeile_anzeigen;
  end
  else begin
    Zeiger:=0;
    TraceZeile_anzeigen;
  end; { if Button=BTNEXT then }
  Edit_TraceNr.Text:=IntToStr(Zeiger);
end; { procedure TFormTrace.UpDown_GesamtClick }




procedure TFormTrace.Button_Starte_TraceClick(Sender: TObject);
begin
  if Zeiger<299 then begin
    Inc(Zeiger);
    TraceZeile_anzeigen;
  end;

end; { procedure TFormTrace.Button_Starte_TraceClick }





procedure TFormTrace.BitBtn_Trace_NeuClick(Sender: TObject);
begin
  TRACE_Datei_neu_einlesen;
end;




procedure TFormTrace.FormDestroy(Sender: TObject);
begin
  Form_CPD2.FormTrace_Left:=FormTrace.Left;
  Form_CPD2.FormTrace_Top:=FormTrace.Top;
  Form_CPD2.FormTrace_Width:=FormTrace.Width;
  Form_CPD2.FormTrace_Height:=FormTrace.Height;

  Trace_Text.Free;
end; { procedure TFormTrace.FormDestroy }






initialization
  {$I trace.lrs}

end.

