unit win_ws;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Windows, ShellAPI;

const
  INVALID_FILE_ATTRIBUTES = DWORD(-1);

type
  TTntFileStream = class(THandleStream)
  public
    constructor Create(const FileName: WideString; Mode: Word);
    destructor Destroy; override;

  end;



function file_age(const FileName: WideString): Integer;
procedure file_age2(const FileName: WideString;
                    var s_Date, s_Time : WideString);
function file_exist(const name: WideString) : Boolean;
function copy_file(FromFile, ToFile: WideString; FailIfExists: Boolean): Boolean;
function rename_file(OldName, NewName : WideString) : Boolean;
function delete_file(FileName : WideString) : Boolean;
function dir_exist(const Directory: WideString) : Boolean;
function create_dir(const Directory: WideString) : BOOLEAN;
procedure show_message(const Message,Caption: WideString);
function run_application(const Programm_Pfad, Programm, Parameter : WideString;
                          handle : DWORD) : WideString;
function Get_Environment_Variable(const Name : wideString) : WideString;
procedure Set_Environment_Variable(const name, value : wideString);
function run_app(ProgrammName, ProgrammOrdner, Parameter : WideString;
                 Wait : Boolean) : Boolean;
function WideString_To_Boolean(BoolStr : WideString) : boolean;


procedure Slash_To_Backslash(var Zeichenkette : WideString);
procedure Backslash_To_Slash(var Zeichenkette : WideString);
function last_backslash(pfad : WideString) : WideString;
function last_slash(pfad : WideString) : WideString;

function WideExtractFilePath(const FileName: WideString): WideString;
function WideExtractFileExt(const FileName: WideString): WideString;
function WideExtractFileName(const FileName: WideString): WideString;
function WideForceDirectories(Dir: WideString): Boolean;
function WideChangeFileExt(const FileName, Extension: WideString): WideString;
function WideStringToUTF8(const S: WideString): AnsiString;
function UTF8ToWideString(const S: AnsiString): WideString;


implementation



function file_age(const FileName: WideString): Integer;
{ FileAge }
var
  Handle: THandle;
  FindData: TWin32FindDataW;
  LocalFileTime: TFileTime;
begin
  Handle := FindFirstFileW(PWideChar(FileName), FindData);
  if Handle <> INVALID_HANDLE_VALUE then
  begin
    Windows.FindClose(Handle);
    if (FindData.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY) = 0 then
    begin
      FileTimeToLocalFileTime(FindData.ftLastWriteTime, LocalFileTime);
      IF FileTimeToDosDateTime(LocalFileTime, LongRec(Result).Hi, LongRec(Result).Lo) then
        Exit
    end;
  end;
  Result := -1;
end; { function file_age }




procedure file_age2(const FileName: WideString;
                    var s_Date, s_Time : WideString);
{ FileAge }
var
  Handle: THandle;
  FindData: TWin32FindDataW;
  LocalFileTime: TFileTime;
  i_Date, i_Time : WORD;
  i_Day, i_Month, I_Year,
  i_Second, i_Minute, i_Hour : Integer;

  function IntToStr2(Zahl : Integer) : WideString;
  var
    ws : WideString;
  begin
    ws:=IntToStr(Zahl);
    if length(ws)=1 then
      ws:='0'+ws;
    result:=ws;
  end;

begin
  i_Date:=Word(0); i_Time:=Word(0);
  s_Date:=''; s_Time:='';
  Handle := FindFirstFileW(PWideChar(FileName), FindData);
  if Handle <> INVALID_HANDLE_VALUE then
  begin
    Windows.FindClose(Handle);
    if (FindData.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY) = 0 then
    begin
      FileTimeToLocalFileTime(FindData.ftLastWriteTime, LocalFileTime);
      IF FileTimeToDosDateTime(LocalFileTime, i_Date, i_Time) then begin
        {
         0–4 Day of the month (1–31)
         5–8 Month (1 = January, 2 = February, etc.)
         9-15 Year offset from 1980 (add 1980 to get actual year)
        }
        i_Day:=i_Date and $001F;  { 0000 0000  0001 1111 }
        i_Month:=i_Date and $01E0;  { 0000 0001 1110 0000 }
        i_Month:=i_Month shr 5;
        I_Year:=i_Date and $FE00;  { 1111 1110 0000 0000 }
        I_Year:=I_Year shr 9;
        I_Year:=1980+I_Year;
        s_Date:=IntToStr2(i_Day)+'.'+IntToStr2(i_Month)+'.'+IntToStr(I_Year);
        {
         0–4 Second divided by 2
         5–10 Minute (0–59)
         11–15 Hour (0–23 on a 24-hour clock)
        }
        i_Second:=i_Time and $001F;  { 0000 0000  0001 1111 }
        i_Minute:=i_Time and $07E0;  { 0000 0111 1110 0000 }
        i_Minute:=i_Minute shr 5;
        i_Hour:=i_Time and $F800;  { 1111 1000 0000 0000 }
        i_Hour:=i_Hour shr 11;
        s_Time:=IntToStr2(i_Hour)+':'+IntToStr2(i_Minute)+':'+IntToStr2(i_Second);
      end;
    end;
  end;
end; { function file_age2 }




function file_exist(const name: WideString) : Boolean;
var
  Handle: THandle;
  FindData: TWin32FindDataW;
begin
  Result := False;
  Handle := FindFirstFileW(PWideChar(name), FindData);
  if Handle <> INVALID_HANDLE_VALUE then
  begin
    Windows.FindClose(Handle);
    if (FindData.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY) = 0 then
      Result := True;
  end;
end; { function find_file }



function copy_file(FromFile, ToFile: WideString; FailIfExists: Boolean): Boolean;
begin
  Result:=CopyFileW(PWideChar(FromFile),PWideChar(ToFile),FailIfExists);
end; { function copy_file }




function rename_file(OldName, NewName : WideString) : Boolean;
begin
  Result:=MoveFileW(PWideChar(OldName),PWideChar(NewName));
end; { function rename_file }




function delete_file(FileName : WideString) : Boolean;
begin
  Result:=DeleteFileW(PWideChar(FileName));
end; { function delete_file }




function dir_exist(const Directory: WideString) : Boolean;
var
  Code: Cardinal;
begin
  Code := GetFileAttributesW(PWideChar(Directory));
  Result := (Code <> INVALID_FILE_ATTRIBUTES) and (FILE_ATTRIBUTE_DIRECTORY and Code <> 0);
end; { function dir_exist }



function create_dir(const Directory: WideString) : BOOLEAN;
begin
  Result := CreateDirectoryW(PWideChar(Directory), nil);
end; { FUNCTION Verzeichnis_existiert }



procedure show_message(const Message,Caption: WideString);
begin
  MessageBoxW(0,PWideChar(Message),PWideChar(Caption),MB_OK);
end; { procedure show_message }




function run_application(const Programm_Pfad, Programm, Parameter : WideString;
                          handle : DWORD) : WideString;
var i,typ : integer;
    msg : WideString;
begin
  // typ:=SW_SHOWNORMAL;
  // typ:=SW_MINIMIZE;
  // typ:=SW_HIDE;
  typ:=SW_SHOWMINIMIZED;

  i := ShellExecuteW(handle,nil,PWideChar(Programm),PWideChar(Parameter),
                     PWideChar(Programm_Pfad),typ);
       { ShellExecuteW(HWND hwnd, LPCWSTR lpOperation, LPCWSTR lpFile,
                       LPCWSTR lpParameters, LPCWSTR lpDirectory, INT nShowCmd); }

      IF i <= 32 THEN BEGIN
        CASE i OF
          0 : msg:='Zuwenig Speicher, ausführbare Datei war zerstört, Relokationswerte waren ungültig';
          2 : msg:='Datei wurde nicht gefunden.';
          3 : msg:='Verzeichnis wurde nicht gefunden.';
          5 : msg:='Fehler beim gemeinsamen Zugriff auf eine Datei im Netz oder Fehler'+
                   ' beim Zugriff auf eine gesperrte Datei im Netz.';
          6 : msg:='Bibliothek forderte separate Datensegmente für jede Task an.';
          8 : msg:='Zuwenig Speicher, um die Anwendung zu starten.';
          10: msg:='Falsche Windows-Version.';
          11: msg:='Ungültige ausführbare Datei. Entweder keine Windows-Anwendung oder Fehler in der EXE-Datei.';
          12: msg:='Anwendung für ein anderes Betriebssystem.';
          13: msg:='Anwendung für MS-DOS 4.0.';
          14: msg:='Typ der ausführbaren Datei unbekannt.';
          15: msg:='Versuch, eine Real-Mode-Anwendung (für eine frühere Windows-Version) zu laden.';
          16: msg:='Versuch, eine zweite Instanz einer ausführbaren Datei mit mehreren Datensegmenten'+
                   ', die nicht als nur lesbar gekennzeichnet waren, zu laden.';
          19: msg:='Versuch, eine komprimierte ausführbare Datei zu laden. Die Datei muß dekomprimiert'+
                   ' werden, bevor sie geladen werden kann.';
          20: msg:='Ungültige dynamische Linkbibliothek (DLL). Eine der DLLs, die benötigt wurde, um '+
                   'die Anwendung auszuführen, war beschädigt.';
        end; { CASE i OF }
        Result:=msg;
      end; { IF i <= 32 THEN }

end; { procedure run_application }






function Get_Environment_Variable(const Name : wideString) : WideString;
var 
  laenge : integer;
  WS : WideString;
begin
  Result := '';
  SetLength(WS,1);
  laenge := Windows.GetEnvironmentVariableW(PWideChar(Name), PWideChar(WS), 1);
  if laenge > 0 then begin
    SetLength(Result, laenge - 1);
    Windows.GetEnvironmentVariableW(PWideChar(Name), PWideChar(Result), laenge);
  end;
end; { function Get_Environment_Variable }




procedure Set_Environment_Variable(const name, value : wideString);
begin
  SetEnvironmentVariableW(PWideChar(name),PWideChar(value));
end; { procedure Set_Environment_Variable }





function run_app(ProgrammName, ProgrammOrdner, Parameter : WideString;
                 Wait : Boolean) : Boolean;
var
  lpStartupInfo : TStartupInfo;
  ProcInfo : TProcessInformation;
  CreateOK : Boolean;
  lpEnvironment : Pointer;

begin
  if length(Parameter)>0 then
    lpEnvironment := @Parameter[1]
  else
    lpEnvironment := nil;

  FillChar(lpStartupInfo,SizeOf(TStartupInfo),#0);
  FillChar(ProcInfo,SizeOf(TProcessInformation),#0);
  lpStartupInfo.cb := SizeOf(TStartupInfo);
  lpStartupInfo.dwFlags := STARTF_USESHOWWINDOW;
  lpStartupInfo.wShowWindow := SW_HIDE;

{
function CreateProcessW(lpApplicationName: LPWSTR; lpCommandLine: LPWSTR;
                        lpProcessAttributes, lpThreadAttributes: PSecurityAttributes;
                        bInheritHandles: BOOL; dwCreationFlags: DWORD;
                        lpEnvironment: Pointer; lpCurrentDirectory: LPWSTR;
                        const lpStartupInfo: TStartupInfo;
                        var lpProcessInformation: TProcessInformation): BOOL; external KernelDLL name 'CreateProcessW';
}

  CreateOK := CreateProcessW(
                      nil,                    { lpApplicationName: PWideChar; }
                      PWideChar(ProgrammName), { lpCommandLine: PWideChar; }
                      nil,                    { lpProcessAttributes : PSecurityAttributes; }
                      nil,                    { lpThreadAttributes: PSecurityAttributes; }
                      False,                  { bInheritHandles: BOOL; }
                      CREATE_NEW_PROCESS_GROUP+
                      NORMAL_PRIORITY_CLASS+
                      CREATE_UNICODE_ENVIRONMENT,
                                              { dwCreationFlags: DWORD; }
                      lpEnvironment,          { lpEnvironment: Pointer; }
                      PWideChar(ProgrammOrdner), { lpCurrentDirectory: PWideChar; }
                      lpStartupInfo,          { const lpStartupInfo: TStartupInfoW; }
                      ProcInfo);              { var lpProcessInformation: TProcessInformation }
    { check to see if successful }
  if CreateOK and Wait then
    WaitForSingleObject(ProcInfo.hProcess, INFINITE);

  CloseHandle(ProcInfo.hProcess);
  CloseHandle(ProcInfo.hThread);

  Result:=CreateOK;
end;





function WideString_To_Boolean(BoolStr : WideString) : boolean;
var
  Ergebnis : boolean;
begin
  Ergebnis:=false;
  if length(BoolStr)>0 then begin
    if (BoolStr='1') or (WideLowerCase(BoolStr)='true') then
      Ergebnis:=true;
  end;
  Result:=Ergebnis;
end; { function WideString_To_Boolean }



// convert all '/' to '\'
procedure Slash_To_Backslash(var Zeichenkette : WideString);
var
  I: Integer;
begin
  I := Pos('/', Zeichenkette);
  while I > 0 do begin
    Zeichenkette[I] := '\';
    I := Pos('/', Zeichenkette);
  end;
end; { procedure Slash_To_Backslash }



// convert all '\' to '/'
procedure Backslash_To_Slash(var Zeichenkette : WideString);
var
  I: Integer;
begin
  I := Pos('\', Zeichenkette);
  while I > 0 do begin
    Zeichenkette[I] := '/';
    I := Pos('\', Zeichenkette);
  end;
end; { procedure Backslash_To_Slash }



function last_backslash(pfad : WideString) : WideString;
var
  pfad_mit_backslash : WideString;
begin
  pfad_mit_backslash:=pfad;
  if length(pfad_mit_backslash)>0 then begin
    if not (pfad_mit_backslash[length(pfad_mit_backslash)]='\') then
      pfad_mit_backslash:=pfad_mit_backslash+'\';

  end; { if length(pfad_name)>0 then }

  last_backslash:=pfad_mit_backslash;
end; { procedure last_backslash }



function last_slash(pfad : WideString) : WideString;
var
  pfad_mit_slash : WideString;
begin
  pfad_mit_slash:=pfad;
  if length(pfad_mit_slash)>0 then begin
    if not (pfad_mit_slash[length(pfad_mit_slash)]='/') then
      pfad_mit_slash:=pfad_mit_slash+'/';

  end; { if length(pfad_name)>0 then }

  last_slash:=pfad_mit_slash;
end; { procedure last_slash }




{ *** TNT *** }


function WideIsPathDelimiter(const S: WideString; Index: Integer): Boolean;
begin
  Result := (Index > 0) and (Index <= Length(S)) and (S[Index] = PathDelim);
end;



function WideExcludeTrailingPathDelimiter(const S: WideString): WideString;
begin
  Result := S;
  if WideIsPathDelimiter(Result, Length(Result)) then
    SetLength(Result, Length(Result)-1);
end;




function WideExcludeTrailingBackslash(const S: WideString): WideString;
begin
  Result := WideExcludeTrailingPathDelimiter(S);
end;




function WStrScan(const Str: PWideChar; Chr: WideChar): PWideChar;
begin
  Result := Str;
  while Result^ <> Chr do
  begin
    if Result^ = #0 then
    begin
      Result := nil;
      Exit;
    end;
    Inc(Result);
  end;
end;



function WideLastDelimiter(const Delimiters, S: WideString): Integer;
var
  P: PWideChar;
begin
  Result := Length(S);
  P := PWideChar(Delimiters);
  while Result > 0 do
  begin
    if (S[Result] <> #0) and (WStrScan(P, S[Result]) <> nil) then
      Exit;
    Dec(Result);
  end;
end;






function WideExtractFilePath(const FileName: WideString): WideString;
var
  I: Integer;
begin
  I := WideLastDelimiter('\:', FileName);
  Result := Copy(FileName, 1, I);
end;



function WideExtractFileExt(const FileName: WideString): WideString;
var
  I: Integer;
begin
  I := WideLastDelimiter('.\:', FileName);
  if (I > 0) and (FileName[I] = '.') then
    Result := Copy(FileName, I, MaxInt) else
    Result := '';
end;



function WideExtractFileName(const FileName: WideString): WideString;
var
  I: Integer;
begin
  I := WideLastDelimiter('\:', FileName);
  Result := Copy(FileName, I + 1, MaxInt);
end;




function WideForceDirectories(Dir: WideString): Boolean;
begin
  Result := True;
  Dir := WideExcludeTrailingBackslash(Dir);
  if (Length(Dir) < 3) or dir_exist(Dir)
    or (WideExtractFilePath(Dir) = Dir) then Exit; // avoid 'xyz:\' problem.
  Result := WideForceDirectories(WideExtractFilePath(Dir));
  if Result then
    Result := create_dir(Dir)
end;




function Tnt_CreateFileW(lpFileName: PWideChar; dwDesiredAccess, dwShareMode: DWORD;
  lpSecurityAttributes: PSecurityAttributes; dwCreationDisposition, dwFlagsAndAttributes: DWORD;
    hTemplateFile: THandle): THandle;
begin
    Result := CreateFileW{TNT-ALLOW CreateFileW}(lpFileName, dwDesiredAccess, dwShareMode,
      lpSecurityAttributes, dwCreationDisposition, dwFlagsAndAttributes, hTemplateFile)
end;



function WideFileOpen(const FileName: WideString; Mode: LongWord): Integer;
const
  AccessMode: array[0..2] of LongWord = (
    GENERIC_READ,
    GENERIC_WRITE,
    GENERIC_READ or GENERIC_WRITE);
  ShareMode: array[0..4] of LongWord = (
    0,
    0,
    FILE_SHARE_READ,
    FILE_SHARE_WRITE,
    FILE_SHARE_READ or FILE_SHARE_WRITE);
begin
  Result := Integer(Tnt_CreateFileW(PWideChar(FileName), AccessMode[Mode and 3],
    ShareMode[(Mode and $F0) shr 4], nil, OPEN_EXISTING,
      FILE_ATTRIBUTE_NORMAL, 0));
end;




function WideFileCreate(const FileName: WideString): Integer;
begin
  Result := Integer(Tnt_CreateFileW(PWideChar(FileName), GENERIC_READ or GENERIC_WRITE,
    0, nil, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0))
end;



function WideChangeFileExt(const FileName, Extension: WideString): WideString;
var
  I: Integer;
begin
  I := WideLastDelimiter('.\:',Filename);
  if (I = 0) or (FileName[I] <> '.') then I := MaxInt;
  Result := Copy(FileName, 1, I - 1) + Extension;
end;




{ TTntFileStream }

constructor TTntFileStream.Create(const FileName: WideString; Mode: Word);
var
  CreateHandle: Integer;
begin
  if Mode = fmCreate then
  begin
    CreateHandle := WideFileCreate(FileName);
  end else
  begin
    CreateHandle := WideFileOpen(FileName, Mode);
  end;
  inherited Create(CreateHandle);
end;

destructor TTntFileStream.Destroy;
begin
  if Handle >= 0 then FileClose(Handle);
end;





function WideStringToUTF8(const S: WideString): AnsiString;
begin
  Result := UTF8Encode(S);
end;


function UTF8ToWideString(const S: AnsiString): WideString;
begin
  Result := UTF8Decode(S);
end;







end.

