﻿unit wincpm;

{$mode objfpc}{$H+}

interface


uses
  Classes, SysUtils, Dialogs, ExtCtrls, Forms, Graphics, StdCtrls, Controls,
  IniFiles, win_ws;



const
  max_BlockFeld_len = 2047;
  IMAGE_DIR = 'DiskImages';

type


  { spt=72,bsh=4,blm=15,exm=0,dsm=710,drm=255,al0=0f0h,al1=0,cks=64,off=2 }
  { BSH = 4 -> BLM = 15 -> Blockgroesse = 2048 }
  { EXM=0 -> Blockgroesse 2048 mehr als 255 BlÃ¶cke -> EXM=0 }
  { DSM=710 -> (710+1)*2048=1456128 = 163800H }
  { plus Systemspuren = (710+1+2)*2048 = 1460224 = 164800H }
  { DRM=255 Verzeichnisseintraege }
  { AL0, AL1 = 0F000H = 4 Verzeichnisbloecke }
  { CGS=64 -> 256 (DRM+1) / 4 = 64 }

  T_DPB = record
            SPT, { Sectors per Logical Track - Sektoren pro Spur (72) }
            BSH, { Block Shift - Blockverschiebungsfaktor = Blockgroesse / 128 (4) }
            BLM, { Block Mask - Blockmaske (15) }
            EXM, { Extent Mask - Extendmaske (0) }
            DSM, { Highest Block Number - Anzahl der Bloecke pro Diskette minus 1 plus Verzeichnis minus Systemspuren (710) }
            DRM, { Highest Directory Entry Number - Anzahl der Verzeichniseintraege minus 1 (255) }
            AL0, AL1, { 16-bit Directory Allocation Pattern - vom Verzeichnis belegte Boecke (0F000H) }
            CKS, { Directory Check Sum - Groesse des Verzeichnispruefvektors (64) }
            OFF  { No. of reserved tracks - Anzahl der Systemspuren (2) }
            : Integer;
         end;


  T_DIR_Entry = record
                  UserNumber : Byte; // 0
                  filename : Array [1..8] of Byte; //  1..8
                  filetype : Array [1..3] of Byte;  // 9..11
                  EX, S2, S1, RC : Byte;  // 12..15
                  AL : Array[1..8] of Word;
                end;


  T_BlockEntry = class(TObject)
                   BlockNumber, RecordCounter : Word;
                 end; { T_BlockList }


  T_DIR_Set = class(TObject)
                UserNumber : Byte;
                filename : String[8]; // Array [1..8] of Char;
                filetype : String[3]; // Array [1..3] of Char;
                ATTR : Array [1..11] of Boolean;
                RecordCount : Word;
                BlockList : TList;
              end; { T_DIR_Set }


  { Twcpm }

  Twcpm = class(TObject)
    constructor Create(var Term : TListBox;
                       var Image3 : TImage); overload;
    destructor Destroy; override;
   private
    { private declarations }
    Blockanzahl : Integer;
    CPM_DIR_List, WIN_DIR_List : TStringList;
    Blockgroesse : Integer;
    DIR_Entry_List : TList;
    BlockFeld : Array [0..max_BlockFeld_len] of Char;
    FIni:TMemIniFile;
    Dateipfad : WideString;
    Terminal : TListBox;
    Image_LW : TImage;

    { allgemein }
    procedure Write_To_Terminal(TermString : String);
    procedure create_IMG_File;
    procedure calculate_Blockgroesse;

    { WIN_To_CPM }
    procedure WIN_DIR_To_WIN_DIR_List;
    procedure Format_CPM_File_Name(var F_Name, F_Type : String;
                                   FileName : String);
    procedure Copy_WIN_Files_To_Image;

    { CPM_To_WIN }
    procedure CPM_DIR_List_To_CPM_File;
    procedure Dir_Entrys_To_DIR_Entry_List;
    procedure DIR_Entry_List_To_CPM_DIR_List;

    { Grafik }
    procedure Read_Free_BlockList;
    procedure Show_Free_BlockList;

  public
    { public declarations }
    Dateiname, DateiExtention,
    CPM_DIR_IN, CPM_DIR_OUT : WideString;
    Write_Log_File : Boolean;
    IMG_File : TMemoryStream;
    Index_Emulation : Integer;
    DPB : T_DPB;

    { allgemein }
    procedure Load_Image_File;
    procedure load_dpb_cpmdsk;
    procedure load_dpb_img;
    procedure load_dpb_dsk;
    procedure Save_IMG_File;

    { WIN_To_CPM }
    procedure Import_Files_To_Image;

    { CPM_To_WIN }
    procedure Export_Files_From_Image;

    { Grafik }
    procedure Show_Image;
  end;





var
  wcpm: Twcpm;


implementation



constructor Twcpm.Create(var Term : TListBox;
                         var Image3 : TImage);
var
  BL_Zaehler : Integer;
begin
  inherited Create;

  Terminal := Term;
  Image_LW := Image3;

  Dateipfad := WideExtractFilePath(Application.ExeName);

  Write_Log_File := false;

  FIni := TMemIniFile.Create('wincpm.ini');
  Dateiname := FIni.ReadString('System', 'Dateiname', 'CPD2.img');
  CPM_DIR_IN := FIni.ReadString('System', 'CPM_DIR_IN', 'CPM_DIR_IN');
  CPM_DIR_OUT := FIni.ReadString('System', 'CPM_DIR_OUT', 'CPM_DIR_OUT');
  Index_Emulation := FIni.ReadInteger('System', 'Index_Emulation', 0);

end; { constructor Twcpm.Create }



{ *** allgemeine Prozeduren *** }



procedure Twcpm.Write_To_Terminal(TermString : String);
begin
  if Write_Log_File then
    Terminal.Items.Add(TermString);

end; { procedure Twcpm.Write_To_Terminal }





procedure Twcpm.create_IMG_File;
var
  x1, Dateigroesse : Integer;
  Buffer : Byte;
begin
  // die
  Dateigroesse := (DPB.SPT*DPB.OFF*128) + ((DPB.DSM+1)*Blockgroesse);

  IMG_File.SetSize(Dateigroesse);
  IMG_File.Position:=0;
  Buffer:=$E5;
  for x1:=0 to Dateigroesse-1 do begin
    IMG_File.Write(Buffer,1);
  end;
  Blockanzahl:=Dateigroesse div Blockgroesse;
end; { procedure Twcpm.create_IMG_File }





procedure Twcpm.calculate_Blockgroesse;
begin
  case wcpm.DPB.BSH of
    3 : Blockgroesse:=1024;
    4 : Blockgroesse:=2048;
    5 : Blockgroesse:=4096;
    6 : Blockgroesse:=8192;
    7 : Blockgroesse:=16384;
  end;
  Write_To_Terminal('Blockgroesse='+IntToStr(Blockgroesse)+' ('+IntToHex(Blockgroesse,4)+'H)');

end; { procedure Twcpm.calculate_Blockgroesse }



procedure Twcpm.load_dpb_cpmdsk;
begin
{
Disk Parameter Block for drive 0. Calculated using DISKDEF values 0, 1, 32, 0, 2048, 512, 256, 0, 0

b_dpb0:	DW	32		; SPT total number of sectors per track.
		DB	4	; BSH data allocation block shift factor, determined by the data block allocation size.
		DB	15	; BLM data allocation block mask (2^BSH - 1).
		DB	0	; EXM extent mask determined by the data block allocation size and the number of disk blocks.
		DW	511	; DSM determines total storage capacity of this drive. (disk size - 1).
		DW	254	; DRM total number of directory entries that can be stored on this drive.
		DB	240	; AL0 determine reserved directory blocks.
		DB	0	; AL1 determine reserved directory blocks.
		DW	0	; CKS size of the directory check vector.
		DW	2	; OFF number of reserved tracks at the beginning of the disk.
 }
  DPB.SPT:=32;  DPB.BSH:=4;  DPB.BLM:=15;  DPB.EXM:=0;  DPB.DSM:=511;
  DPB.DRM:=255; DPB.AL0:=240; DPB.AL1:=$00; DPB.CKS:=0;  DPB.OFF:=2;

  calculate_Blockgroesse;
   DateiExtention := '.cpmdsk';
end; { procedure Twcpm.load_dpb_cpmdsk }






procedure Twcpm.load_dpb_img;
begin
  {
  spt=72,bsh=4,blm=15,exm=0,dsm=710,drm=255,al0=0f0h,al1=0,cks=64,off=2
  }
  DPB.SPT:=72;  DPB.BSH:=4;   DPB.BLM:=15;  DPB.EXM:=0;   DPB.DSM:=710;
  DPB.DRM:=255; DPB.AL0:=$0F; DPB.AL1:=$00; DPB.CKS:=64;  DPB.OFF:=2;

  calculate_Blockgroesse;
   DateiExtention := '.img';
end; { procedure Twcpm.load_dpb_img }





procedure Twcpm.load_dpb_dsk;
begin
  {
  Altair 8800 simulator is part of the SIMH

  Größe des Images: 8388608D = 800000H = 8 MB
  Dir beginnt bei: 6000H
  Daten beginnen bei: E000H
  daher DirSize= 8000H
  Blockgröße ermittelt durch copieren zweier Dateien und nachsehen im Image:
  test1.txt = 1F000H
  test2.txt = 20000H
  Differenz = 1000H = 4096D = Blockgröße

  'Hard Disk Parameter Blocks
  'Each DPB is 17 bytes as defined for DPBs in CP/M followed by 2 bytes sector size as used by SIMH
  hdsk_dpb
  dpb_0                           'Default 8MByte SIMH Altair HDSK params
  :spt_low      BYTE      $20     'sectors per track (low byte)
  :spt_high     BYTE      $00     'sectors per track (high byte)
  :bsh          BYTE      $05     'data allocation Block SHift factor
  :blm          BYTE      $1F     'data allocation block mask
  :exm          BYTE      $01     'EXtent Mask
  :dsm_low      BYTE      $F9     'maximum data block number (low_byte)
  :dsm_high     BYTE      $07     'maximum data block number (high_byte)
  :drm_low      BYTE      $FF     'total number of directory entries (low byte)
  :drm_high     BYTE      $03     'total number of directory entries (high byte)
  :al0          BYTE      $FF     'determine reserved directory blocks
  :al1          BYTE      $00     'determine reserved directory blocks
  :cks_low      BYTE      $00     'size of directory ChecK vector (low byte)
  :cks_high     BYTE      $00     'size of directory ChecK vector (high byte)
  :off_low      BYTE      $06     'number of reserved tracks (offset) (low byte)
  :off_high     BYTE      $00     'number of reserved tracks (offset) (high byte)
  :psh          BYTE      $00     'Physical record SHift factor, CP/M 3
  :phm          BYTE      $00     'PHhysical record Mask, CP/M 3
  :ss_low       BYTE      $80     'Sector Size (low byte)
  :ss_high      BYTE      $00     'Sector Size (high byte)
                                  'N.B. SS must be 128 for CP/M 2 can be varied for CP/M 3 hard disks.
  }
  DPB.SPT:=$20;   DPB.BSH:=$05; DPB.BLM:=$1F; DPB.EXM:=$01;   DPB.DSM:=$07F9;
  DPB.DRM:=$03FF; DPB.AL0:=$FF; DPB.AL1:=$00; DPB.CKS:=$0000; DPB.OFF:=$0006;

  calculate_Blockgroesse;
   DateiExtention := '.dsk';
end; { procedure Twcpm.load_dpb_dsk }





procedure Twcpm.Save_IMG_File;
begin
  IMG_File.SaveToFile(Dateipfad+IMAGE_DIR+'\'+Dateiname);
end; { procedure Twcpm.Save_IMG_File }



{ ***** WINDIR TO CPM-Image ***** }




procedure Twcpm.Import_Files_To_Image;
var
  buttonSelected : Integer;

begin

  WIN_DIR_List := TStringList.Create;
  DIR_Entry_List := TList.Create;
  IMG_File := TMemoryStream.Create;

  // Erzeugen des Images
  create_IMG_File;
  WIN_DIR_To_WIN_DIR_List;

  if WIN_DIR_List.Count>0 then begin

    Copy_WIN_Files_To_Image;

    if FileExists(Dateipfad+IMAGE_DIR+'\'+Dateiname) then begin
      buttonSelected := MessageDlg('Datei: '+Dateipfad+IMAGE_DIR+'\'+Dateiname+
                                   ' existiert bereits. Ueberschreiben?',mtWarning,
                                   [mbYes,mbNo], 0);
      if buttonSelected = mrYes then
        Save_IMG_File;
    end
    else
      Save_IMG_File;

  end
  else
    Write_To_Terminal('*** keine Dateien im Verzeichnis '+IMAGE_DIR+' ***');

  Show_Image;

  WIN_DIR_List.Free;
  DIR_Entry_List.Free;

end; { procedure Twcpm.Import_Files_To_Image }







procedure Twcpm.Load_Image_File;
var
  Dateigroesse : Integer;
begin

  // Laden der Image-Datei
  IMG_File.LoadFromFile(Dateipfad+IMAGE_DIR+'\'+Dateiname);
  Write_To_Terminal('Datei:'+Dateiname+' eingelesen');
  Dateigroesse:=IMG_File.Size;         // GetSize !!!
  Write_To_Terminal('Dateigroesse: '+IntToStr(Dateigroesse)+' = '+IntToHex(Dateigroesse,4)+'H');
  Blockanzahl:=Dateigroesse div Blockgroesse;
  Write_To_Terminal('Anzahl der Bloecke: '+IntToStr(Blockanzahl)+' = '+IntToHex(Blockanzahl,4)+'H');

end; { procedure Twcpm.Load_Image_File }





procedure Twcpm.WIN_DIR_To_WIN_DIR_List;
{ Liest alle Einträge des Windows-Verzeichnisses CPM_DIR_IN in die
  StringListe WIN_DIR_List ein.
}
var
  Info : TSearchRec;
  Count : Longint;
  FileName : String;
begin
  WIN_DIR_List.Clear;

  Count:=0;
  If FindFirst(Dateipfad+CPM_DIR_IN+'\*.*',faAnyFile,Info)=0 then
    begin
    Repeat
      Inc(Count);
      With Info do begin
          if (Info.Name<>'.') and (Info.Name<>'..') then begin
            // Dateinamen werden in CP/M immer gross geschrieben
            FileName := UpperCase(Info.Name);
            WIN_DIR_List.Add(FileName);
          end; { if (Info.Name<>'.') and (Info.Name<>'..') then }
      end; { With Info do }
    Until FindNext(info)<>0;
    end;
  FindClose(Info);

//  WIN_DIR_List.SaveToFile('WIN_DIR_List.txt');

end; { procedure Twcpm.WIN_DIR_To_WIN_DIR_List }








procedure Twcpm.Format_CPM_File_Name(var F_Name, F_Type : String;
                                     FileName : String);
var
  Pos_Punkt : Integer;
begin
    // Umwandeln des Dateinamens
    FileName:=Trim(FileName);

    F_Name:=FileName;
    F_Type:='   ';

    Pos_Punkt:=Pos('.',FileName);
    if Pos_Punkt>0 then begin
      F_Name:=Copy(FileName,1,Pos_Punkt-1);
      F_Type:=Copy(FileName,Pos_Punkt+1,Length(FileName)-1);
    end;

    while Length(F_Name)<8 do
      F_Name:=F_Name+' ';

    while Length(F_Type)<3 do
      F_Type:=F_Type+' ';

end; { procedure Twcpm.Format_CPM_File_Name }





procedure Twcpm.Copy_WIN_Files_To_Image;
{
  Kopiert alle Windows-Dateien, die in der StringList WIN_DIR_List stehen
  in das CPM-Image
}
var
  CopyName : String;
  WIN_File : TMemoryStream;
  WIN_DIR_List_Counter : Integer;


  procedure Free_BlockList;
  // schreibt in das Array BlockFeld alle Bloecke mit Leer(x), Block vorhanden(f),
  // Dir(d) und Belegt(b)
  var
    DIR_Set : T_DIR_Set;
    BlockEntry : T_BlockEntry;
    Zaehler_DEL, Zaehler_BL, Anzahl_Sys : Integer;
  begin
    // erst einmal werden alle Elemente im Array mit "x" beschrieben
    for Zaehler_BL:=0 to max_BlockFeld_len do
      BlockFeld[Zaehler_BL]:='x';

    // dann werden alle Elemente, die wirklich als Bloecke genutzt werden
    // mit "f"=frei gekennzeichnet (ohne Systemspuren)
    for Zaehler_BL:=0 to Blockanzahl-1 do
      BlockFeld[Zaehler_BL]:='f';

    Zaehler_DEL:=((DPB.DRM+1) div (Blockgroesse div 32));

    Write_To_Terminal('Anzahl der Bloecke im DIR='+IntToStr(Zaehler_DEL));

    // das Direktory wird mit "d" gekennzeichnet
    for Zaehler_BL:=0 to Zaehler_DEL-1 do
      BlockFeld[Zaehler_BL]:='d';

    // die belegten Bloecke werden mit "b" gekennzeichnet
    for Zaehler_DEL:=0 to DIR_Entry_List.Count-1 do begin
      DIR_Set:=T_DIR_Set(DIR_Entry_List[Zaehler_DEL]);

      for Zaehler_BL:=0 to DIR_Set.BlockList.Count-1 do begin
        BlockEntry:=T_BlockEntry(DIR_Set.BlockList[Zaehler_BL]);
        BlockFeld[Anzahl_Sys+BlockEntry.BlockNumber]:='b';
      end; { for Zaehler_BL:=0 to DIR_Set.BlockList.Count-1 do }

    end; { for Zaehler:=0 to DPB.DRM do }
  end; { procedure Free_BlockList }



  function Find_Next_Free_Block : Integer;
  // sucht und uebergibt den nächsten freien Block und kennzeichnet
  // ihn als besetzt
  var
    Next_Free_Block, Zaehler_BL : Integer;
    gefunden : Boolean;
  begin
    gefunden:=false;
    Next_Free_Block:=0;
    for Zaehler_BL:=0 to Blockanzahl-1 do begin
      if (not gefunden) then begin
        if BlockFeld[Zaehler_BL]='f' then begin
          BlockFeld[Zaehler_BL]:='b';
          gefunden:=true;
          Next_Free_Block:=Zaehler_BL;
        end; { if BlockFeld[Zaehler_BL]='f' then }
      end; { if (not gefunden) then }
    end; { for Zaehler_BL:=0 to Blockanzahl-1 do }

    if (not gefunden) then
      Write_To_Terminal('*** Fehler: kein freier Block gefunden ***');

    Result:=Next_Free_Block;
  end; { function Find_Next_Free_Block }



  procedure Write_File(FileName : String);
  var
    Zaehler_F,
    Records_per_Block, Records_per_File,
    Record_Counter, DIR_Anfang, Zaehler_DRM,
    DIR_POS_schreiben, geschriebene_Records : Integer;
    F_Name, F_Type : String;
    First_Block_Pos, akt_Block_Pos, akt_Block_Nr, Write_Size : DWord;
    Buffer : Array [1..16384] of Byte;
    Extendnummer, Extendgruppe : Byte;
    BlockList : TList;
    BlockEntry : T_BlockEntry;
    DIR_Entry : T_DIR_Entry;
    DIR_Entry_ready : Boolean;


  begin
    BlockList := TList.Create;

    // Berechnung der Anzahl der Bloecke aus der Win-Dateigroesse
    Records_per_File := WIN_File.Size div 128;

    // ist der nächste Block angerissen (z.B. bei Textdateien, die in Windows
    // editiert wurden - Windows speichert nicht in 128er Sektoren ab), so wird
    // ein Sektor hinzugezaehlt
    if (WIN_File.Size mod 128)>0 then begin
      inc(Records_per_File);
      Write_To_Terminal('*** Records_per_File Plus 1 ***');
    end;

    Record_Counter := Records_per_File;
    Records_per_Block := Blockgroesse div 128;

    Format_CPM_File_Name(F_Name, F_Type, FileName);

    // es wird an der ersten Blockposition angefangen
    // die ergibt sich aus der Laenge des Systemabschnittes am Anfang
    // des Images
    First_Block_Pos:= DPB.SPT*DPB.OFF*128; { Blockgroesse*9 = 4800H = 18432D = 72 * 2 * 128 }
    WIN_File.Position:=0;

    Write_To_Terminal('Schreiben von Datei: '+FileName);  // 277 rec // 900 rec

    // solange nicht alle Records geschrieben wurden, wird weiter geschrieben
    while Record_Counter>0 do begin

      // ein neuer Eintrag für BlockEntry wird erzeugt
      BlockEntry := T_BlockEntry.Create;

      if Record_Counter>Records_per_Block then begin
        Record_Counter:=Record_Counter-Records_per_Block;
        Write_Size:=Blockgroesse;
        BlockEntry.RecordCounter:=Records_per_Block;
      end
      else begin
        Write_Size:=Record_Counter*128;
        BlockEntry.RecordCounter:=Record_Counter;
        Record_Counter:=0;
      end;

      // Aus der Windows-Datei wird der Inhalt eines Blockes (oder eines Sektors * x)
      // in den Buffer gelesen
      WIN_File.Read(Buffer,Write_Size);

      akt_Block_Nr := Find_Next_Free_Block;
      Write_To_Terminal('akt_Block_Nr: '+IntToHex(akt_Block_Nr,2));
      akt_Block_Pos := akt_Block_Nr * Blockgroesse;
      IMG_File.Position:=First_Block_Pos + akt_Block_Pos;
      Write_To_Terminal('IMG_File.Position: '+IntToHex(IMG_File.Position,4));

      // nun wird der Buffer in das Image geschrieben
      IMG_File.Write(Buffer,Write_Size);

      // und dann die aktuelle Blocknummer dort hineingeschrieben
      BlockEntry.BlockNumber:=akt_Block_Nr;
      // und den BlockEntry in die BlockList geschrieben
      BlockList.Add(BlockEntry);

    end; { while Record_Counter>Records_per_Block do }


    DIR_Anfang:=DPB.SPT*DPB.OFF*128; { Blockgroesse*9 = 4800H = 18432D = 72 * 2 * 128 = }
    IMG_File.Position:=DIR_Anfang;

    DIR_Entry_ready:=false;
    Extendnummer:=0;
    Extendgruppe:=0;
    geschriebene_Records:=0;



    for Zaehler_DRM:=0 to DPB.DRM do begin
      while not DIR_Entry_ready do begin
        DIR_POS_schreiben:=IMG_File.Position;
        IMG_File.Read(DIR_Entry, 32);

        if (DIR_Entry.UserNumber=$E5) then begin // E5H bedeutet der Eintrag ist nicht belegt
                                                // oder geloescht

          DIR_Entry.UserNumber:=$00;
          for Zaehler_F:=1 to 8 do
            DIR_Entry.filename[Zaehler_F]:=Byte(F_Name[Zaehler_F]);

          for Zaehler_F:=1 to 3 do
            DIR_Entry.filetype[Zaehler_F]:=Byte(F_Type[Zaehler_F]);



          // solange in der BlockList Eintraege (mit Blocknummern) vorhanden
          // sind, werden diese Blocknummern gelesen und in DIR_Entry.AL
          // eingetragen (maximal aber 8 Einträge)
          for Zaehler_F:=1 to 8 do begin
            if BlockList.Count>0 then begin
              // lesen des naechsten BlockEntry-Eintrages
              BlockEntry:=T_BlockEntry(BlockList.Items[0]);
              // Abspeichern der Blocknummer in der DIR_Entry.AL-Struktur (1..8)
              DIR_Entry.AL[Zaehler_F]:=BlockEntry.BlockNumber;
              // merken, wie viele Records bisher in diesem Verzeichniseitrag
              // geschrieben wurden
              geschriebene_Records:=geschriebene_Records+BlockEntry.RecordCounter;
              // Löschen des BlockEntry-Eintrages
              BlockList.Delete(0);
            end  { if BlockList.Count>0 then }
            else
              DIR_Entry.AL[Zaehler_F]:=$0000;

          end; { for Zaehler_F:=1 to 8 do }


          if BlockList.Count=0 then
            DIR_Entry_ready:=true;


          // die geschriebenen Records werden auf RC, EX und S2 aufgeteilt
          while geschriebene_Records>128 do begin
            geschriebene_Records:=geschriebene_Records-128;
            Inc(Extendnummer);
            if Extendnummer=32 then begin
              Inc(Extendgruppe);
              Extendnummer:=0;
            end; { if Extendnummer=32 then }
          end; { while geschriebene_Records>128 do }


          // ... und eingetragen
          DIR_Entry.EX:=Extendnummer;
          DIR_Entry.S2:=Extendgruppe;
          DIR_Entry.S1:=$0;
          DIR_Entry.RC:=geschriebene_Records;

          Write_To_Terminal('EX='+IntToHex(Extendnummer,2)+'  S2='+IntToHex(Extendgruppe,2)+
                            '  S1='+IntToHex(DIR_Entry.S1,2)+'  RC='+IntToHex(geschriebene_Records,2));

          IMG_File.Position:=DIR_POS_schreiben;
          IMG_File.Write(DIR_Entry, 32);

        end; { if (DIR_Entry.UserNumber=$E5) then }
      end; { while not DIR_Entry_ready do }

    end; { for Zaehler:=0 to DPB.DRM do }

  end; { procedure Read_File }





begin
  { 256 VE * 32 Byte = 8192 Byte = 4 Bloecke }

  { 6800H = Block 4 }


  if WIN_DIR_List.Count>0 then begin

    WIN_File := TMemoryStream.Create;
    Free_BlockList;

    for WIN_DIR_List_Counter:=0 to WIN_DIR_List.Count-1 do begin

      CopyName:=WIN_DIR_List[WIN_DIR_List_Counter];
      CopyName:=Trim(CopyName);
      WIN_File.LoadFromFile(Dateipfad+CPM_DIR_IN+'\'+CopyName);
      Write_File(CopyName);

    end; { for WIN_DIR_List_Counter:=0 to WIN_DIR_List.Count-1 do }

  end; { if ListBox_CPM_DIR.Count>0 then }

  WIN_File.Free;

end; { procedure Twcpm.Copy_WIN_Files_To_Image }





{ ***** CPM-Image TO WINDIR ***** }






procedure Twcpm.Export_Files_From_Image;
begin

  if FileExists(Dateipfad+IMAGE_DIR+'\'+Dateiname) then begin

    CPM_DIR_List := TStringList.Create;
    IMG_File := TMemoryStream.Create;
    DIR_Entry_List := TList.Create;

    Load_Image_File;
    Dir_Entrys_To_DIR_Entry_List;
    DIR_Entry_List_To_CPM_DIR_List;
    CPM_DIR_List_To_CPM_File;

    Show_Image;

    CPM_DIR_List.Free;
    DIR_Entry_List.Free;

  end
  else
    ShowMessage('Datei: '+Dateipfad+IMAGE_DIR+'\'+Dateiname+' nicht vorhanden');

end; { procedure Twcpm.Export_Files_From_Image }






procedure Twcpm.Dir_Entrys_To_DIR_Entry_List;
{
  Die Einträge des Inhaltsverzeichnisses des Images werden in die Struktur
  DIR_Entry : T_DIR_Entry eingelesen.
}
  var
    DIR_Entry : T_DIR_Entry;
    DIR_Set : T_DIR_Set;
    BlockEntry : T_BlockEntry;
    DIR_Anfang, logische_Erweiterung : Word;
    Zaehler_DRM, Zaehler_AL : Integer;
    filename : String; // Array [1..8] of Char;
    filetype : String; // Array [1..3] of Char;
    erster_Durchlauf : Boolean;
    Anzahl_der_Eintraege : Integer;


    procedure Grundeintrag;
    begin
      DIR_Set.BlockList := TList.Create;

      DIR_Set.UserNumber:=DIR_Entry.UserNumber;
      DIR_Set.filename:=filename;
      DIR_Set.filetype:=filetype;

      DIR_Set.ATTR[01]:=((DIR_Entry.filename[1] and $80)=$80);
      DIR_Set.ATTR[02]:=((DIR_Entry.filename[2] and $80)=$80);
      DIR_Set.ATTR[03]:=((DIR_Entry.filename[3] and $80)=$80);
      DIR_Set.ATTR[04]:=((DIR_Entry.filename[4] and $80)=$80);
      DIR_Set.ATTR[05]:=((DIR_Entry.filename[5] and $80)=$80);
      DIR_Set.ATTR[06]:=((DIR_Entry.filename[6] and $80)=$80);
      DIR_Set.ATTR[07]:=((DIR_Entry.filename[7] and $80)=$80);
      DIR_Set.ATTR[08]:=((DIR_Entry.filename[8] and $80)=$80);
      DIR_Set.ATTR[09]:=((DIR_Entry.filetype[1] and $80)=$80);
      DIR_Set.ATTR[10]:=((DIR_Entry.filetype[2] and $80)=$80);
      DIR_Set.ATTR[11]:=((DIR_Entry.filetype[3] and $80)=$80);

    end; { procedure Grundeintrag }


  begin
    DIR_Entry_List.Clear;
    Anzahl_der_Eintraege:=0;

    DIR_Anfang:=DPB.SPT*DPB.OFF*128; { Blockgroesse*9 = 4800H = 18432D = 72 * 2 * 128 = }

    IMG_File.Position:=DIR_Anfang;
    erster_Durchlauf:=true;

    for Zaehler_DRM:=0 to DPB.DRM do begin
      IMG_File.Read(DIR_Entry, 32);

      if (DIR_Entry.UserNumber<>$E5) then begin // E5H bedeutet der Eintrag ist nicht belegt
                                                // oder geloescht

        Inc(Anzahl_der_Eintraege);

        filename:=chr(DIR_Entry.filename[1] and $7F)+chr(DIR_Entry.filename[2] and $7F)+
                  chr(DIR_Entry.filename[3] and $7F)+chr(DIR_Entry.filename[4] and $7F)+
                  chr(DIR_Entry.filename[5] and $7F)+chr(DIR_Entry.filename[6] and $7F)+
                  chr(DIR_Entry.filename[7] and $7F)+chr(DIR_Entry.filename[8] and $7F);

        filetype:=chr(DIR_Entry.filetype[1] and $7F)+chr(DIR_Entry.filetype[2] and $7F)+
                  chr(DIR_Entry.filetype[3] and $7F);

        if erster_Durchlauf then begin
          DIR_Set := T_DIR_Set.Create;
          Grundeintrag;
          erster_Durchlauf:=false;
        end;


        if (DIR_Set.filename<>filename) or (DIR_Set.filetype<>filetype) then begin
          DIR_Entry_List.Add(DIR_Set);
          DIR_Set := T_DIR_Set.Create;
          Grundeintrag;
        end; { if (DIR_Set.filename<>filename) and (DIR_Set.filetype<>filetype) then }


        // logische_Erweiterung = (EXT & 1Fh) + ((S2 & 3Fh) << 5)
        logische_Erweiterung:=  (DIR_Entry.EX and $1F) + ((DIR_Entry.S2 and $3F) shl 5);
        // Rekordnr = logische_Erweiterung << 7 + (RC & 7Fh)
    //    DIR_Set.RecordCount := (logische_Erweiterung shl 7) + (DIR_Entry.RC and $7F);

        DIR_Set.RecordCount := (logische_Erweiterung shl 7) + DIR_Entry.RC;

        if DIR_Entry.RC>$80 then
          Write_To_Terminal('*** Fehler RecordCounter (RC) ist > 80H ('+IntToHex(DIR_Entry.RC,2)+') ***');


        for Zaehler_AL:=1 to 8 do begin
          if DIR_Entry.AL[Zaehler_AL]>0 then begin
            BlockEntry := T_BlockEntry.Create;
            BlockEntry.BlockNumber:=DIR_Entry.AL[Zaehler_AL];
            DIR_Set.BlockList.Add(BlockEntry);
          end; { if DIR_Entry.AL[Zaehler_AL]>0 then }
        end; { for Zaehler_AL:=1 to 8 do }

      end; { if (DIR_Entry.UserNumber<>$E5) then }

    end; { for Zaehler:=0 to DPB.DRM do }

    if Anzahl_der_Eintraege>0 then
      DIR_Entry_List.Add(DIR_Set);

               {
    Write_To_Terminal('++++++++++++++++++++++++++++++++++++++');
    for Zaehler_DRM:=0 to DIR_Entry_List.Count-1 do begin
      DIR_Set:=T_DIR_Set(DIR_Entry_List[Zaehler_DRM]);
      Write_To_Terminal('Datei('+IntToStr(Zaehler_DRM)+'): '+DIR_Set.filename+DIR_Set.filetype);
    end;
    Write_To_Terminal('++++++++++++++++++++++++++++++++++++++');
    Terminal.Items.SaveToFile('Terminal.log');
                        }

end; { procedure Twcpm.Dir_Entrys_To_DIR_Entry_List }








procedure Twcpm.DIR_Entry_List_To_CPM_DIR_List;
{
  Erzeugt aus der Struktur DIR_Entry_List die Stringlist CPM_DIR_List
}
  var
    DIR_Set : T_DIR_Set;
    BlockEntry : T_BlockEntry;
    Zaehler_DEL, Zaehler_BL : Integer;
    Zeile1, Zeile2, Zeile3 : String;

  begin
    CPM_DIR_List.Clear;

    Write_To_Terminal('Directory:');

    if DIR_Entry_List.Count>0 then begin

      for Zaehler_DEL:=0 to DIR_Entry_List.Count-1 do begin
        DIR_Set:=T_DIR_Set(DIR_Entry_List[Zaehler_DEL]);

        Zeile1:='';
        for Zaehler_BL:=0 to DIR_Set.BlockList.Count-1 do begin
          BlockEntry:=T_BlockEntry(DIR_Set.BlockList[Zaehler_BL]);
          Zeile1:=Zeile1+IntToHex(BlockEntry.BlockNumber,4)+'H ';
        end; { for Zaehler_BL:=0 to DIR_Set.BlockList.Count-1 do }

        Zeile2:=Trim(DIR_Set.filename)+'.'+Trim(DIR_Set.filetype);

        while Length(Zeile2)<13 do
          Zeile2:=Zeile2+' ';

        Zeile3:=' S('+IntToStr(DIR_Set.RecordCount)+')';

        while Length(Zeile3)<8 do
          Zeile3:=Zeile3+' ';

        Write_To_Terminal('Dateiname: '+Zeile2+Zeile3+' Bloecke: '+Zeile1);

        CPM_DIR_List.Add(Zeile2);

      end; { for Zaehler:=0 to DPB.DRM do }


    end; { if DIR_Entry_List.Count>0 then }


end; { procedure Twcpm.DIR_Entry_List_To_CPM_DIR_List }







procedure Twcpm.CPM_DIR_List_To_CPM_File;
var
  CopyName : String;
  CPM_File : TMemoryStream;
  CPM_DIR_List_Count : Integer;


  procedure Read_File(FileName : String);
  var
    Zaehler_DEL, Zaehler_BL,
    Records_per_Block : Integer;
    F_Name, F_Type : String;
    First_Block_Pos, akt_Block_Pos,
    Read_Size, RecordCount : DWord;
    Buffer : Array [1..16384] of Byte;

    DIR_Set : T_DIR_Set;
    BlockEntry : T_BlockEntry;

  begin
    Format_CPM_File_Name(F_Name, F_Type, FileName);

    First_Block_Pos:= DPB.SPT*DPB.OFF*128; { Blockgroesse*9 = 4800H = 18432D = 72 * 2 * 128 }
    IMG_File.Position:=First_Block_Pos;

    Write_To_Terminal('Lesen von Datei: '+FileName);

    for Zaehler_DEL:=0 to DIR_Entry_List.Count-1 do begin
      DIR_Set:=T_DIR_Set(DIR_Entry_List[Zaehler_DEL]);

      if (DIR_Set.UserNumber=0) then begin
        if (DIR_Set.filename=F_Name) and (DIR_Set.filetype=F_Type) then begin

          RecordCount:=DIR_Set.RecordCount;
          Records_per_Block:=Blockgroesse div 128;

          for Zaehler_BL:=0 to DIR_Set.BlockList.Count-1 do begin
            BlockEntry:=T_BlockEntry(DIR_Set.BlockList[Zaehler_BL]);
            akt_Block_Pos:=First_Block_Pos+(BlockEntry.BlockNumber*Blockgroesse);
            IMG_File.Position:=akt_Block_Pos;

            if RecordCount>=Records_per_Block then begin
              Read_Size:=Blockgroesse;
              RecordCount:=RecordCount-Records_per_Block;
            end
            else
              Read_Size:=RecordCount*128;

            IMG_File.Read(Buffer, Read_Size);
            CPM_File.Write(Buffer, Read_Size);

          end; { for Zaehler_BL:=0 to DIR_Set.BlockList.Count-1 do }

        end; { if (DIR_Entry.filename=F_Name) and (DIR_Entry.filetype=F_Type) then }
      end; { if DIR_Entry.UserNumber=0 then }

    end; { for Zaehler:=0 to DPB.DRM do }

  end; { procedure Read_File }

begin
  { 256 VE * 32 Byte = 8192 Byte = 4 Bloecke }

  { 6800H = Block 4 }


  if CPM_DIR_List.Count>0 then begin
    CPM_File := TMemoryStream.Create;
    for CPM_DIR_List_Count:=0 to CPM_DIR_List.Count-1 do begin

      CPM_File.SetSize(0);
      CopyName:=CPM_DIR_List[CPM_DIR_List_Count];
      Read_File(CopyName);
      CPM_File.SaveToFile(Dateipfad+CPM_DIR_OUT+'\'+CopyName);

    end; { for ListBox_CPM_DIR_Count:=0 to ListBox_CPM_DIR.Count-1 do }
    CPM_File.Free;

  end; { if ListBox_CPM_DIR.Count>0 then }

end; { procedure Twcpm.Copy_CPM_File }




{ *** Grafik *** }





procedure Twcpm.Show_Image;
begin
  // Anzeige der Image-Bitmap
  Dir_Entrys_To_DIR_Entry_List;

  Read_Free_BlockList;
  Show_Free_BlockList;

end; { procedure Twcpm.Show_Image; }






procedure Twcpm.Read_Free_BlockList;
  var
    DIR_Set : T_DIR_Set;
    BlockEntry : T_BlockEntry;
    Zaehler_DEL, Zaehler_BL, Anzahl_Sys : Integer;
  begin
    for Zaehler_BL:=0 to max_BlockFeld_len do
      BlockFeld[Zaehler_BL]:='x';

    for Zaehler_BL:=0 to Blockanzahl-1 do
      BlockFeld[Zaehler_BL]:='f';

    Anzahl_Sys:=(DPB.OFF*DPB.SPT)*128 div Blockgroesse;
    for Zaehler_BL:=0 to Anzahl_Sys-1 do
      BlockFeld[Zaehler_BL]:='s';

    Zaehler_DEL:=(DPB.DRM+1) div (Blockgroesse div 32);

    for Zaehler_BL:=Anzahl_Sys to Zaehler_DEL+Anzahl_Sys-1 do
      BlockFeld[Zaehler_BL]:='d';

    for Zaehler_DEL:=0 to DIR_Entry_List.Count-1 do begin
      DIR_Set:=T_DIR_Set(DIR_Entry_List[Zaehler_DEL]);

      for Zaehler_BL:=0 to DIR_Set.BlockList.Count-1 do begin
        BlockEntry:=T_BlockEntry(DIR_Set.BlockList[Zaehler_BL]);
        BlockFeld[Anzahl_Sys+BlockEntry.BlockNumber]:='b';
      end; { for Zaehler_BL:=0 to DIR_Set.BlockList.Count-1 do }

    end; { for Zaehler:=0 to DPB.DRM do }

                  {
    Terminal.Items.Clear;
    for Zaehler_BL:=0 to max_BlockFeld_len do begin
      Terminal.Items.Add(BlockFeld[Zaehler_BL]);
    end;
    Terminal.Items.SaveToFile('Terminal.log');
                    }


end; { procedure Twcpm.Read_Free_BlockList }







procedure Twcpm.Show_Free_BlockList;
const
  sectors_per_line = 64;

var
  Zaehler_BL, Zaehler_x, Zaehler_y,
  Pos_x, Pos_y, Width_x, Width_y,
  Anzahl_y : Integer;
  Zeichen : Char;
  offset_links, offset_oben : Integer;
begin
  offset_links := 0;
  offset_oben := 0;

  Image_LW.Canvas.Brush.Color:= clWhite;
  Image_LW.Canvas.Pen.Color:= clBlack;
  Image_LW.Canvas.Pen.Width:=1;
  Image_LW.Canvas.Rectangle(0,0,Image_LW.Canvas.Width,Image_LW.Canvas.Height);

  Width_x:=Image_LW.Canvas.Width div sectors_per_line;
  Anzahl_y:=(Blockanzahl div sectors_per_line)+1;
  Width_y:=Image_LW.Canvas.Height div Anzahl_y;

  Zaehler_BL := 0;
  for Zaehler_y:=0 to Anzahl_y do begin
    Pos_y:=(Zaehler_y*Width_y)+offset_oben;
    for Zaehler_x:=0 to sectors_per_line-1 do begin
      Pos_x:=Zaehler_x*Width_x+offset_links;
      Zeichen:=BlockFeld[Zaehler_BL];
      case Zeichen of
        'x' : Image_LW.Canvas.Brush.Color:=clBlack;
        's' : Image_LW.Canvas.Brush.Color:=clRed;
        'f' : Image_LW.Canvas.Brush.Color:=clWhite;
        'd' : Image_LW.Canvas.Brush.Color:=clBlue;
        'b' : Image_LW.Canvas.Brush.Color:=clGreen;
      else
        Image_LW.Canvas.Brush.Color:=clWhite;
      end;
      Image_LW.Canvas.Rectangle(Pos_x,Pos_y,Pos_x+Width_x,Pos_y+Width_y);
      inc(Zaehler_BL);
    end; { for Zaehler_x:=0 to 15 do }
  end; { for Zaehler_y:=0 to Anzahl_y-1 do }
end; { procedure Twcpm.Show_Free_BlockList }






destructor Twcpm.Destroy;
begin
  if Assigned(FIni) then begin
    FIni.WriteString('System', 'Dateiname', Dateiname);
    FIni.WriteString('System', 'CPM_DIR_IN', CPM_DIR_IN);
    FIni.WriteString('System', 'CPM_DIR_OUT', CPM_DIR_OUT);
    FIni.WriteInteger('System', 'Index_Emulation', Index_Emulation);
    FIni.UpdateFile;
    FIni.Free;
  end; { if Assigned(FIni) then }

  IMG_File.Free;
  inherited Destroy;
end; { destructor Twcpm.Destroy }




end.

