program VT100;

(*

Testprogramm fuer CP/M Console mit VT100 Emulation

Funktion: Ueber die BIOS-Funktion werden ESC-Sequenzen direkt an CONOUT gesendet

*)

(*$I TOOL01.INC *)

CONST
  CONOUT = 3;

var
  weiter : Char;
  ein_SByte : Str3;
  res : Byte;


BEGIN

  weiter:='j';


  ClrScr;
  WriteLN('VT100 Monitortest');
  WriteLN('01234567890123456789');
  WriteLN('12345678901234567890');
  WriteLN('23456789012345678901');
  WriteLn(' ');
  Write('Taste=');


  WHILE weiter<>CHR($1B) DO BEGIN


    Read(KBD,weiter);
    CASE weiter OF
      '0' : BEGIN
              ClrScr;
              WriteLN('VT100 Monitortest');
              WriteLN('01234567890123456789');
              WriteLN('12345678901234567890');
              WriteLN('23456789012345678901');
              WriteLn(' ');
              Write('Taste=');
            END;
      '1' : BEGIN
              (* Cursor setzen -> ESC [ y ; x H *)
              WRITE(CHR($1B)); WRITE('['); WRITE('2'); WRITE(';'); WRITE('8'); WRITE('H');
            END;
      '2' : BEGIN
              (* Cursor Startposition -> ESC [ 2 J *)
              WRITE(CHR($1B)); WRITE('['); WRITE('2'); WRITE('J');
            END;
      '3' : BEGIN
              (* Schirm lschen -> ESC [ f *)
              WRITE(CHR($1B)); WRITE('['); WRITE('f');
            END;
      '4' : BEGIN
              (* Invers ein -> ESC [ 7 m *)
              WRITE(CHR($1B)); WRITE('['); WRITE('7'); WRITE('m');
            END;
      '5' : BEGIN
              (* Invers aus -> ESC [ 0 m *)
              WRITE(CHR($1B)); WRITE('['); WRITE('0'); WRITE('m');
            END;
      '6' : BEGIN
              (* Lschen bis Zeilenende -> ESC [ K *)
              WRITE(CHR($1B)); WRITE('['); WRITE('K');
            END;
      '7' : BEGIN
              (* Zeile einfgen -> ESC [ 1 L *)
              WRITE(CHR($1B)); WRITE('['); WRITE('1'); WRITE('L');
            END;
      '8' : BEGIN
              (* Zeile lschen -> ESC [ 1 M *)
              WRITE(CHR($1B)); WRITE('['); WRITE('1'); WRITE('M');
            END;
    ELSE
      BIOS(CONOUT,ORD(weiter));
    END;

  END; (* WHILE weiter='j' DO *)
  
  ClrScr;

end.





