
; BIOS fuer EM80

		TITLE	EM80BIOS

		.Z80




; **********************************************************
;                   BIOS Sprungvektoren
; **********************************************************




             ; IM FOLGENDEN STEHEN DIE 17 VON CPM DEFINIERTEN
             ; SPRUNGVEKTOREN ZU DEN EINZELNEN EIN-/AUSGABE-
             ; FUNKTIONEN UND DISKETTEN-ROUTINEN

		JP	CBOOT		; (00) Kaltstartroutine
WBOOTE:		JP	WBOOT		; (01) Warmstartroutine
		JP	CONST		; (02) CONSOLE-Status abfragen
		JP	CONIN		; (03) CONSOLE-Eingabe
		JP	CONOUT		; (04) CONSOLE-Ausgabe
		JP	LIST		; (05) LIST-Ausgabe
		JP	PUNCH		; (06) PUNCH-Ausgabe
		JP	READER		; (07) READER-Eingabe
		JP	HOME		; (08) Spur Null einstellen
		JP	SELDSK		; (09) Laufwerk auswhlen
		JP	SETTRK		; (10) Spur auswhlen
		JP	SETSEC		; (11) Sektor auswhlen
		JP	SETDMA		; (12) Datenpufferadresse setzen
		JP	READ		; (13) Selektierten Sektor lesen
		JP	WRITE		; (14) Selektierten Sektor schreiben
		JP	LISTST		; (15) LIST-Status abfragen
		JP	SECTRAN		; (16) Umrechnen Sektornumme

		JP	Monitor		; Monitor



; **********************************************************
;                  Hardware Speicherzellen
; **********************************************************



MonFkt_B:	DB	0
Conn_B:		DB	0
Ergebnis_B:	DB	0
ErgPar1_B:	DB	0


DRV_VEC:

SECTOR:		DB	00H		; Sektor
TRACK:		DW	0002H		; Spur
DISKNO:		DB	00H		; Laufwerksnummer
DMAAD:		DW	80H		; DMA-Adresse


ANZ_LW		EQU	3		; Anzahl der Laufwerke (von 1 beginnend)



DMA_ARRAY:
		DS	128,0






; **********************************************************
;                   MONITOR Speicherzellen
; **********************************************************



ZK_START:
		DB	0CH		; Clear Screen
		DB	'CP/M 2.2 Copyright 1979 (c) by Digital Research',0DH,0AH
		DB	'BIOS-Monitor 2016 written by Ronald Daleske',0DH,0AH,0DH,0AH,0


ZK_CRLF:	
		DB	0DH,0AH,0



; **********************************************************
;                   BIOS Speicherzellen und Texte
; **********************************************************




temp:		DB	00H


DPH:

;Diskettenparameterkopf (DPH0)
; Laufwerk A: (CPM_LW_A)
;
DPH0:		DW	0		;Adresse der Konvertierungs-
					;tabelle (hier 0000H)
		DW	4		;Notizspeicher fuer das BDOS
					; (gesammt = 6 Byte)
		DW	4
		
		DW	80H
		
		;
		DW	DIRBUFF0	;Adresse eines 128 Byte grossen
					;Puffers fuer die Arbeit mit 
					;dem Inhaltsverzeichnis
		DW	DPB0		;Adresse des Diskettenpara-
					;meterblockes
		DW	0		;Adresse eines Notizspeichers
					;fuer die softwaremaessige 
					;Erkennung des Diskettenwechsels
		DW	ALV0		;Adresse eines Notizspeichers
					;fuer die Belegungsinformation



;Diskettenparameterkopf (DPH1)
; Laufwerk B: (CPM_LW_B)
;
DPH1:		DW	0		;Adresse der Konvertierungs-
					;tabelle (hier 0000H)
		DW	4		;Notizspeicher fuer das BDOS
					; (gesammt = 6 Byte)
		DW	4
		
		DW	80H
		
		;
		DW	DIRBUFF1	;Adresse eines 128 Byte grossen
					;Puffers fuer die Arbeit mit 
					;dem Inhaltsverzeichnis
		DW	DPB1		;Adresse des Diskettenpara-
					;meterblockes
		DW	0		;Adresse eines Notizspeichers
					;fuer die softwaremaessige 
					;Erkennung des Diskettenwechsels
		DW	ALV1		;Adresse eines Notizspeichers
					;fuer die Belegungsinformation




;Diskettenparameterkopf (DPH2)
; Laufwerk C: (serial)
;
DPH2:		DW	0		;Adresse der Konvertierungs-
					;tabelle (hier 0000H)
		DW	4		;Notizspeicher fuer das BDOS
					; (gesammt = 6 Byte)
		DW	4
		
		DW	80H
		
		;
		DW	DIRBUFF2	;Adresse eines 128 Byte grossen
					;Puffers fuer die Arbeit mit 
					;dem Inhaltsverzeichnis
		DW	DPB2		;Adresse des Diskettenpara-
					;meterblockes
		DW	0		;Adresse eines Notizspeichers
					;fuer die softwaremaessige 
					;Erkennung des Diskettenwechsels
		DW	ALV2		;Adresse eines Notizspeichers
					;fuer die Belegungsinformation






; Disketten Parameter Block (DPB0)
; ===============================
; 
;
; spt=64,bsh=4,blm=15,exm=0,dsm=1024-1,drm=512-1,al0=0ffh,al1=0,cks=0,off=0
;
DPB0:
; Number of 128-byte records per track
spt0:		DW	64		;Anzahl der Sektoren auf einer Spur 

; Block shift. 3 => 1k, 4 => 2k, 5 => 4k....
bsh0:		DB	4		;Blockverschiebungsfaktor
					;= LOG2(Blockgroesse/128)
					; LOG2 = Logarithmus zur Basis 2
					; LOG2(2048/128) = 4

; Block mask. 7 => 1k, 0Fh => 2k, 1Fh => 4k...
blm0:		DB	15		;Blockmaske = Anzahl der Sekto-
					;ren pro Block - 1
					;BLM = (2^BSH)-1
; Extent mask, see later
exm0:		DB	0		;Extentmaske

; (no. of blocks on the disc)-1
dsm0:		DW	2048-1		;Anzahl der Bloecke pro Diskette minus 1
					;(einschliesslich des Verzeich-
	 				; nisses aber ohne Systemspuren)
; (no. of directory entries)-1
drm0:		DW	512-1		;max. Anzahl der Eintraege im 
					;Inhaltsverzeichnis - 1 = 256 - 1
; Directory allocation bitmap, first byte
al00:		DB	0ffh		;reservierten Eintraege fuer das
					;Inhaltsverzeichnis = 4 Blocke
; Directory allocation bitmap, first byte
AL10:		DB	00000000B	

; Checksum vector size, 0 or 8000h for a fixed disc.
;No. directory entries/4, rounded up.
cks0:		DW	0		;Laenge des Diskettenpuffervektors
					;tors = (DRM+1)/4 = (255+1)/4 = 64

; Offset, number of reserved tracks
off0:		DW	0		;Anzahl der reservierten Spuren
					;am Anfang der Diskette = 0

		DS	8,0



; Disketten Parameter Block (DPB1)
; ===============================
; 
;
; spt=64,bsh=4,blm=15,exm=0,dsm=1024-1,drm=512-1,al0=0ffh,al1=0,cks=0,off=0
;
DPB1:
; Number of 128-byte records per track
spt1:		DW	64		;Anzahl der Sektoren auf einer Spur 

; Block shift. 3 => 1k, 4 => 2k, 5 => 4k....
bsh1:		DB	4		;Blockverschiebungsfaktor
					;= LOG2(Blockgroesse/128)
					; LOG2 = Logarithmus zur Basis 2
					; LOG2(2048/128) = 4

; Block mask. 7 => 1k, 0Fh => 2k, 1Fh => 4k...
blm1:		DB	15		;Blockmaske = Anzahl der Sekto-
					;ren pro Block - 1
					;BLM = (2^BSH)-1
; Extent mask, see later
exm1:		DB	0		;Extentmaske

; (no. of blocks on the disc)-1
dsm1:		DW	2048-1		;Anzahl der Bloecke pro Diskette minus 1
					;(einschliesslich des Verzeich-
	 				; nisses aber ohne Systemspuren)
; (no. of directory entries)-1
drm1:		DW	512-1		;max. Anzahl der Eintraege im 
					;Inhaltsverzeichnis - 1 = 256 - 1
; Directory allocation bitmap, first byte
al01:		DB	0ffh		;reservierten Eintraege fuer das
					;Inhaltsverzeichnis 
					; 512 * 32 = 16384 -> 16384 / 2048 = 8
; Directory allocation bitmap, first byte
AL11:		DB	00000000B	

; Checksum vector size, 0 or 8000h for a fixed disc.
;No. directory entries/4, rounded up.
cks1:		DW	0		;Laenge des Diskettenpuffervektors
					;tors = (DRM+1)/4 = 512/4 = 128

; Offset, number of reserved tracks
off1:		DW	0		;Anzahl der reservierten Spuren
					;am Anfang der Diskette = 0

		DS	8,0







; Disketten Parameter Block (DPB2)
; ===============================
; 
;
; spt=64,bsh=4,blm=15,exm=0,dsm=1024-1,drm=512-1,al0=0ffh,al1=0,cks=0,off=0
;
DPB2:
; Number of 128-byte records per track
spt2:		DW	64		;Anzahl der Sektoren auf einer Spur 

; Block shift. 3 => 1k, 4 => 2k, 5 => 4k....
bsh2:		DB	4		;Blockverschiebungsfaktor
					;= LOG2(Blockgroesse/128)
					; LOG2 = Logarithmus zur Basis 2
					; LOG2(2048/128) = 4

; Block mask. 7 => 1k, 0Fh => 2k, 1Fh => 4k...
blm2:		DB	15		;Blockmaske = Anzahl der Sekto-
					;ren pro Block - 1
					;BLM = (2^BSH)-1
; Extent mask, see later
exm2:		DB	0		;Extentmaske

; (no. of blocks on the disc)-1
dsm2:		DW	2048-1		;Anzahl der Bloecke pro Diskette minus 1
					;(einschliesslich des Verzeich-
	 				; nisses aber ohne Systemspuren)
; (no. of directory entries)-1
drm2:		DW	512-1		;max. Anzahl der Eintraege im 
					;Inhaltsverzeichnis - 1 = 256 - 1
; Directory allocation bitmap, first byte
al02:		DB	0ffh		;reservierten Eintraege fuer das
					;Inhaltsverzeichnis 
					; 512 * 32 = 16384 -> 16384 / 2048 = 8
; Directory allocation bitmap, first byte
AL12:		DB	00000000B	

; Checksum vector size, 0 or 8000h for a fixed disc.
;No. directory entries/4, rounded up.
cks2:		DW	0		;Laenge des Diskettenpuffervektors
					;tors = (DRM+1)/4 = 512/4 = 128

; Offset, number of reserved tracks
off2:		DW	0		;Anzahl der reservierten Spuren
					;am Anfang der Diskette = 0

		DS	8,0








;BDOS - Notizspeicher
DIRBUFF0:	DS	130,0		;IHV - Puffer
ALV0:		DS	260,0		;Belegungsvektor dsm/8
		;

DIRBUFF1:	DS	130,0		;IHV - Puffer
ALV1:		DS	260,0		;Belegungsvektor dsm/8 = 2048 / 8 = 256 
		;

DIRBUFF2:	DS	130,0		;IHV - Puffer
ALV2:		DS	260,0		;Belegungsvektor dsm/8 = 2048 / 8 = 256 
		;

		DS	32,0		; Ersatz




; **********************************************************
;                   BIOS Routinen
; **********************************************************






; *** CBOOT ***
; BIOS-Funktion (00) : Kaltstartroutine
; CBOOT, Cold BOOT : Kaltstart ausfhren
;
; Der Kaltstart wird nur nach dem erstmaligen Laden des Betriebsystems
; bentigt.
; Der Aufruf an den Kaltstart erfolgt meist von einem speziellen
; Ladeprogramm, das nach dem Einschalten des Rechners, das
; BIOS von der Systemdiskette geladen hat.
; Aufgabe des Kaltstart ist es, die einzelnen Systemkomponenten
; zu initialisieren und eine Meldung ber den erfolgten Systemstart
; auf der Console auszugeben.
; Falls der CCP und das BDOS bereits im Speicher stehen, kann
; nach dem Kaltstart sofort der CCP aktiviert werden. In diesem
; Fall mssen aber die beiden Sprungbefehle an den Adressen
; BOOT (nach BIOS+0003h) und BOOT+0005h (nach FBASE+OOO6h)
; eingesetzt sein. Normalerweise wird nach einem Kaltstart ein
; Warmstart ausgefhrt, der den CCP und das BDOS von der Diskette
; ldt und die Sprungbefehle einsetzt. Dann braucht nur
; die zuerst anzuwhlende Disk- und Usernummer in die Speicheradresse
; BOOT+0004h eingetragen zu werden.
;
; Aufruf: CBOOT
;
; Uebergabeparameter: keine
; Rueckgabeparameter: Sprung zum CCP oder bergang in die Warmstart-Funktion
;

CBOOT:		

		;
		LD	SP,STACK	;STACKPOINTER SETZEN
		;


		LD	HL,ZK_START	; Anzeige des Kaltstarttextes
		CALL	AUS_ZK
		;


		XOR	A         	;AKKU loeschen
		LD	(IOBYTE),A	;I/O-BYTE loeschen
		LD	(USERLW),A 	;LAUFWERK 0
		;




; (01) Warmstartroutine
WBOOT:
		;
		LD	SP,STACK	;STACKPOINTER SETZEN
		;
		;
		; BDOS von BDOS_ARR laden
		;
		LD	A,0E2H
		OUT	(PIO_OUT_LOAD_BDOS),A

		;
		; CCP von CCP_ARR laden
		;
		LD	A,0DAH
		OUT	(PIO_OUT_LOAD_CCP),A
		;



		;Parameter setzen und Sprung zum SCCP
		;
GOCPM:		LD	A,0C3H		;JP-OPCODE
		LD	(0),A		;fuer JP BWBOOT
		LD	HL,WBOOTE	;WBOOT-Eintrittspunkt
		LD	(1),HL		;Adressfeld setzen
		;
		LD	(5),A		;fuer JP BDOS
		LD	HL,SBDOS	;SBDOS-Eintrittspunkt
		LD	(6),HL		;Adressfeld setzen
		;
		LD	BC,80H		;Standard-DMA-Adresse
		CALL	SETDMA		;setzen
		;
		LD	A,(USERLW)	;momentanes Laufwerk
		LD	C,A		;in C uebergeben
		;
		JP	SCCPCLR		;Sprung zum SCCP





; *** CONST ***
; BIOS-Funktion (02) : CONSOLE-Status abfragen
; CONST: Status der Eingabeschnittstelle. Wurde ein Zeichen eingegeben,
; so wird im Register A der Wert OFFH bergeben, sonst 0. 
; Das Zeichen wird aber noch nicht eingelesen.
; Diese BIOS-Funktion wird vom BDOS bei jeder Zeichenausgabe
; zur Erkennung der Steuerzeichen CTRL-S und CTRL-C aufgerufen.
; Aufruf: CONST
; Uebergabeparameter: keine
; Rueckgabeparameter: Register A = 000H -> kein Zeichen
;                     Register A = 0FFH -> Zeichen vorhanden
;
CONST:
		IN	A,(PIO_IN_CONST)

		; ist ein Eingabewert vorhanden, so ist 
		; Register A groesser 0
		CP	0
		JR	Z,CONST_A

		LD	A,0FFH

CONST_A:
		; Ruecksprung
		;
		RET



; *** CONIN ***
; BIOS-Funktion (03) : CONSOLE-Eingabe
; CONIN: A = Zeichen von der Console
; Diese Routine holt ein Zeichen von der Console (Tastatur) und
; gibt es im A-Register zurck. Falls kein Zeichen von der
; Console ansteht, mu auf ein Zeichen gewartet werden.
; Aufruf: CONIN
; Uebergabeparameter: keine
; Rueckgabeparameter: Register A = Zeichen von der Console
;    
CONIN:
		IN	A,(PIO_IN_CONIN)

		;
		CP	0
		JR	Z,CONIN
		;
		RET 



; *** CONOUT ***
; BIOS-Funktion (04) : CONSOLE-Ausgabe
; CONOUT (CONsole OUTput) : Zeichen zur Console ausgeben, 
; Der im Register C befindliche Wert wird zur Console (Bildschirm) ausgegeben.
; Aufruf: CONOUT
; Uebergabeparameter: Register C = Zeichen im ASCII-Code
; Rueckgabeparameter: keine
;  
CONOUT:
		LD	A,C
		OUT	(PIO_OUT_CONOUT),A

		;
		RET 






; *** LIST ***
; BIOS-Funktion (05) : LIST-Ausgabe
; LIST (LIST output) : Zeichen zum 'List '-Kanal (Drucker) ausgeben 
; Wie Consolenausgabe, aber zum ' List ' -Kanal.
;
; Aufruf: LIST
; Uebergabeparameter: Register C = Zeichen im ASCII-Code
; Rueckgabeparameter: keine
;   
LIST:
		LD	A,C
		OUT	(PIO_OUT_LIST),A

		;
		RET 




; *** PUNCH ***
; BIOS-Funktion (06) : PUNCH-Ausgabe
; PUNCH output : Zeichen zum ' Punch ' -Kanal ausgeben 
; Wie Consolenausgabe, aber zum ' Punch ' -Kanal
;
; Aufruf: PUNCH
; Uebergabeparameter: Register C = Zeichen im ASCII-Code
; Rueckgabeparameter: keine
;   
; *** derzeit noch nicht implementiert ***
PUNCH:
		RET





; *** READER ***
; BIOS-Funktion (07) : READER-Eingabe
; READER (READER input) : Zeichen vom ' Reader ' -Kanal holen 
; Wie Consoleneingabe , aber vom 'Reader ' -Kanal
;
; Aufruf: READER
; Uebergabeparameter: keine
; Rueckgabeparameter: Register A = Zeichen von der Console
;   
; *** derzeit noch nicht implementiert ***
READER:
		RET





; *** HOME ***
; BIOS-Funktion (08) : Spur Null einstellen
;
; Diese Funktion war bei lteren Laufwerken zur exakten
; Positionierung des Schreib/Lesekopfes gedacht.
; Da das BDOS vor jedem Diskzugriff die Spurnummer ber SETTRK
; anwhlt, ist HOHE bei neueren Laufwerken berflssig.
;
; Aufruf: HOME
; Uebergabeparameter: keine
; Rueckgabeparameter: keine
;   
HOME:
		LD	C,0
		CALL	SETTRK
		RET




; *** SELDSK ***
; BIOS-Funktion (09)   : Laufwerk auswhlen
; SELDSK (SELect DISK) : Das BIOS mu die im C-Register bergebene 
; Laufwerksnummer berprfen und, falls ein Laufwerk mit dieser Nummer 
; existiert, in HL die Adresse des zugehrigen DPH zurckgeben,
; Im CP/n ist nicht garantiert, da nach einem SELDSK-Aufruf
; auch tatschlich auf dieses Laufwerk zugegriffen wird.
; Vielmehr hat der SELDSK-Aufruf nur eine 'Anmeldefunktion',
; damit sich das BDOS auf das Laufwerk einstellen kann.
; Das BIOS mu die Laufwerksnummer aber intern speichern, da
; sich nachfolgende Diskzugriffe immer auf das zuletzt selektierte
; Laufwerk beziehen.
;
; Aufruf: SELDSK
;
; Uebergabeparameter: C   = Laufwerksnummer
;                         =  0 fr Laufwerk A:
;                           ...
;                         = 15 fr Laufwerk P:
;
;                     E,0 = Login-Bit
;                         = 0, falls das Laufwerk zum ersten Mal
;                           angewhlt wird
;                         = 1, falls das Laufwerk seit dem letzten
;                           Warmstart schonmal angewhlt wurde
;
; Rueckgabeparameter: HL -> DPH des Laufwerks
;                     HL = 0, falls das Laufwerk nicht existiert
;  
SELDSK:
		LD	HL,0		; Code bei Fehler
		LD	A,C
		CP	ANZ_LW		; Abfrage der maximalen Laufwerksnummer
		RET	NC		; RET wenn Laufwerk nicht vorhanden
		; Laufwerksnummer im erlaubten Bereich
		LD	(DISKNO),A
		; Parameterkopf-Adresse berechnen
		LD	L,A
		LD	H,0		; HL=Laufwerksnummer
		ADD	HL,HL		; *2
		ADD	HL,HL		; *4
		ADD	HL,HL		; *8
		ADD	HL,HL		; *16 (Kopf - Laenge)
		LD 	DE,DPH
		ADD	HL,DE		; HL = DPBASE (DISKNO*16)
		;
		RET





; *** SETTRK ***
; BIOS-Funktion (10) : Spurnummer auswhlen
; SETTRK (SET TRacK) : Der nchste Diskzugriff bezieht sich auf die im 
; Registerpaar BC bergebene Spur. Die so gesetzte Spurnummer, errechnet
; sich immer aus der BDOS-internen (logischen) Spurnummer plus dem OFF-Wert im DPB. 
; Wie auch beim SELDSK-Aufruf ist ein tatschlicher Diskzugriff nicht garantiert.
;
; Aufruf: SETTRK
;
; Uebergabeparameter: Register BC = Spurnummer
; Rueckgabeparameter: keine
;  
SETTRK:
		LD	(TRACK),BC
		;
		RET




; *** SETSEC ***
; BIOS-Funktion (11)  : Sektor auswhlen
; SETSEC (SET SECtor) : Logische Sektornummer setzen 
;
; Der nchste Diskzugriff bezieht sich auf den im Registerpaar
; BC bergebenen Sektor. Die so gesetzte Sektornummer ist immer
; das Ergebnis der SECTRAN-Funktion (s.u.). Auch hier ist ein
; tatschlicher Diskzugriff auf diesen Sektor nicht garantiert.
;
; Aufruf: SETSEC
;
; Uebergabeparameter: Register BC = Logische Sektornummer - Hier wird nur das niederwertige
;                                                           Byte (Reg.C) abgespeichert 
; Rueckgabeparameter: keine
;  
SETSEC:
		LD	A,C
		LD	(SECTOR),A
		;
		RET






; *** SETDMA ***
; BIOS-Funktion (12) : Datenpufferadresse setzen
;
; SETDMA (SET DMA-addresse) : Alle nachfolgenden Diskzugriffe
; mssen die DMA-Adresse als Quell- (bei Schreibzugriffen)
; bzw. Zieladresse (bei Lesezugriffen) benutzen.
; Die DMA-Adresse zeigt immer auf einen 128-Byte groen Buffer,
; weshalb Diskzugriffe immer in Recordgre erfolgen.
;
; Aufruf: SETDMA
;
; Uebergabeparameter: Register BC = DMA-Adresse
; Rueckgabeparameter: keine
;  
SETDMA:     
	LD	(DMAAD),BC
	;
	RET




; *** READ ***
; BIOS-Funktion (13) : Selektierten Sektor lesen
; READ, READ sector  : Logischen Sektor lesen
;
; Die READ-Funktion liest einen (logischen) Sektor von der Diskette 
; in den DMA-Buffer. Die Disknummer, Spurnummer und Sektornummer sind
; jeweils durch die letzten SELDSK-, SETTRKund SETSEC-Aufrufe festgelegt.
; Bei physikalischen Sektorlngen vom mehr als 128 Bytes, mu das BIOS einen 
; Sektorbuffer entsprechender Groe selbst bereitstellen und aus diesem Buffer, 
; 128 Bytes zum zuletzt definierten DMA-Buffer kopieren.
; Falls ein Lesefehler auftritt, sollte das BIOS den Diskzugriff
; ein paar Mal wiederholen und, falls der Fehler bestehen
; bleibt, den Fehlercode 1 im A-Register zurckgeben.
;
; Aufruf: READ
;
; Uebergabeparameter: keine
; Rueckgabeparameter: Register A = Fehlercode
;                                = 0, kein Fehler
;                                = 1, sonst
;  
READ:	
		LD	HL,DRV_VEC

		LD	A,L
		OUT	(PIO_OUT_RW_VECTOR_LO),A

		LD	A,H
		OUT	(PIO_OUT_READ_VECTOR_HI),A
		;
		XOR	A		; kein Fehler
		;
		RET




; *** WRITE ***
; BIOS-Funktion (14)  : Selektierten Sektor schreiben
; WRITE (WRITE sector): Logischen Sektor schreiben
;
; Die WRITE-Funktion schreibt einen (logischen) Sektor vom DMABuffer
; auf die Diskette. Die Disknummer, Spurnummer und Sektornummer
; sind jeweils durch die letzten SELDSK-, SETTRK- und SETSEC-Aufrufe festgelegt.
; Bei physikalischen Sektorlngen von mehr als 128 Bytes, kann das Record-Flag
; zur Realisierung eines 'Blocking'-Algorithmus verwendet werden. 
; Bei einem normalen Schreibzugriff reicht es, den logischen Sektor nur in 
; den BIOS-internen Sektorbuffer zu bernehmen.
; Dies hat den Vorteil, da nachfolgende Schreibzugriffe auf den selben
; physikalischen Sektor, keinen Diskettenzugriff verlangen.
; Erst wenn der neue logische Sektor in einem anderen physikalsichen Sektor
; liegt, mu der Sektorbuffer auf die Diskette geschrieben werden.
; Directory-Schreibzugriffe sollten immer direkt auf die
; Diskette geleitet werden.
;
; Aufruf: WRITE
;
; Uebergabeparameter: Register C = Record-Flag
;                                = 0, bei einem normalen Schreibzugriff
;                                = 1, falls der logische Sektor ein Directory-Record ist 
;                                = 2, falls der logische Sektor der erste Sektor eines neuen Blocks ist
;
; Rueckgabeparameter: Register A = Fehlercode
;                                = 0, kein Fehler
;                                = 1, sonst
;  
WRITE:		
		LD	C,0

		LD	HL,DRV_VEC

		LD	A,L
		OUT	(PIO_OUT_RW_VECTOR_LO),A

		LD	A,H
		OUT	(PIO_OUT_WRITE_VECTOR_HI),A
		;
		XOR	A		; kein Fehler
		;
		RET



; *** LISTST ***
; BIOS-Funktion (15) : LIST-Status abfragen
;
; LISTST (LIST output STatus) : Status der Druckerausgabe testen 
;
; LISTST wird vom BDOS nicht bentigt, sondern dient dem CP/M
; Hilfsprogramm 'DESPOOL1 den Status der Druckerausgabe zu
; bestimmen.
;
; Aufruf: LISTST
;
; Uebergabeparameter: keine
; Rueckgabeparameter: A = Druckerstatus
;                       = OOH, Drucker nicht bereit
;                       = FFH, Drucker frei
;  
LISTST:
		;
		LD	A,0FFH		; Drucker bereit
		;
		RET




; *** SECTRAN ***
; BIOS-Funktion (16) : Umrechnen Sektornummer
;
; SECTRAN (SECtor TRANslation) : Sektornummer aus der Sektor-Verschrnkungs-
;                                Tabelle holen 
;
; Das BDOS benutzt diese Funktion, um aus der im DPH angegebenen
; Sektor-Verschrnkungs-Tabelle die Sektornummer zu entnehmen.
; Im allgemeinen gengt es, einfach die im Registerpaar BC
; bergebene Sektornummer ins Registerpaar HL zu kopieren.
;
; Aufruf: LISTST
;
; Uebergabeparameter: Register BC = Logische Sektornummer
;                     Register DE -> Sektor-Verschrnkungs-Tabelle
;
; Rueckgabeparameter: Register HL = (Logische) Sektornummer aus der Tabelle
;  
SECTRAN:
		LD	H,B		; Laden von HL mit BC
		LD	L,C
		;
		RET




; **********************************************************








