

; **********************************************************
;  Monitor
; **********************************************************




; Procedur: Monitor
;
; Aufruf: WR_IMG_SEK
; Uebergabeparameter: keine
; Rueckgabeparameter: keine
;  

Monitor:
		;
		; Laden MonitorFunktion
		LD	A,(MonFkt_B)


		; 01 = Abrage des Fehlercodes
		;
		CP	1
		JR	NZ,Monitor_2
		;
;		CALL	INT_RD_ERROR
		LD	A,H
		LD	(Ergebnis_B),A
		LD	A,L
		LD	(ErgPar1_B),A
		;
		JR	Monitor_X
		;
Monitor_2:
		; 02 = RAM in FLASH Brennen (RAMFLOPPY)
		;
		CP	2
		JR	NZ,Monitor_3
		;
;		CALL	INT_RD_SA_RFL
		;
		JR	Monitor_X
		;
Monitor_3:
		; 03 = SECTOR lesen in DMA
		;
		CP	3
		JR	NZ,Monitor_4
		;
;		CALL	RD_IMG_SEK
		;
		JR	Monitor_X
		;

Monitor_4:
		; 04 = SECTOR schreiben aus DMA
		;
		CP	4
		JR	NZ,Monitor_6
		;
;		CALL	WR_IMG_SEK
		;
		JR	Monitor_X
		;
Monitor_6:
		; 06 = Lese SECNT
		;
		CP	6
		JR	NZ,Monitor_7
		;
;		CALL	INT_RE_SECNT
		;
		LD	(Ergebnis_B),A
		;
		JR	Monitor_X
		;

Monitor_7:

		; 06 = 07 = Schreibe SECNT
		;
		CP	7
		JR	NZ,Monitor_8
		;
		LD	A,(Ergebnis_B)
		LD	B,A
		;
;		CALL	INT_SE_SECNT
		;
		JR	Monitor_X
		;

Monitor_8:

Monitor_X:
		;
		RET








; Funktion: WordToCONOUT
;
; Aufruf: WordToCONOUT
; Uebergabeparameter: Register HL - Wordwert
; Rueckgabeparameter: keine
; 
WordToCONOUT:
		CALL	WordToHex		
		;
		PUSH	DE
		PUSH	BC
		;
		LD	C,B
		CALL	CONOUT
		;
		POP	BC
		;
		CALL	CONOUT
		;
		POP	DE
		PUSH	DE
		;
		LD	C,D
		CALL	CONOUT
		;
		POP	DE
		;
		LD	C,E
		CALL	CONOUT
		;
		LD	C,'H'
		CALL	CONOUT
		;
		RET





; Funktion: ByteToCONOUT
;
; Aufruf: ByteToCONOUT
; Uebergabeparameter: Register A = Bytewert
; Rueckgabeparameter: keine
; 
ByteToCONOUT:
		CALL	ByteToHex
		PUSH	BC
		;
		LD	C,B
		CALL	CONOUT
		;
		POP	BC
		CALL	CONOUT
		;
		LD	C,'H'
		CALL	CONOUT
		;
		RET
		



; Funktion: WordToHex
;
; Aufruf: WordToHex
; Uebergabeparameter: Register HL = Wordwert
; Rueckgabeparameter: Register BC und DE - ASCII-Zeichen des Wordwertes
; 
WordToHex:
		LD	A,H
		PUSH	HL
		;
		CALL	ByteToHex
		;
		POP	HL
		PUSH	BC
		;
		LD	A,L
		;
		CALL	ByteToHex
		;
		LD	D,B
		LD	E,C
		POP	BC
		;
		RET







; Funktion: ByteToHex
;
; Aufruf: ByteToHex
; Uebergabeparameter: Register A = Bytewert
; Rueckgabeparameter: Register BC - B = HWT, C = LWT
; 
ByteToHex:
		PUSH	AF
		AND	00FH
		;
		CALL	ByteToHex_A
		LD	C,A
		;
		POP	AF
		SRL	A
		SRL	A
		SRL	A
		SRL	A
		;
		CALL	ByteToHex_A
		LD	B,A
		;
		RET


ByteToHex_A:	ADD	A,'0'		; Zahl '0'
		CP	'9'+1		; '9'+1 -> 0..9 = Cyrry , A..F = not Curry
		RET	C
		;
		ADD	A,07		; 65D ('A') - 48D ('0') = 17D -> Differenz zw. '0' und 'A'
		;
		RET






; Funktion: Ausgabe einer Zeichenkette auf den Bildschirm
;
; Aufruf: AUS_ZK
; Uebergabeparameter: Register HL = Adresse der Zeichenkette 
;                     Ende = 00H
; Rueckgabeparameter: keine
; 
AUS_ZK:		LD	A,(HL)
		OR	A
		RET	Z		;RET wenn Zeichen = 0 ist
		LD	C,A
		PUSH	HL
		CALL	CONOUT		;Ausgabe des Zeichens in Reg.C
		POP	HL
		INC	HL
		;
		JR	AUS_ZK




; Funktion: Ausgabe von CR+LF an den Bildschirm
;
; Aufruf: AUS_CRLF
; Uebergabeparameter: keine
; Rueckgabeparameter: keine
; 
AUS_CRLF:	
		LD	C,0DH
		CALL	CONOUT		;Ausgabe des Zeichens in Reg.C
		;
		LD	C,0AH
		CALL	CONOUT		;Ausgabe des Zeichens in Reg.C
		;
		RET

















