unit CPM_Screen;
{
Copyright (C) 2017 - Ronald Daleske

Licence
=======

 LGPLv2.1 with static linking exception (See COPYING.modifiedLGPL.txt)


 other developer:
 2017 Olev Toom, test and help to make the procedure SCROLL_UP faster


 COLOR_NONE      = $00000000;
 COLOR_BLACK     = $FF000000;
 COLOR_RED       = $FFFF0000;
 COLOR_ORANGE    = $FFFF8500;
 COLOR_LEAFGREEN = $FF009900;
 COLOR_GREEN     = $FF00FF00;
 COLOR_YELLOW    = $FFFFFF00;
 COLOR_DARKGREEN = $FF254117;
 COLOR_DARKGRAY  = $FF595959;
 COLOR_BROWN     = $FF6F4E37;
 COLOR_INDIGO    = $FF2E0854;
 COLOR_RASPBERRY = $FFE30B5C;
 COLOR_GRAY      = $FF808080;
 COLOR_PURPLE    = $FF4B0082;
 COLOR_PINK      = $FFFF0090;
 COLOR_DARKBLUE  = $FF0000A0;
 COLOR_SILVER    = $FFC0C0C0;
 COLOR_BLUEIVY   = $FF3090C7;
 COLOR_MIDGRAY   = $FFE0E0E0;
 COLOR_LIGHTGRAY = $FFF7F7F7;
 COLOR_BLUE      = $FF0000FF;
 COLOR_MAGENTA   = $FFFF00FF;
 COLOR_CYAN      = $FF00FFFF;
 COLOR_WHITE     = $FFFFFFFF;


}

{$mode delphi} {Default to Delphi compatible syntax}
{$H+}          {Default to AnsiString}
{$inline on}   {Allow use of Inline procedures}



interface


// the Standard mode is a lage Screen-Char-Matrix
// the fast-graphic-mode make some commands faster with
// the help of graphical operations
{$DEFINE fast_graphic_mode}




// the Standard Screen on CP/M was 80x24 Character
// is this not defined, is the maximum resolution for this monitor used
//{$DEFINE cpm_standard_screen_80x24}




// use_invert_display_attributes -> only for WordStar 3 usefull
{$DEFINE use_invert_display_attributes}





uses
  GlobalTypes,
  GlobalConfig,
  GlobalConst,
  Platform,
  Threads,
  SysUtils,
  Classes,

  GraphicsConsole,
  Console,
  Framebuffer,

{$IFDEF cpm_standard_screen_80x24}
  Font,
  // Bitstream_Vera_Sans_Mono_14,
  DejaVu_Sans_Mono_17,
{$ENDIF}

  wincpm,
  RGraphics;






{==============================================================================}

const

  Matrix_Col_Max = 100;
  Matrix_Row_Max = 100;

  // Graphical Const

  System_Bar_Height = 80;

  Margin_Left = 20;
  Margin_Top  = 0;
  Margin_Right = 20;
  Margin_Button = 40;


  System_Font_Width = 8;
  System_Font_Height = 16;

  DejaVu_Font_Width = 14;
  DejaVu_Font_Height = 26;


  Dummy_Char = ' ';
  Dummy_FG_COLOR = COLOR_BLACK;
  Dummy_BG_COLOR = COLOR_WHITE;


{$I CPM_on_RaspberryPi_512.inc}

{$I DRIVE_A.inc}
{$I DRIVE_B.inc}
{$I DRIVE_C.inc}

{$I LED_OFF_32.inc}
{$I LED_RED_32.inc}
{$I LED_GREEN_32.inc}

{$I Button_Screenshot.inc}


{==============================================================================}
type

  // Frame-Buffer-Matrix (Bildwiederholspeicher)
  T_FBM_Character = record
                    Character : Char;
                    F_COLOR, B_COLOR : LongWord;
                  end;

  T_FB_Matrix = Array [1..Matrix_Col_Max,1..Matrix_Row_Max] of T_FBM_Character;


  TTermMode = (Normal_TM, IBM_ESC_TM, IBM_CSI_TM, IBM_CSI_TM_Par, IBM_CSI_TM_Par_Zeile,
               PC1715_ESC_TM, PC1715_TM_Zeile, DCA_TM, DCA_TM_Zeile,
               ADM31_ESC_TM, ADM31_ESC_TM_R, ADM31_ESC_TM_C, ADM31_ESC_ESC,
               ADM31_ESC_ESC_ESC, ADM31_ESC_TM_G);

  TEmuMode = (Emu_VT100, EMU_ADM31, Emu_PC1715);



{==============================================================================}
type
  {Matrix-Screen specific clases}
  TConOut = class(TObject)
    public
      {Public Properties}
      Cursor_is_on : Boolean;

      {Public Methods}
      constructor Create;
      destructor Destroy;

      procedure Write_Char(B_Char : Byte);
      procedure DRIVE_NR_WRITE_LOCK(DRIVE_NR : Byte);
      procedure DRIVE_NR_READ_LOCK(DRIVE_NR : Byte);
      procedure Button_Screenshot_on;
      procedure Button_Screenshot_off;
      procedure Button_Show_Drive_A;
      procedure Button_Show_Drive_B;

      procedure Timer_Event;
     {}

   private
     {Internal Variables}

     FB_Matrix : T_FB_Matrix;
     CUR_X, CUR_Y : LongWord;
     TermMode : TTermMode;
     EmuMode : TEmuMode;
     CSI_Parameter1, CSI_Parameter2, ESC_Zeile : LongWord;
     FG_COLOR, BG_COLOR : LongWord;

     BM_LED_OFF, BM_LED_RED, BM_LED_GREEN : TBitmap;

     Monitor_Width, Monitor_Height,
     User_Screen_Width, User_Screen_Height,

     Cursor_Counter : LongWord;

     DRIVE_BMP_Counter : Word;

     DRIVE_A_SHOW_BMP, DRIVE_B_SHOW_BMP : Boolean;
     DRIVE_A_ON, DRIVE_B_ON, DRIVE_C_ON : Boolean;
     DRIVE_NR_READ, DRIVE_NR_WRITE : Byte;

     D_Bitmap : TBitmap;

     Screen_Font_Width, Screen_Font_Height,
     System_Bar_Line_Height,
     Matrix_Col_Count, Matrix_Row_Count : LongWord;


     {Internal Methods}
     procedure DrawINC_to_Framebuffer(POS_X, POS_Y : LongWord;
                                      var Load_Array : Array of Byte);
     procedure Show_Line(Line_Nr : LongWord);
     procedure Show_Matrix;
     procedure Clear_Screen;
     procedure GUI_ConsoleDrawText_Ex(Text:String;X,Y,Forecolor,Backcolor:LongWord);
     procedure switch_Cursor_on;
     procedure switch_Cursor_off;
     procedure Monitor_OFF(DRIVE_NR : Byte);
     procedure Monitor_READ(DRIVE_NR : Byte);
     procedure Monitor_WRITE(DRIVE_NR : Byte);

   protected
     {Internal Variables}
     {Internal Methods}

   end; { TConOut = class(TObject) }




var
  CPM_CONOUT : TConOut;
  GraphicHandle : TWindowHandle;
  PAR_TAB2 : array[0..15000] of Byte;

  Timer_Event_Counter : DWord;
  Thread1Handle : TThreadHandle;



implementation



uses
  modul_pio;



{==============================================================================}
{==============================================================================}
{TConOut}


function Thread1Execute(Parameter:Pointer):PtrInt;
begin
 Thread1Execute:=0;

 {We'll also set the thread name to something meaningful so we can use it in our output}
 ThreadSetName(GetCurrentThreadId,'Example Thread1');

 while True do begin

   INC(Timer_Event_Counter);

    Sleep(10);

  end; {  while True do }

end; { function Thread1Execute }






{==============================================================================}
{==============================================================================}
{TConOut}
constructor TConOut.Create;
var
  bar_line : String;
begin
  {}
  inherited Create;


  // Initializing

  FG_COLOR := Dummy_FG_COLOR;
  BG_COLOR := Dummy_BG_COLOR;

  FramebufferGetPhysical(Monitor_Width, Monitor_Height);

{$IFDEF cpm_standard_screen_80x24}
  Screen_Font_Width:=DejaVu_Font_Width;
  Screen_Font_Height:=DejaVu_Font_Height;
  Matrix_Col_Count:=80;
  Matrix_Row_Count:=24;
{$ELSE}
  Screen_Font_Width:=System_Font_Width;
  Screen_Font_Height:=System_Font_Height;

  Matrix_Col_Count:=(((Monitor_Width-Margin_Left-Margin_Right)) div Screen_Font_Width)-1;
  if Matrix_Col_Count>100 then
    Matrix_Col_Count:=100;

  Matrix_Row_Count:=(((Monitor_Height-System_Bar_Height-Margin_Top-Margin_Button))
                      div Screen_Font_Height)-1;
  if Matrix_Row_Count>100 then
    Matrix_Row_Count:=100;

{$ENDIF}


  D_Bitmap := TBitmap.Create;

  DRIVE_A_SHOW_BMP:=false;
  DRIVE_B_SHOW_BMP:=false;
  DRIVE_BMP_Counter:=0;



  System_Bar_Line_Height:=System_Bar_Height+Screen_Font_Height;
  User_Screen_Width:=Margin_Left+(Screen_Font_Width*Matrix_Col_Count)+Margin_Right;
  User_Screen_Height:=System_Bar_Height+Margin_Top+
                      (Screen_Font_Height*Matrix_Row_Count)+Margin_Button;





  // *** Draw Header ***

  DrawINC_to_Framebuffer(3,3,DRIVE_A);

  DrawINC_to_Framebuffer(3+120,3,DRIVE_B);

  if drive_c_is_used then
    DrawINC_to_Framebuffer(3+120+120,3,DRIVE_C);


  DrawINC_to_Framebuffer(390,6,CPM_on_RaspberryPi_512);



  BM_LED_OFF := TBitmap.Create;
  BM_LED_OFF.LoadFromArray(LED_OFF_32);


  BM_LED_RED := TBitmap.Create;
  BM_LED_RED.LoadFromArray(LED_RED_32);


  BM_LED_GREEN := TBitmap.Create;
  BM_LED_GREEN.LoadFromArray(LED_GREEN_32);


  Monitor_OFF(0);
  Monitor_OFF(1);

  if drive_c_is_used then
    Monitor_OFF(2);


  GraphicsWindowDrawLine(GraphicHandle,3,68,Monitor_Width-3,68,COLOR_SILVER,1);


  bar_line:='Resolution='+IntToStr(Monitor_Width)+'x'+IntToStr(Monitor_Height);
  GraphicsWindowDrawTextEx(GraphicHandle,CONSOLE_DEFAULT_FONT,bar_line,1015,4,FG_COLOR,BG_COLOR);


  bar_line:='Matrix='+IntToStr(Matrix_Col_Count)+'x'+IntToStr(Matrix_Row_Count);
  GraphicsWindowDrawTextEx(GraphicHandle,CONSOLE_DEFAULT_FONT,bar_line,1015,20,FG_COLOR,BG_COLOR);


  bar_line:='Emulation=VT100';
  GraphicsWindowDrawTextEx(GraphicHandle,CONSOLE_DEFAULT_FONT,bar_line,1015,36,FG_COLOR,BG_COLOR);


{
  bar_line:='Time=12:00 Uhr';
  GraphicsWindowDrawTextEx(GraphicHandle,CONSOLE_DEFAULT_FONT,bar_line,1015,42,FG_COLOR,BG_COLOR);
}


  // *** Draw Matrix ***

{$IFDEF cpm_standard_screen_80x24}
  CONSOLE_DEFAULT_FONT:=FontFindByName('DejaVu_Sans_Mono_17');
  GraphicsWindowSetFont(GraphicHandle,CONSOLE_DEFAULT_FONT);
{$ENDIF}



  // FramebufferConsoleDrawBlock(Console:PConsoleDevice;X1,Y1,X2,Y2,Color:LongWord):LongWord;
  GraphicsWindowDrawBlock(GraphicHandle,0,System_Bar_Height,User_Screen_Width-1,
                              User_Screen_Height-1,COLOR_White);



  // Initializing CPM-Emulator

  CUR_X:=1;
  CUR_Y:=1;

  TermMode:=Normal_TM;
  EmuMode := EMU_VT100;



  Cursor_is_on:=false;


  DRIVE_NR_READ:=20;
  DRIVE_NR_WRITE:=20;
  DRIVE_A_ON:=true;
  DRIVE_B_ON:=true;

  if drive_c_is_used then
    DRIVE_C_ON:=true
  else
    DRIVE_C_ON:=false;


  Timer_Event_Counter:=0;

  Cursor_Counter:=0;



  // Preparation to Run

  Button_Show_Drive_A;

  Button_Show_Drive_B;

  Thread1Handle:=BeginThread(@Thread1Execute,nil,Thread1Handle,THREAD_STACK_DEFAULT_SIZE);


end; { constructor TConOut.Create }








{==============================================================================}
{==============================================================================}



procedure TConOut.Timer_Event;
begin

  Inc(Cursor_Counter);

  if Cursor_Counter>8 then begin

    if Cursor_is_on then begin
      switch_Cursor_off;
    end
    else begin
      switch_Cursor_on;
    end; { if Cursor_is_on then }

  end; { if Cursor_Counter>10 then }



  INC(DRIVE_BMP_Counter);

  if DRIVE_BMP_Counter>60 then begin
    DRIVE_BMP_Counter:=0;

    if DRIVE_A_SHOW_BMP then begin
      Button_Show_Drive_A;
      DRIVE_A_SHOW_BMP:=false;
    end;

    if DRIVE_B_SHOW_BMP then begin
      Button_Show_Drive_B;
      DRIVE_B_SHOW_BMP:=false;
    end;

  end; { if DRIVE_BMP_Counter>60 then }






  if DRIVE_A_ON then begin
    Monitor_OFF(0);
    DRIVE_A_ON:=false;
  end; { if DRIVE_A_ON then }

  if DRIVE_B_ON then begin
    Monitor_OFF(1);
    DRIVE_B_ON:=false;
  end; { if DRIVE_B_ON then }

  if DRIVE_C_ON then begin
    CPM_CONOUT.Monitor_OFF(2);
    DRIVE_C_ON:=false;
  end; { if DRIVE_C_ON then }


  if DRIVE_NR_READ<20 then begin
    Monitor_READ(DRIVE_NR_READ);
    DRIVE_NR_READ:=20;
  end; { if DRIVE_NR_READ<20 then }


  if DRIVE_NR_WRITE<20 then begin
    Monitor_WRITE(DRIVE_NR_WRITE);
    DRIVE_NR_WRITE:=20;
  end; { if DRIVE_NR_WRITE<20 then }



end; { procedure TConOut.Timer_Event }










{==============================================================================}
{==============================================================================}



procedure TConOut.Button_Show_Drive_A;
begin

  wcpm_LW_A.generate_Image;
  DrawINC_to_Framebuffer(3+49,3+5,PAR_TAB2);      // 56x50

end; { procedure TConOut.Button_Show_Drive_A }






{==============================================================================}
{==============================================================================}



procedure TConOut.Button_Show_Drive_B;
begin

  wcpm_LW_B.generate_Image;
  DrawINC_to_Framebuffer(3+120+49,3+5,PAR_TAB2);      // 56x50

end; { procedure TConOut.Button_Show_Drive_B }



{==============================================================================}
{==============================================================================}



procedure TConOut.Button_Screenshot_on;
begin

  DrawINC_to_Framebuffer(930,3,Button_Screenshot);

end; { procedure TConOut.Button_Screenshot_on }






{==============================================================================}
{==============================================================================}



procedure TConOut.Button_Screenshot_off;
begin

  GraphicsWindowDrawBlock(GraphicHandle,
                          930,3,930+60,3+61,COLOR_WHITE);

end; { procedure TConOut.Button_Screenshot_off }





{==============================================================================}
{==============================================================================}






procedure TConOut.GUI_ConsoleDrawText_Ex(Text:String;X,Y,Forecolor,Backcolor:LongWord);
var
  x_pos, y_pos : LongWord;
begin

  x_pos:=Margin_Left+(X*Screen_Font_Width);
  y_pos:=System_Bar_Height+(Y*Screen_Font_Height);

  GraphicsWindowDrawTextEx(GraphicHandle,CONSOLE_DEFAULT_FONT,Text,x_pos,y_pos,Forecolor,Backcolor);

end; { procedure GUI_ConsoleDrawText_Ex }



{==============================================================================}
{==============================================================================}
{}
procedure TConOut.DrawINC_to_Framebuffer(POS_X, POS_Y : LongWord;
                                         var Load_Array : Array of Byte);

begin

  D_Bitmap.LoadFromArray(Load_Array);

  GraphicsWindowDrawImage(GraphicHandle,POS_X,POS_Y,
                          D_Bitmap.BM_RAW_Memory.Memory,
                          D_Bitmap.Width,D_Bitmap.Height,COLOR_FORMAT_UNKNOWN);

end; { procedure TConOut.DrawBitmap_to_Framebuffer }




{==============================================================================}
{==============================================================================}
{}
procedure TConOut.Monitor_OFF(DRIVE_NR : Byte);
begin

  case DRIVE_NR of

    0 : begin

          GraphicsWindowDrawImage(GraphicHandle,3+8,3+20,
                                  BM_LED_OFF.BM_RAW_Memory.Memory,
                                  BM_LED_OFF.Width,BM_LED_OFF.Height,COLOR_FORMAT_UNKNOWN);

        end;

    1 : begin

          GraphicsWindowDrawImage(GraphicHandle,3+8+120,3+20,
                                  BM_LED_OFF.BM_RAW_Memory.Memory,
                                  BM_LED_OFF.Width,BM_LED_OFF.Height,COLOR_FORMAT_UNKNOWN);
        end;

    2 : begin

          GraphicsWindowDrawImage(GraphicHandle,3+8+120+120,3+20,
                                  BM_LED_OFF.BM_RAW_Memory.Memory,
                                  BM_LED_OFF.Width,BM_LED_OFF.Height,COLOR_FORMAT_UNKNOWN);

        end;

  end; { case DRIVE_NR of }

end; { procedure TConOut.Monitor_OFF }







{==============================================================================}
{==============================================================================}
{}
procedure TConOut.Monitor_READ(DRIVE_NR : Byte);
begin

  case DRIVE_NR of

    0 : begin

          GraphicsWindowDrawImage(GraphicHandle,3+8,3+20,
                                  BM_LED_GREEN.BM_RAW_Memory.Memory,
                                  BM_LED_GREEN.Width,BM_LED_GREEN.Height,COLOR_FORMAT_UNKNOWN);
          DRIVE_A_ON:=true;
        end; { 0 }

    1 : begin

          GraphicsWindowDrawImage(GraphicHandle,3+8+120,3+20,
                                  BM_LED_GREEN.BM_RAW_Memory.Memory,
                                  BM_LED_GREEN.Width,BM_LED_GREEN.Height,COLOR_FORMAT_UNKNOWN);
          DRIVE_B_ON:=true;
        end; { 1 }

    2 : begin

          GraphicsWindowDrawImage(GraphicHandle,3+8+120+120,3+20,
                                  BM_LED_GREEN.BM_RAW_Memory.Memory,
                                  BM_LED_GREEN.Width,BM_LED_GREEN.Height,COLOR_FORMAT_UNKNOWN);
          DRIVE_C_ON:=true;
        end; { 2 }

  end; { case DRIVE_NR of }

end; { procedure TConOut.Monitor_READ }









{==============================================================================}
{==============================================================================}
{}
procedure TConOut.Monitor_WRITE(DRIVE_NR : Byte);
begin

  case DRIVE_NR of

    0 : begin

          GraphicsWindowDrawImage(GraphicHandle,3+8,3+20,
                                  BM_LED_RED.BM_RAW_Memory.Memory,
                                  BM_LED_RED.Width,BM_LED_RED.Height,COLOR_FORMAT_UNKNOWN);
          DRIVE_A_ON:=true;
          DRIVE_A_SHOW_BMP:=true;

        end; { 0 }

    1 : begin

          GraphicsWindowDrawImage(GraphicHandle,3+8+120,3+20,
                                  BM_LED_RED.BM_RAW_Memory.Memory,
                                  BM_LED_RED.Width,BM_LED_RED.Height,COLOR_FORMAT_UNKNOWN);
          DRIVE_B_ON:=true;
          DRIVE_B_SHOW_BMP:=true;

        end; { 1 }

    2 : begin

          GraphicsWindowDrawImage(GraphicHandle,3+8+120+120,3+20,
                                  BM_LED_RED.BM_RAW_Memory.Memory,
                                  BM_LED_RED.Width,BM_LED_RED.Height,COLOR_FORMAT_UNKNOWN);
          DRIVE_C_ON:=true;
        end; { 2 }

  end; { case DRIVE_NR of }

end; { procedure TConOut.Monitor_WRITE }














{==============================================================================}
{==============================================================================}
{}
procedure TConOut.DRIVE_NR_READ_LOCK(DRIVE_NR : Byte);
begin

   DRIVE_NR_READ:=DRIVE_NR;

end; { procedure TConOut.DRIVE_NR_READ_LOCK }









{==============================================================================}
{==============================================================================}
{}
procedure TConOut.DRIVE_NR_WRITE_LOCK(DRIVE_NR : Byte);
begin

  DRIVE_NR_WRITE:=DRIVE_NR;

end; { procedure TConOut.DRIVE_NR_WRITE_LOCK }




{==============================================================================}
{==============================================================================}
{TConOut}
procedure TConOut.Show_Line(Line_Nr : LongWord);
var
  counter_x : LongWord;
begin

  for counter_x:=1 to Matrix_Col_Count do begin

    GUI_ConsoleDrawText_Ex(
                       FB_Matrix[counter_x,Line_Nr].Character,
                       counter_x,
                       Line_Nr,
                       FB_Matrix[counter_x,Line_Nr].F_COLOR,
                       FB_Matrix[counter_x,Line_Nr].B_COLOR);

  end; { for counter_x:=1 to Matrix_width do }

end; { procedure TConOut.Show_Line }





{==============================================================================}
{==============================================================================}
{TConOut}
procedure TConOut.Show_Matrix;
var
  counter_x, counter_y : LongWord;
begin

  for counter_y:=1 to Matrix_Row_Count do begin

    for counter_x:=1 to Matrix_Col_Count do begin

      GUI_ConsoleDrawText_Ex(
                       FB_Matrix[counter_x,counter_y].Character,
                       counter_x,
                       counter_y,
                       FB_Matrix[counter_x,counter_y].F_COLOR,
                       FB_Matrix[counter_x,counter_y].B_COLOR);

    end; { for counter_x:=1 to Matrix_width do }

  end; { for counter_y:=1 to Matrix_height do }

end; { procedure TConOut.Show_Matrix }







{==============================================================================}
{==============================================================================}
{TConOut}
// Erase all of the display -- all lines are erased,
// changed to single-width, and the cursor does not move.
procedure TConOut.Clear_Screen;
var
  counter_x, counter_y : LongWord;
begin

  for counter_y:=1 to Matrix_Row_Count do begin

    for counter_x:=1 to Matrix_Col_Count do begin

      FB_Matrix[counter_x,counter_y].Character:=Dummy_Char;
      FB_Matrix[counter_x,counter_y].F_COLOR:=FG_COLOR;
      FB_Matrix[counter_x,counter_y].B_COLOR:=BG_COLOR;

    end; { for counter_x:=1 to Matrix_Col_Count do }

  end; { for counter_y:=1 to Matrix_height do }

  Show_Matrix;

  // cursor does not move ????????????????
  CUR_X:=1;
  CUR_Y:=1;

end; { procedure TConOut.Clear_Screen }





{==============================================================================}
{==============================================================================}
{TConOut}
procedure TConOut.switch_Cursor_on;
begin

  GUI_ConsoleDrawText_Ex('_',
                         CUR_X, CUR_Y,
                         FB_Matrix[CUR_X,CUR_Y].F_COLOR,
                         FB_Matrix[CUR_X,CUR_Y].B_COLOR);

  CPM_CONOUT.Cursor_is_on:=true;

  Cursor_Counter:=0;

end; { procedure TConOut.switch_Cursor_on }






{==============================================================================}
{==============================================================================}
{TConOut}
procedure TConOut.switch_Cursor_off;
begin

  GUI_ConsoleDrawText_Ex(FB_Matrix[CUR_X,CUR_Y].Character,
                         CUR_X, CUR_Y,
                         FB_Matrix[CUR_X,CUR_Y].F_COLOR,
                         FB_Matrix[CUR_X,CUR_Y].B_COLOR);

  CPM_CONOUT.Cursor_is_on:=false;

  Cursor_Counter:=0;

end; { procedure TConOut.switch_Cursor_off }







{==============================================================================}
{==============================================================================}
{TConOut}
procedure TConOut.Write_Char(B_Char : Byte);





  procedure SCROLL_UP;
  var
    SD_CUR_X, SD_CUR_Y : LongWord;

{$IFDEF fast_graphic_mode}
    lWidth, lHeight, lResult: LongWord; // OT 20170204
    lSource, lDest: TConsolePoint; // OT 20170204
{$ENDIF}

  begin

    for SD_CUR_Y:=1 to Matrix_Row_Count-1 do begin
      for SD_CUR_X:=1 to Matrix_Col_Count do begin
        FB_Matrix[SD_CUR_X,SD_CUR_Y]:=FB_Matrix[SD_CUR_X,SD_CUR_Y+1];
      end;
    end;

    for SD_CUR_X:=1 to Matrix_Col_Count do begin
      FB_Matrix[SD_CUR_X,Matrix_Row_Count].Character:=Dummy_Char;
      FB_Matrix[SD_CUR_X,Matrix_Row_Count].F_COLOR:=Dummy_FG_COLOR;
      FB_Matrix[SD_CUR_X,Matrix_Row_Count].B_COLOR:=Dummy_BG_COLOR;
    end;

    CUR_X:=1;
    CUR_Y:=Matrix_Row_Count;


{$IFDEF fast_graphic_mode}

    // OT 20170204: do not redraw the graphics screen but scroll it.

    lSource.X := 0; lSource.Y := System_Bar_Line_Height+Screen_Font_Height;
    lDest.X := 0;   lDest.Y := System_Bar_Line_Height;

    lWidth:=User_Screen_Width;
    lHeight:=Screen_Font_Height*(Matrix_Row_Count-1);

    lResult := GraphicsWindowMoveImage(GraphicHandle, lSource, lDest,
                                       lWidth,lHeight, Dummy_BG_COLOR);




{$ELSE}

    Show_Matrix;

{$ENDIF}

  end; { procedure SCROLL_UP }





  procedure LINE_FEED;
  begin
    Inc(CUR_Y);
    if CUR_Y>Matrix_Row_Count then begin
      SCROLL_UP;
    end;
    TermMode:=Normal_TM;
  end; { procedure LINE_FEED }





  // Move the cursor to the home position.
  procedure CURSOR_HOME;
  begin
    CUR_X:=1;
    CUR_Y:=1;
    TermMode:=Normal_TM;
  end; { procedure CURSOR_HOME }





  // Move the active position upward one position without altering the horizontal position.
  // If an attempt is made to move the cursor above the top margin, the cursor stops at the top margin.
  procedure CURSOR_UP;
  begin
    DEC(CUR_Y);
    if CUR_Y<1 then begin
      CUR_Y:=1;
    end;
    TermMode:=Normal_TM;
  end; { procedure CURSOR_UP }






  procedure CURSOR_COUNTER_UP(counter : Integer);
  begin

    if CUR_Y>counter then
      CUR_Y:=CUR_Y-counter
    else
      CUR_Y:=1;

    TermMode:=Normal_TM;

  end; { procedure CURSOR_COUNTER_UP }






  // Move the active position downward one position without altering the horizontal position.
  // If an attempt is made to move the cursor below the bottom margin, the cursor stops at the bottom margin.
  procedure CURSOR_DOWN;
  begin
    INC(CUR_Y);
    if CUR_Y>Matrix_Row_Count then begin
      CUR_Y:=Matrix_Row_Count;
    end;
    TermMode:=Normal_TM;
  end; { procedure CURSOR_DOWN }





  procedure CURSOR_COUNTER_DOWN(counter : Integer);
  begin

    if (CUR_Y+counter)<Matrix_Row_Count then
      CUR_Y:=CUR_Y+counter
    else
      CUR_Y:=Matrix_Row_Count;

    TermMode:=Normal_TM;

  end; { procedure CURSOR_COUNTER_DOWN }




  // Move the active position to the right.
  // If an attempt is made to move the cursor to the right of the right margin,
  // the cursor stops at the right margin.
  procedure CURSOR_RIGHT;
  begin

    INC(CUR_X);
    if CUR_X>Matrix_Col_Count then begin
      CUR_X:=Matrix_Col_Count;
    end;

    TermMode:=Normal_TM;

  end; { procedure CURSOR_RIGHT }




  // Move the active position one position to the left.
  // If an attempt is made to move the cursor to the left of the left margin,
  // the cursor stops at the left margin.
  procedure CURSOR_LEFT;
  begin

    DEC(CUR_X);
    if CUR_X<1 then begin
      CUR_X:=1;
    end;

    TermMode:=Normal_TM;

  end; { procedure CURSOR_LEFT }




  procedure CURSOR_TAB;
  begin
    CUR_X:=8 * ((CUR_X div 8) +1);
  end; { procedure CURSOR_TAB }




  procedure CURSOR_FORWARD;
  begin
    CURSOR_RIGHT;
  end; { procedure CURSOR_FORWARD }





  procedure CURSOR_COUNTER_FORWARD(counter : Integer);
  begin

    if (CUR_X+counter)<Matrix_Col_Count then
      CUR_X:=CUR_X+counter
    else
      CUR_X:=Matrix_Col_Count;

    TermMode:=Normal_TM;

  end; { CURSOR_COUNTER_FORWARD }





  procedure CURSOR_BACKWARD;
  begin
    CURSOR_LEFT;
  end; { procedure CURSOR_BACKWARD }






  procedure CURSOR_COUNTER_BACKWARD(counter : Integer);
  begin

    if CUR_X>counter then
      CUR_X:=CUR_X-counter
    else
      CUR_X:=1;

    TermMode:=Normal_TM;

  end; { procedure CURSOR_COUNTER_BACKWARD }





  { *** DELETE *** }



  // Clear line from cursor right
  // Erase all characters from the active position to the end of the current line.
  // The active position is not changed.
  procedure Erase_to_End_of_Line;
  var
    SD_CUR_X : LongWord;
  begin

    for SD_CUR_X:=CUR_X to Matrix_Col_Count do begin
      FB_Matrix[SD_CUR_X,CUR_Y].Character:=Dummy_Char;
      FB_Matrix[SD_CUR_X,CUR_Y].F_COLOR:=Dummy_FG_COLOR;
      FB_Matrix[SD_CUR_X,CUR_Y].B_COLOR:=Dummy_BG_COLOR;
    end; { for SD_CUR_X:=CUR_X to Matrix_Col_Count do }

    TermMode:=Normal_TM;
    Show_Line(CUR_Y);

  end; { procedure Erase_to_End_of_Line }





  // Erase all characters from the active position to the end of the screen.
  // The active position is not changed.
  procedure Erase_to_End_of_Screen;
  var
    SD_CUR_X, SD_CUR_Y : LongWord;
  begin
    Erase_to_End_of_Line;

    if CUR_Y<Matrix_Row_Count then begin
      for SD_CUR_Y:=CUR_Y+1 to Matrix_Row_Count do begin
         for SD_CUR_X:=1 to Matrix_Col_Count do begin

           FB_Matrix[SD_CUR_X,SD_CUR_Y].Character:=Dummy_Char;
           FB_Matrix[SD_CUR_X,SD_CUR_Y].F_COLOR:=Dummy_FG_COLOR;
           FB_Matrix[SD_CUR_X,SD_CUR_Y].B_COLOR:=Dummy_BG_COLOR;

         end; { for SD_CUR_X:=1 to Matrix_Col_Count do }
      end; { for SD_CUR_Y:=CUR_Y+1 to Matrix_Row_Count do }
    end; { if CUR_Y<Matrix_Row_Count then }

    TermMode:=Normal_TM;
    Show_Matrix;

  end; { procedure Erase_to_End_of_Screen }




  procedure INSERT_CHARACTER;
  var
    SD_CUR_X : LongWord;
  begin

    if CUR_X<Matrix_Col_Count then begin

      for SD_CUR_X:=Matrix_Col_Count downto CUR_X+1 do begin
        FB_Matrix[SD_CUR_X,CUR_Y]:=FB_Matrix[SD_CUR_X-1,CUR_Y];
      end; { for SD_CUR_X:=CUR_X to Matrix_Col_Count do }

    end; { if SD_CUR_X<Matrix_width then }

    FB_Matrix[CUR_X,CUR_Y].Character:=Dummy_Char;
    FB_Matrix[CUR_X,CUR_Y].F_COLOR:=Dummy_FG_COLOR;
    FB_Matrix[CUR_X,CUR_Y].B_COLOR:=Dummy_BG_COLOR;

    TermMode:=Normal_TM;
    Show_Line(CUR_Y);

  end; { procedure INSERT_CHARACTER }




  procedure DELETE_CHARACTER;
  var
    SD_CUR_X : LongWord;
  begin

    for SD_CUR_X:=CUR_X to Matrix_Col_Count-1 do begin
      FB_Matrix[SD_CUR_X,CUR_Y]:=FB_Matrix[SD_CUR_X+1,CUR_Y];
    end; { for SD_CUR_X:=CUR_X to Matrix_Col_Count-1 do }

    TermMode:=Normal_TM;
    Show_Line(CUR_Y);

  end; { procedure DELETE_CHARACTER }




  procedure DELETE_LINE;
  var
    SD_CUR_X : LongWord;
  begin

    for SD_CUR_X:=1 to Matrix_Col_Count do begin
      FB_Matrix[SD_CUR_X,CUR_Y].Character:=Dummy_Char;
      FB_Matrix[SD_CUR_X,CUR_Y].F_COLOR:=Dummy_FG_COLOR;
      FB_Matrix[SD_CUR_X,CUR_Y].B_COLOR:=Dummy_BG_COLOR;
    end; { for SD_CUR_X:=1 to Matrix_Col_Count do }

    CUR_X:=1;

    TermMode:=Normal_TM;
    Show_Line(CUR_Y);

  end; { procedure DELETE_LINE }






  procedure DELETE_BOL;
  var
    SD_CUR_X : LongWord;
  begin

    for SD_CUR_X:=1 to CUR_X do begin
      FB_Matrix[SD_CUR_X,CUR_Y].Character:=Dummy_Char;
      FB_Matrix[SD_CUR_X,CUR_Y].F_COLOR:=Dummy_FG_COLOR;
      FB_Matrix[SD_CUR_X,CUR_Y].B_COLOR:=Dummy_BG_COLOR;
    end; { for SD_CUR_X:=1 to CUR_X-1 do }

    TermMode:=Normal_TM;
    Show_Line(CUR_Y);

  end; { procedure DELETE_BOL }



  // Erase from start of the screen to the active position, inclusive
  procedure Erase_from_start_of_the_screen;
  var
    SD_CUR_X, SD_CUR_Y : LongWord;
  begin
    DELETE_BOL;

    if CUR_Y>1 then begin
      for SD_CUR_Y:=1 to CUR_Y-1 do begin
         for SD_CUR_X:=1 to Matrix_Col_Count do begin
           FB_Matrix[SD_CUR_X,SD_CUR_Y].Character:=Dummy_Char;
           FB_Matrix[SD_CUR_X,SD_CUR_Y].F_COLOR:=Dummy_FG_COLOR;
           FB_Matrix[SD_CUR_X,SD_CUR_Y].B_COLOR:=Dummy_BG_COLOR;
         end; { for SD_CUR_X:=1 to Matrix_Col_Count do }
      end; { for SD_CUR_Y:=1 to CUR_Y-1 do }
    end; { if CUR_Y>1 then }

    TermMode:=Normal_TM;
    Show_Matrix;

  end; { procedure Erase_from_start_of_the_screen }





  procedure RUN_BELL;
  begin
    // dummy
  end; { procedure RUN_BELL }



  procedure RUN_DEL;
  begin

    if CUR_X>1 then begin
      Dec(CUR_X);
      FB_Matrix[CUR_X,CUR_Y].Character:=Dummy_Char;
      FB_Matrix[CUR_X,CUR_Y].F_COLOR:=Dummy_FG_COLOR;
      FB_Matrix[CUR_X,CUR_Y].B_COLOR:=Dummy_BG_COLOR;
    end;

    TermMode:=Normal_TM;
    Show_Line(CUR_Y);

  end; { procedure RUN_DEL }







  procedure DELETE_LINE_SCR_ROLL;
  var
    SD_CUR_X, SD_CUR_Y : LongWord;

{$IFDEF fast_graphic_mode}

    lResult, lWidth, lHeight : LongWord;
    lSource, lDest: TConsolePoint;




{$ENDIF}

  begin

    for SD_CUR_Y:=CUR_Y to Matrix_Row_Count-1 do begin
      for SD_CUR_X:=1 to Matrix_Col_Count do begin
        FB_Matrix[SD_CUR_X,SD_CUR_Y]:=FB_Matrix[SD_CUR_X,SD_CUR_Y+1];
      end; { for SD_CUR_X:=1 to Matrix_Col_Count do }
    end; { for SD_CUR_Y:=CUR_Y to Matrix_height-1 do }

    for SD_CUR_X:=1 to Matrix_Col_Count do begin
      FB_Matrix[SD_CUR_X,Matrix_Row_Count].Character:=Dummy_Char;
      FB_Matrix[SD_CUR_X,Matrix_Row_Count].F_COLOR:=Dummy_FG_COLOR;
      FB_Matrix[SD_CUR_X,Matrix_Row_Count].B_COLOR:=Dummy_BG_COLOR;
    end; { for SD_CUR_X:=1 to Matrix_Col_Count do }



{$IFDEF fast_graphic_mode}

    { OT 20170211 }

    lSource.X := 0;
    lSource.Y := System_Bar_Line_Height + (CUR_Y*Screen_Font_Height);

    lDest.X := 0;
    lDest.Y := lSource.Y - Screen_Font_Height;

    lWidth:=User_Screen_Width;
    lHeight:=Screen_Font_Height*(Matrix_Row_Count-1);

    lResult := GraphicsWindowMoveImage(GraphicHandle, lSource, lDest,
                                       lWidth, lHeight, Dummy_BG_COLOR);


{$ELSE}

    CUR_X:=1;
    Show_Matrix;

{$ENDIF}

    TermMode:=Normal_TM;

  end; { procedure DELETE_LINE_SCR_ROLL }








  procedure INSERT_LINE_SCR_ROLL;
  var
    SD_CUR_X, SD_CUR_Y : LongWord;
  begin

    if CUR_Y<Matrix_Row_Count then begin

      for SD_CUR_Y:=Matrix_Row_Count downto CUR_Y+1 do begin
        for SD_CUR_X:=1 to Matrix_Col_Count do begin
          FB_Matrix[SD_CUR_X,SD_CUR_Y]:=FB_Matrix[SD_CUR_X,SD_CUR_Y-1];
        end; { for SD_CUR_X:=1 to Matrix_Col_Count do }
      end; { for SD_CUR_Y:=Matrix_Row_Count downto CUR_Y+1 do }

    end; { if CUR_Y<Matrix_Row_Count then }

    for SD_CUR_X:=1 to Matrix_Col_Count do begin
      FB_Matrix[SD_CUR_X,CUR_Y].Character:=Dummy_Char;
      FB_Matrix[SD_CUR_X,CUR_Y].F_COLOR:=Dummy_FG_COLOR;
      FB_Matrix[SD_CUR_X,CUR_Y].B_COLOR:=Dummy_BG_COLOR;
    end; { for SD_CUR_X:=1 to Matrix_Col_Count do }

    TermMode:=Normal_TM;
    Show_Matrix;

  end; { procedure INSERT_LINE_SCR_ROLL }






  { ############################################################## }




  procedure Normal_Terminal_Mode;
  begin

    case B_Char of
      $01 : CURSOR_HOME;   // auf Pos 1,1
      $04 : CURSOR_RIGHT;  // rechts
      $05 : CURSOR_UP;     // oben
      $07 : RUN_BELL;      // BELL - Glocke
      $09 : CURSOR_TAB;    // TAB
      $0A : LINE_FEED;     // LF
      $0C : CLEAR_SCREEN;  // CLS - Clear Screen
      $0D : CUR_X:=1;      // CR
      $13 : CURSOR_LEFT;   // links
      $16 : Erase_to_End_of_Line; // ab Cursorposition bis Zeilenende loeschen
      $18 : CURSOR_DOWN;   // unten
      $1B : begin
              case EmuMode of
                Emu_VT100  : TermMode:=IBM_ESC_TM;
                EMU_ADM31  : TermMode:=ADM31_ESC_TM;
                Emu_PC1715 : TermMode:=PC1715_ESC_TM;

              else
                TermMode:= PC1715_ESC_TM;
              end;
            end; { $1B [ESC] }

      $20..$7E : begin

                   GUI_ConsoleDrawText_Ex(Char(B_Char), CUR_X,
                                          CUR_Y,FG_COLOR,BG_COLOR);

                   FB_Matrix[CUR_X,CUR_Y].Character:=Char(B_Char);
                   FB_Matrix[CUR_X,CUR_Y].F_COLOR:=FG_COLOR;
                   FB_Matrix[CUR_X,CUR_Y].B_COLOR:=BG_COLOR;

                   CURSOR_RIGHT;

                 end; { $20..$7E }

      $7F : RUN_DEL;

    else

    end;

  end; { procedure Normal_Terminal_Mode }




  procedure SET_CURSOR_POSITION(Zeile, Spalte : Integer); // bezogen auf 1,1 !!!
  begin


{$IFDEF use_invert_display_attributes}
    if Zeile<1 then
      Zeile:=1;

    if Spalte<1 then
      Spalte:=1;

    CUR_X:=Spalte;
    CUR_Y:=Zeile;
{$ELSE}
    CUR_X:=Spalte+1;
    CUR_Y:=Zeile+1;
{$ENDIF}

    if (CUR_Y>Matrix_Row_Count) then
      CUR_Y:=Matrix_Row_Count;

    if (CUR_X>Matrix_Col_Count) then
      CUR_X:=Matrix_Col_Count;

    TermMode:=Normal_TM;

  end; { procedure SET_CURSOR_POSITION }






  // **********************************
  // ADM31_ESC_Terminal_Mode
  // **********************************


  procedure ADM31_ESC_Terminal_Mode;
  begin
    if B_Char<>$1B then begin

      case B_Char of

        $3D : begin
                TermMode:=ADM31_ESC_TM_R; // ESC = R C
              end; { $3D }
        $1B : begin
                TermMode:=ADM31_ESC_ESC; // ESC ESC
              end; { $3D }
        $54 : begin
                Erase_to_End_of_Line; // ESC T = Erase to End of Line
                TermMode:=Normal_TM;
              end; { $54 }
        $74 : begin
                Erase_to_End_of_Line; // ESC t = Erase to End of Line
                TermMode:=Normal_TM;
              end; { $74 }
        $59 : begin
                Erase_to_End_of_Screen; // ESC Y = Erase to End of Screen
                TermMode:=Normal_TM;
              end; { $59 }
        $79 : begin
                Erase_to_End_of_Screen; // ESC y = Erase to End of Screen
                TermMode:=Normal_TM;
              end; { $79 }
        $3A : begin
                Clear_Screen; // ESC : = home & clear screen
                TermMode:=Normal_TM;
              end; { $3A }
        $2A : begin
                Clear_Screen; // ESC * = home & clear screen
                TermMode:=Normal_TM;
              end; { $2A }
        $47 : begin
                TermMode:=ADM31_ESC_TM_G; // ESC G ...
              end; { $47 }
        $28 : begin
                // ESC ( = Half intensity off
                // derzeit nicht implementiert
              end; { $28 }
        $29 : begin
                // ESC ) = Half intensity on
                // derzeit nicht implementiert
              end; { $29 }
        $45 : begin
                LINE_FEED; // ESC E = Insert line
                TermMode:=Normal_TM;
              end; { $45 }
        $51 : begin
                INSERT_CHARACTER; // ESC Q = Insert Character
                TermMode:=Normal_TM;
              end; { $51 }
        $52 : begin
                DELETE_LINE; // ESC R = Delete Line
                TermMode:=Normal_TM;
              end; { $52 }
        $57 : begin
                DELETE_CHARACTER; // ESC W = Delete Character
                TermMode:=Normal_TM;
              end; { $57 }

        else
          TermMode:=Normal_TM;
          Normal_Terminal_Mode;
        end; { case Zeichen of }
      end
      else begin
    //    Form_CPD2.Terminal.Items.Add('ESC+ESC empfangen');
      end;
    end; { procedure ADM31_ESC_Terminal_Mode }





    procedure ADM31_ESC_Par_Zeile_Terminal_Mode;
    begin
      if B_Char>=$20 then begin
       // ESC_Zeile:=B_Char-$20;
        TermMode:=ADM31_ESC_TM_C;
      end
      else begin
      //  ESC_SonderZeichen_in_Matrix('=');
        TermMode:=Normal_TM;
      end;
    end; { procedure ADM31_ESC_Par_Zeile_Terminal_Mode }



    procedure ADM31_ESC_Par_Spalte_Terminal_Mode;
    begin
      if B_Char>=$20 then begin
        SET_CURSOR_POSITION(ESC_Zeile, B_Char-$20);
      end
      else begin

      end;
      TermMode:=Normal_TM;
    end; { procedure ADM31_ESC_Par_Spalte_Terminal_Mode }




    procedure ADM31_ESC_ESC_Terminal_Mode;
    begin
      case B_Char of
        $1B : begin
                TermMode:=ADM31_ESC_ESC_ESC;
              end; { $1B }
        $3D : begin
                TermMode:=ADM31_ESC_TM_R; // ESC = R C
              end; { $3D }
        $29 : begin
                // Zeichen - nicht implementiert
              end; { $29 }
        $54 : begin
                // Zeichen - nicht implementiert
              end; { $54 }
      else

        TermMode:=Normal_TM;
      end;

    end; { procedure ADM31_ESC_ESC_Terminal_Mode }




    procedure ADM31_ESC_ESC_ESC_Terminal_Mode;
    begin
      if B_Char=$1B then begin
        // color = Zeichen - nicht implementiert
        TermMode:=Normal_TM;
      end
      else begin

        TermMode:=Normal_TM;
      end;
    end; { procedure ADM31_ESC_ESC_ESC_Terminal_Mode }







    procedure ADM31_ESC_G_Terminal_Mode;
    begin
       case B_Char of
         $00 : begin
                 // ESC G 0 = Rev. video and blinking off, restore normal 80 col char set
                 // nicht implementiert
               end; { $00 }
         $01 : begin
                 // ESC G 1 = select 80 col alternate character set
                 // nicht implementiert
               end; { $01 }
         $02 : begin
                 // ESC G 2 = Blinking on
                 // nicht implementiert
               end; { $02 }
         $04 : begin
                 // ESC G 4 = Reverse video on
                 // nicht implementiert
               end; { $04 }
        else

        end; { case Zeichen of }
       TermMode:=Normal_TM;
    end; { procedure ADM31_ESC_Terminal_Mode }






    // **********************************
    // IBM VT100 Terminal_Mode
    // **********************************


    procedure IBM_ESC_Terminal_Mode;
    begin
      case B_Char of

        $3C : begin // ESC <
                { Enter ANSI Mode    ESC <
                  All subsequent escape sequences will be interpreted
                  according to ANSI Standards X3.64-1977 and X3.41-1974.
                  The VT52 escape sequence designed in this section will
                  not be recognized.
                }
                EmuMode:=Emu_VT100;  // VT52 = ESC < - ENTER_ANSI_MODE
              end; { $3C }

        $41 : begin
                 CURSOR_UP;  // VT52 = ESC A - CURSOR_UP
              end; { $41 }

        $42 : begin
                CURSOR_DOWN; // VT52 = ESC B - CURSOR_DOWN
              end; { $42 }

        $43 : begin
                CURSOR_RIGHT; // VT52 = ESC C - CURSOR_RIGHT
              end; { $43 }

        $44 : begin
                CURSOR_LEFT; // VT52 = ESC D - CURSOR_LEFT
              end; { $44 }


        $46 : begin
                // Enter_Graphics_Mode; // VT52 = ESC F - Enter Graphics Mode
              end; { $46 }


        $47 : begin
                // Exit_Graphics_Mode; // VT52 = ESC G - Exit Graphics Mode
              end; { $47 }



        $48 : begin
                CURSOR_HOME; // VT52 = ESC H - Cursor to Home
              end; { $48 }


        $4A : begin
                Erase_to_End_of_Screen; // VT52 = ESC J - Erase to End of Screen
              end; { $4A }

        $4B : begin
                Erase_to_End_of_Line; // VT52 = ESC K - Erase to End of Line
              end; { $4B }

        $59 : begin
                TermMode:=DCA_TM; // VT52 = ESC Y Zeile Spalte - DIRECT_CURSOR_ADRESS
              end; { $59 }

        $5B : begin
                TermMode:=IBM_CSI_TM; // Control Sequence Introducer (CSI) = ESC [
              end; { $5B }

        $63 : begin // VT52 = ESC c - RIS - Reset To Initial State
                CLEAR_SCREEN;
              end; { $63 }



      else

        TermMode:=Normal_TM;
      end; { case Zeichen of }
     end; { procedure ESC_Terminal_Mode }








    procedure Set_Display_Attributes(DispAttr : LongWord);
    begin


      case DispAttr of

        // *** Textattribute ***


        // ESC [ 0 m = Alle Attribute AUS (Reset all attributes)
        0 : begin

{$IFDEF use_invert_display_attributes}
              FG_COLOR:=COLOR_BLACK;     // turn off attributes - normal video
              BG_COLOR:=COLOR_WHITE;
{$ELSE}
              FG_COLOR:=COLOR_BLUE;
              BG_COLOR:=COLOR_WHITE;
{$ENDIF}

            end; { 0 }

        // ESC [ 1 m = Fett ein
        1 : begin
              FG_COLOR:=COLOR_GRAY;
              BG_COLOR:=COLOR_WHITE;
            end;

        // ESC [ 4 m = Unterstreichen
        4 : begin
              FG_COLOR:=COLOR_PURPLE;
              BG_COLOR:=COLOR_WHITE;
            end;

        // ESC [ 5 m = Blinken EIN
        5 : begin
              FG_COLOR:=COLOR_RED;
              BG_COLOR:=COLOR_WHITE;
            end;

        // ESC [ 7 m = Invertierte Darstellung
        7 : begin

{$IFDEF use_invert_display_attributes}
              FG_COLOR:=COLOR_WHITE;
              BG_COLOR:=COLOR_GRAY;
{$ELSE}
              FG_COLOR:=COLOR_BLACK;     // turn off attributes - normal video
              BG_COLOR:=COLOR_WHITE;
{$ENDIF}

            end;

        // ESC [ 8 m = Versteckt ein
        8 : begin
              FG_COLOR:=COLOR_WHITE;
              BG_COLOR:=COLOR_WHITE;
            end;




        // *** Vordergrundfarben ***

        // ESC [ 30 m = Vordergrundfarbe - 30 Schwarz
        30 : FG_COLOR:=COLOR_BLACK;

        // ESC [ 31 m = Vordergrundfarbe - 31 Rot
        31 : FG_COLOR:=COLOR_RED;

        // ESC [ 32 m = Vordergrundfarbe - 32 Grn
        32 : FG_COLOR:=COLOR_GREEN;

        // ESC [ 33 m = Vordergrundfarbe - 33 Gelb
        33 : FG_COLOR:=COLOR_YELLOW;

        // ESC [ 34 m = Vordergrundfarbe - 34 Blau
        34 : FG_COLOR:=COLOR_BLUE;

        // ESC [ 35 m = Vordergrundfarbe - 35 Magenta
        35 : FG_COLOR:=COLOR_MAGENTA;

        // ESC [ 36 m = Vordergrundfarbe - 36 Cyanblau
        36 : FG_COLOR:=COLOR_CYAN;

        // ESC [ 37 m = Vordergrundfarbe - 37 Wei
        37 : FG_COLOR:=COLOR_WHITE;




        // *** Hintergrundfarben ***

        // ESC [ 40 m = Hintergrundfarbe - 40 Schwarz
        40 : BG_COLOR:=COLOR_BLACK;

        // ESC [ 41 m = Hintergrundfarbe - 41 Rot
        41 : BG_COLOR:=COLOR_RED;

        // ESC [ 42 m = Hintergrundfarbe - 42 Grn
        42 : BG_COLOR:=COLOR_GREEN;

        // ESC [ 43 m = Hintergrundfarbe - 43 Gelb
        43 : BG_COLOR:=COLOR_YELLOW;

        // ESC [ 44 m = Hintergrundfarbe - 44 Blau
        44 : BG_COLOR:=COLOR_BLUE;

        // ESC [ 45 m = Hintergrundfarbe - 45 Magenta
        45 : BG_COLOR:=COLOR_MAGENTA;

        // ESC [ 46 m = Hintergrundfarbe - 46 Cyanblau
        46 : BG_COLOR:=COLOR_CYAN;

        // ESC [ 47 m = Hintergrundfarbe - 47 Wei
        47 : BG_COLOR:=COLOR_WHITE;

         else

        TermMode:=Normal_TM;
      end;

    end; { procedure Set_Display_Attributes }







    procedure IBM_CSI_Terminal_Mode;
    begin
      case B_Char of

        $30..$39 : begin
                    CSI_Parameter1:=B_Char-$30;
                    TermMode:=IBM_CSI_TM_Par;
                  end;

        $48 : begin // Character Attributes = ESC [ H
                 // Move the cursor to the home position.
                CURSOR_HOME;

                CSI_Parameter1:=0;
                TermMode:=Normal_TM;
              end; { $48 }

        $4A : begin // ESC [ J
                // erase to end of screen (inclusive)
                 Erase_to_End_of_Screen; // Erase to End of Screen

                CSI_Parameter1:=0;
                TermMode:=Normal_TM;
              end; { $4A }

        $4B : begin // ERASE LINE = ESC [ K
                // Clear line from cursor right
                Erase_to_End_of_Line; // Erase to End of Line
                CSI_Parameter1:=0;
                TermMode:=Normal_TM;
              end; { $4B }

        $6D : begin // Character Attributes = ESC [ m
                Set_Display_Attributes(0);
                CSI_Parameter1:=0;
                TermMode:=Normal_TM;
              end; { $6D }

        $66 : begin // Character Attributes = ESC [ f
                // Move cursor to upper left corner
                CURSOR_HOME;
                CSI_Parameter1:=0;
                TermMode:=Normal_TM;
              end; { $66 }

      else

        TermMode:=Normal_TM;
      end;
    end; { procedure IBM_CSI_Terminal_Mode }






    procedure IBM_CSI_Par_Terminal_Mode;
    var
      x_counter : Integer;
    begin
      case B_Char of
        $30..$39 : begin
                    CSI_Parameter1:=(CSI_Parameter1*10)+B_Char-$30;
                    TermMode:=IBM_CSI_TM_Par;
                  end;

        $3B : begin // ";" -- MOVE CURSOR = ESC [ Pn1 ; PN2 H oder ESC [ Pn1 ; PN2 f
                TermMode:=IBM_CSI_TM_Par_Zeile;
              end; { $3B }

        $41 : begin // CUU -- Cursor Up = ESC [ Pn A
                CURSOR_COUNTER_UP(CSI_Parameter1);
                TermMode:=Normal_TM;
                CSI_Parameter1:=0;
              end; { $41 }

        $42 : begin // CUD -- Cursor Down = ESC [ Pn B
                CURSOR_COUNTER_DOWN(CSI_Parameter1);
                CSI_Parameter1:=0;
                TermMode:=Normal_TM;
              end; { $42 }

        $43 : begin // CUF -- Cursor Forward  = ESC [ Pn C
                CURSOR_COUNTER_FORWARD(CSI_Parameter1);
                CSI_Parameter1:=0;
                TermMode:=Normal_TM;
              end; { $43 }

        $44 : begin // CUB -- Cursor Backward = ESC [ Pn D
                CURSOR_COUNTER_BACKWARD(CSI_Parameter1);
                CSI_Parameter1:=0;
                TermMode:=Normal_TM;
              end; { $44 }

        $4B : begin // EL -- Erase In Line = ESC [ Pn K
                // Erases some or all characters in the active line according to the parameter.
                case CSI_Parameter1 of
                  0 : Erase_to_End_of_Line; // Erase to End of Line
                  1 : DELETE_BOL;
                  2 : DELETE_LINE;
                else

                end;
                CSI_Parameter1:=0;
                TermMode:=Normal_TM;
              end; { $4B }

        $4A : begin // ED -- Erase In Display = ESC [ Pn J
                // This sequence erases some or all of the characters in the
                // display according to the parameter. Any complete line
                // erased by this sequence will return that line to single
                // width mode.
                case CSI_Parameter1 of
                  0 : Erase_to_End_of_Screen;          // Erase to End of Screen
                  1 : Erase_from_start_of_the_screen;  // Erase from start of the screen
                                                       // to the active position, inclusive
                  2 : CLEAR_SCREEN; // erase entire screen (cursor doesn't move)
                else

                end;
                CSI_Parameter1:=0;
                TermMode:=Normal_TM;
              end; { $4A }


        $4C : begin // INSERT_LINE_SCR_ROLL = ESC [ Pn L
                for x_counter:=0 to CSI_Parameter1-1 do
                  INSERT_LINE_SCR_ROLL;

                CSI_Parameter1:=0;
                TermMode:=Normal_TM;
              end; { $4C }


        $4D : begin // DELETE_LINE_SCR_ROLL = ESC [ Pn M
                for x_counter:=0 to CSI_Parameter1-1 do
                  DELETE_LINE_SCR_ROLL;

                CSI_Parameter1:=0;
                TermMode:=Normal_TM;

              end; { $4D }


        $6D : begin // Character Attributes = ESC [ Pn m
                Set_Display_Attributes(CSI_Parameter1);
                CSI_Parameter1:=0;
                TermMode:=Normal_TM;
              end; { $6D }
      else

        TermMode:=Normal_TM;
      end;

    end; { procedure IBM_CSI_Par_Terminal_Mode }






    procedure IBM_CSI_Par_Zeile_Terminal_Mode;
    begin
      case B_Char of
        $30..$39 : begin
                     CSI_Parameter2:=(CSI_Parameter2*10)+B_Char-$30;
                     TermMode:=IBM_CSI_TM_Par_Zeile;
                   end;
        $48 : begin // -- MOVE CURSOR = ESC [ Pn1 ; PN2 H
                SET_CURSOR_POSITION(CSI_Parameter1, CSI_Parameter2);
                CSI_Parameter1:=0;
                CSI_Parameter2:=0;
                TermMode:=Normal_TM;
              end; { $48 }
        $66 : begin // -- MOVE CURSOR = ESC [ Pn1 ; PN2 f
                SET_CURSOR_POSITION(CSI_Parameter1, CSI_Parameter2);
                CSI_Parameter1:=0;
                CSI_Parameter2:=0;
                TermMode:=Normal_TM;
              end; { $66 }
      else

        TermMode:=Normal_TM;
      end;
    end; { procedure IBM_CSI_Par_Zeile_Terminal_Mode }






    // ************
    //    PC1715
    // ************


    procedure PC1715_ESC_Terminal_Mode;
    begin
      if B_Char>=$80 then begin
        ESC_Zeile:=B_Char-$80;
        TermMode:=PC1715_TM_Zeile;
      end
      else begin

        TermMode:=Normal_TM;
      end;
    end; { procedure PC1715_ESC_Terminal_Mode }



    procedure PC1715_ESC_Zeile_Terminal_Mode;
    begin
      if B_Char>=$80 then begin
        SET_CURSOR_POSITION(ESC_Zeile, B_Char-$80);
      end
      else begin

      end;

      TermMode:=Normal_TM;

    end; { procedure PC1715_ESC_Zeile_Terminal_Mode }





    procedure DCA_Terminal_Mode;
    begin
      if B_Char>=$20 then begin
        ESC_Zeile:=B_Char-$20;
        TermMode:=DCA_TM_Zeile;
      end
      else begin

        TermMode:=Normal_TM;
      end;
    end; { procedure DCA_Terminal_Mode }




    procedure DCA_Terminal_Mode_Zeile;
    begin
      if B_Char>=$20 then begin
        SET_CURSOR_POSITION(ESC_Zeile, B_Char-$20);
      end
      else begin

      end;
      TermMode:=Normal_TM;
    end; { procedure DCA_Terminal_Mode_Zeile }








begin

  switch_Cursor_off;

  case TermMode of
    Normal_TM            : Normal_Terminal_Mode;
    IBM_ESC_TM           : IBM_ESC_Terminal_Mode;
    IBM_CSI_TM           : IBM_CSI_Terminal_Mode;
    IBM_CSI_TM_Par       : IBM_CSI_Par_Terminal_Mode;
    IBM_CSI_TM_Par_Zeile : IBM_CSI_Par_Zeile_Terminal_Mode;
    PC1715_ESC_TM        : PC1715_ESC_Terminal_Mode;
    PC1715_TM_Zeile      : PC1715_ESC_Zeile_Terminal_Mode;
    DCA_TM               : DCA_Terminal_Mode;
    DCA_TM_Zeile         : DCA_Terminal_Mode_Zeile;
    ADM31_ESC_TM         : ADM31_ESC_Terminal_Mode;
    ADM31_ESC_TM_R       : ADM31_ESC_Par_Zeile_Terminal_Mode;
    ADM31_ESC_TM_C       : ADM31_ESC_Par_Spalte_Terminal_Mode;
    ADM31_ESC_ESC        : ADM31_ESC_ESC_Terminal_Mode;
    ADM31_ESC_ESC_ESC    : ADM31_ESC_ESC_ESC_Terminal_Mode;
    ADM31_ESC_TM_G       : ADM31_ESC_G_Terminal_Mode;
  end;

end; { procedure TConOut.Write_Char }





destructor TConOut.Destroy;
begin

  D_Bitmap.Free;

end; { destructor TConOut.Destroy }









end.

