program EMUZ80;

{$mode objfpc}{$H+}

{ CP/M Emulator by Ronald Daleske }

{Declare some units used by this example.}
uses
  RaspberryPi,
  GlobalConfig,
  GlobalConst,
  GlobalTypes,
  Platform,
  Threads,
  SysUtils,
  Classes,

  GraphicsConsole,
  Console,

  CPM_Screen,
  modul_image, Emulator, wincpm,
  modul_cpu, modul_ram, modul_pio, modul_serial;



begin


  GraphicHandle:=GraphicsWindowCreate(ConsoleDeviceGetDefault, CONSOLE_POSITION_FULLSCREEN);




  while not DirectoryExists('C:\') do
  begin
    {Sleep for a half second}
    Sleep(500);
  end;


  // IMAGE LW_A
  wcpm_LW_A := Twcpm.Create('C:\CPM_LW_A');
  wcpm_LW_A.load_dpb_FormatE;
  wcpm_LW_A.Import_Files_To_Image;


  // IMAGE LW_B
  wcpm_LW_B := Twcpm.Create('C:\CPM_LW_B');
  wcpm_LW_B.load_dpb_FormatE;
  wcpm_LW_B.Import_Files_To_Image;


  // Initialisieren der anderen Module
  mod_image := Tmod_image.Create;
  mod_cpu := Tmod_cpu.Create;
  mod_ram := Tmod_ram.Create;
  mod_pio := Tmod_pio.Create;


  // nach der Initialisiereung
  mod_image.Lade_BIOS_in_RAM;
  mod_cpu.Reg.SRS.PC:=$00;


  // Endlosschleife
  Z80.Schleife_abarbeiten;


  wcpm_LW_A.Export_Files_From_Image;
  wcpm_LW_A.Destroy;

  wcpm_LW_B.Export_Files_From_Image;
  wcpm_LW_B.Destroy;



  Z80.Free;

  mod_image.Free;
  mod_cpu.Free;
  mod_ram.Free;
  mod_pio.Free;


end.






