unit Emulator;

{$mode objfpc}{$H+}


// soll mit GUI gearbeitet werden
// {$DEFINE mit_GUI}




interface

uses
  SysUtils,
  CPM_Screen,

  RUART,

  modul_ram, modul_cpu, modul_pio;



type


  TZ80 = class(TObject)
    constructor Create; overload;
    destructor Destroy; override;
  private
    { private declarations }
    OP_Code : Byte;

  public
    { public declarations }

    Adress_Zeile, Befehl_Zeile, B_Zeile : String;
    Mode_Protokoll,
    Schleife_aktiv, Befehl_abgearbeitet : Boolean;
    Adresse_WORD : Word;
    procedure Schleife_abarbeiten;
    procedure einen_Befehl_abarbeiten; { Abarbeiten eines Befehls and der Stelle des PC }
  end;



var
  Z80 : TZ80;



implementation





{ ##### Prozessor Z80 ##### }


constructor TZ80.Create;
begin

  Mode_Protokoll:=true;
  Befehl_abgearbeitet:=false;
  Befehl_Zeile:='';

end; { constructor TZ80.Create }



procedure TZ80.Schleife_abarbeiten;
begin

  Schleife_aktiv:=true;
  while Schleife_aktiv do begin

    einen_Befehl_abarbeiten;

    if Timer_Event_Counter>2 then begin

      Timer_Event_Counter:=0;

      CPM_CONOUT.Timer_Event;

    end; { if Cursor_Counter=1000 then }

  end; { while Schleife_aktiv do }

end; { procedure TZ80.Schleife_abarbeiten }



procedure TZ80.einen_Befehl_abarbeiten; { Abarbeiten eines Befehls and der Stelle des PC }
var
  temp_op_code : Byte;


  {$I emu_FLAGs.inc}

  {$I emu_00.inc}

  {$I emu_01.inc}

  {$I emu_02.inc}

  {$I emu_CB.inc}

  {$I emu_DD_CB.inc}

  {$I emu_DD.inc}

  {$I emu_ED.inc}

  {$I emu_FD_CB.inc}

  {$I emu_FD.inc}

  {$I emu_03.inc}



begin

  Befehl_abgearbeitet:=false;

  OP_Code:=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
  INC(mod_cpu.Reg.SRS.PC);

  temp_op_code := OP_Code AND %11000000;

  case temp_op_code of

    %00000000 : OP_Code_00;

    %01000000 : OP_Code_01;

    %10000000 : OP_Code_10;

    %11000000 : OP_Code_11;

  end; { case temp_op_code of }



end; { procedure TZ80.einen_Befehl_abarbeiten }





destructor TZ80.Destroy;
begin

end; { destructor TZ80.Destroy }



end.

