

{ *** OP_Code_00 *** }




  procedure OP_Code_00;
  var
    OP_Code2, ziel_reg,
    Wert_n, Wert_n2, displacement : Byte;
    Wert_Word, Wert_Word2 : Word;
    DAA_nicht_fertig : Boolean;
  begin

    OP_Code2 := OP_Code AND %00000111;

    case OP_Code2 of

      // LD r,n
      %00000110 : begin

                    {
                    Condition Bits Affected: None
                    }

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then
                      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                    {$ENDIF}

                    Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                    INC(mod_cpu.Reg.SRS.PC);

                    ziel_reg := OP_Code AND %00111000;

                    case ziel_reg of
                      // LD A, n
                      %00111000 : begin

                                    mod_cpu.Reg.HRS.A := Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'LD A, ' + IntToHex(Wert_n,2) +'H';
                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;
                                  end; // LD A, n
                      // LD B, n
                      %00000000 : begin

                                    mod_cpu.Reg.HRS.B := Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'LD B, ' + IntToHex(Wert_n,2) +'H';
                                      Form_cpu.Reg_Red.HRS.B:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;
                                  end; // LD B, n

                      // LD C, n
                      %00001000 : begin

                                    mod_cpu.Reg.HRS.C := Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'LD C, ' + IntToHex(Wert_n,2) +'H';
                                      Form_cpu.Reg_Red.HRS.C:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;
                                  end; // LD C, n

                      // LD D, n
                      %00010000 : begin

                                    mod_cpu.Reg.HRS.D := Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'LD D, ' + IntToHex(Wert_n,2) +'H';
                                      Form_cpu.Reg_Red.HRS.D:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;
                                  end; // LD D, n

                      // LD E, n
                      %00011000 : begin

                                    mod_cpu.Reg.HRS.E := Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'LD E, ' + IntToHex(Wert_n,2) +'H';
                                      Form_cpu.Reg_Red.HRS.E:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;
                                  end; // LD E, n

                      // LD H, n
                      %00100000 : begin

                                    mod_cpu.Reg.HRS.H := Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'LD H, ' + IntToHex(Wert_n,2) +'H';
                                      Form_cpu.Reg_Red.HRS.H:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;
                                  end; // LD H, n

                      // LD L, n
                      %00101000 : begin

                                    mod_cpu.Reg.HRS.L := Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'LD L, ' + IntToHex(Wert_n,2) +'H';
                                      Form_cpu.Reg_Red.HRS.L:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;
                                  end; // LD L, n

                      // LD (HL), n
                      %00110000 : begin

                                    mod_ram.Write_Byte((mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L, Wert_n);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'LD (HL), ' + IntToHex(Wert_n,2) +'H';
                                      Form_RAM.setze_Mem_Red((mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L);
                                      Form_cpu.Reg_Red.HRS.HL:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.HL_Inhalt:=Farbe_Schreiben;
                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;
                                  end; // LD E, n

                    end; { case ziel_reg of }

                  end; { %00000110 }




      // INC r
      %00000100 : begin

                    ziel_reg := OP_Code AND %00111000;

                    case ziel_reg of

                      // INC A
                      %00111000 : begin

                                    Wert_n := mod_cpu.Reg.HRS.A and $0F;
                                    INC(Wert_n);

                                    {
                                    S is set if result is negative; reset otherwise
                                    Z is set if result is zero; reset otherwise
                                    H is set if carry from bit 3; reset otherwise
                                    P/V is set if r was 7FH before operation; reset otherwise
                                    N is reset
                                    C is not affected
                                    }

                                    // P/V is set if r was 7FH before operation; reset otherwise
                                    if mod_cpu.Reg.HRS.A=$7F then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                                    // INC
                                    INC(mod_cpu.Reg.HRS.A);


                                    // S is set if result is negative; reset otherwise
                                    Sign_Flag_negative(mod_cpu.Reg.HRS.A);

                                    // Z is set if result is zero; reset otherwise
                                    Zero_Flag_zero(mod_cpu.Reg.HRS.A);

                                    // H is set if carry from bit 3; reset otherwise
                                   if ((Wert_n) and $10) = 0 then
                                     mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                                   else
                                     mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                                   // N is reset
                                   Num_Flag_Reset;


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'INC A';
                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // INC A


                      // INC B
                      %00000000 : begin

                                    Wert_n := mod_cpu.Reg.HRS.B and $0F;
                                    INC(Wert_n);

                                    {
                                    S is set if result is negative; reset otherwise
                                    Z is set if result is zero; reset otherwise
                                    H is set if carry from bit 3; reset otherwise
                                    P/V is set if r was 7FH before operation; reset otherwise
                                    N is reset
                                    C is not affected
                                    }

                                    // P/V is set if r was 7FH before operation; reset otherwise
                                    if mod_cpu.Reg.HRS.B=$7F then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                                    // INC
                                    INC(mod_cpu.Reg.HRS.B);


                                    // S is set if result is negative; reset otherwise
                                    Sign_Flag_negative(mod_cpu.Reg.HRS.B);

                                    // Z is set if result is zero; reset otherwise
                                    Zero_Flag_zero(mod_cpu.Reg.HRS.B);

                                    // H is set if carry from bit 3; reset otherwise
                                   if ((Wert_n) and $10) = 0 then
                                     mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                                   else
                                     mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                                   // N is reset
                                   Num_Flag_Reset;


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'INC B';
                                      Form_cpu.Reg_Red.HRS.B:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // INC B


                      // INC C
                      %00001000 : begin

                                    Wert_n := mod_cpu.Reg.HRS.C and $0F;
                                    INC(Wert_n);

                                    {
                                    S is set if result is negative; reset otherwise
                                    Z is set if result is zero; reset otherwise
                                    H is set if carry from bit 3; reset otherwise
                                    P/V is set if r was 7FH before operation; reset otherwise
                                    N is reset
                                    C is not affected
                                    }

                                    // P/V is set if r was 7FH before operation; reset otherwise
                                    if mod_cpu.Reg.HRS.C=$7F then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                                    // INC
                                    INC(mod_cpu.Reg.HRS.C);


                                    // S is set if result is negative; reset otherwise
                                    Sign_Flag_negative(mod_cpu.Reg.HRS.C);

                                    // Z is set if result is zero; reset otherwise
                                    Zero_Flag_zero(mod_cpu.Reg.HRS.C);

                                    // H is set if carry from bit 3; reset otherwise
                                   if ((Wert_n) and $10) = 0 then
                                     mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                                   else
                                     mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                                   // N is reset
                                   Num_Flag_Reset;


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'INC C';
                                      Form_cpu.Reg_Red.HRS.C:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // INC C



                      // INC D
                      %00010000 : begin

                                    Wert_n := mod_cpu.Reg.HRS.D and $0F;
                                    INC(Wert_n);

                                    {
                                    S is set if result is negative; reset otherwise
                                    Z is set if result is zero; reset otherwise
                                    H is set if carry from bit 3; reset otherwise
                                    P/V is set if r was 7FH before operation; reset otherwise
                                    N is reset
                                    C is not affected
                                    }

                                    // P/V is set if r was 7FH before operation; reset otherwise
                                    if mod_cpu.Reg.HRS.D=$7F then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                                    // INC
                                    INC(mod_cpu.Reg.HRS.D);


                                    // S is set if result is negative; reset otherwise
                                    Sign_Flag_negative(mod_cpu.Reg.HRS.D);

                                    // Z is set if result is zero; reset otherwise
                                    Zero_Flag_zero(mod_cpu.Reg.HRS.D);

                                    // H is set if carry from bit 3; reset otherwise
                                   if ((Wert_n) and $10) = 0 then
                                     mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                                   else
                                     mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                                   // N is reset
                                   Num_Flag_Reset;


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'INC D';
                                      Form_cpu.Reg_Red.HRS.D:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // INC D



                      // INC E
                      %00011000 : begin

                                    Wert_n := mod_cpu.Reg.HRS.E and $0F;
                                    INC(Wert_n);

                                    {
                                    S is set if result is negative; reset otherwise
                                    Z is set if result is zero; reset otherwise
                                    H is set if carry from bit 3; reset otherwise
                                    P/V is set if r was 7FH before operation; reset otherwise
                                    N is reset
                                    C is not affected
                                    }

                                    // P/V is set if r was 7FH before operation; reset otherwise
                                    if mod_cpu.Reg.HRS.E=$7F then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                                    // INC
                                    INC(mod_cpu.Reg.HRS.E);


                                    // S is set if result is negative; reset otherwise
                                    Sign_Flag_negative(mod_cpu.Reg.HRS.E);

                                    // Z is set if result is zero; reset otherwise
                                    Zero_Flag_zero(mod_cpu.Reg.HRS.E);

                                    // H is set if carry from bit 3; reset otherwise
                                   if ((Wert_n) and $10) = 0 then
                                     mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                                   else
                                     mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                                   // N is reset
                                   Num_Flag_Reset;


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'INC E';
                                      Form_cpu.Reg_Red.HRS.E:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // INC E



                      // INC H
                      %00100000 : begin

                                    Wert_n := mod_cpu.Reg.HRS.H and $0F;
                                    INC(Wert_n);

                                    {
                                    S is set if result is negative; reset otherwise
                                    Z is set if result is zero; reset otherwise
                                    H is set if carry from bit 3; reset otherwise
                                    P/V is set if r was 7FH before operation; reset otherwise
                                    N is reset
                                    C is not affected
                                    }

                                    // P/V is set if r was 7FH before operation; reset otherwise
                                    if mod_cpu.Reg.HRS.H=$7F then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                                    // INC
                                    INC(mod_cpu.Reg.HRS.H);


                                    // S is set if result is negative; reset otherwise
                                    Sign_Flag_negative(mod_cpu.Reg.HRS.H);

                                    // Z is set if result is zero; reset otherwise
                                    Zero_Flag_zero(mod_cpu.Reg.HRS.H);

                                    // H is set if carry from bit 3; reset otherwise
                                   if ((Wert_n) and $10) = 0 then
                                     mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                                   else
                                     mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                                   // N is reset
                                   Num_Flag_Reset;


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'INC H';
                                      Form_cpu.Reg_Red.HRS.H:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // INC H




                      // INC L
                      %00101000 : begin

                                    Wert_n := mod_cpu.Reg.HRS.L and $0F;
                                    INC(Wert_n);

                                    {
                                    S is set if result is negative; reset otherwise
                                    Z is set if result is zero; reset otherwise
                                    H is set if carry from bit 3; reset otherwise
                                    P/V is set if r was 7FH before operation; reset otherwise
                                    N is reset
                                    C is not affected
                                    }

                                    // P/V is set if r was 7FH before operation; reset otherwise
                                    if mod_cpu.Reg.HRS.L=$7F then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                                    // INC
                                    INC(mod_cpu.Reg.HRS.L);


                                    // S is set if result is negative; reset otherwise
                                    Sign_Flag_negative(mod_cpu.Reg.HRS.L);

                                    // Z is set if result is zero; reset otherwise
                                    Zero_Flag_zero(mod_cpu.Reg.HRS.L);

                                    // H is set if carry from bit 3; reset otherwise
                                   if ((Wert_n) and $10) = 0 then
                                     mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                                   else
                                     mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                                   // N is reset
                                   Num_Flag_Reset;


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'INC L';
                                      Form_cpu.Reg_Red.HRS.L:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // INC L




                      // INC (HL)
                      %00110000 : begin

                                    Wert_Word := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;
                                    Wert_n := mod_ram.Read_Byte(Wert_Word); // (HL) -> Wert_n

                                    Wert_n2 := Wert_n and $0F;
                                    INC(Wert_n2);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Form_RAM.setze_Mem_Green(Wert_Word);    // HL
                                    end;
                                    {$ENDIF}

                                    {
                                    S is set if result is negative; reset otherwise
                                    Z is set if result is zero; reset otherwise
                                    H is set if carry from bit 3; reset otherwise
                                    P/V is set if (HL) was 7FH before operation; reset otherwise
                                    N is reset
                                    C is not affected
                                    }

                                    // P/V is set if r was 7FH before operation; reset otherwise
                                    if Wert_n=$7F then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                                    // INC
                                    INC(Wert_n);


                                    // S is set if result is negative; reset otherwise
                                    Sign_Flag_negative(Wert_n);

                                    // Z is set if result is zero; reset otherwise
                                    Zero_Flag_zero(Wert_n);

                                    // H is set if carry from bit 3; reset otherwise
                                   if ((Wert_n2) and $10) = 0 then
                                     mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                                   else
                                     mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                                   // N is reset
                                   Num_Flag_Reset;

                                   mod_ram.Write_Byte((mod_cpu.Reg.HRS.H shl 8) +
                                                       mod_cpu.Reg.HRS.L, Wert_n);


                                   {$IFDEF mit_GUI}
                                   if Mode_Protokoll then begin

                                     Befehl_Zeile := 'INC (HL)  ; '+IntToHex(Wert_n,2)+'H';
                                     Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                     Form_cpu.Reg_Red.HRS.HL:=Farbe_Lesen;
                                     Form_cpu.Reg_Red.HRS.HL_Inhalt:=Farbe_Schreiben;

                                   end; { if Mode_Protokoll then }
                                   {$ENDIF}

                                   Befehl_abgearbeitet:=true;

                                 end; // INC (HL)


                    end; { case ziel_reg of }

                  end; { %00000100 }





      // DEC r
      %00000101 : begin

                    ziel_reg := OP_Code AND %00111000;

                    case ziel_reg of

                      // DEC A
                      %00111000 : begin

                                    Wert_n := mod_cpu.Reg.HRS.A and $0F;
                                    DEC(Wert_n);

                                    {
                                    S is set if result is negative; reset otherwise
                                    Z is set if result is zero; reset otherwise
                                    H is set if borrow from bit 4, reset otherwise
                                    P/V is set if m was 80H before operation; reset otherwise
                                    N is set
                                    C is not affected

                                    }

                                    // P/V is set if m was 80H before operation; reset otherwise
                                    if mod_cpu.Reg.HRS.A=$80 then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                                    // DEC
                                    DEC(mod_cpu.Reg.HRS.A);


                                    // S is set if result is negative; reset otherwise
                                    Sign_Flag_negative(mod_cpu.Reg.HRS.A);

                                    // Z is set if result is zero; reset otherwise
                                    Zero_Flag_zero(mod_cpu.Reg.HRS.A);

                                    // H is set if borrow from bit 4, reset otherwise
                                    if ((Wert_n) and $10) = 0 then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                                    // N is set
                                    Num_Flag_Set;


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'DEC A';
                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // DEC A




                      // DEC B
                      %00000000 : begin

                                    Wert_n := mod_cpu.Reg.HRS.B and $0F;
                                    DEC(Wert_n);

                                    {
                                    S is set if result is negative; reset otherwise
                                    Z is set if result is zero; reset otherwise
                                    H is set if borrow from bit 4, reset otherwise
                                    P/V is set if m was 80H before operation; reset otherwise
                                    N is set
                                    C is not affected

                                    }

                                    // P/V is set if m was 80H before operation; reset otherwise
                                    if mod_cpu.Reg.HRS.B=$80 then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                                    // DEC
                                    DEC(mod_cpu.Reg.HRS.B);


                                    // S is set if result is negative; reset otherwise
                                    Sign_Flag_negative(mod_cpu.Reg.HRS.B);

                                    // Z is set if result is zero; reset otherwise
                                    Zero_Flag_zero(mod_cpu.Reg.HRS.B);

                                    // H is set if borrow from bit 4, reset otherwise
                                    if ((Wert_n) and $10) = 0 then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                                    // N is set
                                    Num_Flag_Set;


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'DEC B';
                                      Form_cpu.Reg_Red.HRS.B:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // DEC B



                      // DEC C
                      %00001000 : begin

                                    Wert_n := mod_cpu.Reg.HRS.C and $0F;
                                    DEC(Wert_n);

                                    {
                                    S is set if result is negative; reset otherwise
                                    Z is set if result is zero; reset otherwise
                                    H is set if borrow from bit 4, reset otherwise
                                    P/V is set if m was 80H before operation; reset otherwise
                                    N is set
                                    C is not affected

                                    }

                                    // P/V is set if m was 80H before operation; reset otherwise
                                    if mod_cpu.Reg.HRS.C=$80 then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                                    // DEC
                                    DEC(mod_cpu.Reg.HRS.C);


                                    // S is set if result is negative; reset otherwise
                                    Sign_Flag_negative(mod_cpu.Reg.HRS.C);

                                    // Z is set if result is zero; reset otherwise
                                    Zero_Flag_zero(mod_cpu.Reg.HRS.C);

                                    // H is set if borrow from bit 4, reset otherwise
                                    if ((Wert_n) and $10) = 0 then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                                    // N is set
                                    Num_Flag_Set;


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'DEC C';
                                      Form_cpu.Reg_Red.HRS.C:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // DEC C




                      // DEC D
                      %00010000 : begin

                                    Wert_n := mod_cpu.Reg.HRS.D and $0F;
                                    DEC(Wert_n);

                                    {
                                    S is set if result is negative; reset otherwise
                                    Z is set if result is zero; reset otherwise
                                    H is set if borrow from bit 4, reset otherwise
                                    P/V is set if m was 80H before operation; reset otherwise
                                    N is set
                                    C is not affected

                                    }

                                    // P/V is set if m was 80H before operation; reset otherwise
                                    if mod_cpu.Reg.HRS.D=$80 then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                                    // DEC
                                    DEC(mod_cpu.Reg.HRS.D);


                                    // S is set if result is negative; reset otherwise
                                    Sign_Flag_negative(mod_cpu.Reg.HRS.D);

                                    // Z is set if result is zero; reset otherwise
                                    Zero_Flag_zero(mod_cpu.Reg.HRS.D);

                                    // H is set if borrow from bit 4, reset otherwise
                                    if ((Wert_n) and $10) = 0 then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                                    // N is set
                                    Num_Flag_Set;


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'DEC D';
                                      Form_cpu.Reg_Red.HRS.D:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // DEC D




                      // DEC E
                      %00011000 : begin

                                    Wert_n := mod_cpu.Reg.HRS.E and $0F;
                                    DEC(Wert_n);

                                    {
                                    S is set if result is negative; reset otherwise
                                    Z is set if result is zero; reset otherwise
                                    H is set if borrow from bit 4, reset otherwise
                                    P/V is set if m was 80H before operation; reset otherwise
                                    N is set
                                    C is not affected

                                    }

                                    // P/V is set if m was 80H before operation; reset otherwise
                                    if mod_cpu.Reg.HRS.E=$80 then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                                    // DEC
                                    DEC(mod_cpu.Reg.HRS.E);


                                    // S is set if result is negative; reset otherwise
                                    Sign_Flag_negative(mod_cpu.Reg.HRS.E);

                                    // Z is set if result is zero; reset otherwise
                                    Zero_Flag_zero(mod_cpu.Reg.HRS.E);

                                    // H is set if borrow from bit 4, reset otherwise
                                    if ((Wert_n) and $10) = 0 then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                                    // N is set
                                    Num_Flag_Set;


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'DEC E';
                                      Form_cpu.Reg_Red.HRS.E:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // DEC E


                      // DEC H
                      %00100000 : begin

                                    Wert_n := mod_cpu.Reg.HRS.H and $0F;
                                    DEC(Wert_n);

                                    {
                                    S is set if result is negative; reset otherwise
                                    Z is set if result is zero; reset otherwise
                                    H is set if borrow from bit 4, reset otherwise
                                    P/V is set if m was 80H before operation; reset otherwise
                                    N is set
                                    C is not affected

                                    }

                                    // P/V is set if m was 80H before operation; reset otherwise
                                    if mod_cpu.Reg.HRS.H=$80 then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                                    // DEC
                                    DEC(mod_cpu.Reg.HRS.H);


                                    // S is set if result is negative; reset otherwise
                                    Sign_Flag_negative(mod_cpu.Reg.HRS.H);

                                    // Z is set if result is zero; reset otherwise
                                    Zero_Flag_zero(mod_cpu.Reg.HRS.H);

                                    // H is set if borrow from bit 4, reset otherwise
                                    if ((Wert_n) and $10) = 0 then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                                    // N is set
                                    Num_Flag_Set;


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'DEC H';
                                      Form_cpu.Reg_Red.HRS.H:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // DEC H



                      // DEC L
                      %00101000 : begin

                                    Wert_n := mod_cpu.Reg.HRS.L and $0F;
                                    DEC(Wert_n);

                                    {
                                    S is set if result is negative; reset otherwise
                                    Z is set if result is zero; reset otherwise
                                    H is set if borrow from bit 4, reset otherwise
                                    P/V is set if m was 80H before operation; reset otherwise
                                    N is set
                                    C is not affected

                                    }

                                    // P/V is set if m was 80H before operation; reset otherwise
                                    if mod_cpu.Reg.HRS.L=$80 then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                                    // DEC
                                    DEC(mod_cpu.Reg.HRS.L);


                                    // S is set if result is negative; reset otherwise
                                    Sign_Flag_negative(mod_cpu.Reg.HRS.L);

                                    // Z is set if result is zero; reset otherwise
                                    Zero_Flag_zero(mod_cpu.Reg.HRS.L);

                                    // H is set if borrow from bit 4, reset otherwise
                                    if ((Wert_n) and $10) = 0 then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                                    // N is set
                                    Num_Flag_Set;


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'DEC L';
                                      Form_cpu.Reg_Red.HRS.L:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // DEC L




                      // DEC (HL)
                      %00110000 : begin

                                    Wert_Word := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;
                                    Wert_n := mod_ram.Read_Byte(Wert_Word); // (HL) -> Wert_n

                                    Wert_n2 := Wert_n and $0F;
                                    DEC(Wert_n2);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Form_RAM.setze_Mem_Green(Wert_Word);    // HL
                                    end;
                                    {$ENDIF}

                                    {
                                    S is set if result is negative; reset otherwise
                                    Z is set if result is zero; reset otherwise
                                    H is set if borrow from bit 4, reset otherwise
                                    P/V is set if m was 80H before operation; reset otherwise
                                    N is set
                                    C is not affected
                                    }

                                    // P/V is set if m was 80H before operation; reset otherwise
                                    if Wert_n=$80 then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                                    else
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                                    // DEC
                                    DEC(Wert_n);


                                    // S is set if result is negative; reset otherwise
                                    Sign_Flag_negative(Wert_n);

                                    // Z is set if result is zero; reset otherwise
                                    Zero_Flag_zero(Wert_n);

                                    // H is set if borrow from bit 4, reset otherwise
                                    if ((Wert_n2) and $10) = 0 then
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                                    else
                                     mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                                    // N is set
                                    Num_Flag_Set;

                                    mod_ram.Write_Byte((mod_cpu.Reg.HRS.H shl 8) +
                                                        mod_cpu.Reg.HRS.L, Wert_n);


                                    // Anzeige von (HL) nach der INC-Operation !!!
                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'DEC (HL)  ; '+IntToHex(Wert_n,2)+'H';
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.HL:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.HL_Inhalt:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // INC (HL)



                    end; { case ziel_reg of }

                  end; { %00000101 }






    else { case OP_Code2 of }

      OP_Code2 := OP_Code AND %00001111;

      case OP_Code2 of

        // LD dd, nn
        %00000001 : begin

                      {$IFDEF mit_GUI}
                      if Mode_Protokoll then
                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                      {$ENDIF}

                      Wert_n :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                      INC(mod_cpu.Reg.SRS.PC);

                      {$IFDEF mit_GUI}
                      if Mode_Protokoll then
                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                      {$ENDIF}

                      Wert_n2 :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                      INC(mod_cpu.Reg.SRS.PC);

                      ziel_reg :=  OP_Code AND %00110000;

                      case ziel_reg of

                        // BC, nn
                        %00000000 : begin
                                      {
                                      Condition Bits Affected: None
                                      }

                                      mod_cpu.Reg.HRS.B := Wert_n2;
                                      mod_cpu.Reg.HRS.C := Wert_n;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Befehl_Zeile := 'LD BC, '+IntToHex(Wert_n2,2)+
                                        IntToHex(Wert_n,2)+'H';

                                        Form_cpu.Reg_Red.HRS.BC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                    end; // BC, nn


                        // DE, nn
                        %00010000 : begin
                                      {
                                      Condition Bits Affected: None
                                      }

                                      mod_cpu.Reg.HRS.D := Wert_n2;
                                      mod_cpu.Reg.HRS.E := Wert_n;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Befehl_Zeile := 'LD DE, '+IntToHex(Wert_n2,2)+
                                        IntToHex(Wert_n,2)+'H';

                                        Form_cpu.Reg_Red.HRS.DE:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                    end; // DE, nn


                        // HL, nn
                        %00100000 : begin
                                      {
                                      Condition Bits Affected: None
                                      }

                                      mod_cpu.Reg.HRS.H := Wert_n2;
                                      mod_cpu.Reg.HRS.L := Wert_n;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Befehl_Zeile := 'LD HL, '+IntToHex(Wert_n2,2)+
                                        IntToHex(Wert_n,2)+'H';

                                        Form_cpu.Reg_Red.HRS.HL:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                    end; // HL, nn


                        // SP, nn
                        %00110000 : begin
                                      {
                                      Condition Bits Affected: None
                                      }

                                      mod_cpu.Reg.SRS.SP := (Wert_n2 shl 8) + Wert_n;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Befehl_Zeile := 'LD SP, '+
                                        IntToHex((Wert_n2 shl 8) + Wert_n,4)+'H';

                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}
                                      Befehl_abgearbeitet:=true;

                                    end; // SP, nn

                      end; { case ziel_reg of }


                    end; // LD dd, nn



        // INC ss
        %00000011 : begin

                      ziel_reg :=  OP_Code AND %00110000;

                      case ziel_reg of

                        // INC BC
                        %00000000 : begin
                                      {
                                      Condition Bits Affected: None
                                      }

                                      Wert_Word := (mod_cpu.Reg.HRS.B shl 8) + mod_cpu.Reg.HRS.C;

                                      INC(Wert_Word);

                                      mod_cpu.Reg.HRS.B := Wert_Word shr 8;
                                      mod_cpu.Reg.HRS.C := Wert_Word and $00FF;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Befehl_Zeile := 'INC BC';

                                        Form_cpu.Reg_Red.HRS.BC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                    end; // INC BC


                        // INC DE
                        %00010000 : begin
                                      {
                                      Condition Bits Affected: None
                                      }

                                      Wert_Word := (mod_cpu.Reg.HRS.D shl 8) + mod_cpu.Reg.HRS.E;

                                      INC(Wert_Word);

                                      mod_cpu.Reg.HRS.D := Wert_Word shr 8;
                                      mod_cpu.Reg.HRS.E := Wert_Word and $00FF;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Befehl_Zeile := 'INC DE';

                                        Form_cpu.Reg_Red.HRS.DE:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}
                                      Befehl_abgearbeitet:=true;

                                    end; // INC DE



                        // INC HL
                        %00100000 : begin
                                      {
                                      Condition Bits Affected: None
                                      }

                                      Wert_Word := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;

                                      INC(Wert_Word);

                                      mod_cpu.Reg.HRS.H := Wert_Word shr 8;
                                      mod_cpu.Reg.HRS.L := Wert_Word and $00FF;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Befehl_Zeile := 'INC HL';

                                        Form_cpu.Reg_Red.HRS.HL:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                    end; // INC HL


                        // INC SP
                        %00110000 : begin
                                      {
                                      Condition Bits Affected: None
                                      }

                                      INC(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Befehl_Zeile := 'INC SP';

                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                    end; // INC SP

                      end; { case ziel_reg of }


                    end; // INC ss




        // ADD HL, ss
        %00001001 : begin

                      ziel_reg :=  OP_Code AND %00110000;

                      case ziel_reg of

                        // ADD HL, BC
                        %00000000 : begin

                                      {
                                      S is not affected
                                      Z is not affected
                                      H is set if carry out of bit 11; reset otherwise
                                      P/V is not affected
                                      N is reset
                                      C is set if carry from bit 15; reset otherwise
                                      }

                                      Wert_Word  := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;
                                      Wert_Word2 := (mod_cpu.Reg.HRS.B shl 8) + mod_cpu.Reg.HRS.C;

                                      // H is set if carry out of bit 11; reset otherwise
                                      HalfCarry_ADD16(Wert_Word, Wert_Word2);

                                      // C is set if carry from bit 15; reset otherwise
                                      Carry_Flag_set_if_carry_from_bit_15(Wert_Word + Wert_Word2);

                                      // ADD HL, BC
                                      Wert_Word := Wert_Word + Wert_Word2;

                                      mod_cpu.Reg.HRS.H := Wert_Word shr 8;
                                      mod_cpu.Reg.HRS.L := Wert_Word and $00FF;

                                      // N is reset
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'ADD HL, BC';

                                        Form_cpu.Reg_Red.HRS.HL:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.HRS.BC:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                    end; // ADD HL, BC



                        // ADD HL, DE
                        %00010000 : begin

                                      {
                                      S is not affected
                                      Z is not affected
                                      H is set if carry out of bit 11; reset otherwise
                                      P/V is not affected
                                      N is reset
                                      C is set if carry from bit 15; reset otherwise
                                      }

                                      Wert_Word  := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;
                                      Wert_Word2 := (mod_cpu.Reg.HRS.D shl 8) + mod_cpu.Reg.HRS.E;

                                      // H is set if carry out of bit 11; reset otherwise
                                      HalfCarry_ADD16(Wert_Word, Wert_Word2);

                                      // C is set if carry from bit 15; reset otherwise
                                      Carry_Flag_set_if_carry_from_bit_15(Wert_Word + Wert_Word2);

                                      // ADD HL, DE
                                      Wert_Word := Wert_Word + Wert_Word2;

                                      mod_cpu.Reg.HRS.H := Wert_Word shr 8;
                                      mod_cpu.Reg.HRS.L := Wert_Word and $00FF;

                                      // N is reset
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'ADD HL, DE';

                                        Form_cpu.Reg_Red.HRS.HL:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.HRS.DE:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                    end; // ADD HL, DE



                        // ADD HL, HL
                        %00100000 : begin

                                      {
                                      S is not affected
                                      Z is not affected
                                      H is set if carry out of bit 11; reset otherwise
                                      P/V is not affected
                                      N is reset
                                      C is set if carry from bit 15; reset otherwise
                                      }


                                      Wert_Word  := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;
                                      Wert_Word2 := Wert_Word;


                                      // H is set if carry out of bit 11; reset otherwise
                                      HalfCarry_ADD16(Wert_Word, Wert_Word2);

                                      // C is set if carry from bit 15; reset otherwise
                                      Carry_Flag_set_if_carry_from_bit_15(Wert_Word + Wert_Word2);


                                      Wert_Word := Wert_Word + Wert_Word2;

                                      mod_cpu.Reg.HRS.H := Wert_Word shr 8;
                                      mod_cpu.Reg.HRS.L := Wert_Word and $00FF;

                                      // N is reset
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'ADD HL, HL';

                                        Form_cpu.Reg_Red.HRS.HL:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                    end; // ADD HL, HL


                        // ADD HL, SP
                        %00110000 : begin

                                      {
                                      S is not affected
                                      Z is not affected
                                      H is set if carry out of bit 11; reset otherwise
                                      P/V is not affected
                                      N is reset
                                      C is set if carry from bit 15; reset otherwise
                                      }


                                      Wert_Word  := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;
                                      Wert_Word2 := mod_cpu.Reg.SRS.SP;


                                      // H is set if carry out of bit 11; reset otherwise
                                      HalfCarry_ADD16(Wert_Word, Wert_Word2);

                                      // C is set if carry from bit 15; reset otherwise
                                      Carry_Flag_set_if_carry_from_bit_15(Wert_Word + Wert_Word2);


                                      Wert_Word := Wert_Word + Wert_Word2;

                                      mod_cpu.Reg.HRS.H := Wert_Word shr 8;
                                      mod_cpu.Reg.HRS.L := Wert_Word and $00FF;

                                      // N is reset
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'ADD HL, SP';

                                        Form_cpu.Reg_Red.HRS.HL:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}


                                      Befehl_abgearbeitet:=true;

                                    end; // ADD HL, SP





                      end; { case ziel_reg of }


                    end; // ADD HL, ss





        // DEC ss
        %00001011 : begin
                      {
                      Condition Bits Affected: None
                      }

                      ziel_reg :=  OP_Code AND %00110000;

                      case ziel_reg of

                        // DEC BC
                        %00000000 : begin

                                      Wert_Word := (mod_cpu.Reg.HRS.B shl 8) + mod_cpu.Reg.HRS.C;

                                      DEC(Wert_Word);

                                      mod_cpu.Reg.HRS.B := Wert_Word shr 8;
                                      mod_cpu.Reg.HRS.C := Wert_Word and $00FF;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'DEC BC';

                                        Form_cpu.Reg_Red.HRS.BC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                    end; // DEC BC



                        // DEC DE
                        %00010000 : begin

                                      Wert_Word := (mod_cpu.Reg.HRS.D shl 8) + mod_cpu.Reg.HRS.E;

                                      DEC(Wert_Word);

                                      mod_cpu.Reg.HRS.D := Wert_Word shr 8;
                                      mod_cpu.Reg.HRS.E := Wert_Word and $00FF;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'DEC DE';

                                        Form_cpu.Reg_Red.HRS.DE:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                    end; // DEC DE




                        // DEC HL
                        %00100000 : begin

                                      Wert_Word := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;

                                      DEC(Wert_Word);

                                      mod_cpu.Reg.HRS.H := Wert_Word shr 8;
                                      mod_cpu.Reg.HRS.L := Wert_Word and $00FF;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'DEC HL';

                                        Form_cpu.Reg_Red.HRS.HL:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                    end; // DEC HL



                        // DEC SP
                        %00110000 : begin

                                      DEC(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'DEC SP';

                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                    end; // DEC SP




                      end; { case ziel_reg of }


                    end; // DEC ss




      else { case OP_Code2 of }


        case OP_Code of

          // NOP
          00 : begin
                 {$IFDEF mit_GUI}
                 if Mode_Protokoll then begin
                   Befehl_Zeile := 'NOP'
                 end; { if Mode_Protokoll then }
                 {$ENDIF}
                 Befehl_abgearbeitet:=true;
               end;


          // LD (BC), A
          $02 : begin
                  {
                  Condition Bits Affected: None
                  }
                  mod_ram.Write_Byte((mod_cpu.Reg.HRS.B shl 8) + mod_cpu.Reg.HRS.C, mod_cpu.Reg.HRS.A);
                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin
                    Befehl_Zeile := 'LD (BC), A';
                    Form_RAM.setze_Mem_Red((mod_cpu.Reg.HRS.B shl 8) + mod_cpu.Reg.HRS.C);
                    Form_cpu.Reg_Red.HRS.BC:=Farbe_Lesen;
                    Form_cpu.Reg_Red.HRS.BC_Inhalt:=Farbe_Schreiben;
                    Form_cpu.Reg_Red.HRS.A:=Farbe_Lesen;
                  end; { if Mode_Protokoll then }
                  {$ENDIF}
                 Befehl_abgearbeitet:=true;
                end; { $02 }




          // RLCA = Rotate Left with CarryAccumulator
          $07 : begin

                  if (mod_cpu.Reg.HRS.A and %10000000) = %10000000 then begin

                    // Rotation von A und setzen Bit 0 (da Bit 7 vorher 1 war)
                    mod_cpu.Reg.HRS.A := (mod_cpu.Reg.HRS.A shl 1) or %00000001;

                    // C is set
                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }

                  end
                  else begin

                    // Rotation von A und ruecksetzen Bit 0 (da Bit 7 vorher 0 war)
                    mod_cpu.Reg.HRS.A := (mod_cpu.Reg.HRS.A shl 1) and %11111110;

                    // C is reset
                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }

                  end; { if (mod_cpu.Reg.HRS.A and %10000000) = %10000000 then }

                  {
                  S is not affected
                  Z is not affected
                  H is reset
                  P/V is not affected
                  N is reset
                  C is data from bit 7 of Accumulator
                  }

                  // H is reset
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

                  // N is reset
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }


                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin

                    if (mod_cpu.Reg.HRS.F and %00000001) = 0 then
                      Befehl_Zeile := 'RLCA  ; CY=0'
                    else
                      Befehl_Zeile := 'RLCA  ; CY=1';

                    Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                    Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                  end; { if Mode_Protokoll then }
                  {$ENDIF}

                 Befehl_abgearbeitet:=true;

                end; { RLCA }



          // EX AF, AF2
          $08 : begin

                  Wert_n := mod_cpu.Reg.HRS.F;
                  mod_cpu.Reg.HRS.F := mod_cpu.Reg.ARS.F;
                  mod_cpu.Reg.ARS.F := Wert_n;

                  Wert_n := mod_cpu.Reg.HRS.A;
                  mod_cpu.Reg.HRS.A := mod_cpu.Reg.ARS.A;
                  mod_cpu.Reg.ARS.A := Wert_n;

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin

                    Befehl_Zeile := 'EX AF, AF';

                    Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                    Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                    Form_cpu.Reg_Red.ARS.A:=Farbe_Schreiben;
                    Form_cpu.Reg_Red.ARS.F:=Farbe_Schreiben;

                  end; { if Mode_Protokoll then }
                  {$ENDIF}

                  Befehl_abgearbeitet:=true;

                end; { $08 }



 //         aaa



          // RRCA = Rotate Right with CarryAccumulator
          $0F : begin

                  if (mod_cpu.Reg.HRS.A and %00000001) = %00000001 then begin

                    // Rotation von A nach rechts und setzen Bit 7 (da Bit 0 vorher 1 war)
                    mod_cpu.Reg.HRS.A := (mod_cpu.Reg.HRS.A shr 1) or %10000000;

                    // C is set
                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }

                  end
                  else begin

                    // Rotation von A und ruecksetzen Bit 0 (da Bit 7 vorher 0 war)
                    mod_cpu.Reg.HRS.A := (mod_cpu.Reg.HRS.A shr 1) and %01111111;

                    // C is reset
                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }

                  end; { if (mod_cpu.Reg.HRS.A and %10000000) = %10000000 then }

                  {
                  S Not affected.
                  Z Not affected.
                  H Reset.
                  P/V Not affected.
                  N Reset.
                  C Data from bit 0 of the accumulator.
                  }

                  // H is reset
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

                  // N is reset
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }


                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin

                    if (mod_cpu.Reg.HRS.F and %00000001) = 0 then
                      Befehl_Zeile := 'RRCA  ; CY=0'
                    else
                      Befehl_Zeile := 'RRCA  ; CY=1';

                    Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                    Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                  end; { if Mode_Protokoll then }
                  {$ENDIF}

                 Befehl_abgearbeitet:=true;

                end; { RRCA }




                // DJNZ e -> Decrement B Jump not 0
          $10 : begin
                  {
                  The B register decrements by 1.
                  If the resultant value in register B is not 0, the twos-complement
                  displacement d is added to the value of the Program Counter.
                  The jump is measured from the address of the instruction
                  opcode following this instruction.
                  }

                  {
                  Condition Bits Affected: None
                  }

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then
                    Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                  {$ENDIF}

                  displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                  INC(mod_cpu.Reg.SRS.PC);

                  // DEC B
                  DEC(mod_cpu.Reg.HRS.B);

                  // Sprung wenn B ungleich 0
                  if mod_cpu.Reg.HRS.B<>0 then begin

                    if displacement>127 then
                      mod_cpu.Reg.SRS.PC := mod_cpu.Reg.SRS.PC - (256 - displacement)
                    else
                      mod_cpu.Reg.SRS.PC := mod_cpu.Reg.SRS.PC + displacement; // (PC +- d)

                  end; { if mod_cpu.Reg.HRS.B<>0 then  }

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin

                    if mod_cpu.Reg.HRS.B<>0 then begin

                      if displacement>127 then
                        Befehl_Zeile := 'DJNZ -'+IntToHex(256 - displacement,2)+'H  ; Sprung zurueck -> '+
                                        IntToHex(mod_cpu.Reg.SRS.PC,4)+'H'
                      else
                        Befehl_Zeile := 'DJNZ '+IntToHex(displacement,2)+'H  ; Sprung vor -> '+
                                        IntToHex(mod_cpu.Reg.SRS.PC,4)+'H';

                      Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                    end { if mod_cpu.Reg.HRS.B<>0  }
                    else begin

                      if displacement>127 then
                        Befehl_Zeile := 'DJNZ -'+IntToHex(256 - displacement,2)+'H  ; kein Sprung'
                      else
                        Befehl_Zeile := 'DJNZ '+IntToHex(displacement,2)+'H  ; kein Sprung';

                    end; { else mod_cpu.Reg.HRS.B<>0 }

                    Form_cpu.Reg_Red.HRS.B:=Farbe_Schreiben;

                  end; { if Mode_Protokoll then }
                  {$ENDIF}

                  Befehl_abgearbeitet:=true;

                end;  // DJNZ e






          // LD (DE), A
          $12 : begin
                  mod_ram.Write_Byte((mod_cpu.Reg.HRS.D shl 8) + mod_cpu.Reg.HRS.E, mod_cpu.Reg.HRS.A);
                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin
                    Befehl_Zeile := 'LD (DE), A';
                    Form_RAM.setze_Mem_Red((mod_cpu.Reg.HRS.D shl 8) + mod_cpu.Reg.HRS.E);
                    Form_cpu.Reg_Red.HRS.DE:=Farbe_Lesen;
                    Form_cpu.Reg_Red.HRS.DE_Inhalt:=Farbe_Schreiben;
                    Form_cpu.Reg_Red.HRS.A:=Farbe_Lesen;
                  end; { if Mode_Protokoll then }
                  {$ENDIF}
                  Befehl_abgearbeitet:=true;
                end; { $12 }




          // RLA = Rotate Left Accumulator
          $17 : begin

                  if (mod_cpu.Reg.HRS.A and %10000000) = %10000000 then begin

                    // Rotation von A nach links
                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A shl 1;

                    if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then
                      mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A or %00000001  // setzen von Bit 0, da
                                                                           // CY = 1
                    else
                      mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A and %11111110; // ruecksetzen von Bit 0, da
                                                                            // CY = 0

                    // C is set, da Bit 7 in A vorher 1 war ( Bit 7 -> CY )
                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }

                  end
                  else begin

                    // Rotation von A nach links
                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A shl 1;

                    if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then
                      mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A or %00000001  // setzen von Bit 0, da
                                                                           // CY = 1
                    else
                      mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A and %11111110; // ruecksetzen von Bit 0, da
                                                                            // CY = 0

                    // C is reset
                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }

                  end; { if (mod_cpu.Reg.HRS.A and %10000000) = %10000000 then }

                  {
                  S Not affected.
                  Z Not affected.
                  H Reset.
                  P/V Not affected.
                  N Reset.
                  C Data from bit 7 of the accumulator.
                  }

                  // H is reset
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

                  // N is reset
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }


                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin

                    if (mod_cpu.Reg.HRS.F and %00000001) = 0 then
                      Befehl_Zeile := 'RLA  ; CY=0'
                    else
                      Befehl_Zeile := 'RLA  ; CY=1';

                    Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                    Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                  end; { if Mode_Protokoll then }
                  {$ENDIF}

                 Befehl_abgearbeitet:=true;

                end; { RLA }





          // JR e
          $18 : begin
                  {
                  Condition Bits Affected: None
                  }

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then
                    Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                  {$ENDIF}

                  displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                  INC(mod_cpu.Reg.SRS.PC);


                  if displacement>127 then
                    mod_cpu.Reg.SRS.PC := mod_cpu.Reg.SRS.PC - (256 - displacement)
                  else
                    mod_cpu.Reg.SRS.PC := mod_cpu.Reg.SRS.PC + displacement; // (PC +- d)


                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin

                    if displacement>127 then
                      Befehl_Zeile := 'JR -'+IntToHex(256 - displacement,2)+'H  ; Sprung zurueck -> '+
                                      IntToHex(mod_cpu.Reg.SRS.PC,4)+'H'
                    else
                      Befehl_Zeile := 'JR '+IntToHex(displacement,2)+'H  ; Sprung vor -> '+
                                      IntToHex(mod_cpu.Reg.SRS.PC,4)+'H';

                    Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                  end;
                  {$ENDIF}

                  Befehl_abgearbeitet:=true;


                end; { JR e }






          // LD A, (BC)
          $0A : begin
                  mod_cpu.Reg.HRS.A := mod_ram.Read_Byte((mod_cpu.Reg.HRS.B shl 8) + mod_cpu.Reg.HRS.C);
                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin
                    Befehl_Zeile := 'LD A,(BC)';
                    Form_RAM.setze_Mem_Green((mod_cpu.Reg.HRS.B shl 8) + mod_cpu.Reg.HRS.C);
                    Form_cpu.Reg_Red.HRS.BC:=Farbe_Lesen;
                    Form_cpu.Reg_Red.HRS.BC_Inhalt:=Farbe_Lesen;
                    Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                  end; { if Mode_Protokoll then }
                  {$ENDIF}
                  Befehl_abgearbeitet:=true;
                end; { $0A }


          // LD A, (DE)
          $1A : begin
                  mod_cpu.Reg.HRS.A := mod_ram.Read_Byte((mod_cpu.Reg.HRS.D shl 8) + mod_cpu.Reg.HRS.E);
                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin
                    Befehl_Zeile := 'LD A,(DE)';
                    Form_RAM.setze_Mem_Green((mod_cpu.Reg.HRS.D shl 8) + mod_cpu.Reg.HRS.E);
                    Form_cpu.Reg_Red.HRS.DE:=Farbe_Lesen;
                    Form_cpu.Reg_Red.HRS.DE_Inhalt:=Farbe_Lesen;
                    Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                  end; { if Mode_Protokoll then }
                  {$ENDIF}
                  Befehl_abgearbeitet:=true;
                end; { $1A }





          // RRA = Rotate RightAccumulator
          $1F : begin

                  if (mod_cpu.Reg.HRS.A and %00000001) = %00000001 then begin

                    // Rotation von A nach rechts
                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A shr 1;

                    if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then
                      mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A or %10000000  // setzen von Bit 7, da
                                                                           // CY = 1
                    else
                      mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A and %01111111; // ruecksetzen von Bit 7, da
                                                                            // CY = 0

                    // C is set, da Bit 0 in A vorher 1 war ( Bit 0 -> CY )
                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }

                  end
                  else begin

                    // Rotation von A nach rechts
                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A shr 1;

                    if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then
                      mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A or %10000000  // setzen von Bit 7, da
                                                                           // CY = 1
                    else
                      mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A and %01111111; // ruecksetzen von Bit 7, da
                                                                            // CY = 0

                    // C is reset, da Bit 0 in A vorher 0 war ( Bit 0 -> CY )
                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }

                  end; { if (mod_cpu.Reg.HRS.A and %10000000) = %10000000 then }

                  {
                  S Not affected.
                  Z Not affected.
                  H Reset.
                  P/V Not affected.
                  N Reset.
                  C Data from bit 7 of the accumulator.
                  }

                  // H is reset
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

                  // N is reset
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }


                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin

                    if (mod_cpu.Reg.HRS.F and %00000001) = 0 then
                      Befehl_Zeile := 'RRA  ; CY=0'
                    else
                      Befehl_Zeile := 'RRA  ; CY=1';

                    Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                    Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                  end; { if Mode_Protokoll then }
                  {$ENDIF}

                 Befehl_abgearbeitet:=true;

                end; { RRA }





          // JR NZ, e
          $20 : begin
                  {
                  Condition Bits Affected: None
                  }

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then
                    Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                  {$ENDIF}

                  displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                  INC(mod_cpu.Reg.SRS.PC);


                  // PC setzen, wenn NZ
                  if (mod_cpu.Reg.HRS.F and %01000000) = %00000000 then begin

                    if displacement>127 then
                      mod_cpu.Reg.SRS.PC := mod_cpu.Reg.SRS.PC - (256 - displacement)
                    else
                      mod_cpu.Reg.SRS.PC := mod_cpu.Reg.SRS.PC + displacement; // (PC +- d)

                  end; { if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then  }

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin

                    if (mod_cpu.Reg.HRS.F and %01000000) = %00000000 then begin

                      if displacement>127 then
                        Befehl_Zeile := 'JR NZ,-'+IntToHex(256 - displacement,2)+'H  ; Sprung zurueck -> '+
                                      IntToHex(mod_cpu.Reg.SRS.PC,4)+'H'
                      else
                        Befehl_Zeile := 'JR NZ,'+IntToHex(displacement,2)+'H  ; Sprung vor -> '+
                                      IntToHex(mod_cpu.Reg.SRS.PC,4)+'H';

                      Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                    end { if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then  }
                    else begin

                      if displacement>127 then
                        Befehl_Zeile := 'JR NZ,-'+IntToHex(256 - displacement,2)+'H  ; kein Sprung'
                      else
                        Befehl_Zeile := 'JR NZ,'+IntToHex(displacement,2)+'H  ; kein Sprung';

                    end; { else (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then }

                    Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                  end; { if Mode_Protokoll then }
                  {$ENDIF}

                  Befehl_abgearbeitet:=true;


                end; { JR NZ, e }





          // LD (nn), HL
          $22 : begin

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then
                    Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                  {$ENDIF}

                  Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                  INC(mod_cpu.Reg.SRS.PC);

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then
                    Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                  {$ENDIF}

                  Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                  INC(mod_cpu.Reg.SRS.PC);

                  Wert_Word := (Wert_n2 shl 8) + Wert_n;

                  mod_ram.Write_Byte(Wert_Word, mod_cpu.Reg.HRS.L);

                  INC(Wert_Word);

                  mod_ram.Write_Byte(Wert_Word, mod_cpu.Reg.HRS.H);

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin
                    Befehl_Zeile := 'LD ('+IntToHex((Wert_n2 shl 8) + Wert_n,4)+'H), HL';

                    Form_RAM.setze_Mem_Red((Wert_n2 shl 8) + Wert_n);
                    Form_RAM.setze_Mem_Red(Wert_Word);

                    Form_cpu.Reg_Red.HRS.HL:=Farbe_Schreiben;

                  end; { if Mode_Protokoll then }
                  {$ENDIF}
                  Befehl_abgearbeitet:=true;

                end; { $22 }





          // DAA
          $27 : begin

                  DAA_nicht_fertig := true;

                  if (mod_cpu.Reg.HRS.F and %00000010) = %00000000 then begin
                    // die letzte Operation war: ADD, ADC, INC


                    if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then begin
                      // Carry-Flag Before DAA = 0


                      if (mod_cpu.Reg.HRS.F and %00010000) = %00000000 then begin
                        // Half-Carry Before DAA = 0

                        // Zeile 1 in DAA
                        if ((mod_cpu.Reg.HRS.A and $F0) IN [$00..$90]) and
                           ((mod_cpu.Reg.HRS.A and $0F) IN [$00..$09]) then begin

                          { C is reset }
                          mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }

                          { H is reset }
                          mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

                          DAA_nicht_fertig := false;

                        end; // Zeile 1 in DAA



                        if DAA_nicht_fertig then begin

                          // Zeile 2 in DAA
                          if ((mod_cpu.Reg.HRS.A and $F0) IN [$00..$80]) and
                             ((mod_cpu.Reg.HRS.A and $0F) IN [$0A..$0F]) then begin

                            { A + 06 }
                            mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + $06;

                            { C is reset }
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }

                            { H is set }
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00010000; { Set HF }

                            DAA_nicht_fertig := false;

                          end; // Zeile 2 in DAA

                        end; { if DAA_nicht_fertig then }



                        if DAA_nicht_fertig then begin

                          // Zeile 4 in DAA
                          if ((mod_cpu.Reg.HRS.A and $F0) IN [$A0..$F0]) and
                             ((mod_cpu.Reg.HRS.A and $0F) IN [$00..$09]) then begin

                            { A + 60 }
                            mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + $60;

                            { C is set }
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }

                            { H is reset }
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

                            DAA_nicht_fertig := false;

                          end; // Zeile 4 in DAA

                        end; { if DAA_nicht_fertig then }



                        if DAA_nicht_fertig then begin

                          // Zeile 5 in DAA
                          if ((mod_cpu.Reg.HRS.A and $F0) IN [$90..$F0]) and
                             ((mod_cpu.Reg.HRS.A and $0F) IN [$0A..$0F]) then begin

                            { A + 66 }
                            mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + $66;

                            { C is set }
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }

                            { H is set }
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00010000; { Set HF }

                            DAA_nicht_fertig := false;

                          end; // Zeile 5 in DAA

                        end; { if DAA_nicht_fertig then }



                      end
                      else begin
                        // Half-Carry Before DAA = 1


                        // Zeile 3 in DAA
                        if ((mod_cpu.Reg.HRS.A and $F0) IN [$00..$90]) and
                           ((mod_cpu.Reg.HRS.A and $0F) IN [$00..$03]) then begin

                          { A + 06 }
                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + $06;

                          { C is reset }
                          mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }

                          { H is reset }
                          mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

                          DAA_nicht_fertig := false;

                        end; // Zeile 3 in DAA



                        if DAA_nicht_fertig then begin

                          // Zeile 6 in DAA
                          if ((mod_cpu.Reg.HRS.A and $F0) IN [$A0..$F0]) and
                             ((mod_cpu.Reg.HRS.A and $0F) IN [$00..$03]) then begin

                            { A + 66 }
                            mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + $66;

                            { C is set }
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }

                            { H is reset }
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

                            DAA_nicht_fertig := false;

                          end; // Zeile 6 in DAA

                        end; { if DAA_nicht_fertig then }


                      end; { if (mod_cpu.Reg_Red.HRS.F and %00010000) = %00000000 then }


                    end
                    else begin
                      // Carry-Flag Before DAA = 1


                      if (mod_cpu.Reg.HRS.F and %00010000) = %00000000 then begin
                        // Half-Carry Before DAA = 0


                        // Zeile 7 in DAA
                        if ((mod_cpu.Reg.HRS.A and $F0) IN [$00..$20]) and
                           ((mod_cpu.Reg.HRS.A and $0F) IN [$00..$09]) then begin

                          { A + 60 }
                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + $60;

                          { C is set }
                          mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }

                          { H is reset }
                          mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

                          DAA_nicht_fertig := false;

                        end; // Zeile 7 in DAA



                        if DAA_nicht_fertig then begin

                          // Zeile 8 in DAA
                          if ((mod_cpu.Reg.HRS.A and $F0) IN [$00..$20]) and
                             ((mod_cpu.Reg.HRS.A and $0F) IN [$0A..$0F]) then begin

                            { A + 66 }
                            mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + $66;

                            { C is set }
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }

                            { H is set }
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00010000; { Set HF }

                            DAA_nicht_fertig := false;

                          end; // Zeile 8 in DAA

                        end; { if DAA_nicht_fertig then }


                      end
                      else begin
                        // Half-Carry Before DAA = 1


                        // Zeile 9 in DAA
                        if ((mod_cpu.Reg.HRS.A and $F0) IN [$00..$30]) and
                           ((mod_cpu.Reg.HRS.A and $0F) IN [$00..$03]) then begin

                          { A + 66 }
                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + $66;

                          { C is set }
                          mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }

                          { H is reset }
                          mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

                          DAA_nicht_fertig := false;

                        end; // Zeile 9 in DAA


                      end; { if (.mod_cpu.Form_cpuReg_Red.HRS.F and %00010000) = %00000000 then }


                    end; { if (mod_cpu.Reg_Red.HRS.F and %00000001) = %00000000 then }


                  end
                  else begin
                    // die letzte Operation war: SUB, SBC, DEC, NEG


                    if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then begin
                      // Carry-Flag Before DAA = 0


                      if (mod_cpu.Reg.HRS.F and %00010000) = %00000000 then begin
                        // Half-Carry Before DAA = 0

                        // Zeile 10 in DAA
                        if ((mod_cpu.Reg.HRS.A and $F0) IN [$00..$90]) and
                           ((mod_cpu.Reg.HRS.A and $0F) IN [$00..$09]) then begin

                          { C is reset }
                          mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }

                          { H is reset }
                          mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

                          DAA_nicht_fertig := false;

                        end; // Zeile 10 in DAA


                      end
                      else begin
                        // Half-Carry Before DAA = 1


                        // Zeile 11 in DAA
                        if ((mod_cpu.Reg.HRS.A and $F0) IN [$00..$80]) and
                           ((mod_cpu.Reg.HRS.A and $0F) IN [$06..$0F]) then begin

                          { A + FA }
                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + $FA;

                          { C is reset }
                          mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }

                          { H is reset }
                          mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

                          DAA_nicht_fertig := false;

                        end; // Zeile 11 in DAA


                      end; { if (mod_cpu.Reg.HRS.F and %00010000) = %00000000 then }


                    end
                    else begin
                      // Carry-Flag Before DAA = 1


                      if (mod_cpu.Reg.HRS.F and %00010000) = %00000000 then begin
                        // Half-Carry Before DAA = 0

                        // Zeile 12 in DAA
                        if ((mod_cpu.Reg.HRS.A and $F0) IN [$70..$F0]) and
                           ((mod_cpu.Reg.HRS.A and $0F) IN [$00..$09]) then begin

                          { A + A0 }
                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + $A0;

                          { C is set }
                          mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }

                          { H is reset }
                          mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

                          DAA_nicht_fertig := false;

                        end; // Zeile 12 in DAA

                      end
                      else begin
                        // Half-Carry Before DAA = 1

                        // Zeile 13 in DAA
                        if ((mod_cpu.Reg.HRS.A and $F0) IN [$60..$F0]) and
                           ((mod_cpu.Reg.HRS.A and $0F) IN [$06..$0F]) then begin

                          { A + 9A }
                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + $9A;

                          { C is set }
                          mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }

                          { H is reset }
                          mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

                          DAA_nicht_fertig := false;

                        end; // Zeile 13 in DAA

                      end; { if (mod_cpu.Reg.HRS.F and %00010000) = %00000000 then }

                    end; { if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }

                  end; { if (mod_cpu.Reg.HRS.F and %00000010) = %00000000 then }

                  {
                  S is set if most-significant bit of Accumulator is 1 after operation; reset otherwise
                  Z is set if Accumulator is zero after operation; reset otherwise
                  H, see instruction
                  P/V is set if Accumulator is even parity after operation; reset otherwise
                  N is not affected
                  C, see instruction
                  }

                  // S is set if most-significant bit of Accumulator is 1 after operation; reset otherwise
                  Sign_Flag_negative(mod_cpu.Reg.HRS.A);

                  // Z is set if Accumulator is zero after operation; reset otherwise
                  Zero_Flag_zero(mod_cpu.Reg.HRS.A);

                  // P/V is set if Accumulator is even parity after operation; reset otherwise
                  Parity_Overflow_EVEN_ODD(mod_cpu.Reg.HRS.A);

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin

                    Befehl_Zeile := 'DAA';

                    Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                    Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                  end; { if Mode_Protokoll then }
                  {$ENDIF}


                  Befehl_abgearbeitet:=true;

                end; { DAA }




          // JR Z, e
          $28 : begin
                  {
                  Condition Bits Affected: None
                  }

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then
                    Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                  {$ENDIF}

                  displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                  INC(mod_cpu.Reg.SRS.PC);


                  // PC setzen, wenn Z
                  if (mod_cpu.Reg.HRS.F and %01000000) = %01000000 then begin

                    if displacement>127 then
                      mod_cpu.Reg.SRS.PC := mod_cpu.Reg.SRS.PC - (256 - displacement)
                    else
                      mod_cpu.Reg.SRS.PC := mod_cpu.Reg.SRS.PC + displacement; // (PC +- d)

                  end; { if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then  }

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin

                    if (mod_cpu.Reg.HRS.F and %01000000) = %01000000 then begin

                      if displacement>127 then
                        Befehl_Zeile := 'JR Z,-'+IntToHex(256 - displacement,2)+'H  ; Sprung zurueck -> '+
                                      IntToHex(mod_cpu.Reg.SRS.PC,4)+'H'
                      else
                        Befehl_Zeile := 'JR Z,'+IntToHex(displacement,2)+'H  ; Sprung vor -> '+
                                      IntToHex(mod_cpu.Reg.SRS.PC,4)+'H';

                      Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                    end { if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then  }
                    else begin

                      if displacement>127 then
                        Befehl_Zeile := 'JR Z,-'+IntToHex(256 - displacement,2)+'H  ; kein Sprung'
                      else
                        Befehl_Zeile := 'JR Z,'+IntToHex(displacement,2)+'H  ; kein Sprung';

                    end; { else (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then }

                    Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                  end; { if Mode_Protokoll then }
                  {$ENDIF}

                  Befehl_abgearbeitet:=true;


                end; { JR Z, e }






          // LD HL, (nn)
          $2A : begin

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then
                    Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                  {$ENDIF}

                  Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                  INC(mod_cpu.Reg.SRS.PC);

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then
                    Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                  {$ENDIF}

                  Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                  INC(mod_cpu.Reg.SRS.PC);

                  Wert_Word := (Wert_n2 shl 8) + Wert_n;

                  mod_cpu.Reg.HRS.L := mod_ram.Read_Byte(Wert_Word);

                  INC(Wert_Word);

                  mod_cpu.Reg.HRS.H := mod_ram.Read_Byte(Wert_Word);

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin
                    Befehl_Zeile := 'LD HL, ('+IntToHex((Wert_n2 shl 8) + Wert_n,4)+'H)';

                    Form_RAM.setze_Mem_Green((Wert_n2 shl 8) + Wert_n);
                    Form_RAM.setze_Mem_Green(Wert_Word);

                    Form_cpu.Reg_Red.HRS.HL:=Farbe_Schreiben;

                  end; { if Mode_Protokoll then }
                  {$ENDIF}
                  Befehl_abgearbeitet:=true;

                end; { $2A }




          // CPL
          $2F : begin

                  {
                  S Not affected.
                  Z Not affected.
                  H Set.
                  P/V Not affected.
                  N Set.
                  C Not affected.
                  }

                  { H is set }
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00010000; { Set HF }

                  // N is set
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000010; { Set NF }


                  mod_cpu.Reg.HRS.A := not mod_cpu.Reg.HRS.A;


                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin
                    Befehl_Zeile := 'CPL';

                    Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                    Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                  end; { if Mode_Protokoll then }
                  {$ENDIF}
                  Befehl_abgearbeitet:=true;

                end; { CPL }



          // JR NC, e
          $30 : begin
                  {
                  Condition Bits Affected: None
                  }

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then
                    Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                  {$ENDIF}

                  displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                  INC(mod_cpu.Reg.SRS.PC);


                  // PC setzen, wenn NC
                  if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then begin

                    if displacement>127 then
                      mod_cpu.Reg.SRS.PC := mod_cpu.Reg.SRS.PC - (256 - displacement)
                    else
                      mod_cpu.Reg.SRS.PC := mod_cpu.Reg.SRS.PC + displacement; // (PC +- d)

                  end; { if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then  }

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin

                    if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then begin

                      if displacement>127 then
                        Befehl_Zeile := 'JR NC,-'+IntToHex(256 - displacement,2)+'H  ; Sprung zurueck -> '+
                                      IntToHex(mod_cpu.Reg.SRS.PC,4)+'H'
                      else
                        Befehl_Zeile := 'JR NC,'+IntToHex(displacement,2)+'H  ; Sprung vor -> '+
                                      IntToHex(mod_cpu.Reg.SRS.PC,4)+'H';

                      Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                    end { if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then  }
                    else begin

                      if displacement>127 then
                        Befehl_Zeile := 'JR NC,-'+IntToHex(256 - displacement,2)+'H  ; kein Sprung'
                      else
                        Befehl_Zeile := 'JR NC,'+IntToHex(displacement,2)+'H  ; kein Sprung';

                    end; { else (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then }

                    Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                  end; { if Mode_Protokoll then }
                  {$ENDIF}

                  Befehl_abgearbeitet:=true;


                end; { JR NC, e }










          // LD (nn), A
          $32 : begin

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then
                      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                  {$ENDIF}

                  Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                  INC(mod_cpu.Reg.SRS.PC);

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then
                      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                  {$ENDIF}

                  Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                  INC(mod_cpu.Reg.SRS.PC);

                  mod_ram.Write_Byte((Wert_n2 shl 8) + Wert_n, mod_cpu.Reg.HRS.A);

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin

                    Befehl_Zeile := 'LD ('+IntToHex(Wert_n2,2)+IntToHex(Wert_n,2)+'H), A';

                    Form_RAM.setze_Mem_Red((Wert_n2 shl 8) + Wert_n);
                    Form_cpu.Reg_Red.HRS.A:=Farbe_Lesen;

                  end; { if Mode_Protokoll then }
                  {$ENDIF}
                  Befehl_abgearbeitet:=true;

                end; { $32 }




          // SCF
          $37 : begin

                  {
                  S is not affected
                  Z is not affected
                  H is reset
                  P/V is not affected
                  N is reset
                  C is set
                  }

                  // H is reset
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

                  // N is reset
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }

                  // C is set
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }


                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin

                    Befehl_Zeile := 'SCF';

                    Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                  end; { if Mode_Protokoll then }
                  {$ENDIF}

                  Befehl_abgearbeitet:=true;

                end; { SCF }




          // JR C, e
          $38 : begin
                  {
                  Condition Bits Affected: None
                  }

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then
                    Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                  {$ENDIF}

                  displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                  INC(mod_cpu.Reg.SRS.PC);


                  // PC setzen, wenn C
                  if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then begin

                    if displacement>127 then
                      mod_cpu.Reg.SRS.PC := mod_cpu.Reg.SRS.PC - (256 - displacement)
                    else
                      mod_cpu.Reg.SRS.PC := mod_cpu.Reg.SRS.PC + displacement; // (PC +- d)

                  end; { if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then  }

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin

                    if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then begin

                      if displacement>127 then
                        Befehl_Zeile := 'JR C,-'+IntToHex(256 - displacement,2)+'H  ; Sprung zurueck -> '+
                                      IntToHex(mod_cpu.Reg.SRS.PC,4)+'H'
                      else
                        Befehl_Zeile := 'JR C,'+IntToHex(displacement,2)+'H  ; Sprung vor -> '+
                                      IntToHex(mod_cpu.Reg.SRS.PC,4)+'H';

                      Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                    end { if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then  }
                    else begin

                      if displacement>127 then
                        Befehl_Zeile := 'JR C,-'+IntToHex(256 - displacement,2)+'H  ; kein Sprung'
                      else
                        Befehl_Zeile := 'JR C,'+IntToHex(displacement,2)+'H  ; kein Sprung';

                    end; { else (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then }

                    Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                  end; { if Mode_Protokoll then }
                  {$ENDIF}

                  Befehl_abgearbeitet:=true;


                end; { JR C, e }









          // LD A, (nn)
          $3A : begin

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then
                    Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                  {$ENDIF}

                  Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                  INC(mod_cpu.Reg.SRS.PC);

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then
                    Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                  {$ENDIF}

                  Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                  INC(mod_cpu.Reg.SRS.PC);

                  mod_cpu.Reg.HRS.A := mod_ram.Read_Byte((Wert_n2 shl 8) + Wert_n);

                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin

                    Befehl_Zeile := 'LD A, ('+IntToHex(Wert_n2,2)+IntToHex(Wert_n,2)+'H)';

                    Form_RAM.setze_Mem_Green((Wert_n2 shl 8) + Wert_n);
                    Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;

                  end; { if Mode_Protokoll then }
                  {$ENDIF}
                  Befehl_abgearbeitet:=true;

                end; { $3A }



          // CCF
          $3F : begin

                  {
                  S is not affected
                  Z is not affected
                  H, previous carry is copied
                  P/V is not affected
                  N is reset
                  C is set if CY was 0 before operation; reset otherwise
                  }


                  if (mod_cpu.Reg.HRS.F and %00000001) = 0 then begin

                    // CF = not CF
                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }
                    { C_alt -> H }
                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

                  end
                  else begin

                    // CF = not CF
                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }
                    { C_alt -> H }
                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00010000; { Set HF }

                  end; { if (mod_cpu.Reg.HRS.F and %00000001) = 0 then }


                  { N is reset }
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }


                  {$IFDEF mit_GUI}
                  if Mode_Protokoll then begin

                    Befehl_Zeile := 'CCF';

                    Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                  end; { if Mode_Protokoll then }
                  {$ENDIF}

                  Befehl_abgearbeitet:=true;

                end; { CCF }




        end;

      end; { case OP_Code2 of }

    end; { case OP_Code2 of }

  end; { procedure OP_Code_00 }




