
{ *** OP_Code_10 *** }



  procedure OP_Code_10;
  var
    ziel_reg, OP_Code2,
    Wert_n, Wert_n2 : Byte;
    Wert_Word : Word;
  begin

    OP_Code2 := OP_Code AND %00111000;

    case OP_Code2 of

      // ADD A, r
      %00000000 : begin

                    ziel_reg := OP_Code AND %00000111;

                    case ziel_reg of

                      // ADD A, A
                      %00000111 : begin

                                    setze_Flags_ADD(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.A);
                                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + mod_cpu.Reg.HRS.A;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'ADD A, A';
                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // ADD A, A



                      // ADD A, B
                      %00000000 : begin

                                    setze_Flags_ADD(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.B);
                                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + mod_cpu.Reg.HRS.B;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'ADD A, B';
                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.B:=Farbe_Lesen;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // ADD A, B



                      // ADD A, C
                      %00000001 : begin

                                    setze_Flags_ADD(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.C);
                                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + mod_cpu.Reg.HRS.C;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'ADD A, C';
                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.C:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // ADD A, C



                      // ADD A, D
                      %00000010 : begin

                                    setze_Flags_ADD(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.D);
                                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + mod_cpu.Reg.HRS.D;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'ADD A, D';
                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.D:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // ADD A, D



                      // ADD A, E
                      %00000011 : begin

                                    setze_Flags_ADD(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.E);
                                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + mod_cpu.Reg.HRS.E;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'ADD A, E';
                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.E:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // ADD A, E




                      // ADD A, H
                      %00000100 : begin

                                    setze_Flags_ADD(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.H);
                                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + mod_cpu.Reg.HRS.H;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'ADD A, H';
                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.H:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // ADD A, H



                      // ADD A, L
                      %00000101 : begin

                                    setze_Flags_ADD(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.L);
                                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + mod_cpu.Reg.HRS.L;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'ADD A, L';
                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.L:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // ADD A, L



                      // ADD A, (HL)
                      %00000110 : begin

                                    Wert_Word := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;
                                    Wert_n := mod_ram.Read_Byte(Wert_Word); // (HL) -> Wert_n

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Form_RAM.setze_Mem_Green(Wert_Word);    // HL
                                    end;
                                    {$ENDIF}

                                    setze_Flags_ADD(mod_cpu.Reg.HRS.A, Wert_n);
                                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Befehl_Zeile := 'ADD A, (HL)  ; (HL)='+IntToHex(Wert_n,2)+'H';
                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.HL:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // ADD A, (HL)



                    end; { case ziel_reg of }


                  end; // ADD A, r





      // ADC A, r
      %00001000 : begin

                    ziel_reg := OP_Code AND %00000111;

                    case ziel_reg of

                      // ADC A, A
                      %00000111 : begin

                                    Wert_n := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                                    setze_Flags_ADC(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.A,
                                                    Wert_n);

                                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + mod_cpu.Reg.HRS.A +
                                                         Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      if Wert_n=0 then
                                        Befehl_Zeile := 'ADC A, A  ; CY=0'
                                      else
                                        Befehl_Zeile := 'ADC A, A  ; CY=1';

                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // ADC A, A



                      // ADC A, B
                      %00000000 : begin

                                    Wert_n := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                                    setze_Flags_ADC(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.B,
                                                    Wert_n);

                                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + mod_cpu.Reg.HRS.B +
                                                         Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      if Wert_n=0 then
                                        Befehl_Zeile := 'ADC A, B  ; CY=0'
                                      else
                                        Befehl_Zeile := 'ADC A, B  ; CY=1';

                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.B:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // ADC A, B



                      // ADC A, C
                      %00000001 : begin

                                    Wert_n := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                                    setze_Flags_ADC(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.C,
                                                    Wert_n);

                                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + mod_cpu.Reg.HRS.C +
                                                         Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      if Wert_n=0 then
                                        Befehl_Zeile := 'ADC A, C  ; CY=0'
                                      else
                                        Befehl_Zeile := 'ADC A, C  ; CY=1';

                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.C:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // ADC A, C




                      // ADC A, D
                      %00000010 : begin

                                    Wert_n := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                                    setze_Flags_ADC(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.D,
                                                    Wert_n);

                                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + mod_cpu.Reg.HRS.D +
                                                         Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      if Wert_n=0 then
                                        Befehl_Zeile := 'ADC A, D  ; CY=0'
                                      else
                                        Befehl_Zeile := 'ADC A, D  ; CY=1';

                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.D:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // ADC A, D



                      // ADC A, E
                      %00000011 : begin

                                    Wert_n := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                                    setze_Flags_ADC(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.E,
                                                    Wert_n);

                                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + mod_cpu.Reg.HRS.E +
                                                         Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      if Wert_n=0 then
                                        Befehl_Zeile := 'ADC A, E  ; CY=0'
                                      else
                                        Befehl_Zeile := 'ADC A, E  ; CY=1';

                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.E:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // ADC A, E




                      // ADC A, H
                      %00000100 : begin

                                    Wert_n := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                                    setze_Flags_ADC(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.H,
                                                    Wert_n);

                                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + mod_cpu.Reg.HRS.H +
                                                         Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      if Wert_n=0 then
                                        Befehl_Zeile := 'ADC A, H  ; CY=0'
                                      else
                                        Befehl_Zeile := 'ADC A, H  ; CY=1';

                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.H:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // ADC A, H



                      // ADC A, L
                      %00000101 : begin

                                    Wert_n := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                                    setze_Flags_ADC(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.L,
                                                    Wert_n);

                                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + mod_cpu.Reg.HRS.L +
                                                         Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      if Wert_n=0 then
                                        Befehl_Zeile := 'ADC A, L  ; CY=0'
                                      else
                                        Befehl_Zeile := 'ADC A, L  ; CY=1';

                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.L:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // ADC A, L



                      // ADC A, (HL)
                      %00000110 : begin

                                    Wert_n := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                                    Wert_Word := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;
                                    Wert_n2 := mod_ram.Read_Byte(Wert_Word); // (HL) -> Wert_n

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Form_RAM.setze_Mem_Green(Wert_Word);    // HL
                                    end;
                                    {$ENDIF}

                                    setze_Flags_ADC(mod_cpu.Reg.HRS.A, Wert_n2,
                                                    Wert_n);

                                    mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + Wert_n2 +
                                                         Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      if Wert_n=0 then
                                        Befehl_Zeile := 'ADC A, (HL)  ; (HL)='+IntToHex(Wert_n2,2)+'H CY=0'
                                      else
                                        Befehl_Zeile := 'ADC A, (HL)  ; (HL)='+IntToHex(Wert_n2,2)+'H CY=1';

                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.HL:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                                    end;
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // ADC A, (HL)


                    end; { case ziel_reg of }


                  end; // ADC A, r


      // SUB r
      %00010000 : begin

                          ziel_reg := OP_Code AND %00000111;

                          case ziel_reg of


                            // SUB A
                            %00000111 : begin

                                          setze_Flags_SUB(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.A);
                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - mod_cpu.Reg.HRS.A;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'SUB A';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // SUB A



                            // SUB B
                            %00000000 : begin

                                          setze_Flags_SUB(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.B);
                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - mod_cpu.Reg.HRS.B;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'SUB B';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.B:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}

                                          Befehl_abgearbeitet:=true;

                                        end; // SUB B




                            // SUB C
                            %00000001 : begin

                                          setze_Flags_SUB(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.C);
                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - mod_cpu.Reg.HRS.C;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'SUB C';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.C:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}

                                          Befehl_abgearbeitet:=true;

                                        end; // SUB C




                            // SUB D
                            %00000010 : begin

                                          setze_Flags_SUB(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.D);
                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - mod_cpu.Reg.HRS.D;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'SUB D';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.D:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}

                                          Befehl_abgearbeitet:=true;

                                        end; // SUB D



                            // SUB E
                            %00000011 : begin

                                          setze_Flags_SUB(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.E);
                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - mod_cpu.Reg.HRS.E;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'SUB E';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.E:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}

                                          Befehl_abgearbeitet:=true;

                                        end; // SUB E



                            // SUB H
                            %00000100 : begin

                                          setze_Flags_SUB(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.H);
                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - mod_cpu.Reg.HRS.H;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'SUB H';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.H:=Farbe_Lesen;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                          end;
                                          {$ENDIF}

                                          Befehl_abgearbeitet:=true;

                                        end; // SUB H



                            // SUB L
                            %00000101 : begin

                                          setze_Flags_SUB(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.L);
                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - mod_cpu.Reg.HRS.L;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'SUB L';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.L:=Farbe_Lesen;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                          end;
                                          {$ENDIF}

                                          Befehl_abgearbeitet:=true;

                                        end; // SUB L



                            // SUB (HL)
                            %00000110 : begin

                                          Wert_Word := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;
                                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (HL) -> Wert_n

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Form_RAM.setze_Mem_Green(Wert_Word);    // HL
                                          end;
                                          {$ENDIF}

                                          setze_Flags_SUB(mod_cpu.Reg.HRS.A, Wert_n);
                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - Wert_n;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'SUB (HL)  ; (HL)='+IntToHex(Wert_n,2)+'H';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.HL:=Farbe_Lesen;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                          end;
                                          {$ENDIF}

                                          Befehl_abgearbeitet:=true;

                                        end; // SUB (HL)



                          end; { case ziel_reg of }


                        end; // SUB r



            // SBC A, r
            %00011000 : begin

                          ziel_reg := OP_Code AND %00000111;

                          case ziel_reg of

                            // SBC A, A
                            %00000111 : begin

                                          Wert_n := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                                          setze_Flags_SBC(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.A,
                                                          Wert_n);

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - mod_cpu.Reg.HRS.A -
                                                               Wert_n;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin

                                            if Wert_n=0 then
                                              Befehl_Zeile := 'SBC A, A  ; CY=0'
                                            else
                                              Befehl_Zeile := 'SBC A, A  ; CY=1';

                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // SBC A, A



                            // SBC A, B
                            %00000000 : begin

                                          Wert_n := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                                          setze_Flags_SBC(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.B,
                                                          Wert_n);

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - mod_cpu.Reg.HRS.B -
                                                               Wert_n;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin

                                            if Wert_n=0 then
                                              Befehl_Zeile := 'SBC A, B  ; CY=0'
                                            else
                                              Befehl_Zeile := 'SBC A, B  ; CY=1';

                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.B:=Farbe_Lesen;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // SBC A, B



                            // SBC A, C
                            %00000001 : begin

                                          Wert_n := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                                          setze_Flags_SBC(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.C,
                                                          Wert_n);

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - mod_cpu.Reg.HRS.C -
                                                               Wert_n;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin

                                            if Wert_n=0 then
                                              Befehl_Zeile := 'SBC A, C  ; CY=0'
                                            else
                                              Befehl_Zeile := 'SBC A, C  ; CY=1';

                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.C:=Farbe_Lesen;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // SBC A, C


                            // SBC A, D
                            %00000010 : begin

                                          Wert_n := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                                          setze_Flags_SBC(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.D,
                                                          Wert_n);

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - mod_cpu.Reg.HRS.D -
                                                               Wert_n;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin

                                            if Wert_n=0 then
                                              Befehl_Zeile := 'SBC A, D  ; CY=0'
                                            else
                                              Befehl_Zeile := 'SBC A, D  ; CY=1';

                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.D:=Farbe_Lesen;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // SBC A, D



                            // SBC A, E
                            %00000011 : begin

                                          Wert_n := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                                          setze_Flags_SBC(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.E,
                                                          Wert_n);

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - mod_cpu.Reg.HRS.E -
                                                               Wert_n;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin

                                            if Wert_n=0 then
                                              Befehl_Zeile := 'SBC A, E  ; CY=0'
                                            else
                                              Befehl_Zeile := 'SBC A, E  ; CY=1';

                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.E:=Farbe_Lesen;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // SBC A, E




                            // SBC A, H
                            %00000100 : begin

                                          Wert_n := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                                          setze_Flags_SBC(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.H,
                                                          Wert_n);

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - mod_cpu.Reg.HRS.H -
                                                               Wert_n;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin

                                            if Wert_n=0 then
                                              Befehl_Zeile := 'SBC A, H  ; CY=0'
                                            else
                                              Befehl_Zeile := 'SBC A, H  ; CY=1';

                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.H:=Farbe_Lesen;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // SBC A, H


                            // SBC A, L
                            %00000101 : begin

                                          Wert_n := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                                          setze_Flags_SBC(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.L,
                                                          Wert_n);

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - mod_cpu.Reg.HRS.L -
                                                               Wert_n;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin

                                            if Wert_n=0 then
                                              Befehl_Zeile := 'SBC A, L  ; CY=0'
                                            else
                                              Befehl_Zeile := 'SBC A, L  ; CY=1';

                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.L:=Farbe_Lesen;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // SBC A, L


                            // SBC A, (HL)
                            %00000110 : begin

                                          Wert_n := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                                          Wert_Word := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;
                                          Wert_n2 := mod_ram.Read_Byte(Wert_Word); // (HL) -> Wert_n

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Form_RAM.setze_Mem_Green(Wert_Word);    // HL
                                          end;
                                          {$ENDIF}

                                          setze_Flags_SBC(mod_cpu.Reg.HRS.A, Wert_n2,
                                                          Wert_n);

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - Wert_n2 -
                                                               Wert_n;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin

                                            if Wert_n=0 then
                                              Befehl_Zeile := 'SBC A, (HL)  ; (HL)='+IntToHex(Wert_n2,2)+'H CY=0'
                                            else
                                              Befehl_Zeile := 'SBC A, (HL)  ; (HL)='+IntToHex(Wert_n2,2)+'H CY=1';

                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.HL:=Farbe_Lesen;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;


                                        end; // SBC A, (HL)



                          end; { case ziel_reg of }


                        end; // SBC A, r




            // AND r
            %00100000 : begin

                          ziel_reg := OP_Code AND %00000111;

                          case ziel_reg of

                            // AND A
                            %00000111 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A and mod_cpu.Reg.HRS.A;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is set
                                          Half_Carry_Flag_Set;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'AND A';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // AND A


                            // AND B
                            %00000000 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A and mod_cpu.Reg.HRS.B;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is set
                                          Half_Carry_Flag_Set;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'AND B';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.B:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // AND B


                            // AND C
                            %00000001 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A and mod_cpu.Reg.HRS.C;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is set
                                          Half_Carry_Flag_Set;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'AND C';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.C:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // AND C



                            // AND D
                            %00000010 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A and mod_cpu.Reg.HRS.D;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is set
                                          Half_Carry_Flag_Set;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'AND D';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.D:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // AND D


                            // AND E
                            %00000011 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A and mod_cpu.Reg.HRS.E;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is set
                                          Half_Carry_Flag_Set;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'AND E';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.E:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // AND E



                            // AND H
                            %00000100 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A and mod_cpu.Reg.HRS.H;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is set
                                          Half_Carry_Flag_Set;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'AND H';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.H:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // AND H


                            // AND L
                            %00000101 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A and mod_cpu.Reg.HRS.L;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is set
                                          Half_Carry_Flag_Set;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'AND L';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.L:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // AND L




                            // AND (HL)
                            %00000110 : begin

                                          Wert_Word := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;
                                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (HL) -> Wert_n

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Form_RAM.setze_Mem_Green(Wert_Word);    // HL
                                          end;
                                          {$ENDIF}

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A and Wert_n;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is set
                                          Half_Carry_Flag_Set;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'AND (HL)  ; (HL)='+IntToHex(Wert_n,2)+'H';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.HL:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // AND (HL)





                          end; { case ziel_reg of }


                        end; // AND r




                        // OR r
            %00110000 : begin

                          ziel_reg := OP_Code AND %00000111;

                          case ziel_reg of

                            // OR A
                            %00000111 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A or mod_cpu.Reg.HRS.A;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is reset
                                          Half_Carry_Flag_Reset;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'OR A';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // OR A


                            // OR B
                            %00000000 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A or mod_cpu.Reg.HRS.B;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is reset
                                          Half_Carry_Flag_Reset;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'OR B';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.B:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // OR B



                            // OR C
                            %00000001 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A or mod_cpu.Reg.HRS.C;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is reset
                                          Half_Carry_Flag_Reset;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'OR C';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.C:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // OR C



                            // OR D
                            %00000010 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A or mod_cpu.Reg.HRS.D;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is reset
                                          Half_Carry_Flag_Reset;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'OR D';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.D:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // OR D



                            // OR E
                            %00000011 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A or mod_cpu.Reg.HRS.E;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is reset
                                          Half_Carry_Flag_Reset;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'OR E';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.E:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // OR E



                            // OR H
                            %00000100 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A or mod_cpu.Reg.HRS.H;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is reset
                                          Half_Carry_Flag_Reset;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'OR H';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.H:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // OR H




                            // OR L
                            %00000101 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A or mod_cpu.Reg.HRS.L;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is reset
                                          Half_Carry_Flag_Reset;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'OR L';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.L:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // OR L




                            // OR (HL)
                            %00000110 : begin

                                          Wert_Word := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;
                                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (HL) -> Wert_n

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Form_RAM.setze_Mem_Green(Wert_Word);    // HL
                                          end;
                                          {$ENDIF}

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A or Wert_n;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is reset
                                          Half_Carry_Flag_Reset;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'OR (HL)  ; (HL)='+IntToHex(Wert_n,2)+'H';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.HL:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // OR (HL)

                          end; { case ziel_reg of }

                        end; // OR r




                      // XOR r
            %00101000 : begin

                          ziel_reg := OP_Code AND %00000111;

                          case ziel_reg of

                            // XOR A
                            %00000111 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A xor mod_cpu.Reg.HRS.A;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is reset
                                          Half_Carry_Flag_Reset;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'XOR A';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // XOR A




                            // XOR B
                            %00000000 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A xor mod_cpu.Reg.HRS.B;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is reset
                                          Half_Carry_Flag_Reset;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'XOR B';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.B:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // XOR B



                            // XOR C
                            %00000001 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A xor mod_cpu.Reg.HRS.C;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is reset
                                          Half_Carry_Flag_Reset;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'XOR C';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.C:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // XOR C



                            // XOR D
                            %00000010 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A xor mod_cpu.Reg.HRS.D;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is reset
                                          Half_Carry_Flag_Reset;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'XOR D';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.D:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // XOR D



                            // XOR E
                            %00000011 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A xor mod_cpu.Reg.HRS.E;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is reset
                                          Half_Carry_Flag_Reset;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'XOR E';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.E:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // XOR E




                            // XOR H
                            %00000100 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A xor mod_cpu.Reg.HRS.H;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is reset
                                          Half_Carry_Flag_Reset;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'XOR H';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.H:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // XOR H



                            // XOR L
                            %00000101 : begin

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A xor mod_cpu.Reg.HRS.L;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is reset
                                          Half_Carry_Flag_Reset;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'XOR L';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.L:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // XOR L



                            // XOR (HL)
                            %00000110 : begin

                                          Wert_Word := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;
                                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (HL) -> Wert_n

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Form_RAM.setze_Mem_Green(Wert_Word);    // HL
                                          end;
                                          {$ENDIF}

                                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A xor Wert_n;
                                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                                          // H is reset
                                          Half_Carry_Flag_Reset;

                                          {$IFDEF mit_GUI}
                                          if Mode_Protokoll then begin
                                            Befehl_Zeile := 'XOR (HL)  ; (HL)='+IntToHex(Wert_n,2)+'H';
                                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                            Form_cpu.Reg_Red.HRS.HL:=Farbe_Lesen;
                                          end;
                                          {$ENDIF}
                                          Befehl_abgearbeitet:=true;

                                        end; // XOR (HL)


                          end; { case ziel_reg of }


                        end; // XOR r




            // CP r
            %00111000 : begin

                                ziel_reg := OP_Code AND %00000111;

                                case ziel_reg of


                                  // CP A
                                  %00000111 : begin

                                                setze_Flags_SUB(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.A);

                                                {$IFDEF mit_GUI}
                                                if Mode_Protokoll then begin
                                                  Befehl_Zeile := 'CP A';
                                                  Form_cpu.Reg_Red.HRS.A:=Farbe_Lesen;
                                                  Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                                end;
                                                {$ENDIF}
                                                Befehl_abgearbeitet:=true;

                                              end; // SUB A



                                  // CP B
                                  %00000000 : begin

                                                setze_Flags_SUB(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.B);

                                                {$IFDEF mit_GUI}
                                                if Mode_Protokoll then begin
                                                  Befehl_Zeile := 'CP B';
                                                  Form_cpu.Reg_Red.HRS.A:=Farbe_Lesen;
                                                  Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                                  Form_cpu.Reg_Red.HRS.B:=Farbe_Lesen;
                                                end;
                                                {$ENDIF}

                                                Befehl_abgearbeitet:=true;

                                              end; // CP B




                                  // CP C
                                  %00000001 : begin

                                                setze_Flags_SUB(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.C);

                                                {$IFDEF mit_GUI}
                                                if Mode_Protokoll then begin
                                                  Befehl_Zeile := 'CP C';
                                                  Form_cpu.Reg_Red.HRS.A:=Farbe_Lesen;
                                                  Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                                  Form_cpu.Reg_Red.HRS.C:=Farbe_Lesen;
                                                end;
                                                {$ENDIF}

                                                Befehl_abgearbeitet:=true;

                                              end; // CP C




                                  // CP D
                                  %00000010 : begin

                                                setze_Flags_SUB(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.D);

                                                {$IFDEF mit_GUI}
                                                if Mode_Protokoll then begin
                                                  Befehl_Zeile := 'CP D';
                                                  Form_cpu.Reg_Red.HRS.A:=Farbe_Lesen;
                                                  Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                                  Form_cpu.Reg_Red.HRS.D:=Farbe_Lesen;
                                                end;
                                                {$ENDIF}

                                                Befehl_abgearbeitet:=true;

                                              end; // CP D



                                  // CP E
                                  %00000011 : begin

                                                setze_Flags_SUB(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.E);

                                                {$IFDEF mit_GUI}
                                                if Mode_Protokoll then begin
                                                  Befehl_Zeile := 'CP E';
                                                  Form_cpu.Reg_Red.HRS.A:=Farbe_Lesen;
                                                  Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                                  Form_cpu.Reg_Red.HRS.E:=Farbe_Lesen;
                                                end;
                                                {$ENDIF}

                                                Befehl_abgearbeitet:=true;

                                              end; // CP E



                                  // CP H
                                  %00000100 : begin

                                                setze_Flags_SUB(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.H);

                                                {$IFDEF mit_GUI}
                                                if Mode_Protokoll then begin
                                                  Befehl_Zeile := 'CP H';
                                                  Form_cpu.Reg_Red.HRS.A:=Farbe_Lesen;
                                                  Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                                  Form_cpu.Reg_Red.HRS.H:=Farbe_Lesen;
                                                end;
                                                {$ENDIF}

                                                Befehl_abgearbeitet:=true;

                                              end; // CP H



                                  // CP L
                                  %00000101 : begin

                                                setze_Flags_SUB(mod_cpu.Reg.HRS.A, mod_cpu.Reg.HRS.L);

                                                {$IFDEF mit_GUI}
                                                if Mode_Protokoll then begin
                                                  Befehl_Zeile := 'CP L';
                                                  Form_cpu.Reg_Red.HRS.A:=Farbe_Lesen;
                                                  Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                                  Form_cpu.Reg_Red.HRS.L:=Farbe_Lesen;
                                                end;
                                                {$ENDIF}

                                                Befehl_abgearbeitet:=true;

                                              end; // CP L



                                  // CP (HL)
                                  %00000110 : begin

                                                Wert_Word := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;
                                                Wert_n := mod_ram.Read_Byte(Wert_Word); // (HL) -> Wert_n

                                                {$IFDEF mit_GUI}
                                                if Mode_Protokoll then begin
                                                  Form_RAM.setze_Mem_Green(Wert_Word);    // HL
                                                end;
                                                {$ENDIF}

                                                setze_Flags_SUB(mod_cpu.Reg.HRS.A, Wert_n);

                                                {$IFDEF mit_GUI}
                                                if Mode_Protokoll then begin
                                                  Befehl_Zeile := 'CP (HL)  ; (HL)='+IntToHex(Wert_n,2)+'H';
                                                  Form_cpu.Reg_Red.HRS.A:=Farbe_Lesen;
                                                  Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                                  Form_cpu.Reg_Red.HRS.HL:=Farbe_Lesen;
                                                end;
                                                {$ENDIF}

                                                Befehl_abgearbeitet:=true;

                                              end; // CP (HL)



                                end; { case ziel_reg of }


                              end; // CP r








    end; { case OP_Code2 of }





  end; { procedure OP_Code_10 }





