
  { *** OP_Code_11 *** }




  procedure OP_Code_11;
  var
    OP_Code2, ziel_reg, cc_condition,
    Wert_n, Wert_n2, Wert_n3 : Byte;
  begin






    OP_Code2 := OP_Code AND %00000111;

    case OP_Code2 of



      // RET cc - Conditional Return from Subroutine
      %00000000 : begin

                    cc_condition := OP_Code AND %00111000;

                    case cc_condition of


                      // RET NZ - NZ non zero
                      %00000000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // RET, wenn NZ
                                    if (mod_cpu.Reg.HRS.F and %01000000) = %00000000 then begin

                                      // 1. Stack -> Wert_n/2
                                      Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      INC(mod_cpu.Reg.SRS.SP);

                                      Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      INC(mod_cpu.Reg.SRS.SP);

                                      // 3. gelesene CALL-Adresse -> PC
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                        Befehl_Zeile := 'RET NZ  -> Ruecksprung';

                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}


                                    end { if (mod_cpu.Reg.HRS.F and %01000000) = %00000000 then }
                                    else begin


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Befehl_Zeile := 'RET NZ  -> kein Ruecksprung';
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;
                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end; { else (mod_cpu.Reg.HRS.F and %01000000) = %00000000 then }

                                    Befehl_abgearbeitet:=true;

                                  end; // RET NZ




                      // RET Z
                      %00001000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // RET, wenn Z
                                    if (mod_cpu.Reg.HRS.F and %01000000) = %01000000 then begin


                                      // 1. Stack -> Wert_n/2
                                      Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      INC(mod_cpu.Reg.SRS.SP);

                                      Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      INC(mod_cpu.Reg.SRS.SP);

                                      // 3. gelesene CALL-Adresse -> PC
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                        Befehl_Zeile := 'RET Z  -> Ruecksprung';

                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}


                                    end { if (mod_cpu.Reg.HRS.F and %01000000) = %01000000 then }
                                    else begin


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Befehl_Zeile := 'RET Z  -> kein Ruecksprung';
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;
                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end; { else (mod_cpu.Reg.HRS.F and %01000000) = %01000000 then }

                                    Befehl_abgearbeitet:=true;

                                  end; // RET Z




                      // RET NC - NC no carry
                      %00010000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // RET, wenn NC
                                    if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then begin

                                      // 1. Stack -> Wert_n/2
                                      Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      INC(mod_cpu.Reg.SRS.SP);

                                      Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      INC(mod_cpu.Reg.SRS.SP);

                                      // 3. gelesene CALL-Adresse -> PC
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                        Befehl_Zeile := 'RET NC  -> Ruecksprung';

                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end { if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }
                                    else begin


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Befehl_Zeile := 'RET NC  -> kein Ruecksprung';
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;
                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end; { else (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }

                                    Befehl_abgearbeitet:=true;

                                  end; // RET NC




                      // RET C, nn - C carry
                      %00011000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // RET, wenn C
                                    if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then begin

                                      // 1. Stack -> Wert_n/2
                                      Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      INC(mod_cpu.Reg.SRS.SP);

                                      Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      INC(mod_cpu.Reg.SRS.SP);

                                      // 3. gelesene CALL-Adresse -> PC
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                        Befehl_Zeile := 'RET C  -> Ruecksprung';

                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}


                                    end { if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }
                                    else begin

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Befehl_Zeile := 'RET C  -> kein Ruecksprung';
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;
                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end; { else (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }

                                    Befehl_abgearbeitet:=true;

                                  end; // RET C




                      // RET PO, nn - PO parity odd
                      %00100000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // RET, wenn die Bitzahl ungleich ist
                                    if (mod_cpu.Reg.HRS.F and %00000100) = %00000000 then begin

                                      // 1. Stack -> Wert_n/2
                                      Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      INC(mod_cpu.Reg.SRS.SP);

                                      Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      INC(mod_cpu.Reg.SRS.SP);

                                      // 3. gelesene CALL-Adresse -> PC
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                        Befehl_Zeile := 'RET PO  -> Ruecksprung';

                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end { if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }
                                    else begin

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Befehl_Zeile := 'RET PO  -> kein Ruecksprung';
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;
                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end; { else (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }

                                    Befehl_abgearbeitet:=true;

                                  end; // RET PO




                      // RET PE, nn - PE parity even
                      %00101000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // RET, wenn die Bitzahl gleich ist
                                    if (mod_cpu.Reg.HRS.F and %00000100) = %00000100 then begin

                                      // 1. Stack -> Wert_n/2
                                      Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      INC(mod_cpu.Reg.SRS.SP);

                                      Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      INC(mod_cpu.Reg.SRS.SP);

                                      // 3. gelesene CALL-Adresse -> PC
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                        Befehl_Zeile := 'RET PE  -> Ruecksprung';

                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}


                                    end { if (mod_cpu.Reg.HRS.F and %00000100) = %00000100 then }
                                    else begin

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Befehl_Zeile := 'RET PE  -> kein Ruecksprung';
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;
                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end; { else (mod_cpu.Reg.HRS.F and %00000100) = %00000100 then }

                                    Befehl_abgearbeitet:=true;

                                  end; // RET PE




                      // RET P, nn - P sign positive
                      %00110000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // RET, bei Vorzeichen Positiv
                                    if (mod_cpu.Reg.HRS.F and %10000000) = %00000000 then begin

                                      // 1. Stack -> Wert_n/2
                                      Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      INC(mod_cpu.Reg.SRS.SP);

                                      Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      INC(mod_cpu.Reg.SRS.SP);

                                      // 3. gelesene CALL-Adresse -> PC
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                        Befehl_Zeile := 'RET P  -> Ruecksprung';

                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}


                                    end { if (mod_cpu.Reg.HRS.F and %10000000) = %00000000 then }
                                    else begin

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Befehl_Zeile := 'RET P  -> kein Ruecksprung';
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;
                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end; { else (mod_cpu.Reg.HRS.F and %10000000) = %00000000 then }

                                    Befehl_abgearbeitet:=true;

                                  end; // RET P




                      // RET M, nn - M sign negative
                      %00111000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // RET, bei Vorzeichen Negativ
                                    if (mod_cpu.Reg.HRS.F and %10000000) = %10000000 then begin

                                      // 1. Stack -> Wert_n/2
                                      Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      INC(mod_cpu.Reg.SRS.SP);

                                      Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      INC(mod_cpu.Reg.SRS.SP);

                                      // 3. gelesene CALL-Adresse -> PC
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                        Befehl_Zeile := 'RET M  -> Ruecksprung';

                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}


                                    end { if (mod_cpu.Reg.HRS.F and %10000000) = %10000000 then }
                                    else begin

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Befehl_Zeile := 'RET M  -> kein Ruecksprung';
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;
                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end; { else (mod_cpu.Reg.HRS.F and %10000000) = %10000000 then }

                                    Befehl_abgearbeitet:=true;

                                  end; // RET M


                    end; { case cc_condition of }

      end;// RET cc





      // JP cc, nn
      %00000010 : begin

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then
                      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                    {$ENDIF}

                    Wert_n :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                    INC(mod_cpu.Reg.SRS.PC);

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then
                      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                    {$ENDIF}

                    Wert_n2 :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                    INC(mod_cpu.Reg.SRS.PC);

                    cc_condition := OP_Code AND %00111000;

                    case cc_condition of

                      // JP NZ, nn - NZ non zero
                      %00000000 : begin
                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC setzen, wenn NZ
                                    if (mod_cpu.Reg.HRS.F and %01000000) = %00000000 then
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      if (mod_cpu.Reg.HRS.F and %01000000) = %00000000 then begin
                                        Befehl_Zeile := 'JP NZ, '+IntToHex(Wert_n2,2)+
                                                        IntToHex(Wert_n,2)+'H  ; -> Sprung';
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;
                                      end
                                      else begin
                                        Befehl_Zeile := 'JP NZ, '+IntToHex(Wert_n2,2)+
                                                        IntToHex(Wert_n,2)+'H  ; -> kein Sprung';
                                      end; { if (mod_cpu.Reg.HRS.F and %01000000) = %00000000 then }

                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // JP NZ, nn



                      // JP Z, nn - Z zero
                      %00001000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC setzen, wenn Z
                                    if (mod_cpu.Reg.HRS.F and %01000000) = %01000000 then
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      if (mod_cpu.Reg.HRS.F and %01000000) = %01000000 then begin
                                        Befehl_Zeile := 'JP Z, '+IntToHex(Wert_n2,2)+
                                                        IntToHex(Wert_n,2)+'H  ; -> Sprung';
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;
                                      end
                                      else begin
                                        Befehl_Zeile := 'JP Z, '+IntToHex(Wert_n2,2)+
                                                        IntToHex(Wert_n,2)+'H  ; -> kein Sprung';
                                      end; { if (mod_cpu.Reg.HRS.F and %01000000) = %00000000 then }

                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // JP Z, nn


                      // JP NC, nn - NC no carry
                      %00010000 : begin
                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC setzen, wenn NC
                                    if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then begin
                                        Befehl_Zeile := 'JP NC, '+IntToHex(Wert_n2,2)+
                                                        IntToHex(Wert_n,2)+'H  ; -> Sprung';
                                                         Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;
                                      end
                                      else begin
                                        Befehl_Zeile := 'JP NC, '+IntToHex(Wert_n2,2)+
                                                        IntToHex(Wert_n,2)+'H  ; -> kein Sprung';
                                      end; { if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }

                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // JP NC, nn



                      // JP C, nn - C carry
                      %00011000 : begin
                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC setzen, wenn C
                                    if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then begin
                                        Befehl_Zeile := 'JP C, '+IntToHex(Wert_n2,2)+
                                                        IntToHex(Wert_n,2)+'H  ; -> Sprung';
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;
                                      end
                                      else begin
                                        Befehl_Zeile := 'JP C, '+IntToHex(Wert_n2,2)+
                                                        IntToHex(Wert_n,2)+'H  ; -> kein Sprung';
                                      end; { if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then }

                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // JP C, nn



                      // JP PO, nn - PO parity odd
                      %00100000 : begin
                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC setzen, wenn die Bitzahl ungleich ist
                                    if (mod_cpu.Reg.HRS.F and %00000100) = %00000000 then
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      if (mod_cpu.Reg.HRS.F and %00000100) = %00000000 then begin
                                        Befehl_Zeile := 'JP PO, '+IntToHex(Wert_n2,2)+
                                                        IntToHex(Wert_n,2)+'H  ; -> Sprung';
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;
                                      end
                                      else begin
                                        Befehl_Zeile := 'JP PO, '+IntToHex(Wert_n2,2)+
                                                        IntToHex(Wert_n,2)+'H  ; -> kein Sprung';
                                      end; { if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }

                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // JP PO, nn



                      // JP PE, nn - PE parity even
                      %00101000 : begin
                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC setzen, wenn die Bitzahl ungleich ist
                                    if (mod_cpu.Reg.HRS.F and %00000100) = %00000100 then
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      if (mod_cpu.Reg.HRS.F and %00000100) = %00000100 then begin
                                        Befehl_Zeile := 'JP PE, '+IntToHex(Wert_n2,2)+
                                                        IntToHex(Wert_n,2)+'H  ; -> Sprung';
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;
                                      end
                                      else begin
                                        Befehl_Zeile := 'JP PE, '+IntToHex(Wert_n2,2)+
                                                        IntToHex(Wert_n,2)+'H  ; -> kein Sprung';
                                      end; { if (mod_cpu.Reg.HRS.F and %00000001) = %00000100 then }

                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                                    end;
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // JP PE, nn



                      // JP P, nn - P sign positive
                      %00110000 : begin
                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC setzen, bei Vorzeichen Positiv
                                    if (mod_cpu.Reg.HRS.F and %10000000) = %00000000 then
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      if (mod_cpu.Reg.HRS.F and %10000000) = %00000000 then begin
                                        Befehl_Zeile := 'JP P, '+IntToHex(Wert_n2,2)+
                                                        IntToHex(Wert_n,2)+'H  ; -> Sprung';
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;
                                      end
                                      else begin
                                        Befehl_Zeile := 'JP P, '+IntToHex(Wert_n2,2)+
                                                        IntToHex(Wert_n,2)+'H  ; -> kein Sprung';
                                      end; { if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }

                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // JP P, nn



                      // JP M, nn - M sign negative
                      %00111000 : begin
                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC setzen, bei Vorzeichen Positiv
                                    if (mod_cpu.Reg.HRS.F and %10000000) = %10000000 then
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      if (mod_cpu.Reg.HRS.F and %10000000) = %10000000 then begin
                                        Befehl_Zeile := 'JP M, '+IntToHex(Wert_n2,2)+
                                                        IntToHex(Wert_n,2)+'H  ; -> Sprung';
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;
                                      end
                                      else begin
                                        Befehl_Zeile := 'JP M, '+IntToHex(Wert_n2,2)+
                                                        IntToHex(Wert_n,2)+'H  ; -> kein Sprung';
                                      end; { if (mod_cpu.Reg.HRS.F and %00000001) = %10000000 then }

                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // JP M, nn


                    end; { case cc_condition of }

      end;// RET cc








      // CALL cc, nn -> Conditional CALL Subroutine
      %00000100 : begin

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then
                      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                    {$ENDIF}

                    Wert_n :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                    INC(mod_cpu.Reg.SRS.PC);

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then
                      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                    {$ENDIF}

                    Wert_n2 :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                    INC(mod_cpu.Reg.SRS.PC);

                    cc_condition := OP_Code AND %00111000;

                    case cc_condition of


                      // CALL NZ, nn - NZ non zero
                      %00000000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC setzen, wenn NZ
                                    if (mod_cpu.Reg.HRS.F and %01000000) = %00000000 then begin

                                      // PC -> Stack
                                      DEC(mod_cpu.Reg.SRS.SP);
                                      Wert_n3 := mod_cpu.Reg.SRS.PC shr 8;
                                      mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      DEC(mod_cpu.Reg.SRS.SP);
                                      Wert_n3 := mod_cpu.Reg.SRS.PC and %0000000011111111;
                                      mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}



                                      // gesicherte CALL-Adresse -> PC
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                        Befehl_Zeile := 'CALL NZ, '+IntToHex(mod_cpu.Reg.SRS.PC,4)+
                                                        'H  -> UP-Aufruf';

                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}


                                    end { if (mod_cpu.Reg.HRS.F and %01000000) = %00000000 then }
                                    else begin


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'CALL NZ, '+IntToHex(mod_cpu.Reg.SRS.PC,4)+
                                                        'H  -> kein UP-Aufruf';

                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end; { else (mod_cpu.Reg.HRS.F and %01000000) = %00000000 then }

                                    Befehl_abgearbeitet:=true;

                                  end; // CALL NZ, nn




                      // CALL Z, nn
                      %00001000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC setzen, wenn Z
                                    if (mod_cpu.Reg.HRS.F and %01000000) = %01000000 then begin

                                      // PC -> Stack
                                      DEC(mod_cpu.Reg.SRS.SP);
                                      Wert_n3 := mod_cpu.Reg.SRS.PC shr 8;
                                      mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      DEC(mod_cpu.Reg.SRS.SP);
                                      Wert_n3 := mod_cpu.Reg.SRS.PC and %0000000011111111;
                                      mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}


                                      // gesicherte CALL-Adresse -> PC
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                        Befehl_Zeile := 'CALL Z, '+IntToHex(mod_cpu.Reg.SRS.PC,4)+
                                                        'H  -> UP-Aufruf';

                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}


                                    end { if (mod_cpu.Reg.HRS.F and %01000000) = %01000000 then }
                                    else begin


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'CALL Z, '+IntToHex(mod_cpu.Reg.SRS.PC,4)+
                                                        'H  -> kein UP-Aufruf';

                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end; { else (mod_cpu.Reg.HRS.F and %01000000) = %01000000 then }

                                    Befehl_abgearbeitet:=true;


                                  end; // CALL Z, nn




                      // CALL NC, nn - NC no carry
                      %00010000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC setzen, wenn NC
                                    if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then begin

                                      // PC -> Stack
                                      DEC(mod_cpu.Reg.SRS.SP);
                                      Wert_n3 := mod_cpu.Reg.SRS.PC shr 8;
                                      mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      DEC(mod_cpu.Reg.SRS.SP);
                                      Wert_n3 := mod_cpu.Reg.SRS.PC and %0000000011111111;
                                      mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}


                                      // gesicherte CALL-Adresse -> PC
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                        Befehl_Zeile := 'CALL NC, '+IntToHex(mod_cpu.Reg.SRS.PC,4)+
                                                        'H  -> UP-Aufruf';

                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}


                                    end { if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }
                                    else begin


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'CALL NC, '+IntToHex(mod_cpu.Reg.SRS.PC,4)+
                                                        'H  -> kein UP-Aufruf';

                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end; { else (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }

                                    Befehl_abgearbeitet:=true;

                                  end; // CALL NC, nn




                      // CALL C, nn - C carry
                      %00011000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC setzen, wenn C
                                    if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then begin

                                      // PC -> Stack
                                      DEC(mod_cpu.Reg.SRS.SP);
                                      Wert_n3 := mod_cpu.Reg.SRS.PC shr 8;
                                      mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      DEC(mod_cpu.Reg.SRS.SP);
                                      Wert_n3 := mod_cpu.Reg.SRS.PC and %0000000011111111;
                                      mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}


                                      // gesicherte CALL-Adresse -> PC
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                        Befehl_Zeile := 'CALL C, '+IntToHex(mod_cpu.Reg.SRS.PC,4)+
                                                        'H  -> UP-Aufruf';

                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}


                                    end { if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }
                                    else begin


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'CALL C, '+IntToHex(mod_cpu.Reg.SRS.PC,4)+
                                                        'H  -> kein UP-Aufruf';

                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end; { else (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }

                                    Befehl_abgearbeitet:=true;

                                  end; // CALL C, nn




                      // CALL PO, nn - PO parity odd
                      %00100000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC setzen, wenn die Bitzahl ungleich ist
                                    if (mod_cpu.Reg.HRS.F and %00000100) = %00000000 then begin

                                      // PC -> Stack
                                      DEC(mod_cpu.Reg.SRS.SP);
                                      Wert_n3 := mod_cpu.Reg.SRS.PC shr 8;
                                      mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      DEC(mod_cpu.Reg.SRS.SP);
                                      Wert_n3 := mod_cpu.Reg.SRS.PC and %0000000011111111;
                                      mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}


                                      // gesicherte CALL-Adresse -> PC
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                        Befehl_Zeile := 'CALL PO, '+IntToHex(mod_cpu.Reg.SRS.PC,4)+
                                                        'H  -> UP-Aufruf';

                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}


                                    end { if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }
                                    else begin


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'CALL PO, '+IntToHex(mod_cpu.Reg.SRS.PC,4)+
                                                        'H  -> kein UP-Aufruf';

                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end; { else (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }

                                    Befehl_abgearbeitet:=true;

                                  end; // CALL PO, nn




                      // CALL PE, nn - PE parity even
                      %00101000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC setzen, wenn die Bitzahl gleich ist
                                    if (mod_cpu.Reg.HRS.F and %00000100) = %00000100 then begin

                                      // PC -> Stack
                                      DEC(mod_cpu.Reg.SRS.SP);
                                      Wert_n3 := mod_cpu.Reg.SRS.PC shr 8;
                                      mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      DEC(mod_cpu.Reg.SRS.SP);
                                      Wert_n3 := mod_cpu.Reg.SRS.PC and %0000000011111111;
                                      mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}


                                      // gesicherte CALL-Adresse -> PC
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                        Befehl_Zeile := 'CALL PE, '+IntToHex(mod_cpu.Reg.SRS.PC,4)+
                                                        'H  -> UP-Aufruf';

                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}


                                    end { if (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }
                                    else begin


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'CALL PE, '+IntToHex(mod_cpu.Reg.SRS.PC,4)+
                                                        'H  -> kein UP-Aufruf';

                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end; { else (mod_cpu.Reg.HRS.F and %00000001) = %00000000 then }

                                    Befehl_abgearbeitet:=true;

                                  end; // CALL PE, nn




                      // CALL P, nn - P sign positive
                      %00110000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC setzen, bei Vorzeichen Positiv
                                    if (mod_cpu.Reg.HRS.F and %10000000) = %00000000 then begin

                                      // PC -> Stack
                                      DEC(mod_cpu.Reg.SRS.SP);
                                      Wert_n3 := mod_cpu.Reg.SRS.PC shr 8;
                                      mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      DEC(mod_cpu.Reg.SRS.SP);
                                      Wert_n3 := mod_cpu.Reg.SRS.PC and %0000000011111111;
                                      mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}


                                      // gesicherte CALL-Adresse -> PC
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                        Befehl_Zeile := 'CALL P, '+IntToHex(mod_cpu.Reg.SRS.PC,4)+
                                                        'H  -> UP-Aufruf';

                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}


                                    end { if (mod_cpu.Reg.HRS.F and %10000000) = %00000000 then }
                                    else begin


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'CALL P, '+IntToHex(mod_cpu.Reg.SRS.PC,4)+
                                                        'H  -> kein UP-Aufruf';

                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end; { else (mod_cpu.Reg.HRS.F and %10000000) = %00000000 then }

                                    Befehl_abgearbeitet:=true;

                                  end; // CALL P, nn




                      // CALL M, nn - M sign negative
                      %00111000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC setzen, bei Vorzeichen Negativ
                                    if (mod_cpu.Reg.HRS.F and %10000000) = %10000000 then begin

                                      // PC -> Stack
                                      DEC(mod_cpu.Reg.SRS.SP);
                                      Wert_n3 := mod_cpu.Reg.SRS.PC shr 8;
                                      mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}

                                      DEC(mod_cpu.Reg.SRS.SP);
                                      Wert_n3 := mod_cpu.Reg.SRS.PC and %0000000011111111;
                                      mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                      {$ENDIF}


                                      // gesicherte CALL-Adresse -> PC
                                      mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin
                                        Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                        Befehl_Zeile := 'CALL M, '+IntToHex(mod_cpu.Reg.SRS.PC,4)+
                                                        'H  -> UP-Aufruf';

                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}


                                    end { if (mod_cpu.Reg.HRS.F and %10000000) = %10000000 then }
                                    else begin


                                      {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'CALL M, '+IntToHex(mod_cpu.Reg.SRS.PC,4)+
                                                        'H  -> kein UP-Aufruf';

                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                    end; { else (mod_cpu.Reg.HRS.F and %10000000) = %10000000 then }

                                    Befehl_abgearbeitet:=true;

                                  end; // CALL M, nn


                    end; { case cc_condition of }

      end;// CALL cc, nn




      // RST p -> Restart
      %00000111 : begin

                    cc_condition := OP_Code AND %00111000;

                    case cc_condition of


                      // RST 00H
                      %00000000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC -> Stack
                                    DEC(mod_cpu.Reg.SRS.SP);
                                    Wert_n3 := mod_cpu.Reg.SRS.PC shr 8;
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    DEC(mod_cpu.Reg.SRS.SP);
                                    Wert_n3 := mod_cpu.Reg.SRS.PC and %0000000011111111;
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}


                                    // 3. RST 00-Adresse -> PC
                                    mod_cpu.Reg.SRS.PC := $0000;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                      Befehl_Zeile := 'RST 00H';

                                      Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // RST 00H




                      // RST 08H
                      %00001000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC -> Stack
                                    DEC(mod_cpu.Reg.SRS.SP);
                                    Wert_n3 := mod_cpu.Reg.SRS.PC shr 8;
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    DEC(mod_cpu.Reg.SRS.SP);
                                    Wert_n3 := mod_cpu.Reg.SRS.PC and %0000000011111111;
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}


                                    // RST 08-Adresse -> PC
                                    mod_cpu.Reg.SRS.PC := $0008;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                      Befehl_Zeile := 'RST 08H';

                                      Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // RST 08H




                      // RST 10H
                      %00010000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC -> Stack
                                    DEC(mod_cpu.Reg.SRS.SP);
                                    Wert_n3 := mod_cpu.Reg.SRS.PC shr 8;
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    DEC(mod_cpu.Reg.SRS.SP);
                                    Wert_n3 := mod_cpu.Reg.SRS.PC and %0000000011111111;
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}


                                    // RST 10-Adresse -> PC
                                    mod_cpu.Reg.SRS.PC := $0010;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                      Befehl_Zeile := 'RST 10H';

                                      Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // RST 10H



                      // RST 18H
                      %00011000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC -> Stack
                                    DEC(mod_cpu.Reg.SRS.SP);
                                    Wert_n3 := mod_cpu.Reg.SRS.PC shr 8;
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    DEC(mod_cpu.Reg.SRS.SP);
                                    Wert_n3 := mod_cpu.Reg.SRS.PC and %0000000011111111;
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}


                                    // RST 18-Adresse -> PC
                                    mod_cpu.Reg.SRS.PC := $0018;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                      Befehl_Zeile := 'RST 18H';

                                      Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // RST 18H




                      // RST 20H
                      %00100000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC -> Stack
                                    DEC(mod_cpu.Reg.SRS.SP);
                                    Wert_n3 := mod_cpu.Reg.SRS.PC shr 8;
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    DEC(mod_cpu.Reg.SRS.SP);
                                    Wert_n3 := mod_cpu.Reg.SRS.PC and %0000000011111111;
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}


                                    // RST 20-Adresse -> PC
                                    mod_cpu.Reg.SRS.PC := $0020;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                      Befehl_Zeile := 'RST 20H';

                                      Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // RST 20H




                      // RST 28H
                      %00101000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC -> Stack
                                    DEC(mod_cpu.Reg.SRS.SP);
                                    Wert_n3 := mod_cpu.Reg.SRS.PC shr 8;
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    DEC(mod_cpu.Reg.SRS.SP);
                                    Wert_n3 := mod_cpu.Reg.SRS.PC and %0000000011111111;
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}


                                    // RST 28-Adresse -> PC
                                    mod_cpu.Reg.SRS.PC := $0028;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                      Befehl_Zeile := 'RST 28H';

                                      Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // RST 28H



                      // RST 30H
                      %00110000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC -> Stack
                                    DEC(mod_cpu.Reg.SRS.SP);
                                    Wert_n3 := mod_cpu.Reg.SRS.PC shr 8;
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    DEC(mod_cpu.Reg.SRS.SP);
                                    Wert_n3 := mod_cpu.Reg.SRS.PC and %0000000011111111;
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}


                                    // RST 30-Adresse -> PC
                                    mod_cpu.Reg.SRS.PC := $0030;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                      Befehl_Zeile := 'RST 30H';

                                      Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // RST 30H




                      // RST 38H
                      %00111000 : begin

                                    {
                                    Condition Bits Affected: None
                                    }

                                    // PC -> Stack
                                    DEC(mod_cpu.Reg.SRS.SP);
                                    Wert_n3 := mod_cpu.Reg.SRS.PC shr 8;
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    DEC(mod_cpu.Reg.SRS.SP);
                                    Wert_n3 := mod_cpu.Reg.SRS.PC and %0000000011111111;
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}


                                    // RST 38-Adresse -> PC
                                    mod_cpu.Reg.SRS.PC := $0038;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                      Befehl_Zeile := 'RST 38H';

                                      Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // RST 38H


                    end; { case cc_condition of }

      end;// RST p






    else


    OP_Code2 := OP_Code AND %00001111;

    case OP_Code2 of


      // PUSH qq
      %00000101 : begin

                    ziel_reg := OP_Code AND %00110000;

                    case ziel_reg of

                      // PUSH BC
                      %00000000 : begin
                                    DEC(mod_cpu.Reg.SRS.SP);
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, mod_cpu.Reg.HRS.B);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    DEC(mod_cpu.Reg.SRS.SP);
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, mod_cpu.Reg.HRS.C);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                      Befehl_Zeile := 'PUSH BC';

                                      Form_cpu.Reg_Red.SRS.SP:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.BC:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // PUSH BC


                      // PUSH DE
                      %00010000 : begin
                                    DEC(mod_cpu.Reg.SRS.SP);
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, mod_cpu.Reg.HRS.D);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    DEC(mod_cpu.Reg.SRS.SP);
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, mod_cpu.Reg.HRS.E);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                      Befehl_Zeile := 'PUSH DE';

                                      Form_cpu.Reg_Red.SRS.SP:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.DE:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // PUSH DE


                      // PUSH HL
                      %00100000 : begin
                                    DEC(mod_cpu.Reg.SRS.SP);
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, mod_cpu.Reg.HRS.H);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    DEC(mod_cpu.Reg.SRS.SP);
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, mod_cpu.Reg.HRS.L);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                      Befehl_Zeile := 'PUSH HL';

                                      Form_cpu.Reg_Red.SRS.SP:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.HL:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // PUSH HL


                      // PUSH AF
                      %00110000 : begin
                                    DEC(mod_cpu.Reg.SRS.SP);
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, mod_cpu.Reg.HRS.A);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    DEC(mod_cpu.Reg.SRS.SP);
                                    mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, mod_cpu.Reg.HRS.F);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin
                                      Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                                      Befehl_Zeile := 'PUSH AF';

                                      Form_cpu.Reg_Red.SRS.SP:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // PUSH AF


                    end; { case ziel_reg of }

                  end; // PUSH qq




      // POP qq
      %00000001 : begin

                    ziel_reg := OP_Code AND %00110000;

                    case ziel_reg of

                      // POP BC
                      %00000000 : begin

                                    mod_cpu.Reg.HRS.C := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    INC(mod_cpu.Reg.SRS.SP);

                                    mod_cpu.Reg.HRS.B := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    INC(mod_cpu.Reg.SRS.SP);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'POP BC';

                                      Form_cpu.Reg_Red.SRS.SP:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.BC:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // POP BC



                      // POP DE
                      %00010000 : begin

                                    mod_cpu.Reg.HRS.E := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    INC(mod_cpu.Reg.SRS.SP);

                                    mod_cpu.Reg.HRS.D := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    INC(mod_cpu.Reg.SRS.SP);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'POP DE';

                                      Form_cpu.Reg_Red.SRS.SP:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.DE:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // POP DE


                      // POP HL
                      %00100000 : begin

                                    mod_cpu.Reg.HRS.L := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    INC(mod_cpu.Reg.SRS.SP);

                                    mod_cpu.Reg.HRS.H := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    INC(mod_cpu.Reg.SRS.SP);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'POP HL';

                                      Form_cpu.Reg_Red.SRS.SP:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.HL:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // POP HL


                      // POP AF
                      %00110000 : begin

                                    mod_cpu.Reg.HRS.F := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    INC(mod_cpu.Reg.SRS.SP);

                                    mod_cpu.Reg.HRS.A := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then
                                      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                                    {$ENDIF}

                                    INC(mod_cpu.Reg.SRS.SP);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'POP AF';

                                      Form_cpu.Reg_Red.SRS.SP:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}
                                    Befehl_abgearbeitet:=true;

                                  end; // POP AF




                    end; { case ziel_reg of }

                  end; // POP qq





    else { case OP_Code2 of }


      case OP_Code of



              // JP nn
        $C3 : begin
                {
                Condition Bits Affected: None
                }

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                {$ENDIF}

                Wert_n :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                INC(mod_cpu.Reg.SRS.PC);

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                {$ENDIF}

                Wert_n2 :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);

                mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin
                  Befehl_Zeile := 'JP '+IntToHex(Wert_n2,2)+IntToHex(Wert_n,2)+'H';
                  Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;
                 end;
                {$ENDIF}

                Befehl_abgearbeitet:=true;

              end;  // JP nn





              // ADD A, n
        $C6 : begin

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                {$ENDIF}

                Wert_n :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                INC(mod_cpu.Reg.SRS.PC);

                setze_Flags_ADD(mod_cpu.Reg.HRS.A, Wert_n);
                mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + Wert_n;

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin
                  Befehl_Zeile := 'ADD A, '+IntToHex(Wert_n,2)+'H';
                  Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                  Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                end;
                {$ENDIF}
                Befehl_abgearbeitet:=true;


              end;  // ADD A, n




              // RET - Return from Subroutine
        $C9 : begin

                // 1. Stack -> Wert_n/2
                Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                {$ENDIF}

                INC(mod_cpu.Reg.SRS.SP);

                Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                {$ENDIF}

                INC(mod_cpu.Reg.SRS.SP);

                // 3. gelesene CALL-Adresse -> PC
                mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin

                  Befehl_Zeile := 'RET';

                  Form_cpu.Reg_Red.SRS.SP:=Farbe_Lesen;
                  Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                end; { if Mode_Protokoll then }
                {$ENDIF}

                Befehl_abgearbeitet:=true;


              end;  // RET



        $CB : OP_Code_CB;




              // CALL nn
        $CD : begin

                {
                Condition Bits Affected: None
                }


                // 1. lesen der neuen Adresse (nn -> Wert_n/2)
                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                {$ENDIF}

                Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                INC(mod_cpu.Reg.SRS.PC);

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                {$ENDIF}

                Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                INC(mod_cpu.Reg.SRS.PC);


                // 2. PC -> Stack
                DEC(mod_cpu.Reg.SRS.SP);
                Wert_n3 := mod_cpu.Reg.SRS.PC shr 8;
                mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                {$ENDIF}

                DEC(mod_cpu.Reg.SRS.SP);
                Wert_n3 := mod_cpu.Reg.SRS.PC and %0000000011111111;
                mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n3);


                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                {$ENDIF}


                // 3. gesicherte CALL-Adresse -> PC
                mod_cpu.Reg.SRS.PC := (Wert_n2 shl 8) + Wert_n;

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin
                  Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                  Befehl_Zeile := 'CALL '+IntToHex(mod_cpu.Reg.SRS.PC,4)+'H';

                  Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                  Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;

                end; { if Mode_Protokoll then }
                {$ENDIF}

                Befehl_abgearbeitet:=true;

              end; // CALL nn





              // ADC A, n
        $CE : begin

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                {$ENDIF}

                Wert_n :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                INC(mod_cpu.Reg.SRS.PC);

                Wert_n2 := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                setze_Flags_ADC(mod_cpu.Reg.HRS.A, Wert_n, Wert_n2);
                mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + Wert_n + Wert_n2;

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin
                  if Wert_n2=0 then
                    Befehl_Zeile := 'ADC A, '+IntToHex(Wert_n,2)+'H  ; CY=0'
                  else
                    Befehl_Zeile := 'ADC A, '+IntToHex(Wert_n,2)+'H  ; CY=1';

                  Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                  Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                end;
                {$ENDIF}

                Befehl_abgearbeitet:=true;

              end;  // ADC A, n





              // OUT (n),A - Output to I/O
        $D3 : begin

                 {
                 Condition Bits Affected: None
                 }

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                {$ENDIF}

                Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                INC(mod_cpu.Reg.SRS.PC);

                mod_pio.Output_PIO(Wert_n,mod_cpu.Reg.HRS.A);

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin

                  Befehl_Zeile := 'OUT (' + IntToHex(Wert_n,2) +'H),A';
                  Form_cpu.Reg_Red.HRS.A:=Farbe_Lesen;

                end; { if Mode_Protokoll then }
                {$ENDIF}
                Befehl_abgearbeitet:=true;


              end;  // OUT (n),A




              // SUB n
        $D6 : begin

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                {$ENDIF}

                Wert_n :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                INC(mod_cpu.Reg.SRS.PC);

                setze_Flags_SUB(mod_cpu.Reg.HRS.A, Wert_n);
                mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - Wert_n;

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin
                  Befehl_Zeile := 'SUB '+IntToHex(Wert_n,2)+'H';
                  Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                  Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                end;
                {$ENDIF}
                Befehl_abgearbeitet:=true;


              end;  // SUB n





              // EXX
        $D9 : begin

                // EX BC, BC'
                Wert_n := mod_cpu.Reg.HRS.C;
                mod_cpu.Reg.HRS.C := mod_cpu.Reg.ARS.C;
                mod_cpu.Reg.ARS.C := Wert_n;

                Wert_n := mod_cpu.Reg.HRS.B;
                mod_cpu.Reg.HRS.B := mod_cpu.Reg.ARS.B;
                mod_cpu.Reg.ARS.B := Wert_n;

                // EX DE, DE'
                Wert_n := mod_cpu.Reg.HRS.E;
                mod_cpu.Reg.HRS.E := mod_cpu.Reg.ARS.E;
                mod_cpu.Reg.ARS.E := Wert_n;

                Wert_n := mod_cpu.Reg.HRS.D;
                mod_cpu.Reg.HRS.D := mod_cpu.Reg.ARS.D;
                mod_cpu.Reg.ARS.D := Wert_n;

                // EX HL, HL'
                Wert_n := mod_cpu.Reg.HRS.L;
                mod_cpu.Reg.HRS.L := mod_cpu.Reg.ARS.L;
                mod_cpu.Reg.ARS.L := Wert_n;

                Wert_n := mod_cpu.Reg.HRS.H;
                mod_cpu.Reg.HRS.H := mod_cpu.Reg.ARS.H;
                mod_cpu.Reg.ARS.H := Wert_n;


                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin

                  Befehl_Zeile := 'EXX';

                  Form_cpu.Reg_Red.HRS.BC:=Farbe_Schreiben;
                  Form_cpu.Reg_Red.ARS.BC:=Farbe_Schreiben;

                  Form_cpu.Reg_Red.HRS.DE:=Farbe_Schreiben;
                  Form_cpu.Reg_Red.ARS.DE:=Farbe_Schreiben;

                  Form_cpu.Reg_Red.HRS.HL:=Farbe_Schreiben;
                  Form_cpu.Reg_Red.ARS.HL:=Farbe_Schreiben;

                end; { if Mode_Protokoll then }
                {$ENDIF}
                Befehl_abgearbeitet:=true;

              end; // EXX





              // IN A,(n)
        $DB : begin

                 {
                 Condition Bits Affected: None
                 }

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                {$ENDIF}

                Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                INC(mod_cpu.Reg.SRS.PC);

                mod_cpu.Reg.HRS.A := mod_pio.Input_PIO(Wert_n);

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin

                  Befehl_Zeile := 'IN A,(' + IntToHex(Wert_n,2) +'H)';
                  Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;

                end; { if Mode_Protokoll then }
                {$ENDIF}
                Befehl_abgearbeitet:=true;

              end; // IN A,(n)





        $DD : OP_Code_DD;







              // SBC A, n
        $DE : begin

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                {$ENDIF}

                Wert_n :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                INC(mod_cpu.Reg.SRS.PC);

                Wert_n2 := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                setze_Flags_SBC(mod_cpu.Reg.HRS.A, Wert_n, Wert_n2);
                mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - Wert_n - Wert_n2;

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin
                  if Wert_n2=0 then
                    Befehl_Zeile := 'SBC A, '+IntToHex(Wert_n,2)+'H  ; CY=0'
                  else
                    Befehl_Zeile := 'SBC A, '+IntToHex(Wert_n,2)+'H  ; CY=1';

                  Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                  Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                end;
                {$ENDIF}

                Befehl_abgearbeitet:=true;

              end;  // SBC A, n







              // EX (SP), HL
        $E3 : begin

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                {$ENDIF}

                Wert_n  := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);
                mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, mod_cpu.Reg.HRS.L);
                mod_cpu.Reg.HRS.L := Wert_n;

                INC(mod_cpu.Reg.SRS.SP);

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                {$ENDIF}

                Wert_n  := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);
                mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, mod_cpu.Reg.HRS.H);
                mod_cpu.Reg.HRS.H := Wert_n;

                DEC(mod_cpu.Reg.SRS.SP);

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin

                  Befehl_Zeile := 'EX (SP), HL';

                  Form_cpu.Reg_Red.HRS.HL:=Farbe_Schreiben;
                  Form_cpu.Reg_Red.SRS.SP_Inhalt:=Farbe_Schreiben;

                end; { if Mode_Protokoll then }
                {$ENDIF}
                Befehl_abgearbeitet:=true;

              end; // EX (SP), HL





              // AND n
        $E6 : begin

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                {$ENDIF}

                Wert_n :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                INC(mod_cpu.Reg.SRS.PC);

                mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A and Wert_n;
                setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                // H is set
                Half_Carry_Flag_Set;

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin
                  Befehl_Zeile := 'AND '+IntToHex(Wert_n,2)+'H';
                  Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                  Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                end;
                {$ENDIF}
                Befehl_abgearbeitet:=true;

              end;  // AND n




              // JP (HL)
        $E9 : begin
                {
                Condition Bits Affected: None
                }

                mod_cpu.Reg.SRS.PC := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin
                  Befehl_Zeile := 'JP (HL)';
                  Form_cpu.Reg_Red.HRS.HL:=Farbe_Lesen;
                  Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;
                 end;
                {$ENDIF}

                Befehl_abgearbeitet:=true;

              end;  // JP (HL)





              // EX DE, HL
        $EB : begin

                Wert_n := mod_cpu.Reg.HRS.L;
                mod_cpu.Reg.HRS.L := mod_cpu.Reg.HRS.E;
                mod_cpu.Reg.HRS.E := Wert_n;

                Wert_n := mod_cpu.Reg.HRS.H;
                mod_cpu.Reg.HRS.H := mod_cpu.Reg.HRS.D;
                mod_cpu.Reg.HRS.D := Wert_n;

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin

                  Befehl_Zeile := 'EX DE, HL  ;'+
                                  ' DE='+IntToHex(mod_cpu.Reg.HRS.D,2)+
                                  IntToHex(mod_cpu.Reg.HRS.E,2)+'H '+
                                  ' HL='+IntToHex(mod_cpu.Reg.HRS.H,2)+
                                  IntToHex(mod_cpu.Reg.HRS.L,2)+'H';

                  Form_cpu.Reg_Red.HRS.DE:=Farbe_Schreiben;
                  Form_cpu.Reg_Red.HRS.HL:=Farbe_Schreiben;

                end; { if Mode_Protokoll then }
                {$ENDIF}
                Befehl_abgearbeitet:=true;

              end; // EX DE, HL


        $ED : OP_Code_ED;


              // XOR n
        $EE : begin

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                {$ENDIF}

                Wert_n :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                INC(mod_cpu.Reg.SRS.PC);

                mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A xor Wert_n;
                setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                // H is reset
                Half_Carry_Flag_Reset;

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin
                  Befehl_Zeile := 'XOR '+IntToHex(Wert_n,2)+'H';
                  Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                  Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                end;
                {$ENDIF}

                Befehl_abgearbeitet:=true;

              end;  // XOR n




              // DI
        $F3 : begin

                // DI disables the maskable interrupt
                mod_cpu.Reg.IFF1:=false;
                mod_cpu.Reg.IFF2:=false;

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin
                  Befehl_Zeile := 'DI';
                end;
                {$ENDIF}

                Befehl_abgearbeitet:=true;

              end;  // DI







              // OR n
        $F6 : begin

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                {$ENDIF}

                Wert_n :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                INC(mod_cpu.Reg.SRS.PC);

                mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A or Wert_n;
                setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                // H is reset
                Half_Carry_Flag_Reset;

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin
                  Befehl_Zeile := 'OR '+IntToHex(Wert_n,2)+'H';
                  Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                  Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                end;
                {$ENDIF}

                Befehl_abgearbeitet:=true;

              end;  // OR n




              // LD SP, HL
        $F9 : begin

                mod_cpu.Reg.SRS.SP := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin

                  Befehl_Zeile := 'LD SP, HL  ;'+
                                  ' HL='+IntToHex(mod_cpu.Reg.HRS.H,2)+
                                  IntToHex(mod_cpu.Reg.HRS.L,2)+'H';

                  Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                  Form_cpu.Reg_Red.HRS.HL:=Farbe_Lesen;

                end; { if Mode_Protokoll then }
                {$ENDIF}
                Befehl_abgearbeitet:=true;

              end; // LD SP, HL




              // EI
        $FB : begin

                // EI disables the maskable interrupt
                mod_cpu.Reg.IFF1:=true;
                mod_cpu.Reg.IFF2:=true;

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin
                  Befehl_Zeile := 'EI';
                end;
                {$ENDIF}

                Befehl_abgearbeitet:=true;

              end;  // EI





        $FD : OP_Code_FD;





              // CP n
        $FE : begin

                {$IFDEF mit_GUI}
                if Mode_Protokoll then
                  Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                {$ENDIF}

                Wert_n :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                INC(mod_cpu.Reg.SRS.PC);

                setze_Flags_SUB(mod_cpu.Reg.HRS.A, Wert_n);

                {$IFDEF mit_GUI}
                if Mode_Protokoll then begin
                  Befehl_Zeile := 'CP '+IntToHex(Wert_n,2)+'H';
                  Form_cpu.Reg_Red.HRS.A:=Farbe_Lesen;
                  Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                end;
                {$ENDIF}
                Befehl_abgearbeitet:=true;

              end;  // CP n




      end; { case OP_Code of }

    end; { case OP_Code2 of }



    end; { else case OP_Code2 of }


  end; { procedure OP_Code_11 }



