
  { *** OP_Code_DD *** }



  { *************************** }
  { *** Untergruppen von 11 *** }
  { *************************** }


  // IX-Befehle




  procedure OP_Code_DD_00;
  var
    displacement, Wert_n, Wert_n2,
    OP_Code2, ziel_reg : Byte;
    Wert_Word : Word;
  begin


    OP_Code2 := OP_Code AND %00001111;

    case OP_Code2 of

      // ADD IX,pp
      %00001001 : begin

                    ziel_reg :=  OP_Code AND %00110000;

                    case ziel_reg of

                      // ADD IX,BC
                      %00000000 : begin
                                    {
                                    S is not affected
                                    Z is not affected
                                    H is set if carry out of bit 11; reset otherwise
                                    P/V is not affected
                                    N is reset
                                    C is set if carry from bit 15; reset otherwise
                                    }

                                    Wert_Word := (mod_cpu.Reg.HRS.B shl 8) + mod_cpu.Reg.HRS.C;

                                    // H is set if carry out of bit 11; reset otherwise
                                    HalfCarry_ADD16(mod_cpu.Reg.SRS.IX, Wert_Word);

                                    // C is set if carry from bit 15; reset otherwise
                                    Carry_Flag_set_if_carry_from_bit_15(mod_cpu.Reg.SRS.IX + Wert_Word);

                                    // N is reset
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }

                                    // IX + BC
                                    mod_cpu.Reg.SRS.IX := mod_cpu.Reg.SRS.IX + Wert_Word;

                                    {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'ADD IX, BC';

                                        Form_cpu.Reg_Red.SRS.IX:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.HRS.BC:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                  end; // ADD IX,BC



                      // ADD IX,DE
                      %00010000 : begin
                                    {
                                    S is not affected
                                    Z is not affected
                                    H is set if carry out of bit 11; reset otherwise
                                    P/V is not affected
                                    N is reset
                                    C is set if carry from bit 15; reset otherwise
                                    }

                                    Wert_Word := (mod_cpu.Reg.HRS.D shl 8) + mod_cpu.Reg.HRS.E;

                                    // H is set if carry out of bit 11; reset otherwise
                                    HalfCarry_ADD16(mod_cpu.Reg.SRS.IX, Wert_Word);

                                    // C is set if carry from bit 15; reset otherwise
                                    Carry_Flag_set_if_carry_from_bit_15(mod_cpu.Reg.SRS.IX + Wert_Word);

                                    // N is reset
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }

                                    // IX + DE
                                    mod_cpu.Reg.SRS.IX := mod_cpu.Reg.SRS.IX + Wert_Word;

                                    {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'ADD IX, DE';

                                        Form_cpu.Reg_Red.SRS.IX:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.HRS.DE:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                  end; // ADD IX,DE



                      // ADD IX,HL
                      %00100000 : begin
                                    {
                                    S is not affected
                                    Z is not affected
                                    H is set if carry out of bit 11; reset otherwise
                                    P/V is not affected
                                    N is reset
                                    C is set if carry from bit 15; reset otherwise
                                    }

                                    Wert_Word := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;

                                    // H is set if carry out of bit 11; reset otherwise
                                    HalfCarry_ADD16(mod_cpu.Reg.SRS.IX, Wert_Word);

                                    // C is set if carry from bit 15; reset otherwise
                                    Carry_Flag_set_if_carry_from_bit_15(mod_cpu.Reg.SRS.IX + Wert_Word);

                                    // N is reset
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }

                                    // IX + HL
                                    mod_cpu.Reg.SRS.IX := mod_cpu.Reg.SRS.IX + Wert_Word;

                                    {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'ADD IX, HL';

                                        Form_cpu.Reg_Red.SRS.IX:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.HRS.HL:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                  end; // ADD IX,HL



                      // ADD IX,SP
                      %00110000 : begin
                                    {
                                    S is not affected
                                    Z is not affected
                                    H is set if carry out of bit 11; reset otherwise
                                    P/V is not affected
                                    N is reset
                                    C is set if carry from bit 15; reset otherwise
                                    }

                                    // H is set if carry out of bit 11; reset otherwise
                                    HalfCarry_ADD16(mod_cpu.Reg.SRS.IX, mod_cpu.Reg.SRS.SP);

                                    // C is set if carry from bit 15; reset otherwise
                                    Carry_Flag_set_if_carry_from_bit_15(mod_cpu.Reg.SRS.IX + mod_cpu.Reg.SRS.SP);

                                    // N is reset
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }

                                    // IX + HL
                                    mod_cpu.Reg.SRS.IX := mod_cpu.Reg.SRS.IX + mod_cpu.Reg.SRS.SP;

                                    {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'ADD IX, HL';

                                        Form_cpu.Reg_Red.SRS.IX:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                  end; // ADD IX,SP


                    end; // case ziel_reg of


                  end; // ADD IX,pp

    else

    case OP_Code of



                  // LD IX, nn
                  $21 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          mod_cpu.Reg.SRS.IX_d:=mod_cpu.Reg.SRS.IX;

                          Wert_n :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          Wert_n2 :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          mod_cpu.Reg.SRS.IX := (Wert_n2 shl 8) + Wert_n;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                             Befehl_Zeile := 'LD IX, '+IntToHex(Wert_n2,2)+
                                             IntToHex(Wert_n,2)+'H';

                             Form_cpu.Reg_Red.SRS.IX:=Farbe_Schreiben;

                           end; { if Mode_Protokoll then }
                           {$ENDIF}
                           Befehl_abgearbeitet:=true;

                        end; { $21 }





                  // LD (nn), IX
                  $22 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          mod_cpu.Reg.SRS.IX_d:=mod_cpu.Reg.SRS.IX;

                          Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          // nn
                          Wert_Word := (Wert_n2 shl 8) + Wert_n;

                          Wert_n2 := mod_cpu.Reg.SRS.IX shr 8;
                          Wert_n  := mod_cpu.Reg.SRS.IX and $00FF;

                          mod_ram.Write_Byte(Wert_Word, Wert_n);

                          INC(Wert_Word);

                          mod_ram.Write_Byte(Wert_Word, Wert_n2);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            DEC(Wert_Word);

                            Befehl_Zeile := 'LD ('+IntToHex(Wert_Word,4)+'H), IX';

                            Form_RAM.setze_Mem_Red(Wert_Word);
                            INC(Wert_Word);
                            Form_RAM.setze_Mem_Red(Wert_Word);

                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { $22 }




                  // INC, IX
                  $23 : begin

                          INC(mod_cpu.Reg.SRS.IX);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'INC IX';

                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Schreiben;

                            mod_cpu.Reg.SRS.IX_d:=mod_cpu.Reg.SRS.IX;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { $23 }





                  // LD IX, (nn)
                  $2A : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                              Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          // nn
                          Wert_Word := (Wert_n2 shl 8) + Wert_n;

                          // (nn)
                          Wert_n := mod_ram.Read_Byte(Wert_Word);

                          INC(Wert_Word);

                          // (nn+1)
                          Wert_n2 := mod_ram.Read_Byte(Wert_Word);

                          mod_cpu.Reg.SRS.IX := (Wert_n2 shl 8) + Wert_n;

                          mod_cpu.Reg.SRS.IX_d:=mod_cpu.Reg.SRS.IX;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            DEC(Wert_Word);

                            Befehl_Zeile := 'LD IX, ('+IntToHex(Wert_Word,4)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            INC(Wert_Word);
                            Form_RAM.setze_Mem_Green(Wert_Word);

                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { LD IX, (nn) }




                  // DEC IX
                  $2B : begin

                          DEC(mod_cpu.Reg.SRS.IX);

                          mod_cpu.Reg.SRS.IX_d:=mod_cpu.Reg.SRS.IX;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin
                            Befehl_Zeile := 'DEC IX';

                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { DEC IX }




                  // INC (IX+d)
                  $34 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IX - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IX + displacement; // (IX+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IX+-d) -> Wert_n

                          Wert_n2 := Wert_n and $0F;
                          INC(Wert_n2);

                          {
                          S is set if result is negative; reset otherwise
                          Z is set if result is zero; reset otherwise
                          H is set if carry from bit 3; reset otherwise
                          P/V is set if (IX+d) was 7FH before operation; reset otherwise
                          N is reset
                          C is not affected
                          }

                          // P/V is set if (IX+d) was 7FH before operation; reset otherwise
                          if Wert_n=$7F then
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                          else
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                          // INC
                          INC(Wert_n);


                          // S is set if result is negative; reset otherwise
                          Sign_Flag_negative(Wert_n);

                          // Z is set if result is zero; reset otherwise
                          Zero_Flag_zero(Wert_n);

                          // H is set if carry from bit 3; reset otherwise
                          if ((Wert_n2) and $10) = 0 then
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                          else
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                          // N is reset
                          Num_Flag_Reset;

                          mod_ram.Write_Byte(Wert_Word, Wert_n);

                          mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                          // Anzeige von (IX+d)
                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'INC (IX+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Red(Wert_Word);
                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;
                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                            Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}


                          Befehl_abgearbeitet:=true;

                        end; { INC (IX+d) }





                  // DEC (IX+d)
                  $35 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IX - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IX + displacement; // (IX+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IX+-d) -> Wert_n

                          Wert_n2 := Wert_n and $0F;
                          DEC(Wert_n2);

                          {
                          S is set if result is negative; reset otherwise
                          Z is set if result is zero; reset otherwise
                          H is set if borrow from bit 4, reset otherwise
                          P/V is set if m was 80H before operation; reset otherwise
                          N is set
                          C is not affected
                          }

                          // P/V is set if m was 80H before operation; reset otherwise
                          if Wert_n=$80 then
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                          else
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                          // DEC
                          DEC(Wert_n);


                          // S is set if result is negative; reset otherwise
                          Sign_Flag_negative(Wert_n);

                          // Z is set if result is zero; reset otherwise
                          Zero_Flag_zero(Wert_n);

                          // H is set if borrow from bit 4, reset otherwise
                          if ((Wert_n2) and $10) = 0 then
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                          else
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                          // N is set
                          Num_Flag_Set;

                          mod_ram.Write_Byte(Wert_Word, Wert_n);

                          mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                          // Anzeige von (IX+d)
                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'DEC (IX+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Red(Wert_Word);
                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;
                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                            Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}


                          Befehl_abgearbeitet:=true;

                        end; { DEC (IX+d) }





                  // LD (IX+d), n
                  $36 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IX - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IX + displacement; // (IX+-d)

                          Wert_n :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          mod_ram.Write_Byte(Wert_Word, Wert_n);

                          mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'LD (IX+'+IntToHex(displacement,2)+'H), '+
                                            IntToHex(Wert_n,+2)+'H';

                            Form_RAM.setze_Mem_Red(Wert_Word);
                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;

                            Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { $36 }




    end; // case OP_Code of

    end; // case OP_Code2 of

  end; { procedure OP_Code_DD_00 }




  procedure OP_Code_DD_01;
  var
    quell_reg, ziel_reg, OP_Code2,
    displacement : Byte;
    Wert_Word : Word;
  begin

    OP_Code2 := OP_Code AND %00000111;

    case OP_Code2 of

      // LD r, (IX+d)
      %00000110 : begin

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then
                      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                    {$ENDIF}

                    displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                    INC(mod_cpu.Reg.SRS.PC);

                    if displacement>127 then
                      Wert_Word := mod_cpu.Reg.SRS.IX - (256 - displacement)
                    else
                      Wert_Word := mod_cpu.Reg.SRS.IX + displacement; // (IX+-d)

                    ziel_reg :=  OP_Code AND %00111000;

                    case ziel_reg of

                      // LD A, (IX+d)
                      %00111000 : begin
                                    mod_cpu.Reg.HRS.A := mod_ram.Read_Byte(Wert_Word);

                                    mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'LD A, (IX+'+IntToHex(displacement,2)+'H)';

                                      Form_RAM.setze_Mem_Green(Wert_Word);
                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;

                                      Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // LD A, (IX+d)



                      // LD B, (IX+d)
                      %00000000 : begin
                                    mod_cpu.Reg.HRS.B := mod_ram.Read_Byte(Wert_Word);

                                    mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'LD B, (IX+'+IntToHex(displacement,2)+'H)';

                                      Form_RAM.setze_Mem_Green(Wert_Word);
                                      Form_cpu.Reg_Red.HRS.B:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // LD B, (IX+d)



                      // LD C, (IX+d)
                      %00001000 : begin
                                    mod_cpu.Reg.HRS.C := mod_ram.Read_Byte(Wert_Word);

                                    mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'LD C, (IX+'+IntToHex(displacement,2)+'H)';

                                      Form_RAM.setze_Mem_Green(Wert_Word);
                                      Form_cpu.Reg_Red.HRS.C:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // LD C, (IX+d)



                      // LD D, (IX+d)
                      %00010000 : begin
                                    mod_cpu.Reg.HRS.D := mod_ram.Read_Byte(Wert_Word);

                                    mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'LD D, (IX+'+IntToHex(displacement,2)+'H)';

                                      Form_RAM.setze_Mem_Green(Wert_Word);
                                      Form_cpu.Reg_Red.HRS.D:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // LD D, (IX+d)


                      // LD E, (IX+d)
                      %00011000 : begin

                                    mod_cpu.Reg.HRS.E := mod_ram.Read_Byte(Wert_Word);

                                    mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'LD E, (IX+'+IntToHex(displacement,2)+'H)';

                                      Form_RAM.setze_Mem_Green(Wert_Word);
                                      Form_cpu.Reg_Red.HRS.E:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // LD E, (IX+d)


                      // LD H, (IX+d)
                      %00100000 : begin

                                    mod_cpu.Reg.HRS.H := mod_ram.Read_Byte(Wert_Word);

                                    mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'LD H, (IX+'+IntToHex(displacement,2)+'H)';

                                      Form_RAM.setze_Mem_Green(Wert_Word);
                                      Form_cpu.Reg_Red.HRS.H:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;

                                      Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // LD H, (IX+d)



                      // LD L, (IX+d)
                      %00101000 : begin

                                    mod_cpu.Reg.HRS.L := mod_ram.Read_Byte(Wert_Word);

                                    mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'LD L, (IX+'+IntToHex(displacement,2)+'H)';

                                      Form_RAM.setze_Mem_Green(Wert_Word);
                                      Form_cpu.Reg_Red.HRS.L:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;

                                      Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // LD L, (IX+d)

                    end; { case ziel_reg of }

                  end; { LD r, (IX+d) }


    else  // case OP_Code2 of


      OP_Code2 := OP_Code AND %00111000;


      case OP_Code2 of


        // LD (IX+d), r
        %00110000 : begin

                      {$IFDEF mit_GUI}
                      if Mode_Protokoll then
                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                      {$ENDIF}

                      displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                      INC(mod_cpu.Reg.SRS.PC);

                      if displacement>127 then
                        Wert_Word := mod_cpu.Reg.SRS.IX - (256 - displacement)
                      else
                        Wert_Word := mod_cpu.Reg.SRS.IX + displacement; // (IX+-d)

                      quell_reg :=  OP_Code AND %00000111;

                      case quell_reg of

              // 10 x ->

              // LD (IX+d), A
              %00000111 : begin
                            mod_ram.Write_Byte(Wert_Word, mod_cpu.Reg.HRS.A);

                            mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                            {$IFDEF mit_GUI}
                            if Mode_Protokoll then begin

                              Befehl_Zeile := 'LD (IX+'+IntToHex(displacement,2)+'H), A';

                              Form_RAM.setze_Mem_Red(Wert_Word);
                              Form_cpu.Reg_Red.HRS.A:=Farbe_Lesen;
                              Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;

                              Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Schreiben;

                            end; { if Mode_Protokoll then }
                            {$ENDIF}
                            Befehl_abgearbeitet:=true;

                          end; // LD (IX+d), A


              // LD (IX+d), B
              %00000000 : begin
                            mod_ram.Write_Byte(Wert_Word, mod_cpu.Reg.HRS.B);

                            mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                            {$IFDEF mit_GUI}
                            if Mode_Protokoll then begin

                              Befehl_Zeile := 'LD (IX+'+IntToHex(displacement,2)+'H), B';

                              Form_RAM.setze_Mem_Red(Wert_Word);
                              Form_cpu.Reg_Red.HRS.B:=Farbe_Lesen;
                              Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;

                              Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Schreiben;

                            end; { if Mode_Protokoll then }
                            {$ENDIF}
                            Befehl_abgearbeitet:=true;

                          end; // LD (IX+d), B


              // LD (IX+d), C
              %00000001 : begin
                            mod_ram.Write_Byte(Wert_Word, mod_cpu.Reg.HRS.C);

                            mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                            {$IFDEF mit_GUI}
                            if Mode_Protokoll then begin

                              Befehl_Zeile := 'LD (IX+'+IntToHex(displacement,2)+'H), C';

                              Form_RAM.setze_Mem_Red(Wert_Word);
                              Form_cpu.Reg_Red.HRS.C:=Farbe_Lesen;
                              Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;

                              Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Schreiben;

                            end; { if Mode_Protokoll then }
                            {$ENDIF}
                            Befehl_abgearbeitet:=true;

                          end; // LD (IX+d), C


              // LD (IX+d), D
              %00000010 : begin
                            mod_ram.Write_Byte(Wert_Word, mod_cpu.Reg.HRS.D);

                            mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                            {$IFDEF mit_GUI}
                            if Mode_Protokoll then begin

                              Befehl_Zeile := 'LD (IX+'+IntToHex(displacement,2)+'H), D';

                              Form_RAM.setze_Mem_Red(Wert_Word);
                              Form_cpu.Reg_Red.HRS.D:=Farbe_Lesen;
                              Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;

                              Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Schreiben;

                            end; { if Mode_Protokoll then }
                            {$ENDIF}
                            Befehl_abgearbeitet:=true;

                          end; // LD (IX+d), D


              // LD (IX+d), E
              %00000011 : begin
                            mod_ram.Write_Byte(Wert_Word, mod_cpu.Reg.HRS.E);

                            mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                            {$IFDEF mit_GUI}
                            if Mode_Protokoll then begin

                              Befehl_Zeile := 'LD (IX+'+IntToHex(displacement,2)+'H), E';

                              Form_RAM.setze_Mem_Red(Wert_Word);
                              Form_cpu.Reg_Red.HRS.E:=Farbe_Lesen;
                              Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;

                              Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Schreiben;

                            end; { if Mode_Protokoll then }
                            {$ENDIF}
                            Befehl_abgearbeitet:=true;

                          end; // LD (IX+d), E


              // LD (IX+d), H
              %00000100 : begin
                            mod_ram.Write_Byte(Wert_Word, mod_cpu.Reg.HRS.H);

                            mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                            {$IFDEF mit_GUI}
                            if Mode_Protokoll then begin

                              Befehl_Zeile := 'LD (IX+'+IntToHex(displacement,2)+'H), H';

                              Form_RAM.setze_Mem_Red(Wert_Word);
                              Form_cpu.Reg_Red.HRS.H:=Farbe_Lesen;
                              Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;

                              Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Schreiben;

                            end; { if Mode_Protokoll then }
                            {$ENDIF}
                            Befehl_abgearbeitet:=true;

                          end; // LD (IX+d), H


              // LD (IX+d), L
              %00000101 : begin
                            mod_ram.Write_Byte(Wert_Word, mod_cpu.Reg.HRS.L);

                            mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                            {$IFDEF mit_GUI}
                            if Mode_Protokoll then begin

                              Befehl_Zeile := 'LD (IX+'+IntToHex(displacement,2)+'H), L';

                              Form_RAM.setze_Mem_Red(Wert_Word);
                              Form_cpu.Reg_Red.HRS.L:=Farbe_Lesen;
                              Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;

                              Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Schreiben;

                            end; { if Mode_Protokoll then }
                            {$ENDIF}
                            Befehl_abgearbeitet:=true;

                          end; // LD (IX+d), L

            end; { case quell_reg of }


          end; { LD (IX+d), r }

        end; // case OP_Code2 of

      end;{ else OP_Code2=%01000110 then }



  end; { procedure OP_Code_DD_00 }










  procedure OP_Code_DD_10;
  var
    displacement, Wert_n, Wert_n2 : Byte;
    Wert_Word : Word;
  begin



    case OP_Code of



                  // ADD A, (IX+d)
                  $86 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IX - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IX + displacement; // (IX+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IX + d) -> Wert_n

                          setze_Flags_ADD(mod_cpu.Reg.HRS.A, Wert_n);
                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + Wert_n;

                          mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'ADD A, (IX+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;

                            Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Lesen;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { $86 }





                        // ADC A, (IX+d)
                  $8E : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IX - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IX + displacement; // (IX+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IX + d) -> Wert_n

                          Wert_n2 := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                          setze_Flags_ADC(mod_cpu.Reg.HRS.A, Wert_n, Wert_n2);
                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + Wert_n + Wert_n2;

                          mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'ADC A, (IX+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;
                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                            Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Lesen;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}

                          Befehl_abgearbeitet:=true;

                        end; { $8E }






                  // SUB (IX+d)
                  $96 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IX - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IX + displacement; // (IX+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IX+-d) -> Wert_n

                          setze_Flags_SUB(mod_cpu.Reg.HRS.A, Wert_n);
                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - Wert_n;

                          mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'SUB (IX+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;

                            Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Lesen;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { $96 }





                  // SBC A, (IX+d)
                  $9E : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IX - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IX + displacement; // (IX+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IX + d) -> Wert_n

                          Wert_n2 := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                          setze_Flags_SBC(mod_cpu.Reg.HRS.A, Wert_n, Wert_n2);
                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - Wert_n - Wert_n2;

                          mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'SBC A, (IX+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;
                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                            Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Lesen;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}

                          Befehl_abgearbeitet:=true;

                        end; { $9E }





                  // AND (IX+d)
                  $A6 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IX - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IX + displacement; // (IX+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IX + d) -> Wert_n

                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A and Wert_n;
                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                          // H is set
                          Half_Carry_Flag_Set;

                          mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'AND (IX+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;
                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                            Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { $A6 }






                  // XOR (IX+d)
                  $AE : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IX - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IX + displacement; // (IX+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IX + d) -> Wert_n

                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A xor Wert_n;
                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                          // H is reset
                          Half_Carry_Flag_Reset;

                          mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'XOR (IX+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;
                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                            Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}

                          Befehl_abgearbeitet:=true;

                        end; { $AE }





                  // OR (IX+d)
                  $B6 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IX - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IX + displacement; // (IX+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IX + d) -> Wert_n

                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A or Wert_n;
                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                          // H is reset
                          Half_Carry_Flag_Reset;

                          mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'OR (IX+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;
                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                            Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { $B6 }







                  // CP (IX+d)
                  $BE : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IX - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IX + displacement; // (IX+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IX+d) -> Wert_n

                          setze_Flags_SUB(mod_cpu.Reg.HRS.A, Wert_n);

                          mod_cpu.Reg.SRS.IX_d:=Wert_Word;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'CP (IX+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;

                            Form_cpu.Reg_Red.SRS.IX_Inhalt:=Farbe_Lesen;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { $BE }



    end; // case OP_Code of



  end; { procedure OP_Code_DD_10 }







  procedure OP_Code_DD_11;
  var
    Wert_n, Wert_n2 : Byte;
    Wert_Word : Word;
  begin


    case OP_Code of


      $CB : OP_Code_DD_CB;


                        // POP IX
                  $E1 : begin

                          Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                          {$ENDIF}

                          INC(mod_cpu.Reg.SRS.SP);

                          Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                          mod_cpu.Reg.SRS.IX := (Wert_n2 shl 8) + Wert_n;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                          {$ENDIF}

                          INC(mod_cpu.Reg.SRS.SP);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'POP IX';

                            Form_cpu.Reg_Red.SRS.SP:=Farbe_Lesen;
                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; // POP IX




                          // EX (SP), IX
                  $E3 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                          {$ENDIF}

                          Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);
                          Wert_Word := mod_cpu.Reg.SRS.IX;
                          mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, (mod_cpu.Reg.SRS.IX and $00FF));

                          INC(mod_cpu.Reg.SRS.SP);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                          {$ENDIF}

                          Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);
                          mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, (mod_cpu.Reg.SRS.IX shr 8));
                          mod_cpu.Reg.SRS.IX := (Wert_n2 shl 8) + Wert_n;

                          DEC(mod_cpu.Reg.SRS.SP);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'EX (SP), IX';

                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.SP_Inhalt:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; // EX (SP), IX




                        // PUSH IX
                  $E5 : begin

                          Wert_n2 := mod_cpu.Reg.SRS.IX shr 8;
                          Wert_n  := mod_cpu.Reg.SRS.IX and $00FF;

                          DEC(mod_cpu.Reg.SRS.SP);
                          mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n2);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                          {$ENDIF}

                          DEC(mod_cpu.Reg.SRS.SP);
                          mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin
                            Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                            Befehl_Zeile := 'PUSH IX';

                            Form_cpu.Reg_Red.SRS.SP:=Farbe_Lesen;
                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; // PUSH IX





                        // JP (IX)
                  $E9 : begin
                        {
                        Condition Bits Affected: None
                        }

                        mod_cpu.Reg.SRS.PC := mod_cpu.Reg.SRS.IX;

                        {$IFDEF mit_GUI}
                        if Mode_Protokoll then begin
                          Befehl_Zeile := 'JP (IX)';
                          Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;
                          Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;
                        end;
                        {$ENDIF}

                        Befehl_abgearbeitet:=true;

                      end;  // JP (IX)





                        // LD SP, IX
                  $F9 : begin

                          mod_cpu.Reg.SRS.SP := mod_cpu.Reg.SRS.IX;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'LD SP, IX';

                            Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IX:=Farbe_Lesen;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; // LD SP, IX



    end; { case OP_Code of }



  end; { procedure OP_Code_DD_11 }





  procedure OP_Code_DD;
  var
    OP_Code2 : Byte;
  begin

    {$IFDEF mit_GUI}
    if Mode_Protokoll then
      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
    {$ENDIF}

    OP_Code := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
    INC(mod_cpu.Reg.SRS.PC);

    OP_Code2 := OP_Code AND %11000000;

    case OP_Code2 of

      %00000000 : OP_Code_DD_00;

      %01000000 : OP_Code_DD_01;

      %10000000 : OP_Code_DD_10;

      %11000000 : OP_Code_DD_11;

    end; { case temp_op_code of }

  end; { procedure OP_Code_DD }




{ *** OP_Code_DD *** }



