
  { *** OP_Code_FD *** }



  { *** OP_Code_FD *** }



  { *************************** }
  { *** Untergruppen von 11 *** }
  { *************************** }


  // IY-Befehle




  procedure OP_Code_FD_00;
  var
    displacement, Wert_n, Wert_n2,
    OP_Code2, ziel_reg : Byte;
    Wert_Word : Word;
  begin


    OP_Code2 := OP_Code AND %00001111;

    case OP_Code2 of

      // ADD IY,pp
      %00000000 : begin

                    ziel_reg :=  OP_Code AND %00000111;

                    case ziel_reg of

                      // ADD IY,BC
                      %00000000 : begin
                                    {
                                    S is not affected
                                    Z is not affected
                                    H is set if carry out of bit 11; reset otherwise
                                    P/V is not affected
                                    N is reset
                                    C is set if carry from bit 15; reset otherwise
                                    }

                                    Wert_Word := (mod_cpu.Reg.HRS.B shl 8) + mod_cpu.Reg.HRS.C;

                                    // H is set if carry out of bit 11; reset otherwise
                                    HalfCarry_ADD16(mod_cpu.Reg.SRS.IY, Wert_Word);

                                    // C is set if carry from bit 15; reset otherwise
                                    Carry_Flag_set_if_carry_from_bit_15(mod_cpu.Reg.SRS.IY + Wert_Word);

                                    // N is reset
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }

                                    // IY + BC
                                    mod_cpu.Reg.SRS.IY := mod_cpu.Reg.SRS.IY + Wert_Word;

                                    {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'ADD IY, BC';

                                        Form_cpu.Reg_Red.SRS.IY:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.HRS.BC:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                  end; // ADD IY,BC



                      // ADD IY,DE
                      %00010000 : begin
                                    {
                                    S is not affected
                                    Z is not affected
                                    H is set if carry out of bit 11; reset otherwise
                                    P/V is not affected
                                    N is reset
                                    C is set if carry from bit 15; reset otherwise
                                    }

                                    Wert_Word := (mod_cpu.Reg.HRS.D shl 8) + mod_cpu.Reg.HRS.E;

                                    // H is set if carry out of bit 11; reset otherwise
                                    HalfCarry_ADD16(mod_cpu.Reg.SRS.IY, Wert_Word);

                                    // C is set if carry from bit 15; reset otherwise
                                    Carry_Flag_set_if_carry_from_bit_15(mod_cpu.Reg.SRS.IY + Wert_Word);

                                    // N is reset
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }

                                    // IY + DE
                                    mod_cpu.Reg.SRS.IY := mod_cpu.Reg.SRS.IY + Wert_Word;

                                    {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'ADD IY, DE';

                                        Form_cpu.Reg_Red.SRS.IY:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.HRS.DE:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                  end; // ADD IY,DE



                      // ADD IY,HL
                      %00100000 : begin
                                    {
                                    S is not affected
                                    Z is not affected
                                    H is set if carry out of bit 11; reset otherwise
                                    P/V is not affected
                                    N is reset
                                    C is set if carry from bit 15; reset otherwise
                                    }

                                    Wert_Word := (mod_cpu.Reg.HRS.H shl 8) + mod_cpu.Reg.HRS.L;

                                    // H is set if carry out of bit 11; reset otherwise
                                    HalfCarry_ADD16(mod_cpu.Reg.SRS.IY, Wert_Word);

                                    // C is set if carry from bit 15; reset otherwise
                                    Carry_Flag_set_if_carry_from_bit_15(mod_cpu.Reg.SRS.IY + Wert_Word);

                                    // N is reset
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }

                                    // IY + HL
                                    mod_cpu.Reg.SRS.IY := mod_cpu.Reg.SRS.IY + Wert_Word;

                                    {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'ADD IY, HL';

                                        Form_cpu.Reg_Red.SRS.IY:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.HRS.HL:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                  end; // ADD IY,HL



                      // ADD IY,SP
                      %00110000 : begin
                                    {
                                    S is not affected
                                    Z is not affected
                                    H is set if carry out of bit 11; reset otherwise
                                    P/V is not affected
                                    N is reset
                                    C is set if carry from bit 15; reset otherwise
                                    }

                                    // H is set if carry out of bit 11; reset otherwise
                                    HalfCarry_ADD16(mod_cpu.Reg.SRS.IY, mod_cpu.Reg.SRS.SP);

                                    // C is set if carry from bit 15; reset otherwise
                                    Carry_Flag_set_if_carry_from_bit_15(mod_cpu.Reg.SRS.IY + mod_cpu.Reg.SRS.SP);

                                    // N is reset
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }

                                    // IY + HL
                                    mod_cpu.Reg.SRS.IY := mod_cpu.Reg.SRS.IY + mod_cpu.Reg.SRS.SP;

                                    {$IFDEF mit_GUI}
                                      if Mode_Protokoll then begin

                                        Befehl_Zeile := 'ADD IY, HL';

                                        Form_cpu.Reg_Red.SRS.IY:=Farbe_Schreiben;
                                        Form_cpu.Reg_Red.SRS.SP:=Farbe_Lesen;
                                        Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;

                                      end; { if Mode_Protokoll then }
                                      {$ENDIF}

                                      Befehl_abgearbeitet:=true;

                                  end; // ADD IY,SP


                    end; // case ziel_reg of


                  end; // ADD IY,pp

    else

    case OP_Code of



                  // LD IY, nn
                  $21 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                            mod_cpu.Reg.SRS.IY_d:=mod_cpu.Reg.SRS.IY;
                          {$ENDIF}

                          Wert_n :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          Wert_n2 :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          mod_cpu.Reg.SRS.IY := (Wert_n2 shl 8) + Wert_n;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                             Befehl_Zeile := 'LD IY, '+IntToHex(Wert_n2,2)+
                                             IntToHex(Wert_n,2)+'H';

                             Form_cpu.Reg_Red.SRS.IY:=Farbe_Schreiben;

                           end; { if Mode_Protokoll then }
                           {$ENDIF}
                           Befehl_abgearbeitet:=true;

                        end; { $21 }





                  // LD (nn), IY
                  $22 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                            mod_cpu.Reg.SRS.IY_d:=mod_cpu.Reg.SRS.IY;
                          {$ENDIF}

                          Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          // nn
                          Wert_Word := (Wert_n2 shl 8) + Wert_n;

                          Wert_n2 := mod_cpu.Reg.SRS.IY shr 8;
                          Wert_n  := mod_cpu.Reg.SRS.IY and $00FF;

                          mod_ram.Write_Byte(Wert_Word, Wert_n);

                          INC(Wert_Word);

                          mod_ram.Write_Byte(Wert_Word, Wert_n2);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            DEC(Wert_Word);

                            Befehl_Zeile := 'LD ('+IntToHex(Wert_Word,4)+'H), IY';

                            Form_RAM.setze_Mem_Red(Wert_Word);
                            INC(Wert_Word);
                            Form_RAM.setze_Mem_Red(Wert_Word);

                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { $22 }




                  // INC, IY
                  $23 : begin

                          INC(mod_cpu.Reg.SRS.IY);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'INC IY';

                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Schreiben;

                            mod_cpu.Reg.SRS.IY_d:=mod_cpu.Reg.SRS.IY;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { $23 }





                  // LD IY, (nn)
                  $2A : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                              Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          // nn
                          Wert_Word := (Wert_n2 shl 8) + Wert_n;

                          // (nn)
                          Wert_n := mod_ram.Read_Byte(Wert_Word);

                          INC(Wert_Word);

                          // (nn+1)
                          Wert_n2 := mod_ram.Read_Byte(Wert_Word);

                          mod_cpu.Reg.SRS.IY := (Wert_n2 shl 8) + Wert_n;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            DEC(Wert_Word);

                            Befehl_Zeile := 'LD IY, ('+IntToHex(Wert_Word,4)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            INC(Wert_Word);
                            Form_RAM.setze_Mem_Green(Wert_Word);

                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Schreiben;
                            mod_cpu.Reg.SRS.IY_d:=mod_cpu.Reg.SRS.IY;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { LD IY, (nn) }




                  // DEC IY
                  $2B : begin

                          DEC(mod_cpu.Reg.SRS.IY);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin
                            Befehl_Zeile := 'DEC IY';

                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Schreiben;
                            mod_cpu.Reg.SRS.IY_d:=mod_cpu.Reg.SRS.IY;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { DEC IY }




                  // INC (IY+d)
                  $34 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IY + displacement; // (IY+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY+-d) -> Wert_n

                          Wert_n2 := Wert_n and $0F;
                          INC(Wert_n2);

                          {
                          S is set if result is negative; reset otherwise
                          Z is set if result is zero; reset otherwise
                          H is set if carry from bit 3; reset otherwise
                          P/V is set if (IY+d) was 7FH before operation; reset otherwise
                          N is reset
                          C is not affected
                          }

                          // P/V is set if (IY+d) was 7FH before operation; reset otherwise
                          if Wert_n=$7F then
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                          else
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                          // INC
                          INC(Wert_n);


                          // S is set if result is negative; reset otherwise
                          Sign_Flag_negative(Wert_n);

                          // Z is set if result is zero; reset otherwise
                          Zero_Flag_zero(Wert_n);

                          // H is set if carry from bit 3; reset otherwise
                          if ((Wert_n2) and $10) = 0 then
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                          else
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                          // N is reset
                          Num_Flag_Reset;

                          mod_ram.Write_Byte(Wert_Word, Wert_n);


                          // Anzeige von (IY+d)
                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'INC (IY+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Red(Wert_Word);
                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                            mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                            Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}


                          Befehl_abgearbeitet:=true;

                        end; { INC (IY+d) }





                  // DEC (IY+d)
                  $35 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IY + displacement; // (IY+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY+-d) -> Wert_n

                          Wert_n2 := Wert_n and $0F;
                          DEC(Wert_n2);

                          {
                          S is set if result is negative; reset otherwise
                          Z is set if result is zero; reset otherwise
                          H is set if borrow from bit 4, reset otherwise
                          P/V is set if m was 80H before operation; reset otherwise
                          N is set
                          C is not affected
                          }

                          // P/V is set if m was 80H before operation; reset otherwise
                          if Wert_n=$80 then
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
                          else
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }


                          // DEC
                          DEC(Wert_n);


                          // S is set if result is negative; reset otherwise
                          Sign_Flag_negative(Wert_n);

                          // Z is set if result is zero; reset otherwise
                          Zero_Flag_zero(Wert_n);

                          // H is set if borrow from bit 4, reset otherwise
                          if ((Wert_n2) and $10) = 0 then
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
                          else
                            mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

                          // N is set
                          Num_Flag_Set;

                          mod_ram.Write_Byte(Wert_Word, Wert_n);


                          // Anzeige von (IY+d)
                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'DEC (IY+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Red(Wert_Word);
                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                            mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                            Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}


                          Befehl_abgearbeitet:=true;

                        end; { DEC (IY+d) }





                  // LD (IY+d), n
                  $36 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IY + displacement; // (IY+-d)

                          Wert_n :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          mod_ram.Write_Byte(Wert_Word, Wert_n);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'LD (IY+'+IntToHex(displacement,2)+'H), '+
                                            IntToHex(Wert_n,+2)+'H';

                            Form_RAM.setze_Mem_Red(Wert_Word);
                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                            mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                            Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { $36 }




    end; // case OP_Code of

    end; // case OP_Code2 of

  end; { procedure OP_Code_FD_00 }




  procedure OP_Code_FD_01;
  var
    quell_reg, ziel_reg, OP_Code2,
    displacement : Byte;
    Wert_Word : Word;
  begin

    OP_Code2 := OP_Code AND %00000111;

    case OP_Code2 of

      // LD r, (IY+d)
      %00000110 : begin

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then
                      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                    {$ENDIF}

                    displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                    INC(mod_cpu.Reg.SRS.PC);

                    if displacement>127 then
                      Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement)
                    else
                      Wert_Word := mod_cpu.Reg.SRS.IY + displacement; // (IY+-d)

                    ziel_reg :=  OP_Code AND %00111000;

                    case ziel_reg of

                      // LD A, (IY+d)
                      %00111000 : begin
                                    mod_cpu.Reg.HRS.A := mod_ram.Read_Byte(Wert_Word);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'LD A, (IY+'+IntToHex(displacement,2)+'H)';

                                      Form_RAM.setze_Mem_Green(Wert_Word);
                                      Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                                      Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // LD A, (IY+d)



                      // LD B, (IY+d)
                      %00000000 : begin
                                    mod_cpu.Reg.HRS.B := mod_ram.Read_Byte(Wert_Word);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'LD B, (IY+'+IntToHex(displacement,2)+'H)';

                                      Form_RAM.setze_Mem_Green(Wert_Word);
                                      Form_cpu.Reg_Red.HRS.B:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Lesen;
                                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // LD B, (IY+d)



                      // LD C, (IY+d)
                      %00001000 : begin
                                    mod_cpu.Reg.HRS.C := mod_ram.Read_Byte(Wert_Word);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'LD C, (IY+'+IntToHex(displacement,2)+'H)';

                                      Form_RAM.setze_Mem_Green(Wert_Word);
                                      Form_cpu.Reg_Red.HRS.C:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Lesen;
                                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // LD C, (IY+d)



                      // LD D, (IY+d)
                      %00010000 : begin
                                    mod_cpu.Reg.HRS.D := mod_ram.Read_Byte(Wert_Word);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'LD D, (IY+'+IntToHex(displacement,2)+'H)';

                                      Form_RAM.setze_Mem_Green(Wert_Word);
                                      Form_cpu.Reg_Red.HRS.D:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Lesen;
                                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // LD D, (IY+d)


                      // LD E, (IY+d)
                      %00011000 : begin

                                    mod_cpu.Reg.HRS.E := mod_ram.Read_Byte(Wert_Word);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'LD E, (IY+'+IntToHex(displacement,2)+'H)';

                                      Form_RAM.setze_Mem_Green(Wert_Word);
                                      Form_cpu.Reg_Red.HRS.E:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                                      Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Lesen;
                                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // LD E, (IY+d)


                      // LD H, (IY+d)
                      %00100000 : begin

                                    mod_cpu.Reg.HRS.H := mod_ram.Read_Byte(Wert_Word);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'LD H, (IY+'+IntToHex(displacement,2)+'H)';

                                      Form_RAM.setze_Mem_Green(Wert_Word);
                                      Form_cpu.Reg_Red.HRS.H:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                                      Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // LD H, (IY+d)



                      // LD L, (IY+d)
                      %00101000 : begin

                                    mod_cpu.Reg.HRS.L := mod_ram.Read_Byte(Wert_Word);

                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'LD L, (IY+'+IntToHex(displacement,2)+'H)';

                                      Form_RAM.setze_Mem_Green(Wert_Word);
                                      Form_cpu.Reg_Red.HRS.L:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                                      Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Lesen;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // LD L, (IY+d)

                    end; { case ziel_reg of }

                  end; { LD r, (IY+d) }


    else  // case OP_Code2 of


      OP_Code2 := OP_Code AND %00111000;


      case OP_Code2 of


        // LD (IY+d), r
        %00110000 : begin

                      {$IFDEF mit_GUI}
                      if Mode_Protokoll then
                        Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                      {$ENDIF}

                      displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                      INC(mod_cpu.Reg.SRS.PC);

                      if displacement>127 then
                        Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement)
                      else
                        Wert_Word := mod_cpu.Reg.SRS.IY + displacement; // (IY+-d)

                      quell_reg :=  OP_Code AND %00000111;

                      case quell_reg of

              // 10 x ->

              // LD (IY+d), A
              %00000111 : begin
                            mod_ram.Write_Byte(Wert_Word, mod_cpu.Reg.HRS.A);

                            {$IFDEF mit_GUI}
                            if Mode_Protokoll then begin

                              Befehl_Zeile := 'LD (IY+'+IntToHex(displacement,2)+'H), A';

                              Form_RAM.setze_Mem_Red(Wert_Word);
                              Form_cpu.Reg_Red.HRS.A:=Farbe_Lesen;
                              Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                              mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                              Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                            end; { if Mode_Protokoll then }
                            {$ENDIF}
                            Befehl_abgearbeitet:=true;

                          end; // LD (IY+d), A


              // LD (IY+d), B
              %00000000 : begin
                            mod_ram.Write_Byte(Wert_Word, mod_cpu.Reg.HRS.B);

                            {$IFDEF mit_GUI}
                            if Mode_Protokoll then begin

                              Befehl_Zeile := 'LD (IY+'+IntToHex(displacement,2)+'H), B';

                              Form_RAM.setze_Mem_Red(Wert_Word);
                              Form_cpu.Reg_Red.HRS.B:=Farbe_Lesen;
                              Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                              mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                              Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                            end; { if Mode_Protokoll then }
                            {$ENDIF}
                            Befehl_abgearbeitet:=true;

                          end; // LD (IY+d), B


              // LD (IY+d), C
              %00000001 : begin
                            mod_ram.Write_Byte(Wert_Word, mod_cpu.Reg.HRS.C);

                            {$IFDEF mit_GUI}
                            if Mode_Protokoll then begin

                              Befehl_Zeile := 'LD (IY+'+IntToHex(displacement,2)+'H), C';

                              Form_RAM.setze_Mem_Red(Wert_Word);
                              Form_cpu.Reg_Red.HRS.C:=Farbe_Lesen;
                              Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                              mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                              Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                            end; { if Mode_Protokoll then }
                            {$ENDIF}
                            Befehl_abgearbeitet:=true;

                          end; // LD (IY+d), C


              // LD (IY+d), D
              %00000010 : begin
                            mod_ram.Write_Byte(Wert_Word, mod_cpu.Reg.HRS.D);

                            {$IFDEF mit_GUI}
                            if Mode_Protokoll then begin

                              Befehl_Zeile := 'LD (IY+'+IntToHex(displacement,2)+'H), D';

                              Form_RAM.setze_Mem_Red(Wert_Word);
                              Form_cpu.Reg_Red.HRS.D:=Farbe_Lesen;
                              Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                              mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                              Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                            end; { if Mode_Protokoll then }
                            {$ENDIF}
                            Befehl_abgearbeitet:=true;

                          end; // LD (IY+d), D


              // LD (IY+d), E
              %00000011 : begin
                            mod_ram.Write_Byte(Wert_Word, mod_cpu.Reg.HRS.E);

                            {$IFDEF mit_GUI}
                            if Mode_Protokoll then begin

                              Befehl_Zeile := 'LD (IY+'+IntToHex(displacement,2)+'H), E';

                              Form_RAM.setze_Mem_Red(Wert_Word);
                              Form_cpu.Reg_Red.HRS.E:=Farbe_Lesen;
                              Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                              mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                              Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                            end; { if Mode_Protokoll then }
                            {$ENDIF}
                            Befehl_abgearbeitet:=true;

                          end; // LD (IY+d), E


              // LD (IY+d), H
              %00000100 : begin
                            mod_ram.Write_Byte(Wert_Word, mod_cpu.Reg.HRS.H);

                            {$IFDEF mit_GUI}
                            if Mode_Protokoll then begin

                              Befehl_Zeile := 'LD (IY+'+IntToHex(displacement,2)+'H), H';

                              Form_RAM.setze_Mem_Red(Wert_Word);
                              Form_cpu.Reg_Red.HRS.H:=Farbe_Lesen;
                              Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                              mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                              Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                            end; { if Mode_Protokoll then }
                            {$ENDIF}
                            Befehl_abgearbeitet:=true;

                          end; // LD (IY+d), H


              // LD (IY+d), L
              %00000101 : begin
                            mod_ram.Write_Byte(Wert_Word, mod_cpu.Reg.HRS.L);

                            {$IFDEF mit_GUI}
                            if Mode_Protokoll then begin

                              Befehl_Zeile := 'LD (IY+'+IntToHex(displacement,2)+'H), L';

                              Form_RAM.setze_Mem_Red(Wert_Word);
                              Form_cpu.Reg_Red.HRS.L:=Farbe_Lesen;
                              Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                              mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                              Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                            end; { if Mode_Protokoll then }
                            {$ENDIF}
                            Befehl_abgearbeitet:=true;

                          end; // LD (IY+d), L

            end; { case quell_reg of }


          end; { LD (IY+d), r }

        end; // case OP_Code2 of

      end;{ else OP_Code2=%01000110 then }



  end; { procedure OP_Code_FD_00 }










  procedure OP_Code_FD_10;
  var
    displacement, Wert_n, Wert_n2 : Byte;
    Wert_Word : Word;
  begin



    case OP_Code of



                  // ADD A, (IY+d)
                  $86 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IY + displacement; // (IY+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY + d) -> Wert_n

                          setze_Flags_ADD(mod_cpu.Reg.HRS.A, Wert_n);
                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + Wert_n;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'ADD A, (IY+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                            mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                            Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Lesen;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { $86 }





                        // ADC A, (IY+d)
                  $8E : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IY + displacement; // (IY+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY + d) -> Wert_n

                          Wert_n2 := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                          setze_Flags_ADC(mod_cpu.Reg.HRS.A, Wert_n, Wert_n2);
                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A + Wert_n + Wert_n2;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'ADC A, (IY+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                            mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                            Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Lesen;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}

                          Befehl_abgearbeitet:=true;

                        end; { $8E }






                  // SUB (IY+d)
                  $96 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IY + displacement; // (IY+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY+-d) -> Wert_n

                          setze_Flags_SUB(mod_cpu.Reg.HRS.A, Wert_n);
                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - Wert_n;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'SUB (IY+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                            mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                            Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Lesen;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { $96 }





                  // SBC A, (IY+d)
                  $9E : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IY + displacement; // (IY+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY + d) -> Wert_n

                          Wert_n2 := mod_cpu.Reg.HRS.F and %00000001; // Cyrry-Flag

                          setze_Flags_SBC(mod_cpu.Reg.HRS.A, Wert_n, Wert_n2);
                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A - Wert_n - Wert_n2;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'SBC A, (IY+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                            mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                            Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Lesen;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}

                          Befehl_abgearbeitet:=true;

                        end; { $9E }





                  // AND (IY+d)
                  $A6 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IY + displacement; // (IY+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY + d) -> Wert_n

                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A and Wert_n;
                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                          // H is set
                          Half_Carry_Flag_Set;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'AND (IY+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                            mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                            Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { $A6 }






                  // XOR (IY+d)
                  $AE : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IY + displacement; // (IY+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY + d) -> Wert_n

                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A xor Wert_n;
                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                          // H is reset
                          Half_Carry_Flag_Reset;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'XOR (IY+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                            mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                            Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}

                          Befehl_abgearbeitet:=true;

                        end; { $AE }





                  // OR (IY+d)
                  $B6 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IY + displacement; // (IY+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY + d) -> Wert_n

                          mod_cpu.Reg.HRS.A := mod_cpu.Reg.HRS.A or Wert_n;
                          setze_Flags_LOGIK(mod_cpu.Reg.HRS.A);
                          // H is reset
                          Half_Carry_Flag_Reset;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'OR (IY+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                            mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                            Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { $B6 }







                  // CP (IY+d)
                  $BE : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
                          {$ENDIF}

                          displacement :=mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
                          INC(mod_cpu.Reg.SRS.PC);

                          if displacement>127 then
                            Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement)
                          else
                            Wert_Word := mod_cpu.Reg.SRS.IY + displacement; // (IY+-d)

                          Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY+d) -> Wert_n

                          setze_Flags_SUB(mod_cpu.Reg.HRS.A, Wert_n);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'CP (IY+'+IntToHex(displacement,2)+'H)';

                            Form_RAM.setze_Mem_Green(Wert_Word);
                            Form_cpu.Reg_Red.HRS.A:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                            mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                            Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Lesen;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; { $BE }



    end; // case OP_Code of



  end; { procedure OP_Code_FD_10 }







  procedure OP_Code_FD_11;
  var
    Wert_n, Wert_n2 : Byte;
    Wert_Word : Word;
  begin


    case OP_Code of


      $CB : OP_Code_FD_CB;


                        // POP IY
                  $E1 : begin

                          Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                          {$ENDIF}

                          INC(mod_cpu.Reg.SRS.SP);

                          Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);

                          mod_cpu.Reg.SRS.IY := (Wert_n2 shl 8) + Wert_n;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.SP);
                          {$ENDIF}

                          INC(mod_cpu.Reg.SRS.SP);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'POP IY';

                            Form_cpu.Reg_Red.SRS.SP:=Farbe_Lesen;
                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; // POP IY




                          // EX (SP), IY
                  $E3 : begin

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                          {$ENDIF}

                          Wert_n := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);
                          Wert_Word := mod_cpu.Reg.SRS.IY;
                          mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, (mod_cpu.Reg.SRS.IY and $00FF));

                          INC(mod_cpu.Reg.SRS.SP);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                          {$ENDIF}

                          Wert_n2 := mod_ram.Read_Byte(mod_cpu.Reg.SRS.SP);
                          mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, (mod_cpu.Reg.SRS.IY shr 8));
                          mod_cpu.Reg.SRS.IY := (Wert_n2 shl 8) + Wert_n;

                          DEC(mod_cpu.Reg.SRS.SP);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'EX (SP), IY';

                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.SP_Inhalt:=Farbe_Schreiben;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; // EX (SP), IY




                        // PUSH IY
                  $E5 : begin

                          Wert_n2 := mod_cpu.Reg.SRS.IY shr 8;
                          Wert_n  := mod_cpu.Reg.SRS.IY and $00FF;

                          DEC(mod_cpu.Reg.SRS.SP);
                          mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n2);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then
                            Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);
                          {$ENDIF}

                          DEC(mod_cpu.Reg.SRS.SP);
                          mod_ram.Write_Byte(mod_cpu.Reg.SRS.SP, Wert_n);

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin
                            Form_RAM.setze_Mem_Red(mod_cpu.Reg.SRS.SP);

                            Befehl_Zeile := 'PUSH IY';

                            Form_cpu.Reg_Red.SRS.SP:=Farbe_Lesen;
                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; // PUSH IY





                        // JP (IY)
                  $E9 : begin
                        {
                        Condition Bits Affected: None
                        }

                        mod_cpu.Reg.SRS.PC := mod_cpu.Reg.SRS.IY;

                        {$IFDEF mit_GUI}
                        if Mode_Protokoll then begin
                          Befehl_Zeile := 'JP (IY)';
                          Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                          Form_cpu.Reg_Red.SRS.PC:=Farbe_Schreiben;
                        end;
                        {$ENDIF}

                        Befehl_abgearbeitet:=true;

                      end;  // JP (IY)





                        // LD SP, IY
                  $F9 : begin

                          mod_cpu.Reg.SRS.SP := mod_cpu.Reg.SRS.IY;

                          {$IFDEF mit_GUI}
                          if Mode_Protokoll then begin

                            Befehl_Zeile := 'LD SP, IY';

                            Form_cpu.Reg_Red.SRS.SP:=Farbe_Schreiben;
                            Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;

                          end; { if Mode_Protokoll then }
                          {$ENDIF}
                          Befehl_abgearbeitet:=true;

                        end; // LD SP, IY



    end; { case OP_Code of }



  end; { procedure OP_Code_FD_11 }





  procedure OP_Code_FD;
  var
    OP_Code2 : Byte;
  begin

    {$IFDEF mit_GUI}
    if Mode_Protokoll then
      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
    {$ENDIF}

    OP_Code := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
    INC(mod_cpu.Reg.SRS.PC);

    OP_Code2 := OP_Code AND %11000000;

    case OP_Code2 of

      %00000000 : OP_Code_FD_00;

      %01000000 : OP_Code_FD_01;

      %10000000 : OP_Code_FD_10;

      %11000000 : OP_Code_FD_11;

    end; { case temp_op_code of }

  end; { procedure OP_Code_FD }




{ *** OP_Code_FD *** }



