
  { *** OP_Code_FD_CB *** }



  { *************************** }
  { *** Untergruppen von FD *** }
  { *************************** }


  // IY-Befehle

  var
    displacement_FD_CB : Byte;


  procedure OP_Code_FD_CB_00;
  var
    Wert_n : Byte;
    Wert_Word : Word;
  begin

    case OP_Code of



      // RLC (IY+d)
      $06 : begin

              if displacement_FD_CB>127 then
                Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement_FD_CB)
              else
                Wert_Word := mod_cpu.Reg.SRS.IY + displacement_FD_CB; // (IY +- d)

              Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY +- d) -> Wert_n

              {$IFDEF mit_GUI}
              if Mode_Protokoll then begin
                Form_RAM.setze_Mem_Red(Wert_Word);  // (IY + d)
                mod_cpu.Reg.SRS.IY_d:=Wert_Word;
              end;
              {$ENDIF}


              // RLC ...
              if (Wert_n and %10000000) = %10000000 then begin

                // Rotation von Wert_n und setzen Bit 0 (da Bit 7 vorher 1 war)
                Wert_n := (Wert_n shl 1) or %00000001;

                // CY is set
                mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }

              end
              else begin

                // Rotation von Wert_n und ruecksetzen Bit 0 (da Bit 7 vorher 0 war)
                Wert_n := (Wert_n shl 1) and %11111110;

                // CY is reset
                mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }

              end; { if (Wert_n and %10000000) = %10000000 then }

              {
              C Data from bit 7 of the source.
              }

              setze_Flags_ROTATE(Wert_n);
              mod_ram.Write_Byte(Wert_Word, Wert_n);

              {$IFDEF mit_GUI}
              if Mode_Protokoll then begin

                Befehl_Zeile := 'RLC (IY+'+IntToHex(displacement_FD_CB,2)+'H)';

                Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

              end; { if Mode_Protokoll then }
              {$ENDIF}

              Befehl_abgearbeitet:=true;

            end; // RLC (IY+d)



      // RL (IY+d)
      $16 : begin

              if displacement_FD_CB>127 then
                Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement_FD_CB)
              else
                Wert_Word := mod_cpu.Reg.SRS.IY + displacement_FD_CB; // (IY +- d)

              Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY +- d) -> Wert_n

              {$IFDEF mit_GUI}
              if Mode_Protokoll then begin
                Form_RAM.setze_Mem_Red(Wert_Word);  // (IY +- d)
                mod_cpu.Reg.SRS.IY_d:=Wert_Word;
              end;
              {$ENDIF}


              // RL ...

              if (Wert_n and %10000000) = %10000000 then begin

                // Rotation von Wert_n und setzen CY -> Bit 0
                if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then
                  Wert_n := (Wert_n shl 1) or %00000001
                else
                  Wert_n := (Wert_n shl 1) and %11111110;

                // CY is set
                mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }

              end
              else begin

                // Rotation von Wert_n und setzen CY -> Bit 0
                if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then
                  Wert_n := (Wert_n shl 1) or %00000001
                else
                  Wert_n := (Wert_n shl 1) and %11111110;

                // CY is reset
                mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }

              end; { if (Wert_n and %10000000) = %10000000 then }


              {
              C Data from bit 7 of the source.
              }

              setze_Flags_ROTATE(Wert_n);
              mod_ram.Write_Byte(Wert_Word, Wert_n);

              {$IFDEF mit_GUI}
              if Mode_Protokoll then begin

                Befehl_Zeile := 'RL (IY+'+IntToHex(displacement_FD_CB,2)+'H)';

                Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

              end; { if Mode_Protokoll then }
              {$ENDIF}

              Befehl_abgearbeitet:=true;

            end; // RL (IY+d)




      // RR (IY+d)
      $1E : begin

              if displacement_FD_CB>127 then
                Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement_FD_CB)
              else
                Wert_Word := mod_cpu.Reg.SRS.IY + displacement_FD_CB; // (IY +- d)

              Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY +- d) -> Wert_n

              {$IFDEF mit_GUI}
              if Mode_Protokoll then begin
                Form_RAM.setze_Mem_Red(Wert_Word);  // (IY +- d)
                mod_cpu.Reg.SRS.IY_d:=Wert_Word;
              end;
              {$ENDIF}


              // Merken von Bit 0 -> CY
              if (Wert_n and %00000001) = %00000001 then begin

                // Rechts-Rotation von Wert_n und setzen CY -> Bit 7
                if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then
                  Wert_n := (Wert_n shr 1) or %10000000
                else
                  Wert_n := (Wert_n shr 1) and %01111111;

                // CY is set
                mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }

              end
              else begin

                // Rechts-Rotation von Wert_n und setzen CY -> Bit 7
                if (mod_cpu.Reg.HRS.F and %00000001) = %00000001 then
                  Wert_n := (Wert_n shr 1) or %10000000
                else
                  Wert_n := (Wert_n shr 1) and %01111111;

                // CY is reset
                mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }

              end; { if (Wert_n and %10000000) = %10000000 then }

              setze_Flags_ROTATE(Wert_n);
              mod_ram.Write_Byte(Wert_Word, Wert_n);

              {$IFDEF mit_GUI}
              if Mode_Protokoll then begin

                Befehl_Zeile := 'RR (IY+'+IntToHex(displacement_FD_CB,2)+'H)';

                Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

              end; { if Mode_Protokoll then }
              {$ENDIF}

              Befehl_abgearbeitet:=true;

            end; // RR (IY+d)




      // SLA (IY+d)
      $26 : begin

              if displacement_FD_CB>127 then
                Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement_FD_CB)
              else
                Wert_Word := mod_cpu.Reg.SRS.IY + displacement_FD_CB; // (IY +- d)

              Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY +- d) -> Wert_n

              {$IFDEF mit_GUI}
              if Mode_Protokoll then begin
                Form_RAM.setze_Mem_Red(Wert_Word);  // (IY + d)
                mod_cpu.Reg.SRS.IY_d:=Wert_Word;
              end;
              {$ENDIF}

              // CY is data from bit 7 of source register
              if (Wert_n and %10000000) = %10000000 then
                // CY is set
                mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001 { Set CF }
              else
                // CY is reset
                mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }


              // SLA Wert_n
              Wert_n := Wert_n shl 1;

              setze_Flags_ROTATE(Wert_n);
              mod_ram.Write_Byte(Wert_Word, Wert_n);

              {$IFDEF mit_GUI}
              if Mode_Protokoll then begin

                Befehl_Zeile := 'SLA (IY+'+IntToHex(displacement_FD_CB,2)+'H)';

                Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

              end; { if Mode_Protokoll then }
              {$ENDIF}

              Befehl_abgearbeitet:=true;

            end; // SLA (IY+d)





      // SRA (IY+d)
      $2E : begin

              if displacement_FD_CB>127 then
                Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement_FD_CB)
              else
                Wert_Word := mod_cpu.Reg.SRS.IY + displacement_FD_CB; // (IY +- d)

              Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY +- d) -> Wert_n

              {$IFDEF mit_GUI}
              if Mode_Protokoll then begin
                Form_RAM.setze_Mem_Red(Wert_Word);  // (IY + d)
                mod_cpu.Reg.SRS.IY_d:=Wert_Word;
              end;
              {$ENDIF}


              // merken von Bit 7 des Wert_n
              if (Wert_n and %10000000) = %10000000 then begin

                // *** hier Bit 7 = 1

                // CY wird nach Bit 0 des Wert_n gesetzt
                if (Wert_n and %00000001) = %00000001 then
                  // CY is set
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001 { Set CF }
                else
                  // CY is reset
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }

                // SRA Wert_n
                Wert_n := Wert_n shr 1;

                // setzen von Bit 7 des Wert_n (war vorher auch 1)
                Wert_n := Wert_n or %10000000 { Set bit 7 }

              end
              else begin

                // *** hier Bit 7 = 0

                // CY wird nach Bit 0 des Wert_n gesetzt
                if (Wert_n and %00000001) = %00000001 then
                  // CY is set
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001 { Set CF }
                else
                  // CY is reset
                  mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }

                  // SRA Wert_n
                  Wert_n := Wert_n shr 1;

                  // Ruecksetzen von Bit 7 des Wert_n (war vorher auch 0)
                  Wert_n := Wert_n and %01111111; { Reset bit 7 }

                end; { if (Wert_n and %10000000) = %10000000 then }


                // FLAGS setzen ...
                setze_Flags_ROTATE(Wert_n);
                mod_ram.Write_Byte(Wert_Word, Wert_n);



              // SRA Wert_n
              Wert_n := Wert_n shl 1;

              setze_Flags_ROTATE(Wert_n);
              mod_ram.Write_Byte(Wert_Word, Wert_n);

              {$IFDEF mit_GUI}
              if Mode_Protokoll then begin

                Befehl_Zeile := 'SRA (IY+'+IntToHex(displacement_FD_CB,2)+'H)';

                Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

              end; { if Mode_Protokoll then }
              {$ENDIF}

              Befehl_abgearbeitet:=true;

            end; // SRA (IY+d)





      // SRL (IY+d)
      $3E : begin

              if displacement_FD_CB>127 then
                Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement_FD_CB)
              else
                Wert_Word := mod_cpu.Reg.SRS.IY + displacement_FD_CB; // (IY +- d)

              Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY +- d) -> Wert_n

              {$IFDEF mit_GUI}
              if Mode_Protokoll then begin
                Form_RAM.setze_Mem_Red(Wert_Word);  // (IY + d)
                mod_cpu.Reg.SRS.IY_d:=Wert_Word;
              end;
              {$ENDIF}


              // CY wird nach Bit 0 des Wert_n gesetzt
              if (Wert_n and %00000001) = %00000001 then
                // CY is set
                mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001 { Set CF }
              else
                // CY is reset
                mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }


              // SRL Wert_n
              Wert_n := Wert_n shr 1;

              // Wert_n -> (IY+d)
              mod_ram.Write_Byte(Wert_Word, Wert_n);


              // FLAGS setzen ...
              setze_Flags_ROTATE(Wert_n);


              {$IFDEF mit_GUI}
              if Mode_Protokoll then begin

                Befehl_Zeile := 'SRL (IY+'+IntToHex(displacement_FD_CB,2)+'H)';

                Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

              end; { if Mode_Protokoll then }
              {$ENDIF}

              Befehl_abgearbeitet:=true;

            end; // SRL (IY+d)





    end; // case OP_Code of



  end; { procedure OP_Code_FD_CB_00 }




  procedure OP_Code_FD_CB_01;
  var
    OP_Code2, ziel_bit,
    Wert_n : Byte;
    Wert_Word : Word;
  begin


    OP_Code2 := OP_Code AND %00000111;

    case OP_Code2 of

      // BIT b,(IY+d)
      %00000110 : begin

                    if displacement_FD_CB>127 then
                      Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement_FD_CB)
                    else
                      Wert_Word := mod_cpu.Reg.SRS.IY + displacement_FD_CB; // (IY +- d)

                    Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY +- d) -> Wert_n

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      Form_RAM.setze_Mem_Red(Wert_Word);  // (IY + d)
                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                    end;
                    {$ENDIF}


                    ziel_bit := OP_Code AND %00111000;

                    case ziel_bit of


                      // BIT 0,(IY+d)
                      %00000000 : begin

                                    {
                                    S is unknown
                                    Z is set if specified bit is 0; reset otherwise
                                    H is set
                                    P/V is unknown
                                    N is reset
                                    C is not affected
                                    }

                                    // SF - bei Bit 0..6 Reset (wie im Emulator)
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %01111111; { Reset SF }

                                    // Z is set if specified bit is 0; reset otherwise
                                    // P/V wie Z
                                    if (Wert_n and %00000001) = 0 then begin
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %01000000; { Set ZF }
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100; { Set PF }
                                    end
                                    else begin
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %10111111; { Reset ZF }
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }
                                    end;

                                    // H is set
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00010000; { Set HF }

                                    // N is reset
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'BIT 0,(IY+'+IntToHex(displacement_FD_CB,2)+'H)';

                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                                      Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // BIT 0,(IY+d)


                      // BIT 1,(IY+d)
                      %00001000 : begin

                                    {
                                    S is unknown
                                    Z is set if specified bit is 0; reset otherwise
                                    H is set
                                    P/V is unknown
                                    N is reset
                                    C is not affected
                                    }

                                    // SF - bei Bit 0..6 Reset (wie im Emulator)
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %01111111; { Reset SF }

                                    // Z is set if specified bit is 0; reset otherwise
                                    // P/V wie Z
                                    if (Wert_n and %00000010) = 0 then begin
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %01000000; { Set ZF }
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100; { Set PF }
                                    end
                                    else begin
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %10111111; { Reset ZF }
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }
                                    end;

                                    // H is set
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00010000; { Set HF }

                                    // N is reset
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'BIT 1,(IY+'+IntToHex(displacement_FD_CB,2)+'H)';

                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                                      Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // BIT 1,(IY+d)



                      // BIT 2,(IY+d)
                      %00010000 : begin

                                    {
                                    S is unknown
                                    Z is set if specified bit is 0; reset otherwise
                                    H is set
                                    P/V is unknown
                                    N is reset
                                    C is not affected
                                    }

                                    // SF - bei Bit 0..6 Reset (wie im Emulator)
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %01111111; { Reset SF }

                                    // Z is set if specified bit is 0; reset otherwise
                                    // P/V wie Z
                                    if (Wert_n and %00000100) = 0 then begin
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %01000000; { Set ZF }
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100; { Set PF }
                                    end
                                    else begin
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %10111111; { Reset ZF }
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }
                                    end;

                                    // H is set
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00010000; { Set HF }

                                    // N is reset
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'BIT 2,(IY+'+IntToHex(displacement_FD_CB,2)+'H)';

                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                                      Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // BIT 2,(IY+d)


                      // BIT 3,(IY+d)
                      %00011000 : begin

                                    {
                                    S is unknown
                                    Z is set if specified bit is 0; reset otherwise
                                    H is set
                                    P/V is unknown
                                    N is reset
                                    C is not affected
                                    }

                                    // SF - bei Bit 0..6 Reset (wie im Emulator)
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %01111111; { Reset SF }

                                    // Z is set if specified bit is 0; reset otherwise
                                    // P/V wie Z
                                    if (Wert_n and %00001000) = 0 then begin
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %01000000; { Set ZF }
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100; { Set PF }
                                    end
                                    else begin
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %10111111; { Reset ZF }
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }
                                    end;

                                    // H is set
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00010000; { Set HF }

                                    // N is reset
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'BIT 3,(IY+'+IntToHex(displacement_FD_CB,2)+'H)';

                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                                      Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // BIT 3,(IY+d)



                      // BIT 4,(IY+d)
                      %00100000 : begin

                                    {
                                    S is unknown
                                    Z is set if specified bit is 0; reset otherwise
                                    H is set
                                    P/V is unknown
                                    N is reset
                                    C is not affected
                                    }

                                    // SF - bei Bit 0..6 Reset (wie im Emulator)
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %01111111; { Reset SF }

                                    // Z is set if specified bit is 0; reset otherwise
                                    // P/V wie Z
                                    if (Wert_n and %00010000) = 0 then begin
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %01000000; { Set ZF }
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100; { Set PF }
                                    end
                                    else begin
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %10111111; { Reset ZF }
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }
                                    end;

                                    // H is set
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00010000; { Set HF }

                                    // N is reset
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'BIT 4,(IY+'+IntToHex(displacement_FD_CB,2)+'H)';

                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                                      Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // BIT 4,(IY+d)


                      // BIT 5,(IY+d)
                      %00101000 : begin

                                    {
                                    S is unknown
                                    Z is set if specified bit is 0; reset otherwise
                                    H is set
                                    P/V is unknown
                                    N is reset
                                    C is not affected
                                    }

                                    // SF - bei Bit 0..6 Reset (wie im Emulator)
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %01111111; { Reset SF }

                                    // Z is set if specified bit is 0; reset otherwise
                                    // P/V wie Z
                                    if (Wert_n and %00100000) = 0 then begin
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %01000000; { Set ZF }
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100; { Set PF }
                                    end
                                    else begin
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %10111111; { Reset ZF }
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }
                                    end;

                                    // H is set
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00010000; { Set HF }

                                    // N is reset
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'BIT 5,(IY+'+IntToHex(displacement_FD_CB,2)+'H)';

                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                                      Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // BIT 5,(IY+d)



                      // BIT 6,(IY+d)
                      %00110000 : begin

                                    {
                                    S is unknown
                                    Z is set if specified bit is 0; reset otherwise
                                    H is set
                                    P/V is unknown
                                    N is reset
                                    C is not affected
                                    }

                                    // SF - bei Bit 0..6 Reset (wie im Emulator)
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %01111111; { Reset SF }

                                    // Z is set if specified bit is 0; reset otherwise
                                    // P/V wie Z
                                    if (Wert_n and %01000000) = 0 then begin
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %01000000; { Set ZF }
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100; { Set PF }
                                    end
                                    else begin
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %10111111; { Reset ZF }
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }
                                    end;

                                    // H is set
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00010000; { Set HF }

                                    // N is reset
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'BIT 6,(IY+'+IntToHex(displacement_FD_CB,2)+'H)';

                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                                      Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // BIT 6,(IY+d)



                      // BIT 7,(IY+d)
                      %00111000 : begin

                                    {
                                    S is unknown
                                    Z is set if specified bit is 0; reset otherwise
                                    H is set
                                    P/V is unknown
                                    N is reset
                                    C is not affected
                                    }

                                    // SF - bei Bit 7 Set (wie im Emulator)
                                    Sign_Flag_negative(Wert_n);

                                    // Z is set if specified bit is 0; reset otherwise
                                    // P/V wie Z
                                    if (Wert_n and %10000000) = 0 then begin
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %01000000; { Set ZF }
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100; { Set PF }
                                    end
                                    else begin
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %10111111; { Reset ZF }
                                      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }
                                    end;

                                    // H is set
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00010000; { Set HF }

                                    // N is reset
                                    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101; { Reset NF }


                                    {$IFDEF mit_GUI}
                                    if Mode_Protokoll then begin

                                      Befehl_Zeile := 'BIT 7,(IY+'+IntToHex(displacement_FD_CB,2)+'H)';

                                      Form_cpu.Reg_Red.HRS.F:=Farbe_Schreiben;
                                      Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                                      Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                                    end; { if Mode_Protokoll then }
                                    {$ENDIF}

                                    Befehl_abgearbeitet:=true;

                                  end; // BIT 7,(IY+d)



                    end; // case ziel_bit of

                  end; // BIT b,(IY+d)



    end; // case OP_Code2 of

  end; { procedure OP_Code_FD_CB_01 }







  procedure OP_Code_FD_CB_10;
  var
    quell_reg, ziel_bit, var_ziel_bit, Wert_n : Byte;
    Wert_Word : Word;
  //  bit_string : String;
  begin


    // RES b,(IY+d) - Reset Bit
    ziel_bit := OP_Code AND %00111000;

    case ziel_bit of

      // RES 0,(IY+d)
      %00000000 : begin

                    var_ziel_bit := %11111110;

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      bit_string := '0';
                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                  end; // RES 0,(IY+d)


      // RES 1,(IY+d)
      %00001000 : begin

                    var_ziel_bit := %11111101;

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      bit_string := '1';
                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                  end; // RES 1,(IY+d)


      // RES 2,(IY+d)
      %00010000 : begin

                    var_ziel_bit := %11111011;

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      bit_string := '2';
                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                  end; // RES 2,(IY+d)


      // RES 3,(IY+d)
      %00011000 : begin

                    var_ziel_bit := %11110111;

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      bit_string := '3';
                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                  end; // RES 3,(IY+d)


      // RES 4,(IY+d)
      %00100000 : begin

                    var_ziel_bit := %11101111;

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      bit_string := '4';
                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                  end; // RES 4,(IY+d)


      // RES 5,(IY+d)
      %00101000 : begin

                    var_ziel_bit := %11011111;

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      bit_string := '5';
                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                  end; // RES 5,(IY+d)


      // RES 6,(IY+d)
      %00110000 : begin

                    var_ziel_bit := %10111111;

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      bit_string := '6';
                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                  end; // RES 6,(IY+d)


      // RES 7,(IY+d)
      %00111000 : begin

                    var_ziel_bit := %01111111;

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      bit_string := '7';
                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                  end; // RES 7,(IY+d)


    end; { case ziel_bit of }



    // RES b,(IY+d)
    quell_reg := OP_Code AND %00000111;

    case quell_reg of


      // RES b,(IY+d)
      %00000110 : begin
                    {
                    Condition Bits Affected: None
                    }

                    if displacement_FD_CB>127 then
                      Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement_FD_CB)
                    else
                      Wert_Word := mod_cpu.Reg.SRS.IY + displacement_FD_CB; // (IY +- d)

                    Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY +- d) -> Wert_n

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      Form_RAM.setze_Mem_Red(Wert_Word);  // (IY + d)
                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                    end;
                    {$ENDIF}

                    // RES b,(IY+d)
                    Wert_n := Wert_n and var_ziel_bit;

                    // Wert_n -> (IY+d)
                    mod_ram.Write_Byte(Wert_Word, Wert_n);

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin

                      Befehl_Zeile := 'RES '+bit_string+', (IY+'+IntToHex(displacement_FD_CB,2)+'H)';

                      Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                      Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                    Befehl_abgearbeitet:=true;

                  end; // RES b,(IY+d)


    end; { case quell_reg of }


  end; { procedure OP_Code_FD_CB_10 }









  procedure OP_Code_FD_CB_11;
  var
    quell_reg, ziel_bit, var_ziel_bit, Wert_n : Byte;
    Wert_Word : Word;
 //   bit_string : String;
  begin


    // SET b,(IY+d)
    ziel_bit := OP_Code AND %00111000;

    case ziel_bit of

      // SET 0,(IY+d)
      %00000000 : begin

                    var_ziel_bit := %00000001;

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      bit_string := '0';
                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                  end; // SET 0,(IY+d)


      // SET 1,(IY+d)
      %00001000 : begin

                    var_ziel_bit := %00000010;

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      bit_string := '1';
                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                  end; // SET 1,(IY+d)


      // SET 2,(IY+d)
      %00010000 : begin

                    var_ziel_bit := %00000100;

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      bit_string := '2';
                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                  end; // SET 2,(IY+d)


      // SET 3,(IY+d)
      %00011000 : begin

                    var_ziel_bit := %00001000;

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      bit_string := '3';
                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                  end; // SET 3,(IY+d)


      // SET 4,(IY+d)
      %00100000 : begin

                    var_ziel_bit := %00010000;

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      bit_string := '4';
                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                  end; // SET 4,(IY+d)


      // SET 5,(IY+d)
      %00101000 : begin

                    var_ziel_bit := %00100000;

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      bit_string := '5';
                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                  end; // SET 5,(IY+d)


      // SET 6,(IY+d)
      %00110000 : begin

                    var_ziel_bit := %01000000;

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      bit_string := '6';
                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                  end; // SET 6,(IY+d)


      // SET 7,(IY+d)
      %00111000 : begin

                    var_ziel_bit := %10000000;

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      bit_string := '7';
                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                  end; // SET 7,(IY+d)


    end; { case ziel_bit of }



    // SET b,(IY+d)
    quell_reg := OP_Code AND %00000111;

    case quell_reg of


      // SET b,(IY+d)
      %00000110 : begin
                    {
                    Condition Bits Affected: None
                    }

                    if displacement_FD_CB>127 then
                      Wert_Word := mod_cpu.Reg.SRS.IY - (256 - displacement_FD_CB)
                    else
                      Wert_Word := mod_cpu.Reg.SRS.IY + displacement_FD_CB; // (IY +- d)

                    Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY +- d) -> Wert_n

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin
                      Form_RAM.setze_Mem_Red(Wert_Word);  // (IY + d)
                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                    end;
                    {$ENDIF}

                    // SET b,(IY+d)
                    Wert_n := Wert_n or var_ziel_bit;

                    // Wert_n -> (IY+d)
                    mod_ram.Write_Byte(Wert_Word, Wert_n);

                    {$IFDEF mit_GUI}
                    if Mode_Protokoll then begin

                      Befehl_Zeile := 'SET '+bit_string+', (IY+'+IntToHex(displacement_FD_CB,2)+'H)';

                      Form_cpu.Reg_Red.SRS.IY:=Farbe_Lesen;
                      mod_cpu.Reg.SRS.IY_d:=Wert_Word;
                      Form_cpu.Reg_Red.SRS.IY_Inhalt:=Farbe_Schreiben;

                    end; { if Mode_Protokoll then }
                    {$ENDIF}

                    Befehl_abgearbeitet:=true;

                  end; // SET b,(IY+d)


    end; { case quell_reg of }


  end; { procedure OP_Code_FD_CB_11 }





  { FD_CB FD_CB FD_CB FD_CB FD_CB FD_CB }




  procedure OP_Code_FD_CB;
  var
    OP_Code2 : Byte;
  begin

    {$IFDEF mit_GUI}
    if Mode_Protokoll then
      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
    {$ENDIF}

    displacement_FD_CB := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
    INC(mod_cpu.Reg.SRS.PC);

    {$IFDEF mit_GUI}
    if Mode_Protokoll then
      Form_RAM.setze_Mem_Green(mod_cpu.Reg.SRS.PC);
    {$ENDIF}

    OP_Code := mod_ram.Read_Byte(mod_cpu.Reg.SRS.PC);
    INC(mod_cpu.Reg.SRS.PC);


    OP_Code2 := OP_Code AND %11000000;

    case OP_Code2 of

      %00000000 : OP_Code_FD_CB_00;

      %01000000 : OP_Code_FD_CB_01;

      %10000000 : OP_Code_FD_CB_10;

      %11000000 : OP_Code_FD_CB_11;

    end; { case temp_op_code of }

  end; { procedure OP_Code_FD_CB }







         Wert_n := mod_ram.Read_Byte(Wert_Word); // (IY +- d) -> Wert_n
