
  { *** FLAG-UP *** }




  { **********   Flags nur setzen oder nur zuruecksetzen   *********** }



  procedure Half_Carry_Flag_Reset;
  begin

    { Half Carry Flag (4) }
    { H is reset }
    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

  end; { procedure Half_Carry_Flag_Reset }




  procedure Half_Carry_Flag_Set;
  begin

    { Half Carry Flag (4) }
    { H is set }
    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00010000; { Set HF }

  end; { procedure Half_Carry_Flag_Set }



  procedure Num_Flag_Set;
  begin
    // N is set
    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000010; { Set NF }

  end; { procedure Num_Flag_Set }




  procedure Num_Flag_Reset;
  begin

    { N-Flag (1) }
    { N is reset }
    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111101 { Reset NF }

  end; { procedure Num_Flag_Reset }





  procedure Carry_Flag_Reset;
  begin

    { C is reset }
    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }

  end; { procedure Carry_Flag_Reset }






  procedure Carry_Flag_Set;
  begin
    // C is set
    mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001; { Set CF }

  end; { procedure Carry_Flag_Set }






  { **********   Flags nach Bedingungen setzen oder zuruecksetzen   *********** }


  procedure Sign_Flag_negative(Ergebnis_Wert : Byte);
  begin

    { Sign-Flag (7) }
    { S is set if result is negative; reset otherwise }
    if (Ergebnis_Wert and %10000000)=%10000000 then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %10000000 { Set SF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %01111111; { Reset SF }

  end; { procedure Sign_Flag_negative }




  procedure Sign_Flag_negative_Ergebnis(Ergebnis_Wert : Word);
  begin

    { Sign-Flag (7) }
    { S is set if result is negative; reset otherwise }
    if (Ergebnis_Wert and %0000000010000000)=%10000000 then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %10000000 { Set SF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %01111111; { Reset SF }

  end; { procedure Sign_Flag_negative }





  procedure Sign_Flag_negative_Word(Ergebnis_Wert : Word);
  begin

    { Sign-Flag (7) }
    { S is set if result is negative; reset otherwise }
    if (Ergebnis_Wert and $8000)=$8000 then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %10000000 { Set SF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %01111111; { Reset SF }

  end; { procedure Sign_Flag_negative }





  procedure Zero_Flag_zero(Ergebnis_Wert : Word);
  begin

    { Zero-Flag (6) }
    { Z is set if result is zero; reset otherwise }
    if (Ergebnis_Wert and $FF)=0 then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %01000000 { Set ZF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %10111111; { Reset ZF }

  end; { procedure Zero_Flag_zero }








  procedure Zero_Flag_zero_Word(Ergebnis_Wert : DWord);
  begin

    { Zero-Flag (6) }
    { Z is set if result is zero; reset otherwise }
    if (Ergebnis_Wert and $FFFF)=0 then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %01000000 { Set ZF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %10111111; { Reset ZF }

  end; { procedure Zero_Flag_zero_Word }










  procedure HalfCarry_ADD(Summand1, Summand2 : Byte);
  begin

    // H is set if carry from bit 3; reset otherwise
    if (((Summand1 and $0F)+(Summand2 and $0F)) and $10) = 0 then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

  end; { procedure HalfCarry_ADD }




  procedure HalfCarry_ADD16(Summand1, Summand2 : Word);
  begin

    // H is set if carry out of bit 11;. reset otherwise
    if (((Summand1 and $0FFF)+(Summand2 and $0FFF)) and $1000) = 0 then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

  end; { procedure HalfCarry_ADD16 }






  procedure HalfCarry_ADC(Summand1, Summand2, Summand_Carry : Byte);
  begin

    // H is set if carry from bit 3; reset otherwise
    if (((Summand1 and $0F)+(Summand2 and $0F) + Summand_Carry) and $10) = 0 then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

  end; { procedure HalfCarry_ADC }





  procedure HalfCarry_ADC16(Summand1, Summand2, Summand_Carry : Word);
  begin

    // H is set if carry out of bit 11;. reset otherwise
    if (((Summand1 and $0FFF)+(Summand2 and $0FFF) + Summand_Carry) and $1000) = 0 then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111 { Reset HF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000; { Set HF }

  end; { procedure HalfCarry_ADC }






  procedure HalfCarry_SUB(Minuend, Subtrahend : Byte);
  begin

    // H is set if borrow from bit 4; reset otherwise
    if (Minuend and $0F)<(Subtrahend and $0F) then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000 { Set HF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

  end; { procedure HalfCarry_SUB }






  procedure HalfCarry_SBC(Minuend, Subtrahend, Subtrahend_Carry : Byte);
  begin

    // H is set if borrow from bit 4; reset otherwise
    if (Minuend and $0F)<((Subtrahend and $0F) + Subtrahend_Carry) then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000 { Set HF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

  end; { procedure HalfCarry_SBC }







  procedure HalfCarry_SBC16(Minuend, Subtrahend, Subtrahend_Carry : Word);
  begin

    // H is set if carry out of bit 11;. reset otherwise
    if (Minuend and $0FFF)<((Subtrahend and $0FFF) + Subtrahend_Carry) then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or  %00010000 { Set HF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11101111; { Reset HF }

  end; { procedure HalfCarry_SBC }






  procedure Parity_Overflow_Flag_Switch(Switch_Wert : Boolean);
  begin

    { P/V-Flag (2) }
    { P/V contains contents of IFF2 }
    if Switch_Wert then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }

  end; { procedure Parity_Overflow_Flag_Switch }





  procedure Parity_Overflow_Flag_set_if_not_null(Ergebnis_Wert : Word);
  begin

    // P/V is set if BC -1 is not 0; reset otherwise
    if Ergebnis_Wert=0 then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011 { Reset PF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100; { Set PF }

  end; { procedure Parity_Overflow_Flag_set_if_not_null }







  procedure Carry_Flag_set_if_carry_from_bit_7(Ergebnis : Word);
  begin

    // C is set if carry from bit 7; reset otherwise
    if Ergebnis>$FF then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001 { Set CF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }

  end; { procedure Carry_Flag_set_if_carry_from_bit_7 }





  procedure Carry_Flag_set_if_carry_from_bit_15(Ergebnis : DWord);
  begin

    // C is set if carry from bit 15; reset otherwise
    if Ergebnis>$FFFF then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000001 { Set CF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111110; { Reset CF }

  end; { procedure Carry_Flag_set_if_carry_from_bit_15 }





{ **********   alle Flags nach Befehlsgruppen setzen oder zuruecksetzen   *********** }




  procedure setze_Flags_IR_Reg(sF_Register : Byte);
  begin

    //  Das Flag-Register F
    // ----------------------------------------------
    // Bit  |  7 |  6 |  5 |  4 |  3 |  2 |  1 |  0 |
    // Flag | SF | ZF | YF | HF | XF | PF | NF | CF |
    // ----------------------------------------------

    { Sign-Flag (7) }
    { S is set if result is negative; reset otherwise }
    Sign_Flag_negative(sF_Register);

    { Zero-Flag (6) }
    { Z is set if result is zero; reset otherwise }
    Zero_Flag_zero(sF_Register);

    { Half Carry Flag (4) }
    { H is reset }
    Half_Carry_Flag_Reset;

    { P/V-Flag (2) }
    { P/V contains contents of IFF2 }
    Parity_Overflow_Flag_Switch(mod_cpu.Reg.IFF2);

    { N-Flag (1) }
    { N is reset }
    Num_Flag_Reset;

    { C is not affected }

  end; { setze_Flags_IR_Reg }






  procedure Parity_Overflow_ADD(Summand1, Summand2 : Byte);
  var
    Ergebnis_Byte : Byte;
    Ergebnis_Integer, Summand_I1,
    Summand_I2, Ergebnis_Byte_Integer : Integer;

  begin
    {
    128..255  0..127
    -128..-1  0..127
    }

    Ergebnis_Byte := Summand1 + Summand2;

    if Ergebnis_Byte>127 then
      Ergebnis_Byte_Integer := (256 - Ergebnis_Byte) * -1
    else
      Ergebnis_Byte_Integer := Ergebnis_Byte;

    if Summand1>127 then
      Summand_I1 := (256 - Summand1) * -1
    else
      Summand_I1 := Summand1;

    if Summand2>127 then
      Summand_I2 := (256 - Summand2) * -1
    else
      Summand_I2 := Summand2;

    Ergebnis_Integer := Summand_I1 + Summand_I2;

    // P/V is set if overflow; reset otherwise
    if Ergebnis_Byte_Integer<>Ergebnis_Integer then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }

  end; { procedure Parity_Overflow_ADD }






  procedure setze_Flags_ADD(Summand1, Summand2 : Byte);
  var
    Summe : Word;
  begin

     {
    S is set if result is negative; reset otherwise
    Z is set if result is zero; reset otherwise
    H is set if carry from bit 3; reset otherwise
    P/V is set if overflow; reset otherwise
    N is reset
    C is set if carry from bit 7; reset otherwise
     }

    Summe := Summand1 + Summand2;

    // S is set if result is negative; reset otherwise
    Sign_Flag_negative_Ergebnis(Summe);

    // Z is set if result is zero; reset otherwise
    Zero_Flag_zero(Summe);

    // H is set if carry from bit 3; reset otherwise
    HalfCarry_ADD(Summand1, Summand2);

    // P/V is set if overflow; reset otherwise
    Parity_Overflow_ADD(Summand1, Summand2);

    // N is reset
    Num_Flag_Reset;

    // C is set if carry from bit 7; reset otherwise
    Carry_Flag_set_if_carry_from_bit_7(Summe);

  end; { setze_Flags_ADD }







  procedure Parity_Overflow_ADC(Summand1, Summand2, Summand_Carry : Byte);
  var
    Ergebnis_Byte : Byte;
    Ergebnis_Integer, Summand_I1,
    Summand_I2, Ergebnis_Byte_Integer : Integer;

  begin
    {
    128..255  0..127
    -128..-1  0..127
    }

    Ergebnis_Byte := Summand1 + Summand2 + Summand_Carry;

    if Ergebnis_Byte>127 then
      Ergebnis_Byte_Integer := (256 - Ergebnis_Byte) * -1
    else
      Ergebnis_Byte_Integer := Ergebnis_Byte;

    if Summand1>127 then
      Summand_I1 := (256 - Summand1) * -1
    else
      Summand_I1 := Summand1;

    if Summand2>127 then
      Summand_I2 := (256 - Summand2) * -1
    else
      Summand_I2 := Summand2;

    Ergebnis_Integer := Summand_I1 + Summand_I2 + Summand_Carry;

    // P/V is set if overflow; reset otherwise
    if Ergebnis_Byte_Integer<>Ergebnis_Integer then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }

  end; { procedure Parity_Overflow_ADC }









  procedure setze_Flags_ADC(Summand1, Summand2, Summand_Carry : Byte);
  var
    Summe : Word;
  begin

    {
    S is set if result is negative; reset otherwise
    Z is set if result is zero; reset otherwise
    H is set if carry from bit 3; reset otherwise
    P/V is set if overflow; reset otherwise
    N is reset
    C is set if carry from bit 7; reset otherwise
    }

    Summe := Summand1 + Summand2 + Summand_Carry;

    // S is set if result is negative; reset otherwise
    Sign_Flag_negative_Ergebnis(Summe);

    // Z is set if result is zero; reset otherwise
    Zero_Flag_zero(Summe);

    // H is set if carry from bit 3; reset otherwise
    HalfCarry_ADC(Summand1, Summand2, Summand_Carry);

    // P/V is set if overflow; reset otherwise
    Parity_Overflow_ADC(Summand1, Summand2, Summand_Carry);

    // N is reset
    Num_Flag_Reset;

    // C is set if carry from bit 7; reset otherwise
    Carry_Flag_set_if_carry_from_bit_7(Summe);

  end; { setze_Flags_ADC }











  procedure Parity_Overflow_ADC16(Summand1, Summand2, Summand_Carry : Word);
  var
    Ergebnis_Word : Word;
    Ergebnis_Integer, Summand_I1,
    Summand_I2, Ergebnis_Word_Integer : Integer;

  begin
    {
    32768..65536  0..32767
    -32768..-1  0..32767
    }

    Ergebnis_Word := Summand1 + Summand2 + Summand_Carry;

    if Ergebnis_Word>32767 then
      Ergebnis_Word_Integer := (65536 - Ergebnis_Word) * -1
    else
      Ergebnis_Word_Integer := Ergebnis_Word;

    if Summand1>32767 then
      Summand_I1 := (65536 - Summand1) * -1
    else
      Summand_I1 := Summand1;

    if Summand2>32767 then
      Summand_I2 := (65536 - Summand2) * -1
    else
      Summand_I2 := Summand2;

    Ergebnis_Integer := Summand_I1 + Summand_I2 + Summand_Carry;

    // P/V is set if overflow; reset otherwise
    if Ergebnis_Word_Integer<>Ergebnis_Integer then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }

  end; { procedure Parity_Overflow_ADC16 }








  procedure setze_Flags_ADC16(Summand1, Summand2, Summand_Carry : Word);
  var
    Summe : DWord;
  begin

    {
    S is set if result is negative; reset otherwise
    Z is set if result is zero; reset otherwise
    H is set if carry out of bit 11;. reset otherwise
    P/V is set if overflow; reset otherwise
    N is reset
    C is set if carry from bit 15; reset otherwise
    }

    Summe := Summand1 + Summand2 + Summand_Carry;

    // S is set if result is negative; reset otherwise
    Sign_Flag_negative_Word(Summe);

    // Z is set if result is zero; reset otherwise
    Zero_Flag_zero_Word(Summe);

    // H is set if carry out of bit 11;. reset otherwise
    HalfCarry_ADC16(Summand1, Summand2, Summand_Carry);

    // P/V is set if overflow; reset otherwise
    Parity_Overflow_ADC16(Summand1, Summand2, Summand_Carry);

    // N is reset
    Num_Flag_Reset;

    // C is set if carry from bit 15; reset otherwise
    Carry_Flag_set_if_carry_from_bit_15(Summe);

  end; { setze_Flags_ADC }








  procedure Parity_Overflow_SUB(Minuend, Subtrahend : Byte);
  var
    Ergebnis_Byte : Byte;
    Ergebnis_Integer, Minuend2,
    Subtrahend2, Ergebnis_Byte_Integer : Integer;

  begin
    {
    128..255  0..127
    -128..-1  0..127
    }

    Ergebnis_Byte := Minuend - Subtrahend;

    if Ergebnis_Byte>127 then
      Ergebnis_Byte_Integer := (256 - Ergebnis_Byte) * -1
    else
      Ergebnis_Byte_Integer := Ergebnis_Byte;

    if Minuend>127 then
      Minuend2 := (256 - Minuend) * -1
    else
      Minuend2 := Minuend;

    if Subtrahend>127 then
      Subtrahend2 := (256 - Subtrahend) * -1
    else
      Subtrahend2 := Subtrahend;

    Ergebnis_Integer := Minuend2 - Subtrahend2;

    // P/V is set if overflow; reset otherwise
    if Ergebnis_Byte_Integer<>Ergebnis_Integer then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }

  end; { procedure Parity_Overflow_SUB }






  procedure setze_Flags_SUB(Minuend, Subtrahend : Byte);
  var
    Differenz : Word;
  begin

     {
     S is set if result is negative; reset otherwise
     Z is set if result is zero; reset otherwise
     H is set if borrow from bit 4; reset otherwise
     P/V is set if overflow; reset otherwise
     N is set
     C is set if borrow; reset otherwise
     }

    Differenz := Minuend - Subtrahend;

    // S is set if result is negative; reset otherwise
    Sign_Flag_negative_Ergebnis(Differenz);

    // Z is set if result is zero; reset otherwise
    Zero_Flag_zero(Differenz);

    // H is set if carry from bit 3; reset otherwise
    HalfCarry_SUB(Minuend, Subtrahend);

    // P/V is set if overflow; reset otherwise
    Parity_Overflow_SUB(Minuend, Subtrahend);

    // N is set
    Num_Flag_Set;

    // C is set if carry from bit 7; reset otherwise
    Carry_Flag_set_if_carry_from_bit_7(Differenz);

  end; { setze_Flags_SUB }






  procedure Parity_Overflow_SBC(Minuend, Subtrahend, Subtrahend_Carry : Byte);
  var
    Ergebnis_Byte : Byte;
    Ergebnis_Integer, Minuend2,
    Subtrahend2, Ergebnis_Byte_Integer : Integer;

  begin
    {
    128..255  0..127
    -128..-1  0..127
    }

    Ergebnis_Byte := Minuend - Subtrahend - Subtrahend_Carry;

    if Ergebnis_Byte>127 then
      Ergebnis_Byte_Integer := (256 - Ergebnis_Byte) * -1
    else
      Ergebnis_Byte_Integer := Ergebnis_Byte;

    if Minuend>127 then
      Minuend2 := (256 - Minuend) * -1
    else
      Minuend2 := Minuend;

    if Subtrahend>127 then
      Subtrahend2 := (256 - Subtrahend) * -1
    else
      Subtrahend2 := Subtrahend;

    Ergebnis_Integer := Minuend2 - Subtrahend2 - Subtrahend_Carry;

    // P/V is set if overflow; reset otherwise
    if Ergebnis_Byte_Integer<>Ergebnis_Integer then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }

  end; { procedure Parity_Overflow_SBC }




  procedure setze_Flags_SBC(Minuend, Subtrahend, Subtrahend_Carry : Byte);
  var
    Differenz : Word;

  begin

     {
     S is set if result is negative; reset otherwise
     Z is set if result is zero; reset otherwise
     H is set if borrow from bit 4; reset otherwise
     P/V is reset if overflow; reset otherwise
     N is set
     C is set if borrow; reset otherwise
     }

    Differenz := Minuend - Subtrahend - Subtrahend_Carry;

    // S is set if result is negative; reset otherwise
    Sign_Flag_negative_Ergebnis(Differenz);

    // Z is set if result is zero; reset otherwise
    Zero_Flag_zero(Differenz);

    // H is set if borrow from bit 4; reset otherwise
    HalfCarry_SBC(Minuend, Subtrahend, Subtrahend_Carry);

    // P/V is set if overflow; reset otherwise
    Parity_Overflow_SBC(Minuend, Subtrahend, Subtrahend_Carry);

    // N is set
    Num_Flag_Set;

    // C is set if carry from bit 7; reset otherwise
    Carry_Flag_set_if_carry_from_bit_7(Differenz);

  end; { setze_Flags_SBC }










  procedure Parity_Overflow_SBC16(Minuend, Subtrahend, Subtrahend_Carry : Word);
  var
    Ergebnis_Word : Word;
    Ergebnis_Integer, Minuend2,
    Subtrahend2, Ergebnis_Word_Integer : Integer;

  begin
    {
    32768..65536  0..32767
    -32768..-1  0..32767

    }

    Ergebnis_Word := Minuend - Subtrahend - Subtrahend_Carry;

    if Ergebnis_Word>32767 then
      Ergebnis_Word_Integer := (65536 - Ergebnis_Word) * -1
    else
      Ergebnis_Word_Integer := Ergebnis_Word;

    if Minuend>32767 then
      Minuend2 := (65536 - Minuend) * -1
    else
      Minuend2 := Minuend;

    if Subtrahend>32767 then
      Subtrahend2 := (65536 - Subtrahend) * -1
    else
      Subtrahend2 := Subtrahend;

    Ergebnis_Integer := Minuend2 - Subtrahend2 - Subtrahend_Carry;

    // P/V is set if overflow; reset otherwise
    if Ergebnis_Word_Integer<>Ergebnis_Integer then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF }

  end; { procedure Parity_Overflow_SBC16 }





  procedure setze_Flags_SBC16(Minuend, Subtrahend, Subtrahend_Carry : Word);
  var
    Differenz : DWord;

  begin

     {
     S is set if result is negative; reset otherwise
     Z is set if result is zero; reset otherwise
     H is set if a borrow from bit 12; reset otherwise
     P/V is set if overflow; reset otherwise
     N is set
     C is set if borrow; reset otherwise
     }

    Differenz := Minuend - Subtrahend - Subtrahend_Carry;

    // S is set if result is negative; reset otherwise
    Sign_Flag_negative_Word(Differenz);

    // Z is set if result is zero; reset otherwise
    Zero_Flag_zero_Word(Differenz);

    // H is set if a borrow from bit 12; reset otherwise
    HalfCarry_SBC16(Minuend, Subtrahend, Subtrahend_Carry);

    // P/V is set if overflow; reset otherwise
    Parity_Overflow_SBC16(Minuend, Subtrahend, Subtrahend_Carry);

    // N is set
    Num_Flag_Set;

    // C is set if borrow; reset otherwise
    Carry_Flag_set_if_carry_from_bit_15(Differenz);


  end; { setze_Flags_SBC16 }









  procedure Parity_Overflow_EVEN_ODD(AND_Byte : Byte);
  var
    Zaehler : Integer;

  begin
    {
    This flag is also used with logical operations and rotate instructions to
    indicate the resulting parity is Even. The number of 1 bits in a byte are
    counted. If the total is Odd, ODD parity is flagged (P = 0). If the total is
    Even, EVEN parity is flagged (P = 1).
    }

    Zaehler := 0;

    if (AND_Byte and %00000001) = %00000001 then
      Inc(Zaehler);

    if (AND_Byte and %00000010) = %00000010 then
      Inc(Zaehler);

    if (AND_Byte and %00000100) = %00000100 then
      Inc(Zaehler);

    if (AND_Byte and %00001000) = %00001000 then
      Inc(Zaehler);

    if (AND_Byte and %00010000) = %00010000 then
      Inc(Zaehler);

    if (AND_Byte and %00100000) = %00100000 then
      Inc(Zaehler);

    if (AND_Byte and %01000000) = %01000000 then
      Inc(Zaehler);

    if (AND_Byte and %10000000) = %10000000 then
      Inc(Zaehler);


    // P/V is set if parity even; reset otherwise
    if (Zaehler and %00000001) = %00000000 then
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F or %00000100 { Set PF = Even = Gleich }
    else
      mod_cpu.Reg.HRS.F:=mod_cpu.Reg.HRS.F and %11111011; { Reset PF = Odd = Ungleich }

  end; { procedure Parity_Overflow_EVEN_ODD }





  procedure setze_Flags_LOGIK(Ergebnis : Byte);
  begin

    {
    S is set if result is negative; reset otherwise
    Z is set if result is zero; reset otherwise
    P/V is set if parity even; reset otherwise
    N is reset
    C is reset
    }

    // S is set if result is negative; reset otherwise
    Sign_Flag_negative(Ergebnis);

    // Z is set if result is zero; reset otherwise
    Zero_Flag_zero(Ergebnis);

    // P/V is set if parity even; reset otherwise
    Parity_Overflow_EVEN_ODD(Ergebnis);

    // N is reset
    Num_Flag_Reset;

    // C is reset
    Carry_Flag_Reset;

  end; { procedure setze_Flags_LOGIK }






  procedure setze_Flags_ROTATE(Ergebnis : Byte);
  begin

    {
    S Set if result is negative; reset otherwise.
    Z Set if result is 0; reset otherwise.
    H Reset.
    P/V Set if parity is even; reset otherwise.
    N Reset.
    }

    // S Set if result is negative; reset otherwise.
    Sign_Flag_negative(Ergebnis);

    // Z Set if result is 0; reset otherwise.
    Zero_Flag_zero(Ergebnis);

    // H Reset.
    Half_Carry_Flag_Reset;

    // P/V is set if parity even; reset otherwise
    Parity_Overflow_EVEN_ODD(Ergebnis);

    // N Reset.
    Num_Flag_Reset;

  end; { procedure setze_Flags_ROTATE }








