unit modul_cpu;

{$mode objfpc}

interface


type


  { ***** Prozessor Z80 ***** }

  //  Das Flag-Register F
  // ----------------------------------------------
  // Bit  |  7 |  6 |  5 |  4 |  3 |  2 |  1 |  0 |
  // Flag | SF | ZF | YF | HF | XF | PF | NF | CF |
  // ----------------------------------------------

  TARS = record { Allgemein Register Satz }
    A, F, B, C, D, E, H, L : Byte;
  end;

  TSRS = record { Spezial Register Satz }
    I, R : Byte;
    IX, IY, SP, PC : Word;
    IX_d, IY_d : Word;
  end;

  TReg = record { Register }
    HRS { Haupt Register Satz }, ARS { Alternativer Register Satz } :  TARS;
    SRS : TSRS; { Spezial Register Satz }
    IFF1, IFF2 : Boolean;
    interrupt_mode : Integer;
  end;



  Tmod_cpu = class(TObject)

    constructor Create; overload;
    destructor Destroy; override;

  private

  public

    Reg : TReg;

    procedure Reset; { Ruecksetzen aller Register }

  end; // Tmod_cpu = class(TObject)



var
  mod_cpu: Tmod_cpu;



implementation



constructor Tmod_cpu.Create;
begin
  inherited Create;

end; { constructor Tmod_cpu.Create }






procedure Tmod_cpu.Reset; { Ruecksetzen aller Register }
begin

  { HRS }
  Reg.HRS.A:=$0; Reg.HRS.F:=$0;
  Reg.HRS.B:=$0; Reg.HRS.C:=$0;
  Reg.HRS.D:=$0; Reg.HRS.E:=$0;
  Reg.HRS.H:=$0; Reg.HRS.L:=$0;

  { ARS }
  Reg.ARS.A:=$0; Reg.ARS.F:=$0;
  Reg.ARS.B:=$0; Reg.ARS.C:=$0;
  Reg.ARS.D:=$0; Reg.ARS.E:=$0;
  Reg.ARS.H:=$0; Reg.ARS.L:=$0;

  { SRS }
  Reg.SRS.I:=$0; Reg.SRS.R:=$0;
  Reg.SRS.IX:=$0; Reg.SRS.IY:=$0;
  Reg.SRS.SP:=$0; Reg.SRS.PC:=$0;

  { Interrupt Flip-Flop }
  Reg.IFF1 := false;
  Reg.IFF2 := false;

  { Interrupt-Mode }
  Reg.interrupt_mode := 0;

end; { procedure Tmod_cpu.Reset }





destructor Tmod_cpu.Destroy;
begin

  inherited Destroy;
end; { destructor Tmod_cpu.Destroy }




end.

