unit modul_image;

{$mode objfpc}{$H+}

interface

uses
  Classes,

  Emulator, modul_ram, wincpm;


const

  {$I CBIOS_TXT.INC}

  {$I BDOS_TXT.INC}

  {$I CCP_TXT.INC}


type


  Tmod_image = class(TObject)

    constructor Create; overload;
    destructor Destroy; override;

  private


  public
    VAR_SECTOR, VAR_TRACK, VAR_DISKNO : Integer;
    DPB : T_DPB;

    procedure Lade_BIOS_in_RAM;

    procedure Read_IMAGE_Sektor(ISEC_LFD_NR : Byte;
                                var DMAAD : Word);
    procedure Write_IMAGE_Sektor(ISEC_LFD_NR : Byte;
                                 var DMAAD : Word);
    procedure Lade_BDOS_in_RAM(ADR_HI : Byte);
    procedure Lade_CCP_in_RAM(ADR_HI : Byte);

  end; // Tmod_image = class(TObject)



var
  mod_image: Tmod_image;



implementation


uses
  CPM_Screen;




constructor Tmod_image.Create;
begin
  inherited Create;

  Z80 := TZ80.Create;

end; { constructor Tmod_image.Create }






procedure Tmod_image.Lade_BIOS_in_RAM;
var
  A_Zaehler : Integer;
begin

  for A_Zaehler:=0 to Laenge_CBIOS_Array do begin
    mod_ram.Write_Byte(A_Zaehler,CBIOS_ARR[A_Zaehler]);
  end; { for Zaehler_l1:=0 to l1 do }

end; { procedure Tmod_image.Lade_BIOS_in_RAM }






procedure Tmod_image.Lade_BDOS_in_RAM(ADR_HI : Byte);
var
  A_Zaehler : Integer;
  Adresse : Word;
begin
  Adresse := ADR_HI shl 8;

  for A_Zaehler:=0 to Laenge_BDOS_Array do begin
    mod_ram.Write_Byte(Adresse+A_Zaehler,BDOS_ARR[A_Zaehler]);
  end; { for A_Zaehler:=0 to Laenge_BDOS_Array do }

end; { procedure Tmod_image.Lade_BDOS_in_RAM }








procedure Tmod_image.Lade_CCP_in_RAM(ADR_HI : Byte);
var
  A_Zaehler : Integer;
  Adresse : Word;
begin
  Adresse := ADR_HI shl 8;

  for A_Zaehler:=0 to Laenge_CCP_Array do begin
    mod_ram.Write_Byte(Adresse+A_Zaehler,CCP_ARR[A_Zaehler]);
  end; { for A_Zaehler:=0 to Laenge_BDOS_Array do }

end; { procedure Tmod_image.Lade_CCP_in_RAM }







procedure Tmod_image.Read_IMAGE_Sektor(ISEC_LFD_NR : Byte;
                                         var DMAAD : Word);
var
  ein_Byte : Byte;
  x1 : Integer;
  I_POS : LongInt;

begin

  if ISEC_LFD_NR=0 then
    CPM_CONOUT.DRIVE_NR_READ_LOCK(VAR_DISKNO);

  case VAR_DISKNO of
    0 : begin
          I_POS:=(ISEC_LFD_NR*32)+(((VAR_TRACK*wcpm_LW_A.DPB.SPT)+(VAR_SECTOR))*128);
          wcpm_LW_A.IMG_File.Position:=I_POS;

        end; { 0 }
    1 : begin
          I_POS:=(ISEC_LFD_NR*32)+(((VAR_TRACK*wcpm_LW_B.DPB.SPT)+(VAR_SECTOR))*128);
          wcpm_LW_B.IMG_File.Position:=I_POS;

        end; { 1 }
  else

  end; { case VAR_DISKNO of }



  for x1:=0 to 31 do begin

    case VAR_DISKNO of
      0 : wcpm_LW_A.IMG_File.Read(ein_Byte,1);
      1 : wcpm_LW_B.IMG_File.Read(ein_Byte,1);
    else
      ein_Byte:=$E5;
    end; { case VAR_DISKNO of }

    mod_ram.Write_Byte(DMAAD, ein_Byte);
    INC(DMAAD);

  end; { for x1:=0 to 31 do }


end; { procedure Tmod_image.Read_IMAGE_Sektor }








procedure Tmod_image.Write_IMAGE_Sektor(ISEC_LFD_NR : Byte;
                                          var DMAAD : Word);
var
  ein_Byte : Byte;
  x1 : Integer;
  I_POS : LongInt;

begin

  if ISEC_LFD_NR=0 then begin
    CPM_CONOUT.DRIVE_NR_WRITE_LOCK(VAR_DISKNO);
  end;


  case VAR_DISKNO of
    0 : begin
          I_POS:=(ISEC_LFD_NR*32)+(((VAR_TRACK*wcpm_LW_A.DPB.SPT)+(VAR_SECTOR))*128);
          wcpm_LW_A.IMG_File.Position:=I_POS;

        end; { 0 }
    1 : begin
          I_POS:=(ISEC_LFD_NR*32)+(((VAR_TRACK*wcpm_LW_B.DPB.SPT)+(VAR_SECTOR))*128);
          wcpm_LW_B.IMG_File.Position:=I_POS;

        end; { 1 }
  else

  end; { case VAR_DISKNO of }


  for x1:=0 to 31 do begin

    ein_Byte := mod_ram.Read_Byte(DMAAD);
    INC(DMAAD);

    case VAR_DISKNO of
      0 : wcpm_LW_A.IMG_File.Write(ein_Byte,1);
      1 : wcpm_LW_B.IMG_File.Write(ein_Byte,1);
    else

    end; { case VAR_DISKNO of }

  end; { for x1:=0 to 31 do }


end; { procedure Tmod_image.Write_IMAGE_Sektor }









destructor Tmod_image.Destroy;
begin
  inherited Destroy;
end;







end.

