unit modul_pio;

{$mode objfpc}

interface

//{$DEFINE use_serial_drive}

//{$DEFINE use_serial_keyboard}


uses

  SysUtils,
  Keyboard, {Keyboard uses USB so that will be included automatically}
  Keymap_DE,
  DWCOTG,   {We need to include the USB host driver for the Raspberry Pi}
  Console,

  wincpm,
  screenshot,


  {$IFDEF use_serial_drive}
  modul_serial,
  {$ENDIF}


  {$IFDEF use_serial_keyboard}
  RUART,
  {$ENDIF}


  CPM_Screen;




const


  // PIO OUT
  PIO_OUT_CONOUT           = $001;
  PIO_OUT_RW_VECTOR_LO     = $002;
  PIO_OUT_READ_VECTOR_HI   = $003;
  PIO_OUT_WRITE_VECTOR_HI  = $004;
  PIO_OUT_LIST             = $005;
  PIO_OUT_LOAD_BDOS        = $006;
  PIO_OUT_LOAD_CCP         = $007;
  PIO_OUT_SAVE             = $008;

  PIO_OUT_EXIT             = $0FF;


  // PIO IN
  PIO_IN_CONST             = $001;
  PIO_IN_CONIN             = $002;


  // DRV_VEC

  OFFSET_SECTOR = 0;
  OFFSET_TRACK  = 1;
  OFFSET_DISKNO = 3;
  OFFSET_DMAAD  = 4;


  {$IFDEF use_serial_drive}
    drive_c_is_used : Boolean = true;
  {$ELSE}
    drive_c_is_used : Boolean = false;
  {$ENDIF}



type


  Tmod_pio = class(TObject)

    constructor Create; overload;
    destructor Destroy; override;

  private
    RW_VECTOR_LO : Byte;
    function CONST_auslesen : Byte;
    function CONIN_auslesen : Byte;

  public

    function Input_PIO(Port : Byte) : Byte; { ein Byte von der PIO lesen }
    procedure Output_PIO(Port, Data : Byte); { ein Byte in die PIO schreiben }

  end; // Tmod_pio = class(TObject)



var
  mod_pio: Tmod_pio;
  Zeichen : Char;


implementation


uses
  modul_image,
  modul_ram, Emulator;



constructor Tmod_pio.Create;
begin
  inherited Create;

  CPM_CONOUT:=TConOut.Create;

  {$IFDEF use_serial_drive}
  mod_serial := Tmod_serial.Create;
  {$ENDIF}


  {$IFDEF use_serial_keyboard}
  UART_Init(128000);
  {$ENDIF}



end; { constructor Tmod_pio.Create }








function Tmod_pio.CONST_auslesen : Byte;
var
  CONST_Byte : Byte;

begin


  if Timer_Event_Counter>2 then begin

    Timer_Event_Counter:=0;

    CPM_CONOUT.Timer_Event;

  end; { if Cursor_Counter=1000 then }



  CONST_Byte:=0;

  {$IFDEF use_serial_keyboard}
  if UART_Status then begin
    CONST_Byte:=$FF;
  end;
  {$ELSE}
  if ConsoleKeypressed then begin
    CONST_Byte:=$FF;
  end;
  {$ENDIF}

  Result := CONST_Byte;

end; { function Tmod_pio.CONST_auslesen }





function Tmod_pio.CONIN_auslesen : Byte;
var
  Character : Byte;
begin


  while CONST_auslesen=0 do begin



  end; { while CONST_auslesen=0 do }




  {$IFDEF use_serial_keyboard}
  Character:=UART_Read;
  {$ELSE}
  Character:=Byte(ConsoleReadKey);
  {$ENDIF}


  // Del -> RUN_DEL
  if Character=$08 then
    Character:=$7F;


  if Character=0 then begin


    {$IFDEF use_serial_keyboard}
    {$ELSE}
    Character:=Byte(ConsoleReadKey);
    {$ENDIF}


    case Character of
      $3B : begin
              CPM_CONOUT.Button_Screenshot_on;
              make_ScreenShot(GraphicHandle); // F1 -> ScreenShot
              CPM_CONOUT.Button_Screenshot_off;
            end;


      $52 : Character:=$16;  // Einfg -> 16H = Ctrl+V
      $53 : Character:=$07;  // Entf  -> 07H
      $47 : Character:=$01;  // Pos1  -> 01H = Ctrl+A (Turbo Pascal Editor - Wort links)
      $4F : Character:=$06;  // Ende  -> 06H = Ctrl+F (Turbo Pascal Editor - Wort rechts)
      $49 : Character:=$12;  // Bild hoch     -> 12H = Ctrl+R (Turbo Pascal Editor - Bild hoch)
      $51 : Character:=$03;  // Bild runter   -> 03H = Ctrl+C (Turbo Pascal Editor - Bild runter)
      $48 : Character:=$05;  // Kursor hoch   -> 05H = Ctrl+E (Turbo Pascal Editor - Kursor hoch)
      $50 : Character:=$18;  // Kursor runter -> 18H = Ctrl+X (Turbo Pascal Editor - Kursor runter)
      $4B : Character:=$13;  // Kursor links  -> 13H = Ctrl+S (Turbo Pascal Editor - Kursor links)
      $4D : Character:=$04;  // Kursor rechts -> 04H = Ctrl+D (Turbo Pascal Editor - Kursor rechts)
    end;

  end; { if Character=0 then }


  if Character=0 then
    Character:=3;

  Result := Character;

end; { function Tmod_pio.CONIN_auslesen }






function Tmod_pio.Input_PIO(Port : Byte) : Byte; { ein Byte von der PIO lesen }
var
  Ergebnis : Byte;
begin
  Ergebnis := 0;

  {
  PIO_IN_CONST		EQU	001H
  PIO_IN_CONIN		EQU	002H
  }

  case Port of

    PIO_IN_CONST             : begin
                                 Ergebnis:=CONST_auslesen;
                               end; { PIO_OUT_CONOUT }

    PIO_IN_CONIN             : begin
                                 Ergebnis:=CONIN_auslesen;
                               end; { PIO_OUT_RW_VECTOR_LO }

  else


  end; { case Adress of }

  Result:=Ergebnis;

end; { function Tmod_pio.Read_Byte }





procedure Tmod_pio.Output_PIO(Port, Data : Byte); { ein Byte in die PIO schreiben }
var
  RW_VECTOR_HI, Byte_Low, Byte_High,
  VAR_SECTOR, VAR_TRACK_LOW, VAR_TRACK_HIGH : Byte;
  RW_VECTOR, VAR_DMAAD : Word;
  VEC_Zaehler : Integer;
begin


  {
  PIO_OUT_CONOUT           : Byte = $001;
  PIO_OUT_RW_VECTOR_LO     : Byte = $002;
  PIO_OUT_READ_VECTOR_HI   : Byte = $003;
  PIO_OUT_WRITE_VECTOR_HI  : Byte = $004;
  PIO_OUT_HALT
  }

  case Port of

    PIO_OUT_CONOUT           : begin
                                 CPM_CONOUT.Write_Char(Data);
                               end; { PIO_OUT_CONOUT }

    PIO_OUT_RW_VECTOR_LO     : begin
                                 RW_VECTOR_LO:=Data;
                               end; { PIO_OUT_RW_VECTOR_LO }


    PIO_OUT_READ_VECTOR_HI   : begin
                                 RW_VECTOR_HI:=Data;
                                 RW_VECTOR := (RW_VECTOR_HI shl 8) + RW_VECTOR_LO;

                                 VAR_SECTOR := mod_ram.Read_Byte(RW_VECTOR);
                                 INC(RW_VECTOR);
                                 mod_image.VAR_SECTOR := VAR_SECTOR;

                                 VAR_TRACK_LOW := mod_ram.Read_Byte(RW_VECTOR);
                                 INC(RW_VECTOR);
                                 VAR_TRACK_HIGH := mod_ram.Read_Byte(RW_VECTOR);
                                 INC(RW_VECTOR);
                                 mod_image.VAR_TRACK := (VAR_TRACK_HIGH shl 8) + VAR_TRACK_LOW;

                                 Byte_Low := mod_ram.Read_Byte(RW_VECTOR);
                                 INC(RW_VECTOR);
                                 mod_image.VAR_DISKNO := Byte_Low;

                                 Byte_Low := mod_ram.Read_Byte(RW_VECTOR);
                                 INC(RW_VECTOR);
                                 Byte_High := mod_ram.Read_Byte(RW_VECTOR);
                                 INC(RW_VECTOR);
                                 VAR_DMAAD := (Byte_High shl 8) + Byte_Low;

                                 {$IFDEF use_serial_drive}

                                 case mod_image.VAR_DISKNO of

                                   0,1 : begin
                                           for VEC_Zaehler:=0 to 3 do begin
                                             mod_image.Read_IMAGE_Sektor(VEC_Zaehler, VAR_DMAAD);
                                           end;
                                         end; { 0,1 }
                                   2   : begin

                                           mod_serial.Write_STD_to_UART(VAR_SECTOR,
                                                      VAR_TRACK_HIGH, VAR_TRACK_LOW);

                                           for VEC_Zaehler:=0 to 7 do begin
                                             mod_serial.Read_SECTOR_from_UART(VEC_Zaehler, VAR_DMAAD);
                                           end;

                                         end; { 2 }

                                 end;

                                 {$ELSE}

                                 for VEC_Zaehler:=0 to 3 do begin
                                   mod_image.Read_IMAGE_Sektor(VEC_Zaehler, VAR_DMAAD);
                                 end;

                                 {$ENDIF}

                               end; { PIO_OUT_READ_VECTOR_HI }




    PIO_OUT_WRITE_VECTOR_HI  : begin
                                 RW_VECTOR_HI:=Data;
                                 RW_VECTOR := (RW_VECTOR_HI shl 8) + RW_VECTOR_LO;

                                 Byte_Low := mod_ram.Read_Byte(RW_VECTOR);
                                 INC(RW_VECTOR);
                                 mod_image.VAR_SECTOR := Byte_Low;

                                 Byte_Low := mod_ram.Read_Byte(RW_VECTOR);
                                 INC(RW_VECTOR);
                                 Byte_High := mod_ram.Read_Byte(RW_VECTOR);
                                 INC(RW_VECTOR);
                                 mod_image.VAR_TRACK := (Byte_High shl 8) + Byte_Low;

                                 Byte_Low := mod_ram.Read_Byte(RW_VECTOR);
                                 INC(RW_VECTOR);
                                 mod_image.VAR_DISKNO := Byte_Low;

                                 Byte_Low := mod_ram.Read_Byte(RW_VECTOR);
                                 INC(RW_VECTOR);
                                 Byte_High := mod_ram.Read_Byte(RW_VECTOR);
                                 INC(RW_VECTOR);
                                 VAR_DMAAD := (Byte_High shl 8) + Byte_Low;

                                 for VEC_Zaehler:=0 to 3 do begin

                                   mod_image.Write_IMAGE_Sektor(VEC_Zaehler, VAR_DMAAD);

                                 end;

                               end; { PIO_OUT_WRITE_VECTOR_HI }


    PIO_OUT_LIST             : begin
                                 // erst mal nur Dummy

                               end; { PIO_OUT_LIST }



    PIO_OUT_LOAD_BDOS        : begin
                                 mod_image.Lade_BDOS_in_RAM(Data);
                               end; { PIO_OUT_LOAD_BDOS }


    PIO_OUT_LOAD_CCP         : begin
                                 mod_image.Lade_CCP_in_RAM(Data);
                               end; { PIO_OUT_LOAD_CCP }

    PIO_OUT_SAVE             : begin
                                 wcpm_LW_A.Export_Files_From_Image;
                                 wcpm_LW_B.Export_Files_From_Image;
                               end; { PIO_OUT_SAVE }

    PIO_OUT_EXIT             : begin
                                 Z80.Schleife_aktiv:=false;
                               end; { PIO_OUT_EXIT }

  else
    // CPM_CONOUT.Write_MS_WriteLn('falscher PORT ...');
  end; { case Adress of }

end; { procedure Tmod_pio.Write_Byte }





destructor Tmod_pio.Destroy;
begin

  inherited Destroy;
end; { destructor Tmod_pio.Destroy }



end.

         
