unit modul_serial;

{$mode objfpc}{$H+}

interface


uses
  SysUtils,
  Platform,
  modul_ram,
  RUART;


type

  Tmod_serial = class(TObject)

    constructor Create; overload;
    destructor Destroy; override;

  private

  public

    procedure Write_STD_to_UART(SECTOR, TRACK_HIGH,
                                TRACK_LOW : Byte);
    procedure Read_SECTOR_from_UART(ISEC_LFD_NR : Byte;
                                    var DMAAD : Word);

  end; // Tmod_serial = class(TObject)



var
  mod_serial : Tmod_serial;




implementation



constructor Tmod_serial.Create;
begin
  inherited Create;

 // UART_Init(115200);

  UART_Init(230400);

//  UART_Init(460800);  // nur mit Fehlern

  UART_Write($40);

end; { constructor Tmod_serial.Create }








procedure Tmod_serial.Write_STD_to_UART(SECTOR, TRACK_HIGH,
                                        TRACK_LOW : Byte);
var
  std_line : String;
begin

  // Sector, Track, Drive (STD) = s SE TH TL DR
  std_line:='s'+IntToHex(SECTOR,2)+
                IntToHex(TRACK_HIGH,2)+IntToHex(TRACK_LOW,2)+'02';

  // Senden der STD
  UART_Write_Text(std_line);

end; { procedure Tmod_serial.STD_an_PC_senden }







procedure Tmod_serial.Read_SECTOR_from_UART(ISEC_LFD_NR : Byte;
                                            var DMAAD : Word);
var
  one_Byte : Byte;
  rs_line : String;
  rs_arr : array [0..50] of Char;
  x1, rs_arr_counter : Byte;
  l1 : String;
  transmission_runs : Boolean;
  transmission_counter, tc : LongWord;

begin

  transmission_runs:=true;

  tc:=0;

  sleep(1);

  while transmission_runs do begin

    Inc(tc);

    rs_line:='u'+IntToHex(ISEC_LFD_NR,2);
    UART_Write_Text(rs_line);

    rs_arr_counter:=0;
    one_Byte:=0;
    transmission_counter:=0;


    // 'U000102030405060708090A0B0C0D0E0F+CR+LF
    while (one_Byte<>$0A) and (transmission_counter<100000) do begin

      if UART_Status then begin

        one_Byte:=UART_Read;
        rs_arr[rs_arr_counter]:=Char(one_Byte);
        Inc(rs_arr_counter);

      end; { if UART_Status then }

      Inc(transmission_counter);

    end; { while wait_to_ready do }

    if (one_Byte=$0A) and (transmission_counter<100000) then
      transmission_runs:=false;

  end; { while transmission_runs do }

  if tc>1 then begin
    rs_line:='y*** transmission error ***';
    UART_Write_Text(rs_line);
  end;


  rs_arr_counter:=1;
  for x1:=0 to 15 do begin
    l1:='$'+rs_arr[rs_arr_counter]+rs_arr[rs_arr_counter+1];
    Inc(rs_arr_counter);
    Inc(rs_arr_counter);
    one_Byte:=StrToInt(l1);

    mod_ram.Write_Byte(DMAAD, one_Byte);
    INC(DMAAD);

  end; { for x2:=0 to 15 do }

end; { procedure Tmod_serial.Read_serial_Sektor }






destructor Tmod_serial.Destroy;
begin
  inherited Destroy;
end; { destructor Tmod_serial.Destroy }







end.

