unit screenshot;
{
Copyright (C) 2016 - Ronald Daleske

Licence
=======

 LGPLv2.1 with static linking exception (See COPYING.modifiedLGPL.txt)

}

{$mode delphi} {Default to Delphi compatible syntax}
{$H+}          {Default to AnsiString}
{$inline on}   {Allow use of Inline procedures}


interface

uses
  GlobalConst,
  SysUtils,
  GraphicsConsole,
  GlobalTypes,
  Framebuffer,
  Platform,
  RGraphics;



var
  D_Bitmap : TBitmap;


procedure make_ScreenShot(WindowHandle : TWindowHandle);

implementation


VAR
  ScreenShot_Counter : LongWord;




{==============================================================================}
{==============================================================================}
{}
procedure ScreenShot_to_Bitmap(BMP_Name : String;
                               WindowHandle : TWindowHandle);
var
  D_Bitmap_Width, D_Bitmap_Height : LongWord;
begin

  D_Bitmap := TBitmap.Create;


  FramebufferGetPhysical(D_Bitmap_Width, D_Bitmap_Height);

 // D_Bitmap.Width:=1280;
 // D_Bitmap.Height:=1024;

  D_Bitmap.Width:=D_Bitmap_Width;
  D_Bitmap.Height:=D_Bitmap_Height;

  GraphicsWindowGetImage(WindowHandle,0,0,D_Bitmap.BM_RAW_Memory.Memory,
                         D_Bitmap.Width,D_Bitmap.Height,COLOR_FORMAT_UNKNOWN);

  D_Bitmap.SaveToFile(BMP_Name);

  D_Bitmap.Free;

end; { procedure ScreenShot_to_Bitmap }



{==============================================================================}
{==============================================================================}
{}
procedure make_ScreenShot(WindowHandle : TWindowHandle);
var
  name : String;
begin

  INC(ScreenShot_Counter);
  name:='C:\ScreenShot_'+IntToStr(ScreenShot_Counter)+'.BMP';
  ScreenShot_to_Bitmap(name,WindowHandle);

end; { procedure ScreenShot }


{==============================================================================}
{==============================================================================}

initialization
 ScreenShot_Counter:=0;

{==============================================================================}

finalization
 {Nothing}

{==============================================================================}
{==============================================================================}



end.

